/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.applet.phind;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import org.greenstone.applet.phind.Phind;
import org.greenstone.applet.phind.ResultBox;
import org.greenstone.applet.phind.ResultCanvas;

public class ResultTitle
extends Canvas {
    Phind phind;
    ResultBox parent;
    ResultCanvas canvas;
    Font plain;
    Font bold;
    Graphics g;

    ResultTitle(ResultBox p) {
        this.parent = p;
        this.phind = p.phind;
        this.canvas = p.c;
        this.g = this.getGraphics();
        this.plain = this.phind.plainFont;
        this.bold = this.phind.boldFont;
        Dimension d = this.getSize();
        d.height = this.phind.fontSize + 10;
        this.setSize(d);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        Dimension canvasSize = this.getSize();
        g.setFont(this.plain);
        int margin = g.getFontMetrics().stringWidth(" 8888 ");
        int y = this.phind.fontSize + 5;
        int rightMargin = this.canvas.getSize().width;
        int secondColumn = rightMargin - margin;
        int firstColumn = secondColumn - margin;
        g.setColor(Color.white);
        g.fillRect(0, 0, canvasSize.width, canvasSize.height);
        g.setColor(Color.black);
        String phrase = this.parent.searchPhrase.replace('+', ' ');
        String links = "";
        links = this.parent.numberOfThesaurusLinks <= 0 ? "" : (this.parent.numberOfThesaurusLinks == 1 ? "1 link" : (this.parent.thesaurusLinksRetrieved == this.parent.numberOfThesaurusLinks ? this.parent.numberOfThesaurusLinks + " links" : this.parent.thesaurusLinksRetrieved + " of " + this.parent.numberOfThesaurusLinks + " links"));
        String expansions = "";
        expansions = this.parent.numberOfExpansions <= 0 ? "no phrases" : (this.parent.numberOfExpansions == 1 ? "1 phrase" : (this.parent.expansionsRetrieved == this.parent.numberOfExpansions ? this.parent.numberOfExpansions + " phrases" : this.parent.expansionsRetrieved + " of " + this.parent.numberOfExpansions + " phrases"));
        String documents = "";
        documents = this.parent.numberOfDocuments <= 0 ? "no documents" : (this.parent.documentsRetrieved == 1 ? "1 document" : (this.parent.documentsRetrieved == this.parent.numberOfDocuments ? this.parent.numberOfDocuments + " documents" : this.parent.documentsRetrieved + " of " + this.parent.numberOfDocuments + " documents"));
        String status = "(";
        if (this.parent.numberOfThesaurusLinks > 0) {
            status = status + links + ", ";
        }
        status = status + expansions + ", " + documents + ")";
        g.setFont(this.bold);
        g.drawString(phrase, 0, y);
        int tab = g.getFontMetrics().stringWidth(phrase + "  ");
        g.setFont(this.plain);
        g.drawString(status, tab, y);
        if ((tab += g.getFontMetrics().stringWidth(status)) < firstColumn) {
            g.drawString("docs", firstColumn, y);
            g.drawString("freq", secondColumn, y);
        }
    }
}

