#!/bin/bash

if [ ! -d bin ] ; then
    echo "Making directory: bin"
    mkdir bin
fi

classpath="bin:jars/commons-lang3-3.9.jar:jars/java-json.jar:jars/opennlp-tools-1.9.1.jar"

cygpath --version >/dev/null 2>&1
if [ $? = 0 ] ; then
    classpath=`cygpath -wp $classpath | sed 's/\\\\/\\\\\\\\/g'`
fi

echo "Compiling:"
echo
ls src/org/hathitrust/lrl/*/*.java

javac -cp "$classpath" \
      -s src \
      -d bin \
     src/org/hathitrust/lrl/*/*.java


#     src/org/hathitrust/lrl/pagelevel/FilterSeedWords.java

