#!/bin/bash

ifile=${1:-data-output/maori-1000-fulltextsearch-volid-freq.json}
#ifile_dir=${ifile%/*}
#ifile_tail=${ifile##*/}
ifile_root=${ifile%.*}

tsv_file="$ifile_root.tsv"
csv_file="$ifile_root.csv"

echo ""
echo "Extracting 'volume-page-id' and 'freq count' from:"
echo "  $ifile"
echo "Outputing the (unsorted) results as:"
echo "  $tsv_file"
echo ""

cat $ifile \
    | tr ',' '\n' \
    | sed 's/^{//' \
    | sed 's/}$//' \
    | sed 's/\(\".*\"\):/\1\t/g' \
    > "$tsv_file"

output_dir="sorted-${tsv_file%/*}"

if [ ! -d "$output_dir" ] ; then
    echo "Creating directory: $output_dir"
    mkdir "$output_dir"
fi

echo "Generating:"
echo "  sorted-$tsv_file"
cat "$tsv_file" | sort -r -n -k 2 > "sorted-$tsv_file"

echo "Converting to TSV to CSV format:"
echo "  sorted-$csv_file"
cat "sorted-$tsv_file" | tr '\t' ',' > "sorted-$csv_file"

echo ""
