package org.hathitrust.lrl.core;

import java.nio.file.Path;
import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

public class EFJson {

	public static void appendJsonPageElementToText(JSONObject json_page_element, StringBuffer page_buffer)
	{
		
		try {
			JSONObject json_tokenPosCount = json_page_element.getJSONObject("tokenPosCount");

			int words_per_line = 0;

			@SuppressWarnings("rawtypes")
			Iterator key_iterator = json_tokenPosCount.keys();

			while (key_iterator.hasNext()) {
				String key = (String)key_iterator.next();
				page_buffer.append(key);
				words_per_line++;

				if (key_iterator.hasNext()) {	
					if (words_per_line == 40) {
						page_buffer.append("\n");
						words_per_line = 0;
					}
					else {
						page_buffer.append(" ");
					}
				}
			}
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public static String JsonPageToText(JSONObject json_page)
	{
		StringBuffer page_buffer = new StringBuffer();
		
		try {
			JSONObject json_header = json_page.getJSONObject("header");
			appendJsonPageElementToText(json_header,page_buffer);
			int header_len = page_buffer.length();
			
			if (header_len>0) {
				page_buffer.append("\n");
			}
			JSONObject json_body = json_page.getJSONObject("body");
			appendJsonPageElementToText(json_body,page_buffer);
			int header_and_body_len = page_buffer.length();
						
			if (header_and_body_len > header_len) {
				page_buffer.append("\n");
			}
			JSONObject json_footer = json_page.getJSONObject("footer");
			appendJsonPageElementToText(json_footer,page_buffer);
			int header_body_and_footer_len = page_buffer.length();
			
			if (header_body_and_footer_len > header_and_body_len) {
				page_buffer.append("\n");
			}
		}
		catch (Exception e) {
			e.printStackTrace();
		}
		
		String page_text = page_buffer.toString();
		
		return page_text;
	}
	
	
	
	public static String JsonVolumeToText(JSONObject json_volume)
	{
		StringBuffer pages_buffer = new StringBuffer();
		
		try {
			JSONObject json_features = json_volume.getJSONObject("features");
			JSONArray json_pages = json_features.getJSONArray("pages");

			int num_pages = json_pages.length();
			
			for (int i=0; i<num_pages; i++) {
				if (i>0) {
					pages_buffer.append("\n");
				}
				
				JSONObject json_page = json_pages.getJSONObject(i);
				
				String page_text = JsonPageToText(json_page);
				pages_buffer.append(page_text + "\n");
			}
		}
		catch (Exception e) {
			e.printStackTrace();
		}
		
		String volume_text = pages_buffer.toString();
		
		return volume_text;
	}
	
}
