package org.hathitrust.lrl.pagelevel;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;

import org.hathitrust.lrl.core.EFJson;
import org.hathitrust.lrl.core.UtilIO;
import org.json.JSONObject;

public class PageEFJSONToText {

	public static void ConvertJsonFileToText(Path input_filename)
	{
		if (input_filename.toString().endsWith(".json")) {

			System.out.println("*** Processing filenane = " + input_filename);

			JSONObject json_page = UtilIO.readJSONFile(input_filename.toString());
			String page_text = EFJson.JsonPageToText(json_page);

			String output_filename = input_filename.toString().replace(".json",".txt");
			output_filename = output_filename.replace("page-ef-json", "page-ef-text");
			
			File output_dir = new File(output_filename).getParentFile(); 
				
			if (!output_dir.exists()) {
				System.out.println("Creating directory:" + output_dir);
				output_dir.mkdirs();
			}
			
			UtilIO.writeTextToFile(output_filename, page_text);
		}
		else {
			System.out.println("*** Skipping:" + input_filename);
		}

	}
	
	public static void main(String[] args) 
	{		
		String page_json_base_dir_str = UtilIO.LRL_HOME + File.separator + "data-output" 
				+ File.separator + "page-ef-json";
		//File page_json_base_dir = new File(page_json_base_dir_str);


		try {
			Files.walk(Paths.get(page_json_base_dir_str))
			.filter(Files::isRegularFile)
			.forEach(item -> PageEFJSONToText.ConvertJsonFileToText(item) );

		}
		catch (Exception e) {
			e.printStackTrace();
		}

		System.out.flush();
		System.err.println("Done!");
	}

}
