/*
 * Decompiled with CFR 0.152.
 */
package company.evo.dawg;

import java.io.DataInput;
import java.io.IOException;

class Dict {
    public static final int ROOT = 0;
    public static final int MISSING = -1;
    private int[] units;

    public Dict(DataInput input) throws IOException {
        int size = input.readInt();
        this.units = new int[size];
        for (int i = 0; i < size; ++i) {
            this.units[i] = input.readInt();
        }
    }

    public boolean contains(byte[] key) {
        int index = this.followBytes(key);
        if (index == -1) {
            return false;
        }
        return this.hasValue(index);
    }

    public int find(byte[] key) {
        int index = this.followBytes(key);
        if (index == -1) {
            return -1;
        }
        if (!this.hasValue(index)) {
            return -1;
        }
        return this.value(index);
    }

    public int followBytes(byte[] key) {
        return this.followBytes(key, 0);
    }

    public int followBytes(byte[] key, int index) {
        for (int i = 0; i < key.length; ++i) {
            if ((index = this.followByte(key[i], index)) != -1) continue;
            return -1;
        }
        return index;
    }

    public int followByte(byte c, int index) {
        int o = Units.offset(this.units[index]);
        int nextIndex = (index ^ o ^ c & 0xFF) & 0xFFFFFFFF;
        if (Units.label(this.units[nextIndex]) != (c & 0xFF)) {
            return -1;
        }
        return nextIndex;
    }

    public boolean hasValue(int index) {
        return Units.hasLeaf(this.units[index]);
    }

    public int value(int index) {
        int o = Units.offset(this.units[index]);
        int valueIndex = (index ^ o) & 0xFFFFFFFF;
        return Units.value(this.units[valueIndex]);
    }

    static class Units {
        public static final int PRECISION_MASK = -1;
        public static final int HAS_LEAF_BIT = 256;
        public static final int EXTENSION_BIT = 512;
        public static final int OFFSET_MAX = 0x200000;
        public static final int IS_LEAF_BIT = Integer.MIN_VALUE;

        Units() {
        }

        public static int value(int base) {
            return base & Integer.MAX_VALUE & 0xFFFFFFFF;
        }

        public static int offset(int base) {
            return base >> 10 << ((base & 0x200) >> 6) & 0xFFFFFFFF;
        }

        public static int label(int base) {
            return base & 0x800000FF & 0xFFFFFFFF;
        }

        public static boolean hasLeaf(int base) {
            return (base & 0x100 & 0xFFFFFFFF) != 0;
        }
    }
}

