/*
 * Decompiled with CFR 0.152.
 */
package company.evo.jmorphy2;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import company.evo.jmorphy2.Dictionary;
import company.evo.jmorphy2.FSFileLoader;
import company.evo.jmorphy2.FileLoader;
import company.evo.jmorphy2.Grammeme;
import company.evo.jmorphy2.ParsedWord;
import company.evo.jmorphy2.ProbabilityEstimator;
import company.evo.jmorphy2.Resources;
import company.evo.jmorphy2.Tag;
import company.evo.jmorphy2.units.AnalyzerUnit;
import company.evo.jmorphy2.units.DictionaryUnit;
import company.evo.jmorphy2.units.KnownPrefixUnit;
import company.evo.jmorphy2.units.KnownSuffixUnit;
import company.evo.jmorphy2.units.LatinUnit;
import company.evo.jmorphy2.units.NumberUnit;
import company.evo.jmorphy2.units.PunctuationUnit;
import company.evo.jmorphy2.units.RomanUnit;
import company.evo.jmorphy2.units.UnknownPrefixUnit;
import company.evo.jmorphy2.units.UnknownUnit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MorphAnalyzer {
    private final Tag.Storage tagStorage;
    private final List<AnalyzerUnit> units;
    private final ProbabilityEstimator prob;
    private final Cache<String, List<ParsedWord>> cache;

    private MorphAnalyzer(Tag.Storage tagStorage, List<AnalyzerUnit> units, ProbabilityEstimator prob, Cache<String, List<ParsedWord>> cache) throws IOException {
        this.tagStorage = tagStorage;
        this.units = units;
        this.prob = prob;
        this.cache = cache;
    }

    public Grammeme getGrammeme(String value) {
        return this.tagStorage.getGrammeme(value);
    }

    public Collection<Grammeme> getAllGrammemes() {
        return this.tagStorage.getAllGrammemes();
    }

    public Tag getTag(String tagString) {
        return this.tagStorage.getTag(tagString);
    }

    public Collection<Tag> getAllTags() {
        return this.tagStorage.getAllTags();
    }

    public List<String> normalForms(char[] buffer, int offset, int count) throws IOException {
        return this.normalForms(new String(buffer, offset, count));
    }

    public List<String> normalForms(String word) throws IOException {
        List<ParsedWord> parseds = this.parse(word);
        ArrayList<String> normalForms = new ArrayList<String>();
        HashSet<String> uniqueNormalForms = new HashSet<String>();
        for (ParsedWord p : parseds) {
            if (uniqueNormalForms.contains(p.normalForm)) continue;
            normalForms.add(p.normalForm);
            uniqueNormalForms.add(p.normalForm);
        }
        return normalForms;
    }

    public List<Tag> tag(char[] buffer, int offset, int count) throws IOException {
        return this.tag(new String(buffer, offset, count));
    }

    public List<Tag> tag(String word) throws IOException {
        List<ParsedWord> parseds = this.parse(word);
        ArrayList tags = Lists.newArrayListWithCapacity((int)parseds.size());
        for (ParsedWord p : parseds) {
            tags.add(p.tag);
        }
        return tags;
    }

    public List<ParsedWord> parse(char[] buffer, int offset, int count) throws IOException {
        return this.parse(new String(buffer, offset, count));
    }

    public List<ParsedWord> parse(String word) throws IOException {
        if (this.cache != null) {
            List<ParsedWord> parseds = (List<ParsedWord>)this.cache.getIfPresent((Object)word);
            if (parseds == null) {
                parseds = this.parseNC(word);
                this.cache.put((Object)word, parseds);
            }
            return parseds;
        }
        return this.parseNC(word);
    }

    private List<ParsedWord> parseNC(String word) throws IOException {
        String wordLower = word.toLowerCase();
        List<Object> parseds = Lists.newArrayList();
        for (AnalyzerUnit unit : this.units) {
            List<ParsedWord> unitParseds = unit.parse(word, wordLower);
            if (unitParseds == null) continue;
            parseds.addAll(unitParseds);
            if (!unit.isTerminated() || parseds.isEmpty()) continue;
            break;
        }
        parseds = this.filterDups((List<ParsedWord>)parseds);
        parseds = this.estimate((List<ParsedWord>)parseds);
        Collections.sort(parseds, Collections.reverseOrder());
        return parseds;
    }

    private List<ParsedWord> estimate(List<ParsedWord> parseds) throws IOException {
        float[] newScores = new float[parseds.size()];
        float sumProbs = 0.0f;
        float sumScores = 0.0f;
        int i = 0;
        if (this.prob == null) {
            return parseds;
        }
        for (ParsedWord parsed : parseds) {
            newScores[i] = this.prob.getProbability(parsed.foundWord, parsed.tag);
            sumProbs += newScores[i];
            sumScores += parsed.score;
            ++i;
        }
        if (sumProbs < 1.0E-6f) {
            float k = 1.0f / sumScores;
            i = 0;
            for (ParsedWord parsed : parseds) {
                newScores[i] = parsed.score * k;
                ++i;
            }
        }
        ArrayList<ParsedWord> estimatedParseds = new ArrayList<ParsedWord>(parseds.size());
        i = 0;
        for (ParsedWord parsed : parseds) {
            estimatedParseds.add(parsed.rescore(newScores[i]));
            ++i;
        }
        return estimatedParseds;
    }

    private List<ParsedWord> filterDups(List<ParsedWord> parseds) {
        HashSet<ParsedWord.Unique> seenParseds = new HashSet<ParsedWord.Unique>();
        ArrayList<ParsedWord> filteredParseds = new ArrayList<ParsedWord>();
        for (ParsedWord p : parseds) {
            ParsedWord.Unique u = p.toUnique();
            if (seenParseds.contains(u)) continue;
            filteredParseds.add(p);
            seenParseds.add(u);
        }
        return filteredParseds;
    }

    public static class Builder {
        private static final String DICT_PATH_VAR = "dictPath";
        public static final int DEFAULT_CACHE_SIZE = 10000;
        private String dictPath;
        private FileLoader loader;
        private Map<Character, String> charSubstitutes;
        private Lang lang = Lang.RU;
        private List<AnalyzerUnit.Builder> unitBuilders;
        private int cacheSize = 10000;
        private Cache<String, List<ParsedWord>> cache = null;

        public Builder dictPath(String path) {
            this.dictPath = path;
            return this;
        }

        public Builder fileLoader(FileLoader loader) {
            this.loader = loader;
            return this;
        }

        public Builder charSubstitutes(Map<Character, String> charSubstitutes) {
            this.charSubstitutes = charSubstitutes;
            return this;
        }

        public Builder cacheSize(int size) {
            this.cacheSize = size;
            return this;
        }

        public MorphAnalyzer build() throws IOException {
            Tag.Storage tagStorage = new Tag.Storage();
            if (this.loader == null) {
                if (this.dictPath == null) {
                    this.dictPath = System.getProperty(DICT_PATH_VAR);
                }
                this.loader = new FSFileLoader(this.dictPath);
            }
            if (this.unitBuilders == null) {
                Dictionary.Builder dictBuilder = new Dictionary.Builder(this.loader);
                String langCode = dictBuilder.build((Tag.Storage)tagStorage).getMeta().languageCode.toUpperCase();
                this.lang = Lang.valueOf(langCode);
                Set<String> knownPrefixes = null;
                if (this.lang != null) {
                    knownPrefixes = Resources.getKnownPrefixes(this.lang);
                    if (this.charSubstitutes == null) {
                        this.charSubstitutes = Resources.getCharSubstitutes(this.lang);
                    }
                }
                DictionaryUnit.Builder dictUnitBuilder = new DictionaryUnit.Builder(dictBuilder, true, 1.0f).charSubstitutes(this.charSubstitutes);
                this.unitBuilders = new ArrayList<AnalyzerUnit.Builder>();
                this.unitBuilders.add(dictUnitBuilder);
                this.unitBuilders.add(new NumberUnit.Builder(true, 0.9f));
                this.unitBuilders.add(new PunctuationUnit.Builder(true, 0.9f));
                this.unitBuilders.add(new RomanUnit.Builder(false, 0.9f));
                this.unitBuilders.add(new LatinUnit.Builder(true, 0.9f));
                if (knownPrefixes != null) {
                    this.unitBuilders.add(new KnownPrefixUnit.Builder(dictUnitBuilder, knownPrefixes, true, 0.75f));
                }
                this.unitBuilders.add(new UnknownPrefixUnit.Builder(dictUnitBuilder, true, 0.5f));
                this.unitBuilders.add(new KnownSuffixUnit.Builder(dictBuilder, true, 0.5f).charSubstitutes(this.charSubstitutes));
                this.unitBuilders.add(new UnknownUnit.Builder(true, 1.0f));
            }
            ArrayList<AnalyzerUnit> units = new ArrayList<AnalyzerUnit>();
            Dictionary.Meta dictMeta = null;
            for (AnalyzerUnit.Builder unitBuilder : this.unitBuilders) {
                AnalyzerUnit unit = unitBuilder.build(tagStorage);
                if (unit instanceof DictionaryUnit) {
                    dictMeta = ((DictionaryUnit)unit).getDict().getMeta();
                }
                units.add(unit);
            }
            ProbabilityEstimator prob = null;
            if (dictMeta != null && dictMeta.ptw) {
                prob = new ProbabilityEstimator(this.loader);
            }
            if (this.cacheSize > 0) {
                this.cache = CacheBuilder.newBuilder().maximumSize((long)this.cacheSize).build();
            }
            return new MorphAnalyzer(tagStorage, units, prob, this.cache);
        }
    }

    static enum Lang {
        RU,
        UK;

    }
}

