/*
 * Decompiled with CFR 0.152.
 */
package company.evo.jmorphy2;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import company.evo.jmorphy2.Grammeme;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Tag {
    public static final String PART_OF_SPEECH = "POST";
    public static final String ANIMACY = "ANim";
    public static final String GENDER = "GNdr";
    public static final String NUMBER = "NMbr";
    public static final String CASE = "CAse";
    public static final String ASPECT = "ASpc";
    public static final String TRANSITIVITY = "TRns";
    public static final String PERSON = "PErs";
    public static final String TENSE = "TEns";
    public static final String MOOD = "MOod";
    public static final String VOICE = "VOic";
    public static final String INVOLVEMENT = "INvl";
    private static final ImmutableSet<String> NON_PRODUCTIVE_GRAMMEMES = ImmutableSet.of((Object)"NUMR", (Object)"NPRO", (Object)"PRED", (Object)"PREP", (Object)"CONJ", (Object)"PRCL", (Object[])new String[]{"INTJ", "Apro"});
    private final String originalTagString;
    private final Storage storage;
    public final ImmutableSet<Grammeme> grammemes;
    public final Grammeme POS;
    public final Grammeme anymacy;
    public final Grammeme aspect;
    public final Grammeme Case;
    public final Grammeme gender;
    public final Grammeme involvement;
    public final Grammeme mood;
    public final Grammeme number;
    public final Grammeme person;
    public final Grammeme tense;
    public final Grammeme transitivity;
    public final Grammeme voice;

    public Tag(String tagString, Storage storage) {
        String[] grammemeStrings;
        this.originalTagString = tagString;
        this.storage = storage;
        HashSet<Grammeme> grammemes = new HashSet<Grammeme>();
        for (String grammemeValue : grammemeStrings = tagString.replace(" ", ",").split(",")) {
            if (grammemeValue == null) continue;
            grammemes.add(storage.getGrammeme(grammemeValue));
        }
        this.grammemes = ImmutableSet.copyOf(grammemes);
        this.POS = this.getGrammemeFor(PART_OF_SPEECH);
        this.anymacy = this.getGrammemeFor(ANIMACY);
        this.aspect = this.getGrammemeFor(ASPECT);
        this.Case = this.getGrammemeFor(CASE);
        this.gender = this.getGrammemeFor(GENDER);
        this.involvement = this.getGrammemeFor(INVOLVEMENT);
        this.mood = this.getGrammemeFor(MOOD);
        this.number = this.getGrammemeFor(NUMBER);
        this.person = this.getGrammemeFor(PERSON);
        this.tense = this.getGrammemeFor(TENSE);
        this.transitivity = this.getGrammemeFor(TRANSITIVITY);
        this.voice = this.getGrammemeFor(VOICE);
    }

    private Grammeme getGrammemeFor(String rootValue) {
        for (Grammeme grammeme : this.grammemes) {
            Grammeme rootGrammeme = grammeme.getRoot();
            if (rootGrammeme == null || !rootGrammeme.equals(rootValue)) continue;
            return grammeme;
        }
        return null;
    }

    public Set<String> getGrammemeValues() {
        HashSet<String> grammemeValues = new HashSet<String>();
        for (Grammeme grammeme : this.grammemes) {
            grammemeValues.add(grammeme.value);
        }
        return grammemeValues;
    }

    public boolean contains(String grammemeValue) {
        return this.grammemes.contains((Object)this.storage.getGrammeme(grammemeValue));
    }

    public boolean contains(Grammeme grammeme) {
        return this.grammemes.contains((Object)grammeme);
    }

    public boolean containsAll(Collection<Grammeme> grammemes) {
        return this.grammemes.containsAll(grammemes);
    }

    public boolean containsAllValues(Collection<String> grammemeValues) {
        for (String grammemeValue : grammemeValues) {
            if (this.grammemes.contains((Object)this.storage.getGrammeme(grammemeValue))) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(Collection<Grammeme> grammemes) {
        for (Grammeme grammeme : grammemes) {
            if (!this.contains(grammeme)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAnyValues(Collection<String> grammemeValues) {
        for (String grammemeValue : grammemeValues) {
            if (!this.grammemes.contains((Object)this.storage.getGrammeme(grammemeValue))) continue;
            return true;
        }
        return false;
    }

    public boolean isProductive() {
        return Sets.intersection(this.getGrammemeValues(), NON_PRODUCTIVE_GRAMMEMES).isEmpty();
    }

    public String getTagString() {
        return this.originalTagString;
    }

    public boolean equals(Object obj) {
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tag other = (Tag)obj;
        return this.grammemes.equals(other.grammemes);
    }

    public String toString() {
        return this.originalTagString;
    }

    public static class Storage {
        private final Map<String, Tag> tags = new HashMap<String, Tag>();
        private final Map<String, Grammeme> grammemes = new HashMap<String, Grammeme>();

        public Tag getTag(String tagString) {
            return this.tags.get(tagString);
        }

        public Collection<Tag> getAllTags() {
            return this.tags.values();
        }

        private void addTag(Tag tag) {
            this.tags.put(tag.getTagString(), tag);
        }

        public Tag newTag(String tagString) {
            Tag tag = this.getTag(tagString);
            if (tag == null) {
                tag = new Tag(tagString, this);
                this.addTag(tag);
            }
            return tag;
        }

        public Grammeme getGrammeme(String grammemeValue) {
            if (grammemeValue == null) {
                return null;
            }
            return this.grammemes.get(grammemeValue.toLowerCase());
        }

        public Collection<Grammeme> getAllGrammemes() {
            return this.grammemes.values();
        }

        private void addGrammeme(Grammeme grammeme) {
            this.grammemes.put(grammeme.key, grammeme);
        }

        public Grammeme newGrammeme(List<String> grammemeInfo) {
            Grammeme grammeme = this.getGrammeme(grammemeInfo.get(0));
            if (grammeme == null) {
                grammeme = new Grammeme(grammemeInfo, this);
                this.addGrammeme(grammeme);
            }
            return grammeme;
        }
    }
}

