/*
 * Decompiled with CFR 0.152.
 */
package company.evo.jmorphy2;

import company.evo.dawg.PayloadsDAWG;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WordsDAWG
extends PayloadsDAWG {
    public WordsDAWG(InputStream stream) throws IOException {
        super(stream);
    }

    protected WordForm decodePayload(PayloadsDAWG.Payload payload) throws IOException {
        DataInputStream stream = new DataInputStream(new ByteArrayInputStream(payload.value));
        short paradigmId = stream.readShort();
        short idx = stream.readShort();
        return new WordForm(payload.key, paradigmId, idx);
    }

    public List<WordForm> similarWords(String word, Map<Character, String> replaceChars) throws IOException {
        ArrayList<WordForm> foundWords = new ArrayList<WordForm>();
        for (PayloadsDAWG.Payload payload : this.similarItems(word, replaceChars)) {
            foundWords.add(this.decodePayload(payload));
        }
        return foundWords;
    }

    public static class WordForm {
        public final String word;
        public final short paradigmId;
        public final short idx;

        public WordForm(String word, short paradigmId, short idx) {
            this.word = word;
            this.paradigmId = paradigmId;
            this.idx = idx;
        }

        public boolean equals(Object obj) {
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WordForm other = (WordForm)obj;
            return this.word.equals(other.word) && this.paradigmId == other.paradigmId && this.idx == other.idx;
        }
    }
}

