/*
 * Decompiled with CFR 0.152.
 */
package company.evo.jmorphy2.units;

import company.evo.jmorphy2.ParsedWord;
import company.evo.jmorphy2.Tag;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public abstract class AnalyzerUnit {
    protected final Tag.Storage tagStorage;
    protected final boolean terminate;
    protected final float score;

    protected AnalyzerUnit(Tag.Storage tagStorage, boolean terminate, float score) {
        this.tagStorage = tagStorage;
        this.terminate = terminate;
        this.score = score;
    }

    public boolean isTerminated() {
        return this.terminate;
    }

    public abstract List<ParsedWord> parse(String var1, String var2) throws IOException;

    class AnalyzerParsedWord
    extends ParsedWord {
        public AnalyzerParsedWord(String word, Tag tag, String normalForm, String foundWord, float score) {
            super(word, tag, normalForm, foundWord, score);
        }

        @Override
        public ParsedWord rescore(float newScore) {
            return new AnalyzerParsedWord(this.word, this.tag, this.normalForm, this.foundWord, newScore);
        }

        @Override
        public List<ParsedWord> getLexeme() {
            return Arrays.asList(this);
        }

        @Override
        public String toString() {
            return String.format("<ParsedWord: \"%s\", \"%s\", \"%s\", \"%s\", %.6f, %s>", this.word, this.tag, this.normalForm, this.foundWord, Float.valueOf(this.score), AnalyzerUnit.this.getClass());
        }
    }

    public static abstract class Builder {
        protected final boolean terminate;
        protected final float score;
        protected AnalyzerUnit cachedUnit;

        protected Builder(boolean terminate, float score) {
            this.terminate = terminate;
            this.score = score;
        }

        protected abstract AnalyzerUnit newAnalyzerUnit(Tag.Storage var1) throws IOException;

        public AnalyzerUnit build(Tag.Storage tagStorage) throws IOException {
            if (this.cachedUnit == null) {
                this.cachedUnit = this.newAnalyzerUnit(tagStorage);
            }
            return this.cachedUnit;
        }
    }
}

