/*
 * Decompiled with CFR 0.152.
 */
package company.evo.jmorphy2.units;

import company.evo.jmorphy2.Dictionary;
import company.evo.jmorphy2.ParsedWord;
import company.evo.jmorphy2.Tag;
import company.evo.jmorphy2.WordsDAWG;
import company.evo.jmorphy2.units.AnalyzerUnit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DictionaryUnit
extends AnalyzerUnit {
    private final Dictionary dict;
    private final Map<Character, String> charSubstitutes;

    public DictionaryUnit(Tag.Storage tagStorage, Dictionary dict, Map<Character, String> charSubstitutes, boolean terminate, float score) {
        super(tagStorage, terminate, score);
        this.dict = dict;
        this.charSubstitutes = charSubstitutes;
    }

    public Dictionary getDict() {
        return this.dict;
    }

    @Override
    public List<ParsedWord> parse(String word, String wordLower) throws IOException {
        ArrayList<ParsedWord> parseds = new ArrayList<ParsedWord>();
        for (WordsDAWG.WordForm wf : this.dict.getWords().similarWords(wordLower, this.charSubstitutes)) {
            String normalForm = this.dict.buildNormalForm(wf.paradigmId, wf.idx, wf.word);
            Tag tag = this.dict.buildTag(wf.paradigmId, wf.idx);
            parseds.add(new DictionaryParsedWord(wordLower, tag, normalForm, wf.word, wf, this.score));
        }
        return parseds;
    }

    class DictionaryParsedWord
    extends AnalyzerUnit.AnalyzerParsedWord {
        private final WordsDAWG.WordForm wordForm;

        public DictionaryParsedWord(String word, Tag tag, String normalForm, String foundWord, WordsDAWG.WordForm wordForm, float score) {
            super(DictionaryUnit.this, word, tag, normalForm, foundWord, score);
            this.wordForm = wordForm;
        }

        @Override
        public ParsedWord rescore(float newScore) {
            return new DictionaryParsedWord(this.word, this.tag, this.normalForm, this.foundWord, this.wordForm, newScore);
        }

        @Override
        public List<ParsedWord> getLexeme() {
            ArrayList<ParsedWord> lexeme = new ArrayList<ParsedWord>();
            Dictionary.Paradigm paradigm = DictionaryUnit.this.dict.getParadigm(this.wordForm.paradigmId);
            short s = paradigm.size();
            String stem = DictionaryUnit.this.dict.buildStem(this.wordForm.paradigmId, this.wordForm.idx, this.wordForm.word);
            String normalForm = DictionaryUnit.this.dict.buildNormalForm(this.wordForm.paradigmId, this.wordForm.idx, this.wordForm.word);
            for (short idx = 0; idx < s; idx = (short)(idx + 1)) {
                String prefix = DictionaryUnit.this.dict.getParadigmPrefixes()[paradigm.getStemPrefixId(idx)];
                String suffix = DictionaryUnit.this.dict.getSuffix(this.wordForm.paradigmId, idx);
                String word = prefix + stem + suffix;
                Tag tag = DictionaryUnit.this.dict.buildTag(this.wordForm.paradigmId, idx);
                WordsDAWG.WordForm wf = new WordsDAWG.WordForm(word, this.wordForm.paradigmId, idx);
                lexeme.add(new DictionaryParsedWord(word, tag, normalForm, wf.word, wf, this.score));
            }
            return lexeme;
        }
    }

    public static class Builder
    extends AnalyzerUnit.Builder {
        private Dictionary.Builder dictBuilder;
        private Map<Character, String> charSubstitutes;

        public Builder(Dictionary.Builder dictBuilder, boolean terminate, float score) {
            super(terminate, score);
            this.dictBuilder = dictBuilder;
        }

        public Builder charSubstitutes(Map<Character, String> charSubstitutes) {
            this.charSubstitutes = charSubstitutes;
            this.cachedUnit = null;
            return this;
        }

        @Override
        protected AnalyzerUnit newAnalyzerUnit(Tag.Storage tagStorage) throws IOException {
            Dictionary dict = this.dictBuilder.build(tagStorage);
            return new DictionaryUnit(tagStorage, dict, this.charSubstitutes, this.terminate, this.score);
        }
    }
}

