/*
 * Decompiled with CFR 0.152.
 */
package company.evo.jmorphy2.units;

import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import company.evo.jmorphy2.ParsedWord;
import company.evo.jmorphy2.Tag;
import company.evo.jmorphy2.units.AnalyzerUnit;
import java.util.ArrayList;
import java.util.List;

public class NumberUnit
extends AnalyzerUnit {
    private NumberUnit(Tag.Storage tagStorage, boolean terminate, float score) {
        super(tagStorage, terminate, score);
    }

    @Override
    public List<ParsedWord> parse(String word, String wordLower) {
        Tag tag = null;
        if (Ints.tryParse((String)word) != null) {
            tag = this.tagStorage.getTag("NUMB,intg");
        } else if (Floats.tryParse((String)word) != null) {
            tag = this.tagStorage.getTag("NUMB,real");
        }
        if (tag != null) {
            ArrayList<ParsedWord> parseds = new ArrayList<ParsedWord>();
            parseds.add(new AnalyzerUnit.AnalyzerParsedWord(word, tag, word, word, this.score));
            return parseds;
        }
        return null;
    }

    public static class Builder
    extends AnalyzerUnit.Builder {
        public Builder(boolean terminate, float score) {
            super(terminate, score);
        }

        @Override
        protected AnalyzerUnit newAnalyzerUnit(Tag.Storage tagStorage) {
            tagStorage.newGrammeme(Lists.newArrayList((Object[])new String[]{"NUMB", "", "\u0427\u0418\u0421\u041b\u041e", "\u0447\u0438\u0441\u043b\u043e"}));
            tagStorage.newGrammeme(Lists.newArrayList((Object[])new String[]{"intg", "", "\u0446\u0435\u043b", "\u0446\u0435\u043b\u043e\u0435"}));
            tagStorage.newGrammeme(Lists.newArrayList((Object[])new String[]{"real", "", "\u0432\u0435\u0449", "\u0432\u0435\u0449\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0435"}));
            tagStorage.newTag("NUMB,intg");
            tagStorage.newTag("NUMB,real");
            return new NumberUnit(tagStorage, this.terminate, this.score);
        }
    }
}

