/*
 * Decompiled with CFR 0.152.
 */
package company.evo.jmorphy2.units;

import company.evo.jmorphy2.ParsedWord;
import company.evo.jmorphy2.Tag;
import company.evo.jmorphy2.units.AnalyzerUnit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

abstract class PrefixedUnit
extends AnalyzerUnit {
    protected final AnalyzerUnit unit;

    public PrefixedUnit(Tag.Storage tagStorage, AnalyzerUnit unit, boolean terminate, float score) {
        super(tagStorage, terminate, score);
        this.unit = unit;
    }

    protected List<ParsedWord> parseWithPrefix(String word, String wordLower, String prefix) throws IOException {
        ArrayList<ParsedWord> parseds = new ArrayList<ParsedWord>();
        int prefixLen = prefix.length();
        for (ParsedWord p : this.unit.parse(word.substring(prefixLen), wordLower.substring(prefixLen))) {
            if (!p.tag.isProductive()) continue;
            parseds.add(new PrefixedParsedWord(prefix, p, this.score));
        }
        return parseds;
    }

    class PrefixedParsedWord
    extends AnalyzerUnit.AnalyzerParsedWord {
        private final String prefix;
        private final ParsedWord parsedWord;

        public PrefixedParsedWord(String prefix, ParsedWord p, float score) {
            super(PrefixedUnit.this, prefix + p.word, p.tag, prefix + p.normalForm, p.foundWord, score);
            this.prefix = prefix;
            this.parsedWord = p;
        }

        @Override
        public ParsedWord rescore(float newScore) {
            return new PrefixedParsedWord(this.prefix, this.parsedWord, newScore);
        }

        @Override
        public List<ParsedWord> getLexeme() {
            ArrayList<ParsedWord> lexeme = new ArrayList<ParsedWord>();
            for (ParsedWord p : this.parsedWord.getLexeme()) {
                lexeme.add(new PrefixedParsedWord(this.prefix, p, 1.0f));
            }
            return lexeme;
        }
    }
}

