/*
 * Decompiled with CFR 0.152.
 */
package company.evo.jmorphy2.lucene;

import company.evo.jmorphy2.MorphAnalyzer;
import company.evo.jmorphy2.lucene.Jmorphy2StemFilter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.Version;

public final class Jmorphy2Analyzer
extends Analyzer {
    private static List<Set<String>> DEFAULT_EXCLUDE_TAGS = new ArrayList<Set<String>>();
    private final MorphAnalyzer morph;

    public Jmorphy2Analyzer(MorphAnalyzer morph) {
        this.morph = morph;
    }

    protected Analyzer.TokenStreamComponents createComponents(String arg0, Reader reader) {
        StandardTokenizer tokenizer = new StandardTokenizer(Version.LUCENE_47, reader);
        Object result = new LowerCaseFilter(Version.LUCENE_47, (TokenStream)tokenizer);
        result = new Jmorphy2StemFilter((TokenStream)result, this.morph, null, DEFAULT_EXCLUDE_TAGS, true);
        return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)result);
    }

    static {
        for (final String pos : new String[]{"NPRO", "PREP", "CONJ", "PRCL", "INTJ"}) {
            DEFAULT_EXCLUDE_TAGS.add((Set<String>)new HashSet<String>(){
                {
                    this.add(pos);
                }
            });
        }
    }
}

