/*
 * Decompiled with CFR 0.152.
 */
package company.evo.jmorphy2.lucene;

import company.evo.jmorphy2.nlp.SubjectExtractor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.AttributeSource;

public class Jmorphy2SubjectFilter
extends TokenFilter {
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final KeywordAttribute keywordAtt = (KeywordAttribute)this.addAttribute(KeywordAttribute.class);
    private final SubjectExtractor subjExtractor;
    private final int maxSentenceLength;
    private Iterator<SubjectExtractor.Token> subjTokensIterator = null;
    private List<AttributeSource.State> savedStates = null;
    private int prevIndex = -1;

    public Jmorphy2SubjectFilter(TokenStream input, SubjectExtractor subjExtractor) {
        this(input, subjExtractor, 10);
    }

    public Jmorphy2SubjectFilter(TokenStream input, SubjectExtractor subjExtractor, int maxSentenceLength) {
        super(input);
        this.subjExtractor = subjExtractor;
        this.maxSentenceLength = maxSentenceLength;
    }

    public void reset() throws IOException {
        super.reset();
        this.subjTokensIterator = null;
        this.savedStates = null;
        this.prevIndex = -1;
    }

    public final boolean incrementToken() throws IOException {
        if (this.subjTokensIterator == null) {
            ArrayList<String> terms = new ArrayList<String>(this.maxSentenceLength);
            this.savedStates = new ArrayList<AttributeSource.State>(this.maxSentenceLength);
            while (terms.size() < this.maxSentenceLength && this.input.incrementToken()) {
                if (this.keywordAtt.isKeyword()) continue;
                terms.add(new String(this.termAtt.buffer(), 0, this.termAtt.length()));
                this.savedStates.add(this.captureState());
            }
            List subjTerms = this.subjExtractor.extractTokens(terms.toArray(new String[0]));
            this.subjTokensIterator = subjTerms.iterator();
        }
        if (!this.subjTokensIterator.hasNext()) {
            return false;
        }
        this.setTerm(this.subjTokensIterator.next());
        return true;
    }

    private void setTerm(SubjectExtractor.Token token) {
        this.restoreState(this.savedStates.get(token.index));
        this.termAtt.copyBuffer(token.word.toCharArray(), 0, token.word.length());
        this.termAtt.setLength(token.word.length());
        this.posIncAtt.setPositionIncrement(this.posIncAtt.getPositionIncrement() - 1 + token.index - this.prevIndex);
        this.prevIndex = token.index;
    }
}

