/*
 * Decompiled with CFR 0.152.
 */
package company.evo.jmorphy2.lucene;

import company.evo.jmorphy2.FileLoader;
import company.evo.jmorphy2.JSONUtils;
import company.evo.jmorphy2.MorphAnalyzer;
import company.evo.jmorphy2.lucene.Jmorphy2SubjectFilter;
import company.evo.jmorphy2.lucene.LuceneFileLoader;
import company.evo.jmorphy2.nlp.Parser;
import company.evo.jmorphy2.nlp.Ruleset;
import company.evo.jmorphy2.nlp.SimpleParser;
import company.evo.jmorphy2.nlp.SimpleTagger;
import company.evo.jmorphy2.nlp.SubjectExtractor;
import company.evo.jmorphy2.nlp.Tagger;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class Jmorphy2SubjectFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String DICT_PATH_ATTR = "dict";
    public static final String REPLACES_PATH_ATTR = "replaces";
    public static final String CACHE_SIZE_ATTR = "cacheSize";
    public static final String TAGGER_RULES_PATH_ATTR = "taggerRules";
    public static final String TAGGER_THRESHOLD_ATTR = "taggerThreshold";
    public static final String PARSER_RULES_PATH_ATTR = "parserRules";
    public static final String PARSER_THRESHOLD_ATTR = "parserThreshold";
    public static final String EXTRACT_ATTR = "extract";
    public static final String MAX_SENTENCE_LENGTH_ATTR = "maxSentenceLength";
    public static final String DEFAULT_DICT_PATH = "pymorphy2_dicts";
    public static final int DEFAULT_MAX_SENTENCE_LENGTH = 10;
    private SubjectExtractor subjExtractor;
    private final String dictPath;
    private final String replacesPath;
    private final int cacheSize;
    private final String taggerRulesPath;
    private final int taggerThreshold;
    private final String parserRulesPath;
    private final int parserThreshold;
    private final String extract;
    private final int maxSentenceLength;

    public Jmorphy2SubjectFilterFactory(Map<String, String> args) {
        super(args);
        this.assureMatchVersion();
        String dictPath = args.get(DICT_PATH_ATTR);
        if (dictPath == null) {
            dictPath = DEFAULT_DICT_PATH;
        }
        this.dictPath = dictPath;
        this.replacesPath = args.get(REPLACES_PATH_ATTR);
        this.cacheSize = this.getInt(args, CACHE_SIZE_ATTR, 10000);
        this.taggerRulesPath = args.get(TAGGER_RULES_PATH_ATTR);
        this.taggerThreshold = this.getInt(args, TAGGER_THRESHOLD_ATTR, 1000);
        this.parserRulesPath = args.get(PARSER_RULES_PATH_ATTR);
        this.parserThreshold = this.getInt(args, TAGGER_THRESHOLD_ATTR, 100);
        this.extract = args.get(EXTRACT_ATTR);
        this.maxSentenceLength = this.getInt(args, MAX_SENTENCE_LENGTH_ATTR, 10);
    }

    public void inform(ResourceLoader loader) throws IOException {
        Map<Character, String> replaceChars = null;
        if (this.replacesPath != null) {
            replaceChars = this.parseReplaces(loader.openResource(this.replacesPath));
        }
        MorphAnalyzer morph = new MorphAnalyzer.Builder().fileLoader((FileLoader)new LuceneFileLoader(loader, this.dictPath)).charSubstitutes(replaceChars).cacheSize(this.cacheSize).build();
        Ruleset ruleset = new Ruleset(loader.openResource(this.taggerRulesPath));
        SimpleTagger tagger = new SimpleTagger(morph, ruleset, this.taggerThreshold);
        SimpleParser parser = new SimpleParser(morph, (Tagger)tagger, new Ruleset(loader.openResource(this.parserRulesPath)), this.parserThreshold);
        this.subjExtractor = new SubjectExtractor((Parser)parser, this.extract, true);
    }

    public TokenStream create(TokenStream tokenStream) {
        return new Jmorphy2SubjectFilter(tokenStream, this.subjExtractor, this.maxSentenceLength);
    }

    private Map<Character, String> parseReplaces(InputStream stream) throws IOException {
        HashMap<Character, String> replaceChars = new HashMap<Character, String>();
        for (Map.Entry entry : ((Map)JSONUtils.parseJSON((InputStream)stream)).entrySet()) {
            String c = (String)entry.getKey();
            if (c.length() != 1) {
                throw new IOException(String.format("Replaceable string must contain only one character: '%s'", c));
            }
            replaceChars.put(Character.valueOf(c.charAt(0)), (String)entry.getValue());
        }
        return replaceChars;
    }
}

