/*
 * Decompiled with CFR 0.152.
 */
package company.evo.jmorphy2.nlp;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import company.evo.jmorphy2.Grammeme;
import company.evo.jmorphy2.MorphAnalyzer;
import company.evo.jmorphy2.nlp.Node;
import company.evo.jmorphy2.nlp.Parser;
import company.evo.jmorphy2.nlp.Rule;
import company.evo.jmorphy2.nlp.Ruleset;
import company.evo.jmorphy2.nlp.Tagger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SimpleParser
extends Parser {
    protected final Ruleset rules;
    private final int threshold;
    protected final Set<String> allowedGrammemeValues;
    public static final int DEFAULT_THRESHOLD = 100;
    protected static final Ruleset defaultRules = new Ruleset();

    public SimpleParser(MorphAnalyzer morph, Tagger tagger) throws IOException {
        this(morph, tagger, defaultRules);
    }

    public SimpleParser(MorphAnalyzer morph, Tagger tagger, Ruleset rules) throws IOException {
        this(morph, tagger, rules, 100);
    }

    public SimpleParser(MorphAnalyzer morph, Tagger tagger, int threshold) throws IOException {
        this(morph, tagger, defaultRules, threshold);
    }

    public SimpleParser(MorphAnalyzer morph, Tagger tagger, Ruleset rules, int threshold) throws IOException {
        super(morph, tagger);
        this.rules = rules;
        this.threshold = threshold;
        this.allowedGrammemeValues = Sets.union(this.getGrammemeValuesFor("CAse"), this.getGrammemeValuesFor("NMbr"));
    }

    private Set<String> getGrammemeValuesFor(String rootValue) {
        HashSet<String> values = new HashSet<String>();
        for (Grammeme grammeme : this.morph.getAllGrammemes()) {
            Grammeme rootGrammeme = grammeme.getRoot();
            if (rootGrammeme == null || !rootGrammeme.equals((Object)rootValue)) continue;
            values.add(grammeme.value);
        }
        return values;
    }

    @Override
    public Node.Top parse(List<Node.Top> sentences) {
        List<Node.Top> tops = this.parseAll(sentences);
        if (tops.isEmpty()) {
            return new Node.Top((ImmutableList<Node>)ImmutableList.of(), 0.0f);
        }
        return tops.get(0);
    }

    @Override
    public List<Node.Top> parseAll(List<Node.Top> sentences) {
        boolean var = false;
        boolean wave = false;
        ArrayList<Node.Top> results = new ArrayList<Node.Top>();
        HashSet<Long> uniqueTopHashes = new HashSet<Long>();
        while (!sentences.isEmpty()) {
            ArrayList<Node.Top> nextSentences = new ArrayList<Node.Top>();
            for (Node.Top sent : sentences) {
                boolean hasMatchedRules = false;
                ImmutableList<Node> nodes = sent.getChildren();
                int nodesSize = sent.getChildrenSize();
                int minCount = 1;
                for (int offset = 0; offset <= nodesSize - minCount; ++offset) {
                    for (int count = minCount; count <= nodesSize - offset; ++count) {
                        ImmutableList subNodes = nodes.subList(offset, offset + count);
                        Rule mRule = this.rules.match((List<Node>)subNodes);
                        if (mRule == null) continue;
                        hasMatchedRules = true;
                        ImmutableList<Node> reducedNodes = this.reduce(mRule, nodes, offset);
                        float topScore = Node.sumScoreFor(reducedNodes) / (float)reducedNodes.size() / (float)(Node.maxDepthFor(reducedNodes) + 1);
                        Node.Top top = new Node.Top(reducedNodes, topScore);
                        if (uniqueTopHashes.contains(top.uniqueHash)) continue;
                        nextSentences.add(top);
                        uniqueTopHashes.add(top.uniqueHash);
                    }
                }
                if (hasMatchedRules) continue;
                results.add(sent);
            }
            Collections.sort(nextSentences, Node.scoreComparator());
            sentences = nextSentences.subList(0, Math.min(this.threshold, nextSentences.size()));
        }
        Collections.sort(results, Node.scoreComparator());
        return results;
    }

    private ImmutableList<Node> reduce(Rule rule, ImmutableList<Node> nodes, int offset) {
        ImmutableList.Builder newNodesBuilder = ImmutableList.builder();
        newNodesBuilder.addAll((Iterable)nodes.subList(0, offset));
        ImmutableList subNodes = nodes.subList(offset, offset + rule.rightSize);
        ImmutableSet<String> grammemeValues = rule.commonGrammemeValues((List<Node>)subNodes, this.allowedGrammemeValues);
        float score = Node.sumScoreFor((List<Node>)subNodes) + rule.weight * (float)grammemeValues.size();
        ImmutableList.Builder reducedNodesBuilder = ImmutableList.builder();
        int i = 0;
        for (Node rNode : subNodes) {
            Rule.NodeMatcher m = (Rule.NodeMatcher)rule.right.get(i);
            if (grammemeValues.equals(rNode.grammemeValues) && (m.flags & 2) == 0) {
                reducedNodesBuilder.addAll(rNode.getChildren());
            } else {
                reducedNodesBuilder.add((Object)rNode);
            }
            ++i;
        }
        ImmutableList reducedNodes = reducedNodesBuilder.build();
        newNodesBuilder.add((Object)new Node(grammemeValues, (ImmutableList<Node>)reducedNodes, score));
        newNodesBuilder.addAll((Iterable)nodes.subList(offset + rule.rightSize, nodes.size()));
        return newNodesBuilder.build();
    }

    static {
        defaultRules.add("NP", "$NP @CONJ $NP", 10.0f);
        defaultRules.add("NP", "NP PP", 9.0f);
        defaultRules.add("VP", "VP PP", 9.0f);
        defaultRules.add("PP", "PREP NP", 8.0f);
        defaultRules.add("PP", "PP LATN", 8.0f);
        defaultRules.add("PP", "PP NUMB", 8.0f);
        defaultRules.add("PP", "PREP LATN", 8.0f);
        defaultRules.add("PP", "PREP NUMB", 8.0f);
        defaultRules.add("NP", "$NP,nomn @NP,gent", 8.0f);
        defaultRules.add("NP", "NP @LATN", 5.0f);
        defaultRules.add("NP", "NP @NUMB", 5.0f);
        defaultRules.add("NP", "@LATN NP", 4.0f);
        defaultRules.add("NP", "@NUMB NP", 4.0f);
        defaultRules.add("NP", "ADJF NP", 9.0f);
        defaultRules.add("NP", "NP ADJF", 8.0f);
        defaultRules.add("VP", "INFN VERB", 2.0f);
        defaultRules.add("UNKN", "Name | Erro", 2.0f);
        defaultRules.add("NP", "NOUN,nomn", 2.0f);
        defaultRules.add("NP", "NOUN,accs", 1.0f);
        defaultRules.add("NP", "NOUN", 1.0f);
        defaultRules.add("NP,nomn,sing", "LATN", 1.0f);
        defaultRules.add("VP", "INFN", 1.0f);
        defaultRules.add("VP", "VERB", 1.0f);
    }
}

