var fs = require('fs');
var sys = require('sys');

require('./typed-array.js');
require('../../mad.js');
require('../../bit.js');
require('../../layer3.js');

var tests = [];
tests.push({
block_type: 0,
scalefac_compress: 0,
flags: 0,
scfsi: 0,
byte: [73,110,102,111,0,0,0,15,0,0,0,40,0,0,167,88,0,6,6,12],
gr0_scalefac: [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 0,
flags: 0,
scfsi: 0,
byte: [73,110,102,111,0,0,0,15,0,0,0,40,0,0,167,88,0,6,6,12],
gr0_scalefac: [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]});

tests.push({
block_type: 1,
scalefac_compress: 0,
flags: 0,
scfsi: 0,
byte: [57,119,149,211,145,248,167,55,213,104,83,72,17,73,51,134,108,227,151,235],
gr0_scalefac: [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]});

tests.push({
block_type: 2,
scalefac_compress: 0,
flags: 0,
scfsi: 0,
byte: [49,143,75,66,49,185,251,162,48,77,2,144,50,42,111,106,48,122,128,178],
gr0_scalefac: [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,166,0,96,245,138,0,1,0,0,0,212,87,167,0,20,4,0],
scalefac: [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]});

tests.push({
block_type: 3,
scalefac_compress: 9,
flags: 0,
scfsi: 0,
byte: [0,0,228,12,16,12,7,0,47,76,7,128,47,76,27,32,125,204,5,32],
gr0_scalefac: [0,0,0,0,0,0,0,0,3,2,1,0,0,0,3,0,0,1,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,3,2,1,0,0,0,3,0,0,1,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 9,
flags: 0,
scfsi: 9,
byte: [44,8,67,0,116,2,51,1,216,8,3,3,164,16,83,6,216,33,163,15],
gr0_scalefac: [0,0,0,0,0,0,0,0,3,2,1,0,0,0,3,0,0,1,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,2,3,0,0,0,2,0,1,0,0,1,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 10,
flags: 0,
scfsi: 0,
byte: [0,1,196,1,0,64,3,1,228,8,99,2,24,11,83,2,228,17,227,4],
gr0_scalefac: [0,0,0,0,0,0,0,1,3,0,1,0,0,0,4,0,0,2,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,1,3,0,1,0,0,0,4,0,0,2,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 9,
flags: 1,
scfsi: 8,
byte: [24,8,9,0,192,44,0,136,192,147,2,60,193,20,4,120,194,5,9,68],
gr0_scalefac: [0,0,0,0,0,0,0,1,3,0,1,0,0,0,4,0,0,2,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,1,2,0,0,0,2,0,0,0,2,1,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 8,
flags: 1,
scfsi: 0,
byte: [0,1,196,0,48,30,0,137,48,32,192,184,48,44,1,37,48,74,194,56],
gr0_scalefac: [0,0,0,0,0,0,0,1,3,0,1,0,0,0,0,0,0,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,1,3,0,1,0,0,0,0,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 9,
flags: 0,
scfsi: 8,
byte: [12,8,1,0,192,53,0,100,192,152,2,16,193,27,4,76,194,14,8,224],
gr0_scalefac: [0,0,0,0,0,0,0,1,3,0,1,0,0,0,0,0,0,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,3,0,0,0,2,0,0,0,0,1,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 10,
flags: 0,
scfsi: 0,
byte: [0,2,232,1,0,96,3,1,148,7,67,1,168,10,19,2,68,16,35,3],
gr0_scalefac: [0,0,0,0,0,0,0,2,3,2,2,0,0,0,4,0,0,3,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,2,3,2,2,0,0,0,4,0,0,3,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 8,
flags: 0,
scfsi: 8,
byte: [8,0,131,0,240,0,227,2,124,7,179,4,136,16,67,8,100,33,243,19],
gr0_scalefac: [0,0,0,0,0,0,0,2,3,2,2,0,0,0,4,0,0,3,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,1,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 9,
flags: 0,
scfsi: 0,
byte: [0,1,196,0,192,12,7,64,34,204,7,176,47,140,10,0,76,76,16,240],
gr0_scalefac: [0,0,0,0,0,0,0,1,3,0,1,0,0,0,0,0,3,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,1,3,0,1,0,0,0,0,0,3,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 5,
flags: 2,
scfsi: 8,
byte: [34,0,96,40,128,18,96,95,1,8,96,171,130,58,97,57,4,160,98,206],
gr0_scalefac: [0,0,0,0,0,0,0,1,3,0,1,0,0,0,0,0,3,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 8,
flags: 0,
scfsi: 0,
byte: [0,1,232,0,48,24,192,118,48,25,0,167,48,32,193,12,48,55,2,15],
gr0_scalefac: [0,0,0,0,0,0,0,1,3,2,2,0,0,0,0,0,0,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,1,3,2,2,0,0,0,0,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 8,
flags: 0,
scfsi: 8,
byte: [8,16,128,80,22,6,6,40,15,38,10,224,33,70,19,248,70,102,45,160],
gr0_scalefac: [0,0,0,0,0,0,0,1,3,2,2,0,0,0,0,0,0,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,2,0,0,0,1,0,0,0,0,1,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 9,
flags: 0,
scfsi: 0,
byte: [0,1,232,0,128,12,96,29,204,97,42,12,124,68,76,209,133,140,30,129],
gr0_scalefac: [0,0,0,0,0,0,0,1,3,2,2,0,0,0,0,0,2,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,1,3,2,2,0,0,0,0,0,2,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 8,
flags: 0,
scfsi: 8,
byte: [8,17,2,32,56,204,14,160,31,140,25,144,72,76,46,96,151,140,105,177],
gr0_scalefac: [0,0,0,0,0,0,0,1,3,2,2,0,0,0,0,0,2,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 10,
flags: 1,
scfsi: 0,
byte: [0,1,232,1,1,0,3,1,124,7,99,1,112,10,179,1,212,17,67,3],
gr0_scalefac: [0,0,0,0,0,0,0,1,3,2,2,0,0,0,4,0,1,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,1,3,2,2,0,0,0,4,0,1,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 5,
flags: 0,
scfsi: 8,
byte: [34,0,14,3,196,192,243,1,188,193,160,4,40,194,241,8,228,198,176,27],
gr0_scalefac: [0,0,0,0,0,0,0,1,3,2,2,0,0,0,4,0,1,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 9,
flags: 1,
scfsi: 0,
byte: [0,0,232,0,112,12,5,192,29,204,5,144,42,140,6,192,70,76,11,48],
gr0_scalefac: [0,0,0,0,0,0,0,0,3,2,2,0,0,0,0,0,1,3,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,3,2,2,0,0,0,0,0,1,3,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 0,
flags: 0,
scfsi: 10,
byte: [48,43,192,20,48,82,128,132,48,139,65,71,48,248,130,182,50,51,200,67],
gr0_scalefac: [0,0,0,0,0,0,0,0,3,2,2,0,0,0,0,0,1,3,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 8,
flags: 1,
scfsi: 0,
byte: [0,0,232,0,48,22,192,116,48,20,128,173,48,25,65,26,48,41,2,45],
gr0_scalefac: [0,0,0,0,0,0,0,0,3,2,2,0,0,0,0,0,0,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,3,2,2,0,0,0,0,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 0,
flags: 0,
scfsi: 11,
byte: [48,46,0,41,48,84,192,111,48,141,1,40,48,251,194,129,50,57,135,162],
gr0_scalefac: [0,0,0,0,0,0,0,0,3,2,2,0,0,0,0,0,0,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 10,
flags: 0,
scfsi: 0,
byte: [0,0,232,1,64,96,3,1,96,7,83,1,60,10,195,1,112,17,243,2],
gr0_scalefac: [0,0,0,0,0,0,0,0,3,2,2,0,0,0,5,0,0,3,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,3,2,2,0,0,0,5,0,0,3,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 0,
flags: 0,
scfsi: 8,
byte: [51,12,58,53,96,88,56,237,11,63,226,72,50,62,198,253,62,138,52,193],
gr0_scalefac: [0,0,0,0,0,0,0,0,3,2,2,0,0,0,5,0,0,3,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 8,
flags: 2,
scfsi: 0,
byte: [0,0,148,0,49,92,116,49,40,175,49,77,32,50,18,57,48,79,198,216],
gr0_scalefac: [0,0,0,0,0,0,0,0,2,1,1,0,0,0,0,0,0,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,2,1,1,0,0,0,0,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 0,
flags: 0,
scfsi: 11,
byte: [48,50,128,75,48,87,192,63,48,144,0,234,49,0,66,15,50,67,6,76],
gr0_scalefac: [0,0,0,0,0,0,0,0,2,1,1,0,0,0,0,0,0,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 13,
flags: 0,
scfsi: 0,
byte: [0,0,1,173,128,40,172,0,99,130,153,139,208,6,50,109,153,79,100,96],
gr0_scalefac: [0,0,0,0,0,0,0,1,5,3,3,0,0,0,5,0,5,3,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,1,5,3,3,0,0,0,5,0,5,3,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 0,
flags: 0,
scfsi: 8,
byte: [48,53,64,90,48,89,0,36,48,145,192,201,49,2,1,208,50,71,69,151],
gr0_scalefac: [0,0,0,0,0,0,0,1,5,3,3,0,0,0,5,0,5,3,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 13,
flags: 0,
scfsi: 0,
byte: [0,0,1,137,0,40,12,0,100,51,1,141,18,230,53,126,25,67,238,96],
gr0_scalefac: [0,0,0,0,0,0,0,1,4,2,2,0,0,0,5,0,0,3,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,1,4,2,2,0,0,0,5,0,0,3,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 0,
flags: 0,
scfsi: 8,
byte: [48,55,0,105,48,90,192,5,48,147,0,164,49,3,193,145,50,74,4,212],
gr0_scalefac: [0,0,0,0,0,0,0,1,4,2,2,0,0,0,5,0,0,3,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 10,
flags: 1,
scfsi: 0,
byte: [0,1,216,1,0,96,3,1,56,7,19,0,236,10,227,0,216,18,115,1],
gr0_scalefac: [0,0,0,0,0,0,0,1,3,1,2,0,0,0,4,0,0,3,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,1,3,1,2,0,0,0,4,0,0,3,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 0,
flags: 0,
scfsi: 8,
byte: [48,57,64,118,12,11,132,194,81,1,252,196,18,5,48,201,51,16,36,251],
gr0_scalefac: [0,0,0,0,0,0,0,1,3,1,2,0,0,0,4,0,0,3,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 13,
flags: 0,
scfsi: 0,
byte: [0,0,2,137,128,40,144,0,99,50,129,136,16,38,27,110,24,147,118,96],
gr0_scalefac: [0,0,0,0,0,0,0,2,4,2,3,0,0,0,5,0,4,4,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,2,4,2,3,0,0,0,5,0,4,4,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 0,
flags: 0,
scfsi: 8,
byte: [48,58,128,133,48,93,64,24,48,148,128,82,49,5,193,3,50,78,131,44],
gr0_scalefac: [0,0,0,0,0,0,0,2,4,2,3,0,0,0,5,0,4,4,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 10,
flags: 0,
scfsi: 0,
byte: [0,1,216,1,0,0,3,1,24,6,243,0,188,10,227,0,128,18,147,0],
gr0_scalefac: [0,0,0,0,0,0,0,1,3,1,2,0,0,0,4,0,0,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,1,3,1,2,0,0,0,4,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 0,
flags: 0,
scfsi: 9,
byte: [48,60,192,144,48,94,0,53,48,149,192,35,49,6,0,178,50,79,194,59],
gr0_scalefac: [0,0,0,0,0,0,0,1,3,1,2,0,0,0,4,0,0,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 10,
flags: 0,
scfsi: 0,
byte: [0,1,216,1,2,64,3,1,20,6,195,0,160,10,243,0,76,18,131,0],
gr0_scalefac: [0,0,0,0,0,0,0,1,3,1,2,0,0,0,4,0,2,2,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,1,3,1,2,0,0,0,4,0,2,2,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 0,
flags: 0,
scfsi: 8,
byte: [48,62,0,157,48,95,64,78,18,18,196,196,27,1,84,201,64,4,120,252],
gr0_scalefac: [0,0,0,0,0,0,0,1,3,1,2,0,0,0,4,0,2,2,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 10,
flags: 1,
scfsi: 0,
byte: [0,1,216,1,0,96,3,1,0,6,179,0,132,10,227,0,24,18,146,80],
gr0_scalefac: [0,0,0,0,0,0,0,1,3,1,2,0,0,0,4,0,0,3,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,1,3,1,2,0,0,0,4,0,0,3,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 0,
flags: 0,
scfsi: 8,
byte: [48,63,192,168,48,96,0,103,48,150,64,46,49,6,128,9,50,80,64,114],
gr0_scalefac: [0,0,0,0,0,0,0,1,3,1,2,0,0,0,4,0,0,3,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 13,
flags: 0,
scfsi: 0,
byte: [0,0,2,169,128,32,176,2,98,146,81,131,143,226,22,224,7,126,96,24],
gr0_scalefac: [0,0,0,0,0,0,0,2,5,2,3,0,0,0,4,0,5,4,0,0,1,0],
scalefac: [0,0,0,0,0,0,0,2,5,2,3,0,0,0,4,0,5,4,0,0,1,0]});

tests.push({
block_type: 0,
scalefac_compress: 0,
flags: 0,
scfsi: 8,
byte: [48,65,0,181,48,96,192,124,48,150,128,95,49,6,64,122,50,79,1,185],
gr0_scalefac: [0,0,0,0,0,0,0,2,5,2,3,0,0,0,4,0,5,4,0,0,1,0],
scalefac: [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 12,
flags: 0,
scfsi: 0,
byte: [0,0,1,133,1,128,1,135,67,57,130,165,97,42,78,97,4,148,96,63],
gr0_scalefac: [0,0,0,0,0,0,0,1,4,1,2,0,0,0,3,0,0,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,1,4,1,2,0,0,0,3,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 0,
flags: 0,
scfsi: 9,
byte: [48,66,192,190,48,97,0,145,48,150,192,134,49,5,128,209,50,77,194,186],
gr0_scalefac: [0,0,0,0,0,0,0,1,4,1,2,0,0,0,3,0,0,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 13,
flags: 0,
scfsi: 0,
byte: [0,0,2,137,128,32,16,0,98,50,49,128,143,161,102,225,137,119,166,4],
gr0_scalefac: [0,0,0,0,0,0,0,2,4,2,3,0,0,0,4,0,0,4,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,2,4,2,3,0,0,0,4,0,0,4,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 0,
flags: 0,
scfsi: 8,
byte: [48,68,0,201,48,97,192,164,48,150,0,173,49,4,193,30,50,75,3,161],
gr0_scalefac: [0,0,0,0,0,0,0,2,4,2,3,0,0,0,4,0,0,4,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 9,
flags: 1,
scfsi: 0,
byte: [0,1,216,12,0,12,3,32,24,204,0,80,42,12,0,144,73,76,4,192],
gr0_scalefac: [0,0,0,0,0,0,0,1,3,1,2,0,0,0,3,0,0,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,1,3,1,2,0,0,0,3,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 0,
flags: 0,
scfsi: 9,
byte: [48,69,64,212,48,98,0,185,48,150,64,208,49,3,129,103,50,72,196,116],
gr0_scalefac: [0,0,0,0,0,0,0,1,3,1,2,0,0,0,3,0,0,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 12,
flags: 0,
scfsi: 0,
byte: [0,0,1,133,1,150,1,133,227,0,32,167,48,89,34,49,126,67,48,65],
gr0_scalefac: [0,0,0,0,0,0,0,1,4,1,2,0,0,0,3,0,2,3,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,1,4,1,2,0,0,0,3,0,2,3,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 0,
flags: 0,
scfsi: 8,
byte: [48,70,128,221,48,98,64,202,48,149,0,243,49,2,65,168,50,69,5,59],
gr0_scalefac: [0,0,0,0,0,0,0,1,4,1,2,0,0,0,3,0,2,3,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 12,
flags: 0,
scfsi: 0,
byte: [0,0,1,133,1,128,1,128,80,2,232,140,10,67,0,140,18,19,1,200],
gr0_scalefac: [0,0,0,0,0,0,0,1,4,1,2,0,0,0,3,0,0,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,1,4,1,2,0,0,0,3,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 0,
flags: 0,
scfsi: 9,
byte: [48,71,192,230,48,98,0,221,48,148,193,18,49,0,1,233,50,64,197,244],
gr0_scalefac: [0,0,0,0,0,0,0,1,4,1,2,0,0,0,3,0,0,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 12,
flags: 1,
scfsi: 0,
byte: [0,0,1,133,1,128,1,128,74,2,209,96,10,51,0,176,17,227,2,12],
gr0_scalefac: [0,0,0,0,0,0,0,1,4,1,2,0,0,0,3,0,0,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,1,4,1,2,0,0,0,3,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 0,
flags: 0,
scfsi: 9,
byte: [48,72,128,241,48,98,64,236,48,147,129,49,48,254,66,36,50,60,6,169],
gr0_scalefac: [0,0,0,0,0,0,0,1,4,1,2,0,0,0,3,0,0,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 12,
flags: 0,
scfsi: 0,
byte: [0,0,1,133,1,144,1,132,2,184,128,160,48,229,27,50,74,54,48,93],
gr0_scalefac: [0,0,0,0,0,0,0,1,4,1,2,0,0,0,3,0,2,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,1,4,1,2,0,0,0,3,0,2,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 5,
flags: 0,
scfsi: 8,
byte: [34,0,96,127,129,172,96,170,1,182,97,0,130,64,97,184,4,34,99,225],
gr0_scalefac: [0,0,0,0,0,0,0,1,4,1,2,0,0,0,3,0,2,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 9,
flags: 0,
scfsi: 0,
byte: [0,0,216,12,32,12,27,21,0,164,233,136,72,177,148,113,137,131,48,53],
gr0_scalefac: [0,0,0,0,0,0,0,0,3,1,2,0,0,0,3,0,0,2,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,3,1,2,0,0,0,3,0,0,2,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 5,
flags: 0,
scfsi: 8,
byte: [34,0,96,128,1,190,96,170,129,208,96,253,2,118,97,179,132,128,99,214],
gr0_scalefac: [0,0,0,0,0,0,0,0,3,1,2,0,0,0,3,0,0,2,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 12,
flags: 1,
scfsi: 0,
byte: [0,0,0,133,1,152,1,128,44,2,137,128,8,4,209,128,150,8,169,129],
gr0_scalefac: [0,0,0,0,0,0,0,0,4,1,2,0,0,0,3,0,3,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,4,1,2,0,0,0,3,0,3,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 5,
flags: 0,
scfsi: 8,
byte: [32,128,96,112,129,136,96,147,1,170,96,218,130,72,97,120,4,66,99,82],
gr0_scalefac: [0,0,0,0,0,0,0,0,4,1,2,0,0,0,3,0,3,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 13,
flags: 1,
scfsi: 0,
byte: [0,0,0,133,8,16,96,0,96,8,128,152,96,6,129,46,96,42,2,32],
gr0_scalefac: [0,0,0,0,0,0,0,0,4,1,2,0,4,0,2,0,3,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,4,1,2,0,4,0,2,0,3,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 5,
flags: 0,
scfsi: 8,
byte: [32,160,96,113,1,150,96,146,129,188,96,216,2,114,97,115,132,140,99,71],
gr0_scalefac: [0,0,0,0,0,0,0,0,4,1,2,0,4,0,2,0,3,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 9,
flags: 1,
scfsi: 0,
byte: [0,0,216,8,96,12,0,160,18,204,1,64,36,140,5,208,66,204,12,224],
gr0_scalefac: [0,0,0,0,0,0,0,0,3,1,2,0,0,0,2,0,1,2,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,3,1,2,0,0,0,2,0,1,2,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 8,
flags: 0,
scfsi: 10,
byte: [8,32,96,98,129,100,96,126,1,150,96,185,130,64,97,63,4,62,98,212],
gr0_scalefac: [0,0,0,0,0,0,0,0,3,1,2,0,0,0,2,0,1,2,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,2,0,0,0,0,0,2,0,1,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 13,
flags: 1,
scfsi: 0,
byte: [0,0,2,165,8,16,104,0,96,2,128,140,96,13,129,30,96,51,2,12],
gr0_scalefac: [0,0,0,0,0,0,0,2,5,1,2,0,4,0,2,0,3,2,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,2,5,1,2,0,4,0,2,0,3,2,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 5,
flags: 3,
scfsi: 8,
byte: [32,128,96,98,1,114,96,125,129,164,96,183,2,98,97,58,132,124,98,200],
gr0_scalefac: [0,0,0,0,0,0,0,2,5,1,2,0,4,0,2,0,3,2,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 9,
flags: 1,
scfsi: 0,
byte: [0,1,136,4,32,12,0,96,23,204,3,64,47,140,9,112,85,204,19,96],
gr0_scalefac: [0,0,0,0,0,0,0,1,2,0,2,0,0,0,1,0,0,2,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,1,2,0,2,0,0,0,1,0,0,2,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 9,
flags: 0,
scfsi: 8,
byte: [28,64,197,0,192,171,2,128,192,214,2,244,193,57,4,80,194,26,8,60],
gr0_scalefac: [0,0,0,0,0,0,0,1,2,0,2,0,0,0,1,0,0,2,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,1,3,0,1,0,0,0,3,0,1,1,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 12,
flags: 0,
scfsi: 0,
byte: [0,0,1,133,25,18,0,36,4,163,0,204,9,243,2,40,18,35,4,116],
gr0_scalefac: [0,0,0,0,0,0,0,1,4,1,2,0,3,0,2,0,2,1,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,1,4,1,2,0,3,0,2,0,2,1,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 9,
flags: 0,
scfsi: 9,
byte: [8,64,195,2,168,10,83,3,84,12,67,4,208,18,51,8,68,34,131,18],
gr0_scalefac: [0,0,0,0,0,0,0,1,4,1,2,0,3,0,2,0,2,1,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,2,0,1,0,0,0,3,0,2,1,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 12,
flags: 0,
scfsi: 0,
byte: [0,0,1,133,1,4,0,128,4,115,0,224,9,131,2,76,17,211,4,168],
gr0_scalefac: [0,0,0,0,0,0,0,1,4,1,2,0,0,0,2,0,0,2,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,1,4,1,2,0,0,0,2,0,0,2,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 9,
flags: 1,
scfsi: 8,
byte: [8,64,193,0,192,171,2,160,192,208,3,44,193,47,4,184,194,4,9,12],
gr0_scalefac: [0,0,0,0,0,0,0,1,4,1,2,0,0,0,2,0,0,2,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,2,0,1,0,0,0,3,0,0,1,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 13,
flags: 0,
scfsi: 0,
byte: [0,0,2,133,136,16,1,0,74,1,161,128,106,3,249,129,8,7,129,130],
gr0_scalefac: [0,0,0,0,0,0,0,2,4,1,3,0,4,0,2,0,0,0,2,0,0,0],
scalefac: [0,0,0,0,0,0,0,2,4,1,3,0,4,0,2,0,0,0,2,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 9,
flags: 1,
scfsi: 8,
byte: [24,64,202,0,192,146,2,76,192,179,2,208,193,0,4,68,193,185,8,48],
gr0_scalefac: [0,0,0,0,0,0,0,2,4,1,3,0,4,0,2,0,0,0,2,0,0,0],
scalefac: [0,0,0,0,0,0,0,1,2,0,1,0,0,0,3,0,2,2,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 12,
flags: 1,
scfsi: 0,
byte: [0,0,1,133,25,2,0,200,7,102,2,48,17,198,5,24,33,230,10,16],
gr0_scalefac: [0,0,0,0,0,0,0,1,4,1,2,0,3,0,2,0,0,1,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,1,4,1,2,0,3,0,2,0,0,1,0,0,0,0]});

tests.push({
block_type: 0,
scalefac_compress: 9,
flags: 0,
scfsi: 9,
byte: [8,64,195,2,76,9,67,2,184,11,179,3,236,17,195,6,176,34,19,15],
gr0_scalefac: [0,0,0,0,0,0,0,1,4,1,2,0,3,0,2,0,0,1,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,2,0,1,0,0,0,3,0,0,1,0,0,0,0]});

tests.push({
block_type: 1,
scalefac_compress: 9,
flags: 0,
scfsi: 0,
byte: [0,0,192,196,0,0,64,129,152,6,128,87,24,52,0,241,8,2,19,48],
gr0_scalefac: [0,0,0,0,0,0,0,0,3,0,0,0,3,0,1,0,0,0,0,0,0,0],
scalefac: [0,0,0,0,0,0,0,0,3,0,0,0,3,0,1,0,0,0,0,0,0,0]});

tests.push({
block_type: 2,
scalefac_compress: 10,
flags: 0,
scfsi: 0,
byte: [0,0,0,0,96,200,140,32,0,0,0,12,34,192,92,76,166,21,56,204],
gr0_scalefac: [0,0,0,0,0,0,0,0,3,0,0,0,3,0,1,0,0,0,0,0,0,0,166,0,96,245,138,0,1,0,0,0,212,87,167,0,21,4,0],
scalefac: [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,0,3,1,0,4,3,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0]});


function ary2str(ary) {
    return String.fromCharCode.apply(this, ary);
}


for (var i = 0; i < tests.length; i++) {
    var test = tests[i];
    var ptr = new Mad.Bit(ary2str(test.byte), 0);
    var channel = {
        block_type: test.block_type,
        scalefac: [],
        scalefac_compress: test.scalefac_compress,
        flags: test.flags
    };

    var gr0ch = {
        scalefac: test.gr0_scalefac
    };

    Mad.III_scalefactors(ptr, channel, gr0ch, test.scfsi);

    console.log("offset: " + ptr.offset);

    for (var j = 0; j < channel.scalefac.length; j++) {
        console.log(Math.abs(channel.scalefac[j] - test.scalefac[j]));
    }
}