/*
 * Decompiled with CFR 0.152.
 */
package com.echonest.knowledge.hashr;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.util.AttributeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashFilter
extends TokenFilter {
    protected static final Logger log = LoggerFactory.getLogger(HashFilter.class);
    private TermAttribute termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
    private OffsetAttribute offAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private int prevOff;

    public HashFilter(TokenStream input) {
        super(input);
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            AttributeSource.State s = this.captureState();
            if (this.input.incrementToken()) {
                int posn;
                String ps = this.termAtt.term();
                try {
                    posn = Integer.parseInt(ps);
                }
                catch (NumberFormatException ex) {
                    throw new IOException(String.format("Bad offset %s", ps), ex);
                }
                this.restoreState(s);
                this.offAtt.setOffset(this.prevOff, posn);
                this.prevOff = posn;
                return true;
            }
        }
        return false;
    }
}

