/*
 * Decompiled with CFR 0.152.
 */
package com.echonest.knowledge.hashr;

import java.io.IOException;
import java.util.Arrays;
import java.util.PriorityQueue;
import java.util.logging.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocSlice;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.SolrPluginUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashQueryComponent
extends SearchComponent {
    private static final Logger logger = Logger.getLogger(HashQueryComponent.class.getName());

    public void prepare(ResponseBuilder rb) throws IOException {
        SolrQueryRequest req = rb.req;
        SolrParams params = req.getParams();
        SolrQueryResponse rsp = rb.rsp;
        String fl = params.get("fl");
        int fieldFlags = 0;
        if (fl != null) {
            fieldFlags |= SolrPluginUtils.setReturnFields((String)fl, (SolrQueryResponse)rsp);
            fieldFlags |= 1;
        }
        rb.setFieldFlags(fieldFlags);
    }

    public void process(ResponseBuilder rb) throws IOException {
        SolrQueryRequest req = rb.req;
        SolrQueryResponse rsp = rb.rsp;
        SolrParams params = rb.req.getParams();
        String q = params.get("q");
        int rows = params.getInt("rows", 10);
        int start = params.getInt("start", 0);
        String[] qs = q.split(" ");
        int half = qs.length / 2;
        if (qs.length % 2 != 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format("Hash query with %d hashes has %d offsets", half + 1, half));
        }
        String[] terms = new String[half];
        int[] offsets = new int[half];
        int i = 0;
        int j = 0;
        while (i < qs.length) {
            terms[j] = qs[i];
            try {
                offsets[j] = Integer.parseInt(qs[i + 1]);
            }
            catch (NumberFormatException ex) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format("Hash %s has non-integer offset %s", qs[i], qs[i + 1]));
            }
            i += 2;
            ++j;
        }
        SolrIndexSearcher searcher = req.getSearcher();
        DocList dl = this.eval(searcher.getIndexReader(), terms, rb, rows, start);
        SolrIndexSearcher.QueryResult qr = new SolrIndexSearcher.QueryResult();
        qr.setDocList(dl);
        rb.setResult(qr);
        rsp.add("response", (Object)rb.getResults().docList);
        rsp.getToLog().add("hits", (Object)rb.getResults().docList.matches());
        SolrPluginUtils.optimizePreFetchDocs((DocList)rb.getResults().docList, (Query)rb.getQuery(), (SolrQueryRequest)req, (SolrQueryResponse)rsp);
    }

    private void heapCheck(PriorityQueue<DocTermCount> h, int hsize, int doc, int count) {
        if (h.size() < hsize) {
            h.offer(new DocTermCount(doc, count));
        } else if (h.peek().count < count) {
            DocTermCount dtc = h.poll();
            dtc.setDoc(doc);
            dtc.setCount(count);
            h.offer(dtc);
        }
    }

    private DocList eval(IndexReader reader, String[] queryTerms, ResponseBuilder rb, int rows, int start) throws IOException {
        int hsize = start + rows;
        PriorityQueue<DocTermCount> h = new PriorityQueue<DocTermCount>(hsize);
        int[] docs = new int[32];
        int[] freqs = new int[32];
        int[] alld = new int[256];
        int base = 0;
        int nHits = 0;
        for (IndexReader sub : reader.getSequentialSubReaders()) {
            int p = 0;
            for (String t : queryTerms) {
                TermDocs td = sub.termDocs(new Term("fp", t));
                int pos = td.read(docs, freqs);
                while (pos != 0) {
                    for (int i = 0; i < pos; ++i) {
                        if (p >= alld.length) {
                            alld = Arrays.copyOf(alld, alld.length * 2);
                        }
                        alld[p++] = docs[i];
                    }
                    pos = td.read(docs, freqs);
                }
                td.close();
            }
            if (p > 0) {
                Arrays.sort(alld, 0, p);
                int curr = alld[0];
                int count = 0;
                for (int i = 0; i < p; ++i) {
                    int doc = alld[i];
                    if (doc == curr) {
                        ++count;
                        continue;
                    }
                    ++nHits;
                    this.heapCheck(h, hsize, curr += base, count);
                    curr = doc;
                    count = 1;
                }
                this.heapCheck(h, hsize, curr + base, count);
            }
            base += sub.maxDoc();
        }
        int outSize = Math.min(hsize, h.size());
        int[] rd = new int[outSize];
        float[] rs = new float[outSize];
        for (int i = outSize - 1; i >= 0; --i) {
            DocTermCount top = (DocTermCount)h.poll();
            rd[i] = top.getDoc();
            rs[i] = top.getCount();
        }
        return new DocSlice(0, outSize, rd, rs, nHits, outSize == 0 ? 0.0f : rs[0]);
    }

    public String getDescription() {
        return "Queries for a number of fingerprint hashes, returning the documents with the most occurrences";
    }

    public String getSourceId() {
        return "HashQueryComponent";
    }

    public String getSource() {
        return "HashQueryComponent";
    }

    public String getVersion() {
        return "HashQueryComponent";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DocTermCount
    implements Comparable<DocTermCount> {
        private int doc;
        private int count;

        public DocTermCount(int doc, int count) {
            this.doc = doc;
            this.count = count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }

        public int getDoc() {
            return this.doc;
        }

        public void setDoc(int doc) {
            this.doc = doc;
        }

        @Override
        public int compareTo(DocTermCount o) {
            return this.count - o.count;
        }
    }
}

