/*
 * Decompiled with CFR 0.152.
 */
package com.echonest.knowledge.hashr;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.common.SolrInputDocument;

public class Ingest {
    private static Logger logger = Logger.getLogger(Ingest.class.getName());

    private static void processFile(String f, SolrServer solr) throws IOException {
        String l;
        BufferedReader r = new BufferedReader(new FileReader(f));
        int ln = 0;
        int added = 0;
        ArrayList<SolrInputDocument> docs = new ArrayList<SolrInputDocument>();
        long start = System.currentTimeMillis();
        while ((l = r.readLine()) != null) {
            ++ln;
            int pos = l.indexOf(32);
            if (pos < 0) {
                System.err.format("Weird line at %d of file %s\n", ln, f);
                continue;
            }
            SolrInputDocument doc = new SolrInputDocument();
            doc.addField("track_id", (Object)l.substring(0, pos));
            doc.addField("fp", (Object)l.substring(pos + 1));
            docs.add(doc);
            ++added;
            if (docs.size() != 300) continue;
            long now = System.currentTimeMillis();
            try {
                solr.add(docs);
                logger.info(String.format("Added %d docs in %dms %.2fdocs/s", added, now - start, (double)added / (double)(now - start) * 1000.0));
            }
            catch (SolrServerException ex) {
                logger.log(Level.SEVERE, "Error indexing docs", ex);
            }
            docs.clear();
        }
        if (docs.size() > 0) {
            try {
                solr.add(docs);
            }
            catch (SolrServerException ex) {
                logger.log(Level.SEVERE, "Error indexing docs", ex);
            }
        }
        r.close();
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Usage: Ingest <solr URL> <dat file> <dat file>...");
            return;
        }
        CommonsHttpSolrServer solr = new CommonsHttpSolrServer(args[0]);
        for (int i = 1; i < args.length; ++i) {
            Ingest.processFile(args[i], (SolrServer)solr);
        }
    }
}

