/*
 * Decompiled with CFR 0.152.
 */
package com.echonest.knowledge.hashr;

import java.io.BufferedReader;
import java.io.FileReader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JQuery
implements Runnable {
    private static final Logger logger = Logger.getLogger(JQuery.class.getName());
    SolrServer solr;
    String path;
    List<String> l;
    long tt;

    public JQuery(List<String> l, String solr, String path) throws MalformedURLException {
        this.solr = new CommonsHttpSolrServer(solr);
        this.path = path;
        logger.info(String.format("path: %s", path));
        this.l = l;
    }

    @Override
    public void run() {
        int n = 0;
        for (String q : this.l) {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.add("q", new String[]{q});
            params.add("fl", new String[]{"*,score"});
            QueryRequest query = new QueryRequest((SolrParams)params);
            query.setPath(this.path);
            long start = System.currentTimeMillis();
            try {
                QueryResponse resp = new QueryResponse(this.solr.request((SolrRequest)query), this.solr);
                long elapsed = System.currentTimeMillis() - start;
                this.tt += elapsed;
                if (++n % 200 != 0) continue;
                logger.info(String.format("%s nq: %d avg: %.2f", Thread.currentThread().getName(), n, (double)this.tt / (double)n));
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Error running query");
                return;
            }
        }
        logger.info(String.format("%s nq: %d avg: %.2f", Thread.currentThread().getName(), n, (double)this.tt / (double)n));
    }

    public static void main(String[] args) throws Exception {
        int i;
        String q;
        if (args.length == 0) {
            System.err.println("Usage: JQuery <solr URL> <component> <query file> <n threads>");
            return;
        }
        BufferedReader r = new BufferedReader(new FileReader(args[2]));
        ArrayList<String> l = new ArrayList<String>();
        while ((q = r.readLine()) != null) {
            l.add(q);
        }
        int nThreads = Integer.parseInt(args[3]);
        if (nThreads == 1) {
            JQuery jq = new JQuery(l, args[0], args[1]);
            jq.run();
            logger.info(String.format("Over %d threads: %d queries avg time: %.2f", nThreads, l.size(), (double)jq.tt / (double)l.size()));
            return;
        }
        int per = l.size() / nThreads;
        JQuery[] qs = new JQuery[nThreads];
        Thread[] ts = new Thread[nThreads];
        for (i = 0; i < nThreads; ++i) {
            ArrayList<String> tl = new ArrayList<String>();
            for (int j = 0; j < per; ++j) {
                tl.add((String)l.remove(0));
            }
            qs[i] = new JQuery(tl, args[0], args[1]);
        }
        for (i = 0; i < nThreads; ++i) {
            ts[i] = new Thread(qs[i]);
            ts[i].start();
        }
        for (i = 0; i < nThreads; ++i) {
            ts[i].join();
        }
        long tt = 0L;
        long n = 0L;
        for (int i2 = 0; i2 < qs.length; ++i2) {
            tt += qs[i2].tt;
            n += (long)qs[i2].l.size();
        }
        logger.info(String.format("Over %d threads: %d queries avg time: %.2f", nThreads, n, (double)tt / (double)n));
    }
}

