/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ngram.NGramTokenFilter;
import org.apache.solr.analysis.BaseTokenFilterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NGramFilterFactory
extends BaseTokenFilterFactory {
    private int maxGramSize = 0;
    private int minGramSize = 0;

    @Override
    public void init(Map<String, String> args) {
        super.init(args);
        String maxArg = args.get("maxGramSize");
        this.maxGramSize = maxArg != null ? Integer.parseInt(maxArg) : 2;
        String minArg = args.get("minGramSize");
        this.minGramSize = minArg != null ? Integer.parseInt(minArg) : 1;
    }

    public NGramTokenFilter create(TokenStream input) {
        return new NGramTokenFilter(input, this.minGramSize, this.maxGramSize);
    }
}

