/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;

public final class TrimFilter
extends TokenFilter {
    final boolean updateOffsets;
    private final TermAttribute termAtt;
    private final OffsetAttribute offsetAtt;

    public TrimFilter(TokenStream in, boolean updateOffsets) {
        super(in);
        this.updateOffsets = updateOffsets;
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
        this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    }

    public boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        char[] termBuffer = this.termAtt.termBuffer();
        int len = this.termAtt.termLength();
        if (len == 0) {
            return true;
        }
        int start = 0;
        int end = 0;
        int endOff = 0;
        for (start = 0; start < len && termBuffer[start] <= ' '; ++start) {
        }
        for (end = len; end >= start && termBuffer[end - 1] <= ' '; --end) {
            ++endOff;
        }
        if (start > 0 || end < len) {
            if (start < end) {
                this.termAtt.setTermBuffer(termBuffer, start, end - start);
            } else {
                this.termAtt.setTermLength(0);
            }
            if (this.updateOffsets) {
                int newStart = this.offsetAtt.startOffset() + start;
                int newEnd = this.offsetAtt.endOffset() - (start < end ? endOff : 0);
                this.offsetAtt.setOffset(newStart, newEnd);
            }
        }
        return true;
    }
}

