/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.Token;
import org.apache.solr.client.solrj.request.FieldAnalysisRequest;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.AnalysisRequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldAnalysisRequestHandler
extends AnalysisRequestHandlerBase {
    @Override
    protected NamedList doAnalysis(SolrQueryRequest req) throws Exception {
        FieldAnalysisRequest analysisRequest = this.resolveAnalysisRequest(req);
        IndexSchema indexSchema = req.getCore().getSchema();
        return this.handleAnalysisRequest(analysisRequest, indexSchema);
    }

    @Override
    public String getDescription() {
        return "Provide a breakdown of the analysis process of field/query text";
    }

    @Override
    public String getVersion() {
        return "$Revision: 805844 $";
    }

    @Override
    public String getSourceId() {
        return "$Id: FieldAnalysisRequestHandler.java 805844 2009-08-19 15:38:11Z ehatcher $";
    }

    @Override
    public String getSource() {
        return "$URL: http://svn.apache.org/repos/asf/lucene/solr/branches/branch-1.4/src/java/org/apache/solr/handler/FieldAnalysisRequestHandler.java $";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    FieldAnalysisRequest resolveAnalysisRequest(SolrQueryRequest req) {
        String value;
        FieldAnalysisRequest analysisRequest;
        SolrParams solrParams;
        block8: {
            Iterator<ContentStream> i$;
            solrParams = req.getParams();
            analysisRequest = new FieldAnalysisRequest();
            boolean useDefaultSearchField = true;
            if (solrParams.get("analysis.fieldtype") != null) {
                analysisRequest.setFieldTypes(Arrays.asList(solrParams.get("analysis.fieldtype").split(",")));
                useDefaultSearchField = false;
            }
            if (solrParams.get("analysis.fieldname") != null) {
                analysisRequest.setFieldNames(Arrays.asList(solrParams.get("analysis.fieldname").split(",")));
                useDefaultSearchField = false;
            }
            if (useDefaultSearchField) {
                analysisRequest.addFieldName(req.getSchema().getDefaultSearchFieldName());
            }
            analysisRequest.setQuery(solrParams.get("analysis.query", solrParams.get("q")));
            value = solrParams.get("analysis.fieldvalue");
            Iterable<ContentStream> streams = req.getContentStreams();
            if (streams != null && (i$ = streams.iterator()).hasNext()) {
                ContentStream stream = i$.next();
                Reader reader = null;
                try {
                    try {
                        reader = stream.getReader();
                        value = IOUtils.toString((Reader)reader);
                    }
                    catch (IOException e) {
                        Object var12_11 = null;
                        IOUtils.closeQuietly((Reader)reader);
                        break block8;
                    }
                    Object var12_10 = null;
                }
                catch (Throwable throwable) {
                    Object var12_12 = null;
                    IOUtils.closeQuietly((Reader)reader);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        analysisRequest.setFieldValue(value);
        analysisRequest.setShowMatch(solrParams.getBool("analysis.showmatch", false));
        return analysisRequest;
    }

    protected NamedList<NamedList> handleAnalysisRequest(FieldAnalysisRequest request, IndexSchema schema) {
        SimpleOrderedMap analysisResults = new SimpleOrderedMap();
        SimpleOrderedMap fieldTypeAnalysisResults = new SimpleOrderedMap();
        if (request.getFieldTypes() != null) {
            for (String fieldTypeName : request.getFieldTypes()) {
                FieldType fieldType = schema.getFieldTypes().get(fieldTypeName);
                fieldTypeAnalysisResults.add(fieldTypeName, this.analyzeValues(request, fieldType, null));
            }
        }
        SimpleOrderedMap fieldNameAnalysisResults = new SimpleOrderedMap();
        if (request.getFieldNames() != null) {
            for (String fieldName : request.getFieldNames()) {
                FieldType fieldType = schema.getFieldType(fieldName);
                fieldNameAnalysisResults.add(fieldName, this.analyzeValues(request, fieldType, fieldName));
            }
        }
        analysisResults.add("field_types", (Object)fieldTypeAnalysisResults);
        analysisResults.add("field_names", (Object)fieldNameAnalysisResults);
        return analysisResults;
    }

    private NamedList<NamedList> analyzeValues(FieldAnalysisRequest analysisRequest, FieldType fieldType, String fieldName) {
        NamedList<List<NamedList>> analyzedTokens;
        AnalysisRequestHandlerBase.AnalysisContext context;
        HashSet<String> termsToMatch = new HashSet<String>();
        String queryValue = analysisRequest.getQuery();
        if (queryValue != null && analysisRequest.isShowMatch()) {
            List<Token> tokens = this.analyzeValue(queryValue, fieldType.getQueryAnalyzer());
            for (Token token : tokens) {
                termsToMatch.add(token.term());
            }
        }
        SimpleOrderedMap analyzeResults = new SimpleOrderedMap();
        if (analysisRequest.getFieldValue() != null) {
            context = new AnalysisRequestHandlerBase.AnalysisContext(fieldName, fieldType, fieldType.getAnalyzer(), termsToMatch);
            analyzedTokens = this.analyzeValue(analysisRequest.getFieldValue(), context);
            analyzeResults.add("index", analyzedTokens);
        }
        if (analysisRequest.getQuery() != null) {
            context = new AnalysisRequestHandlerBase.AnalysisContext(fieldName, fieldType, fieldType.getQueryAnalyzer());
            analyzedTokens = this.analyzeValue(analysisRequest.getQuery(), context);
            analyzeResults.add("query", analyzedTokens);
        }
        return analyzeResults;
    }
}

