/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowFileRequestHandler
extends RequestHandlerBase {
    public static final String HIDDEN = "hidden";
    public static final String USE_CONTENT_TYPE = "contentType";
    protected Set<String> hiddenFiles;
    private static ShowFileRequestHandler instance;

    public ShowFileRequestHandler() {
        instance = this;
    }

    @Override
    public void init(NamedList args) {
        String[] hidden;
        super.init(args);
        ModifiableSolrParams params = new ModifiableSolrParams(this.invariants);
        if (params.get("wt") == null) {
            params.set("wt", new String[]{"raw"});
        }
        this.invariants = params;
        this.hiddenFiles = new HashSet<String>();
        if (this.invariants != null && (hidden = this.invariants.getParams(HIDDEN)) != null) {
            for (String s : hidden) {
                this.hiddenFiles.add(s.toUpperCase());
            }
        }
    }

    public Set<String> getHiddenFiles() {
        return this.hiddenFiles;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        File adminFile = null;
        SolrResourceLoader loader = req.getCore().getResourceLoader();
        File configdir = new File(loader.getConfigDir());
        String fname = req.getParams().get("file", null);
        if (fname == null) {
            adminFile = configdir;
        } else {
            if (this.hiddenFiles.contains((fname = fname.replace('\\', '/')).toUpperCase())) {
                throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "Can not access: " + fname);
            }
            if (fname.indexOf("..") >= 0) {
                throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "Invalid path: " + fname);
            }
            adminFile = new File(configdir, fname);
        }
        if (!adminFile.exists()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not find: " + adminFile.getName() + " [" + adminFile.getAbsolutePath() + "]");
        }
        if (!adminFile.canRead() || adminFile.isHidden()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not show: " + adminFile.getName() + " [" + adminFile.getAbsolutePath() + "]");
        }
        if (adminFile.isDirectory()) {
            int basePath = configdir.getAbsolutePath().length() + 1;
            SimpleOrderedMap files = new SimpleOrderedMap();
            for (File f : adminFile.listFiles()) {
                String path = f.getAbsolutePath().substring(basePath);
                if (this.hiddenFiles.contains((path = path.replace('\\', '/')).toUpperCase()) || f.isHidden() || f.getName().startsWith(".")) continue;
                SimpleOrderedMap fileInfo = new SimpleOrderedMap();
                files.add(path, (Object)fileInfo);
                if (f.isDirectory()) {
                    fileInfo.add("directory", (Object)true);
                } else {
                    fileInfo.add("size", (Object)f.length());
                }
                fileInfo.add("modified", (Object)new Date(f.lastModified()));
            }
            rsp.add("files", files);
        } else {
            ContentStreamBase.FileStream content = new ContentStreamBase.FileStream(adminFile);
            content.setContentType(req.getParams().get(USE_CONTENT_TYPE));
            rsp.add("content", content);
        }
        rsp.setHttpCaching(false);
    }

    @Deprecated
    public static String getFileContents(String path) {
        if (instance != null && ShowFileRequestHandler.instance.hiddenFiles != null && ShowFileRequestHandler.instance.hiddenFiles.contains(path)) {
            return "";
        }
        try {
            SolrCore core = SolrCore.getSolrCore();
            InputStream input = core.getResourceLoader().openResource(path);
            return IOUtils.toString((InputStream)input);
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public String getDescription() {
        return "Admin Get File -- view config files directly";
    }

    @Override
    public String getVersion() {
        return "$Revision: 790580 $";
    }

    @Override
    public String getSourceId() {
        return "$Id: ShowFileRequestHandler.java 790580 2009-07-02 13:20:22Z markrmiller $";
    }

    @Override
    public String getSource() {
        return "$URL: http://svn.apache.org/repos/asf/lucene/solr/branches/branch-1.4/src/java/org/apache/solr/handler/admin/ShowFileRequestHandler.java $";
    }
}

