/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ElevationComparatorSource
extends FieldComparatorSource {
    private final Map<String, Integer> priority;

    public ElevationComparatorSource(Map<String, Integer> boosts) {
        this.priority = boosts;
    }

    public FieldComparator newComparator(final String fieldname, final int numHits, int sortPos, boolean reversed) throws IOException {
        return new FieldComparator(){
            FieldCache.StringIndex idIndex;
            private final int[] values;
            int bottomVal;
            {
                this.values = new int[numHits];
            }

            public int compare(int slot1, int slot2) {
                return this.values[slot2] - this.values[slot1];
            }

            public void setBottom(int slot) {
                this.bottomVal = this.values[slot];
            }

            private int docVal(int doc) throws IOException {
                String id = this.idIndex.lookup[this.idIndex.order[doc]];
                Integer prio = (Integer)ElevationComparatorSource.this.priority.get(id);
                return prio == null ? 0 : prio;
            }

            public int compareBottom(int doc) throws IOException {
                return this.docVal(doc) - this.bottomVal;
            }

            public void copy(int slot, int doc) throws IOException {
                this.values[slot] = this.docVal(doc);
            }

            public void setNextReader(IndexReader reader, int docBase) throws IOException {
                this.idIndex = FieldCache.DEFAULT.getStringIndex(reader, fieldname);
            }

            public Comparable value(int slot) {
                return Integer.valueOf(this.values[slot]);
            }
        };
    }
}

