/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.net.URL;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.MoreLikeThisHandler;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.search.DocList;
import org.apache.solr.search.SolrIndexSearcher;

public class MoreLikeThisComponent
extends SearchComponent {
    public static final String COMPONENT_NAME = "mlt";

    public void prepare(ResponseBuilder rb) throws IOException {
    }

    public void process(ResponseBuilder rb) throws IOException {
        SolrParams p = rb.req.getParams();
        if (p.getBool(COMPONENT_NAME, false)) {
            SolrIndexSearcher searcher = rb.req.getSearcher();
            MoreLikeThisHandler.MoreLikeThisHelper mlt = new MoreLikeThisHandler.MoreLikeThisHelper(p, searcher);
            int mltcount = p.getInt("mlt.count", 5);
            NamedList<DocList> sim = mlt.getMoreLikeThese(rb.getResults().docList, mltcount, rb.getFieldFlags());
            rb.rsp.add("moreLikeThis", sim);
        }
    }

    public String getDescription() {
        return "More Like This";
    }

    public String getVersion() {
        return "$Revision: 631357 $";
    }

    public String getSourceId() {
        return "$Id: MoreLikeThisComponent.java 631357 2008-02-26 19:47:07Z yonik $";
    }

    public String getSource() {
        return "$URL: http://svn.apache.org/repos/asf/lucene/solr/branches/branch-1.4/src/java/org/apache/solr/handler/component/MoreLikeThisComponent.java $";
    }

    public URL[] getDocs() {
        return null;
    }
}

