/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LogMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.StandardDirectoryFactory;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.update.SolrIndexConfig;
import org.apache.solr.util.SolrPluginUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrIndexWriter
extends IndexWriter {
    private static Logger log = LoggerFactory.getLogger(SolrIndexWriter.class);
    String name;
    IndexSchema schema;
    private PrintStream infoStream;
    private static DirectoryFactory LEGACY_DIR_FACTORY = new StandardDirectoryFactory();
    private boolean isClosed = false;

    private void init(String name, IndexSchema schema, SolrIndexConfig config) throws IOException {
        log.debug("Opened Writer " + name);
        this.name = name;
        this.schema = schema;
        this.setSimilarity(schema.getSimilarity());
        if (config != null) {
            if (config.maxBufferedDocs != -1) {
                this.setMaxBufferedDocs(config.maxBufferedDocs);
            }
            if (config.ramBufferSizeMB != -1.0) {
                this.setRAMBufferSizeMB(config.ramBufferSizeMB);
            }
            if (config.termIndexInterval != -1) {
                this.setTermIndexInterval(config.termIndexInterval);
            }
            if (config.maxMergeDocs != -1) {
                this.setMaxMergeDocs(config.maxMergeDocs);
            }
            if (config.maxFieldLength != -1) {
                this.setMaxFieldLength(config.maxFieldLength);
            }
            String className = config.mergePolicyInfo == null ? SolrIndexConfig.DEFAULT_MERGE_POLICY_CLASSNAME : config.mergePolicyInfo.className;
            MergePolicy policy = null;
            try {
                policy = (MergePolicy)schema.getResourceLoader().newInstance(className, null, new Class[]{IndexWriter.class}, new Object[]{this});
            }
            catch (Exception e) {
                policy = (MergePolicy)schema.getResourceLoader().newInstance(className, new String[0]);
            }
            if (config.mergePolicyInfo != null) {
                SolrPluginUtils.invokeSetters(policy, config.mergePolicyInfo.initArgs);
            }
            this.setMergePolicy(policy);
            if (this.getMergePolicy() instanceof LogMergePolicy) {
                this.setUseCompoundFile(config.useCompoundFile);
            } else {
                log.warn("Use of compound file format cannot be configured if merge policy is not an instance of LogMergePolicy. The configured policy's defaults will be used.");
            }
            className = config.mergeSchedulerInfo == null ? SolrIndexConfig.DEFAULT_MERGE_SCHEDULER_CLASSNAME : config.mergeSchedulerInfo.className;
            MergeScheduler scheduler = (MergeScheduler)schema.getResourceLoader().newInstance(className, new String[0]);
            if (config.mergeSchedulerInfo != null) {
                SolrPluginUtils.invokeSetters(scheduler, config.mergeSchedulerInfo.initArgs);
            }
            this.setMergeScheduler(scheduler);
            String infoStreamFile = config.infoStreamFile;
            if (infoStreamFile != null) {
                File f = new File(infoStreamFile);
                File parent = f.getParentFile();
                if (parent != null) {
                    parent.mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(f, true);
                this.infoStream = new TimeLoggingPrintStream(fos, true);
                this.setInfoStream(this.infoStream);
            }
        }
    }

    public static Directory getDirectory(String path, DirectoryFactory directoryFactory, SolrIndexConfig config) throws IOException {
        String lockType;
        String rawLockType;
        Directory d = directoryFactory.open(path);
        String string = rawLockType = null == config ? null : config.lockType;
        if (null == rawLockType) {
            log.warn("No lockType configured for " + path + " assuming 'simple'");
            rawLockType = "simple";
        }
        if ("simple".equals(lockType = rawLockType.toLowerCase().trim())) {
            d.setLockFactory((LockFactory)new SimpleFSLockFactory(path));
        } else if ("native".equals(lockType)) {
            d.setLockFactory((LockFactory)new NativeFSLockFactory(path));
        } else if ("single".equals(lockType)) {
            if (!(d.getLockFactory() instanceof SingleInstanceLockFactory)) {
                d.setLockFactory((LockFactory)new SingleInstanceLockFactory());
            }
        } else if ("none".equals(lockType)) {
            log.error("CONFIGURATION WARNING: locks are disabled on " + path);
            d.setLockFactory((LockFactory)new NoLockFactory());
        } else {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unrecognized lockType: " + rawLockType);
        }
        return d;
    }

    public static Directory getDirectory(String path, SolrIndexConfig config) throws IOException {
        log.warn("SolrIndexWriter is using LEGACY_DIR_FACTORY which means deprecated code is likely in use and SolrIndexWriter is ignoring any custom DirectoryFactory.");
        return SolrIndexWriter.getDirectory(path, LEGACY_DIR_FACTORY, config);
    }

    public SolrIndexWriter(String name, String path, DirectoryFactory dirFactory, boolean create, IndexSchema schema) throws IOException {
        super(SolrIndexWriter.getDirectory(path, dirFactory, null), false, schema.getAnalyzer(), create);
        this.init(name, schema, null);
    }

    @Deprecated
    public SolrIndexWriter(String name, String path, DirectoryFactory dirFactory, boolean create, IndexSchema schema, SolrIndexConfig config) throws IOException {
        super(SolrIndexWriter.getDirectory(path, dirFactory, null), config.luceneAutoCommit, schema.getAnalyzer(), create);
        this.init(name, schema, config);
    }

    public SolrIndexWriter(String name, String path, boolean create, IndexSchema schema) throws IOException {
        super(SolrIndexWriter.getDirectory(path, null), false, schema.getAnalyzer(), create);
        this.init(name, schema, null);
    }

    public SolrIndexWriter(String name, String path, boolean create, IndexSchema schema, SolrIndexConfig config) throws IOException {
        super(SolrIndexWriter.getDirectory(path, config), config.luceneAutoCommit, schema.getAnalyzer(), create);
        this.init(name, schema, config);
    }

    public SolrIndexWriter(String name, String path, DirectoryFactory dirFactory, boolean create, IndexSchema schema, SolrIndexConfig config, IndexDeletionPolicy delPolicy) throws IOException {
        super(SolrIndexWriter.getDirectory(path, dirFactory, config), schema.getAnalyzer(), create, delPolicy, new IndexWriter.MaxFieldLength(10000));
        this.init(name, schema, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        log.debug("Closing Writer " + this.name);
        try {
            super.close();
            if (this.infoStream != null) {
                this.infoStream.close();
            }
            Object var2_1 = null;
            this.isClosed = true;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.isClosed = true;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.isClosed) {
                log.error("SolrIndexWriter was not closed prior to finalize(), indicates a bug -- POSSIBLE RESOURCE LEAK!!!");
                this.close();
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    static {
        LEGACY_DIR_FACTORY.init(new NamedList());
    }

    class TimeLoggingPrintStream
    extends PrintStream {
        private DateFormat dateFormat;

        public TimeLoggingPrintStream(OutputStream underlyingOutputStream, boolean autoFlush) {
            super(underlyingOutputStream, autoFlush);
            this.dateFormat = DateFormat.getDateTimeInstance();
        }

        public void println(String x) {
            this.print(this.dateFormat.format(new Date()) + " ");
            super.println(x);
        }
    }
}

