/*
 * Decompiled with CFR 0.152.
 */
package jsongminer;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintStream;
import java.util.HashMap;
import mckay.utilities.staticlibraries.FileMethods;
import mckay.utilities.xml.ParsingXMLErrorHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ConfigDataAndParser
extends DefaultHandler {
    public boolean identify_only;
    public boolean package_song_artist_album;
    public boolean reextract_known_artist_metadata;
    public boolean reextract_known_album_metadata;
    public boolean include_unqualified_dublin_core;
    public boolean include_qualified_dublin_core;
    public boolean include_other_metadata_with_dublin_core;
    public boolean enable_echo_nest_fingerprinting;
    public boolean save_echo_nest_metadata;
    public boolean enable_last_fm_fingerprinting;
    public boolean save_last_fm_metadata;
    public boolean enable_embedded_metadata_track_identification;
    public boolean save_embedded_metadata;
    public boolean store_fails;
    public boolean url_encode_output;
    public boolean save_output_as_ace_xml;
    public boolean save_output_as_txt;
    public boolean print_extracted_metadata_to_terminal;
    public boolean print_current_status_to_terminal;
    public boolean print_errors_to_terminal;
    public String songs_save_directory;
    public String artists_save_directory;
    public String albums_save_directory;
    public String echo_nest_api_key;
    public String echo_nest_fingerprinting_codegen_run_path;
    public String echo_nest_codegen_directory;
    public String last_fm_api_key;
    public String artists_already_accessed_file_path;
    public String albums_already_accessed_file_path;
    private HashMap<String, Boolean> parsing_state;
    private StringBuffer element_text_so_far;
    private boolean parsing_begun;

    public ConfigDataAndParser(String config_file_path, PrintStream warning_stream) {
        block8: {
            this.setPublicFieldsToDefaults();
            if (config_file_path != null) {
                try {
                    this.parsejSongMinerConfigurationFile(config_file_path);
                }
                catch (Exception e) {
                    if (warning_stream != null) {
                        warning_stream.println("WARNING: Could not parse the jSongMiner configuration file that should be at " + config_file_path);
                        warning_stream.println("DETAILS: " + e.getMessage());
                        warning_stream.println("This is normal the first time that this program is run.\n");
                        warning_stream.println("Reverting to default configuration settings...\n");
                        warning_stream.println("Saving default configuration settings to " + config_file_path + "...\n");
                    }
                    try {
                        this.setPublicFieldsToDefaults();
                        this.saveConfigurationFile(config_file_path);
                        if (warning_stream != null) {
                            warning_stream.println("Saving of configuration settings complete.");
                            warning_stream.println("It is strongly recommended that you change these settings now that they are saved, either by editing the file manually or by using command line options.\n");
                        }
                    }
                    catch (Exception f) {
                        if (warning_stream == null) break block8;
                        warning_stream.println("WARNING: Could not save the jSongMinerConfiguration file to " + config_file_path);
                        warning_stream.println("DETAILS: " + f.getMessage());
                        warning_stream.println("Please be sure that this directory exists with read/write permissions, otherwise it will not be possible to save a configuration file.");
                        warning_stream.println("Proceeding with default configuration settings...\n");
                    }
                }
            }
        }
        if (warning_stream != null) {
            this.testPublicFieldValues(warning_stream);
        }
    }

    public void parsejSongMinerConfigurationFile(String path_of_file_to_parse) throws Exception {
        this.refreshParsingFields();
        FileMethods.validateFile((File)new File(path_of_file_to_parse), (boolean)true, (boolean)false);
        ConfigDataAndParser handler = this;
        XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        parser.setFeature("http://xml.org/sax/features/validation", true);
        parser.setErrorHandler((ErrorHandler)new ParsingXMLErrorHandler());
        parser.setContentHandler(handler);
        try {
            parser.parse(path_of_file_to_parse);
        }
        catch (SAXParseException e) {
            throw new Exception("The " + path_of_file_to_parse + " file is not a valid XML file.\n\n" + "Details of the problem: " + e.getMessage() + "This error is likely in the region of line " + e.getLineNumber() + ".");
        }
        catch (SAXException e) {
            throw new Exception("The " + path_of_file_to_parse + " file must be a valid jSongMiner configuration file.\n" + "Details of the problem: " + e.getMessage());
        }
        catch (Exception e) {
            throw new Exception("The " + path_of_file_to_parse + " file is not formatted properly.\n" + "Details of the problem: " + e.getMessage());
        }
    }

    public void saveConfigurationFile(String save_path) throws Exception {
        try {
            FileWriter writer = new FileWriter(new File(save_path));
            writer.write("<?xml version=\"1.0\"?>\n");
            writer.write("<!DOCTYPE jsongminer_config_file [\n");
            writer.write("\t<!ELEMENT jsongminer_config_file (identify_only, package_song_artist_album, reextract_known_artist_metadata, reextract_known_album_metadata, include_unqualified_dublin_core, include_qualified_dublin_core, include_other_metadata_with_dublin_core, enable_echo_nest_fingerprinting, save_echo_nest_metadata, enable_last_fm_fingerprinting, save_last_fm_metadata, enable_embedded_metadata_track_identification, save_embedded_metadata, store_fails, url_encode_output, save_output_as_ace_xml, save_output_as_txt, print_extracted_metadata_to_terminal, print_current_status_to_terminal, print_errors_to_terminal, songs_save_directory, artists_save_directory, albums_save_directory, echo_nest_api_key, echo_nest_fingerprinting_codegen_run_path, echo_nest_codegen_directory, last_fm_api_key, artists_already_accessed_file_path, albums_already_accessed_file_path)>\n");
            writer.write("\t<!ELEMENT identify_only (#PCDATA)>\n");
            writer.write("\t<!ELEMENT package_song_artist_album (#PCDATA)>\n");
            writer.write("\t<!ELEMENT reextract_known_artist_metadata (#PCDATA)>\n");
            writer.write("\t<!ELEMENT reextract_known_album_metadata (#PCDATA)>\n");
            writer.write("\t<!ELEMENT include_unqualified_dublin_core (#PCDATA)>\n");
            writer.write("\t<!ELEMENT include_qualified_dublin_core (#PCDATA)>\n");
            writer.write("\t<!ELEMENT include_other_metadata_with_dublin_core (#PCDATA)>\n");
            writer.write("\t<!ELEMENT enable_echo_nest_fingerprinting (#PCDATA)>\n");
            writer.write("\t<!ELEMENT enable_last_fm_fingerprinting (#PCDATA)>\n");
            writer.write("\t<!ELEMENT save_echo_nest_metadata (#PCDATA)>\n");
            writer.write("\t<!ELEMENT enable_embedded_metadata_track_identification (#PCDATA)>\n");
            writer.write("\t<!ELEMENT save_last_fm_metadata (#PCDATA)>\n");
            writer.write("\t<!ELEMENT save_embedded_metadata (#PCDATA)>\n");
            writer.write("\t<!ELEMENT store_fails (#PCDATA)>\n");
            writer.write("\t<!ELEMENT url_encode_output (#PCDATA)>\n");
            writer.write("\t<!ELEMENT save_output_as_ace_xml (#PCDATA)>\n");
            writer.write("\t<!ELEMENT save_output_as_txt (#PCDATA)>\n");
            writer.write("\t<!ELEMENT print_extracted_metadata_to_terminal (#PCDATA)>\n");
            writer.write("\t<!ELEMENT print_current_status_to_terminal (#PCDATA)>\n");
            writer.write("\t<!ELEMENT print_errors_to_terminal (#PCDATA)>\n");
            writer.write("\t<!ELEMENT songs_save_directory (#PCDATA)>\n");
            writer.write("\t<!ELEMENT artists_save_directory (#PCDATA)>\n");
            writer.write("\t<!ELEMENT albums_save_directory (#PCDATA)>\n");
            writer.write("\t<!ELEMENT echo_nest_api_key (#PCDATA)>\n");
            writer.write("\t<!ELEMENT echo_nest_fingerprinting_codegen_run_path (#PCDATA)>\n");
            writer.write("\t<!ELEMENT echo_nest_codegen_directory (#PCDATA)>\n");
            writer.write("\t<!ELEMENT last_fm_api_key (#PCDATA)>\n");
            writer.write("\t<!ELEMENT artists_already_accessed_file_path (#PCDATA)>\n");
            writer.write("\t<!ELEMENT albums_already_accessed_file_path (#PCDATA)>\n");
            writer.write("]>\n");
            writer.write("\n");
            writer.write("<jsongminer_config_file>\n");
            writer.write("\t<identify_only>" + this.identify_only + "</identify_only>\n");
            writer.write("\t<package_song_artist_album>" + this.package_song_artist_album + "</package_song_artist_album>\n");
            writer.write("\t<reextract_known_artist_metadata>" + this.reextract_known_artist_metadata + "</reextract_known_artist_metadata>\n");
            writer.write("\t<reextract_known_album_metadata>" + this.reextract_known_album_metadata + "</reextract_known_album_metadata>\n");
            writer.write("\t<include_unqualified_dublin_core>" + this.include_unqualified_dublin_core + "</include_unqualified_dublin_core>\n");
            writer.write("\t<include_qualified_dublin_core>" + this.include_qualified_dublin_core + "</include_qualified_dublin_core>\n");
            writer.write("\t<include_other_metadata_with_dublin_core>" + this.include_other_metadata_with_dublin_core + "</include_other_metadata_with_dublin_core>\n");
            writer.write("\t<enable_echo_nest_fingerprinting>" + this.enable_echo_nest_fingerprinting + "</enable_echo_nest_fingerprinting>\n");
            writer.write("\t<save_echo_nest_metadata>" + this.save_echo_nest_metadata + "</save_echo_nest_metadata>\n");
            writer.write("\t<enable_last_fm_fingerprinting>" + this.enable_last_fm_fingerprinting + "</enable_last_fm_fingerprinting>\n");
            writer.write("\t<save_last_fm_metadata>" + this.save_last_fm_metadata + "</save_last_fm_metadata>\n");
            writer.write("\t<enable_embedded_metadata_track_identification>" + this.enable_embedded_metadata_track_identification + "</enable_embedded_metadata_track_identification>\n");
            writer.write("\t<save_embedded_metadata>" + this.save_embedded_metadata + "</save_embedded_metadata>\n");
            writer.write("\t<store_fails>" + this.store_fails + "</store_fails>\n");
            writer.write("\t<url_encode_output>" + this.url_encode_output + "</url_encode_output>\n");
            writer.write("\t<save_output_as_ace_xml>" + this.save_output_as_ace_xml + "</save_output_as_ace_xml>\n");
            writer.write("\t<save_output_as_txt>" + this.save_output_as_txt + "</save_output_as_txt>\n");
            writer.write("\t<print_extracted_metadata_to_terminal>" + this.print_extracted_metadata_to_terminal + "</print_extracted_metadata_to_terminal>\n");
            writer.write("\t<print_current_status_to_terminal>" + this.print_current_status_to_terminal + "</print_current_status_to_terminal>\n");
            writer.write("\t<print_errors_to_terminal>" + this.print_errors_to_terminal + "</print_errors_to_terminal>\n");
            writer.write("\t<songs_save_directory>" + this.songs_save_directory + "</songs_save_directory>\n");
            writer.write("\t<artists_save_directory>" + this.artists_save_directory + "</artists_save_directory>\n");
            writer.write("\t<albums_save_directory>" + this.albums_save_directory + "</albums_save_directory>\n");
            writer.write("\t<echo_nest_api_key>" + this.echo_nest_api_key + "</echo_nest_api_key>\n");
            writer.write("\t<echo_nest_fingerprinting_codegen_run_path>" + this.echo_nest_fingerprinting_codegen_run_path + "</echo_nest_fingerprinting_codegen_run_path>\n");
            writer.write("\t<echo_nest_codegen_directory>" + this.echo_nest_codegen_directory + "</echo_nest_codegen_directory>\n");
            writer.write("\t<last_fm_api_key>" + this.last_fm_api_key + "</last_fm_api_key>\n");
            writer.write("\t<artists_already_accessed_file_path>" + this.artists_already_accessed_file_path + "</artists_already_accessed_file_path>\n");
            writer.write("\t<albums_already_accessed_file_path>" + this.albums_already_accessed_file_path + "</albums_already_accessed_file_path>\n");
            writer.write("</jsongminer_config_file>");
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            throw new Exception("Given file " + save_path + " may not be written to. Details: " + e.getMessage());
        }
    }

    public void testPublicFieldValues(PrintStream to_write) {
        if (this.echo_nest_api_key == null) {
            to_write.println("WARNING: No Echo Nest API key is specified in the configuration file. It is strongly suggested that one be acquired from http://developer.echonest.com/account/register and entered in the configuration file for this software, as the Echo Nest web services may not return results otherwise.\n");
        }
        if (this.last_fm_api_key == null) {
            to_write.println("WARNING: No Last.FM API key is specified in the configuration file. It is strongly suggested that one be acquired from http://www.last.fm/api/account and entered in the configuration file for this software, as the Last.FM web services may not return results otherwise.\n");
        }
        if (!(this.print_extracted_metadata_to_terminal || this.save_output_as_ace_xml || this.save_output_as_txt)) {
            to_write.println("WARNING: Under the current configuration settings, none of the options (ACE XML, text or printing to standard out) are selected for outputting extracted metadata. It is strongly suggested that one or more of them be activated on the configurations file for this software so that extracted metadata may be examined, unless overrides are specified at the command line.\n");
        }
        if (!this.url_encode_output) {
            to_write.println("WARNING: Under the current configuration settings, output will be generated whose content is not URL encoded. This could result in the generation of invalid XML or text files that do not parse properly, so it is strongly suggested that URL encoding be turned on in the configurations file, unless all that is wanted is output results to standard out.\n");
        }
        if (!(this.save_echo_nest_metadata || this.save_last_fm_metadata || this.save_embedded_metadata)) {
            to_write.println("WARNING: Under the current configuration settings, no extracted metadata will be saved. It is therefore strongly suggested that at least one of the desired metadata sources be activated in the configuration settings file.\n");
        }
        if (!(this.enable_echo_nest_fingerprinting || this.enable_last_fm_fingerprinting || this.enable_embedded_metadata_track_identification)) {
            to_write.println("WARNING: Under the current configuration settings, all of the song identification methods are disabled, other than using tags manually specified at the command line. It is suggested that other means of song identification be activated in the configuration settings file.\n");
        }
    }

    private void setPublicFieldsToDefaults() {
        this.identify_only = false;
        this.package_song_artist_album = true;
        this.reextract_known_artist_metadata = true;
        this.reextract_known_album_metadata = true;
        this.include_unqualified_dublin_core = false;
        this.include_qualified_dublin_core = false;
        this.include_other_metadata_with_dublin_core = true;
        this.enable_echo_nest_fingerprinting = true;
        this.save_echo_nest_metadata = true;
        this.enable_last_fm_fingerprinting = true;
        this.save_last_fm_metadata = true;
        this.enable_embedded_metadata_track_identification = true;
        this.save_embedded_metadata = true;
        this.store_fails = false;
        this.url_encode_output = true;
        this.save_output_as_ace_xml = true;
        this.save_output_as_txt = false;
        this.print_extracted_metadata_to_terminal = true;
        this.print_current_status_to_terminal = true;
        this.print_errors_to_terminal = true;
        this.songs_save_directory = System.getProperty("user.home");
        this.artists_save_directory = System.getProperty("user.home");
        this.albums_save_directory = System.getProperty("user.home");
        this.echo_nest_api_key = null;
        this.echo_nest_fingerprinting_codegen_run_path = null;
        this.echo_nest_codegen_directory = null;
        this.last_fm_api_key = null;
        this.artists_already_accessed_file_path = "./artists_so_far.ser";
        this.albums_already_accessed_file_path = "./albums_so_far.ser";
    }

    private void refreshParsingFields() {
        this.parsing_begun = false;
        this.parsing_state = new HashMap(16);
        this.parsing_state.put("jsongminer_config_file", new Boolean(false));
        this.parsing_state.put("identify_only", new Boolean(false));
        this.parsing_state.put("package_song_artist_album", new Boolean(false));
        this.parsing_state.put("reextract_known_artist_metadata", new Boolean(false));
        this.parsing_state.put("reextract_known_album_metadata", new Boolean(false));
        this.parsing_state.put("include_unqualified_dublin_core", new Boolean(false));
        this.parsing_state.put("include_qualified_dublin_core", new Boolean(false));
        this.parsing_state.put("include_other_metadata_with_dublin_core", new Boolean(false));
        this.parsing_state.put("enable_echo_nest_fingerprinting", new Boolean(false));
        this.parsing_state.put("save_echo_nest_metadata", new Boolean(false));
        this.parsing_state.put("enable_last_fm_fingerprinting", new Boolean(false));
        this.parsing_state.put("save_last_fm_metadata", new Boolean(false));
        this.parsing_state.put("enable_embedded_metadata_track_identification", new Boolean(false));
        this.parsing_state.put("save_embedded_metadata", new Boolean(false));
        this.parsing_state.put("store_fails", new Boolean(false));
        this.parsing_state.put("url_encode_output", new Boolean(false));
        this.parsing_state.put("save_output_as_ace_xml", new Boolean(false));
        this.parsing_state.put("save_output_as_txt", new Boolean(false));
        this.parsing_state.put("print_extracted_metadata_to_terminal", new Boolean(false));
        this.parsing_state.put("print_current_status_to_terminal", new Boolean(false));
        this.parsing_state.put("print_errors_to_terminal", new Boolean(false));
        this.parsing_state.put("songs_save_directory", new Boolean(false));
        this.parsing_state.put("artists_save_directory", new Boolean(false));
        this.parsing_state.put("albums_save_directory", new Boolean(false));
        this.parsing_state.put("echo_nest_api_key", new Boolean(false));
        this.parsing_state.put("echo_nest_fingerprinting_codegen_run_path", new Boolean(false));
        this.parsing_state.put("echo_nest_codegen_directory", new Boolean(false));
        this.parsing_state.put("last_fm_api_key", new Boolean(false));
        this.parsing_state.put("artists_already_accessed_file_path", new Boolean(false));
        this.parsing_state.put("albums_already_accessed_file_path", new Boolean(false));
    }

    public void startElement(String namespace, String element_name, String qual_name, Attributes attributes) throws SAXException {
        if (!this.parsing_begun) {
            if (!element_name.equals("jsongminer_config_file")) {
                throw new SAXException("This is a " + element_name + " type XML file. It should be a jsongminer_config_file type file.");
            }
            this.parsing_begun = true;
        }
        this.element_text_so_far = new StringBuffer();
        this.parsing_state.put(element_name, true);
    }

    public void characters(char[] characters, int start_position, int length) throws SAXException {
        String text = new String(characters, start_position, length);
        this.element_text_so_far.append(text);
    }

    public void endElement(String namespace, String element_name, String qual_name) throws SAXException {
        String text = this.element_text_so_far.toString();
        if (this.parsing_state.get("identify_only").booleanValue()) {
            this.identify_only = new Boolean(text);
        } else if (this.parsing_state.get("package_song_artist_album").booleanValue()) {
            this.package_song_artist_album = new Boolean(text);
        } else if (this.parsing_state.get("reextract_known_artist_metadata").booleanValue()) {
            this.reextract_known_artist_metadata = new Boolean(text);
        } else if (this.parsing_state.get("reextract_known_album_metadata").booleanValue()) {
            this.reextract_known_album_metadata = new Boolean(text);
        } else if (this.parsing_state.get("include_unqualified_dublin_core").booleanValue()) {
            this.include_unqualified_dublin_core = new Boolean(text);
        } else if (this.parsing_state.get("include_qualified_dublin_core").booleanValue()) {
            this.include_qualified_dublin_core = new Boolean(text);
        } else if (this.parsing_state.get("include_other_metadata_with_dublin_core").booleanValue()) {
            this.include_other_metadata_with_dublin_core = new Boolean(text);
        } else if (this.parsing_state.get("enable_echo_nest_fingerprinting").booleanValue()) {
            this.enable_echo_nest_fingerprinting = new Boolean(text);
        } else if (this.parsing_state.get("save_echo_nest_metadata").booleanValue()) {
            this.save_echo_nest_metadata = new Boolean(text);
        } else if (this.parsing_state.get("enable_last_fm_fingerprinting").booleanValue()) {
            this.enable_last_fm_fingerprinting = new Boolean(text);
        } else if (this.parsing_state.get("save_last_fm_metadata").booleanValue()) {
            this.save_last_fm_metadata = new Boolean(text);
        } else if (this.parsing_state.get("enable_embedded_metadata_track_identification").booleanValue()) {
            this.enable_embedded_metadata_track_identification = new Boolean(text);
        } else if (this.parsing_state.get("save_embedded_metadata").booleanValue()) {
            this.save_embedded_metadata = new Boolean(text);
        } else if (this.parsing_state.get("store_fails").booleanValue()) {
            this.store_fails = new Boolean(text);
        } else if (this.parsing_state.get("url_encode_output").booleanValue()) {
            this.url_encode_output = new Boolean(text);
        } else if (this.parsing_state.get("save_output_as_ace_xml").booleanValue()) {
            this.save_output_as_ace_xml = new Boolean(text);
        } else if (this.parsing_state.get("save_output_as_txt").booleanValue()) {
            this.save_output_as_txt = new Boolean(text);
        } else if (this.parsing_state.get("print_extracted_metadata_to_terminal").booleanValue()) {
            this.print_extracted_metadata_to_terminal = new Boolean(text);
        } else if (this.parsing_state.get("print_current_status_to_terminal").booleanValue()) {
            this.print_current_status_to_terminal = new Boolean(text);
        } else if (this.parsing_state.get("print_errors_to_terminal").booleanValue()) {
            this.print_errors_to_terminal = new Boolean(text);
        } else if (this.parsing_state.get("songs_save_directory").booleanValue()) {
            this.songs_save_directory = text;
        } else if (this.parsing_state.get("artists_save_directory").booleanValue()) {
            this.artists_save_directory = text;
        } else if (this.parsing_state.get("albums_save_directory").booleanValue()) {
            this.albums_save_directory = text;
        } else if (this.parsing_state.get("echo_nest_api_key").booleanValue()) {
            this.echo_nest_api_key = text;
        } else if (this.parsing_state.get("echo_nest_fingerprinting_codegen_run_path").booleanValue()) {
            this.echo_nest_fingerprinting_codegen_run_path = text;
        } else if (this.parsing_state.get("echo_nest_codegen_directory").booleanValue()) {
            this.echo_nest_codegen_directory = text;
        } else if (this.parsing_state.get("last_fm_api_key").booleanValue()) {
            this.last_fm_api_key = text;
        } else if (this.parsing_state.get("artists_already_accessed_file_path").booleanValue()) {
            this.artists_already_accessed_file_path = text;
        } else if (this.parsing_state.get("albums_already_accessed_file_path").booleanValue()) {
            this.albums_already_accessed_file_path = text;
        }
        this.parsing_state.put(element_name, false);
    }
}

