/*
 * Decompiled with CFR 0.152.
 */
package jsongminer;

import java.util.HashMap;
import java.util.Vector;
import jsongminer.MusicMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DublinCoreInterpreter {
    public static Vector<MusicMetaData> getSongUnqualifiedDublinCore(Vector<MusicMetaData> song_metadata) {
        String[][] identifier_mappings = new String[][]{{"dc.Title", "Song Title"}, {"dc.Creator", "Artist Name"}, {"dc.Subject", "Song-Related Tag"}, {"dc.Description", "Last.FM Track Wiki Text"}, {"dc.Publisher", "Record Label"}, {"dc.Contributor", "Composer Name"}, {"dc.Date", "Release Year"}, {"dc.Type", "Genre"}, {"dc.Format", "Encoding Format"}, {"dc.Identifier", "Music Brainz Song ID"}, {"dc.Source", "Album Title"}, {"dc.Language", "Language"}, {"dc.Relation", "Similar Track"}, {"dc.Coverage", "Release Country"}};
        HashMap<String, Vector<String[]>> alternate_mappings = new HashMap<String, Vector<String[]>>();
        String[] alt_fields = new String[]{"Music Brainz Artist ID", "Echo Nest Artist ID", "Discogs Artist Site", "Artist Official URL", "Artist Wikipedia URL"};
        DublinCoreInterpreter.addToAlternateMappings("dc.Creator", alt_fields, alternate_mappings);
        alt_fields = new String[]{"Last.FM Track Wiki Summary", "Comment", "Duration (seconds)", "Tempo (BPM)", "Time Signature", "Key", "Mode", "Loudness (-100 to 100 dB)", "Last.FM Track Play Count", "Echo Nest Song Hottness (0 to 1)"};
        DublinCoreInterpreter.addToAlternateMappings("dc.Description", alt_fields, alternate_mappings);
        alt_fields = new String[]{"Lyricist Name", "Remixer Name"};
        DublinCoreInterpreter.addToAlternateMappings("dc.Contributor", alt_fields, alternate_mappings);
        alt_fields = new String[]{"Grouping", "Song-Related Tag", "Mood"};
        DublinCoreInterpreter.addToAlternateMappings("dc.Type", alt_fields, alternate_mappings);
        alt_fields = new String[]{"Encoding Type", "Encoder", "Bit Rate (kilobits per second)", "Sample Rate (Hz)", "Variable Bit Rate", "Number of Channels", "Audio Source File"};
        DublinCoreInterpreter.addToAlternateMappings("dc.Format", alt_fields, alternate_mappings);
        alt_fields = new String[]{"Echo Nest Song ID", "Last.FM Track URL", "MusicIP Song ID", "Amazon Song ID", "Song Barcode", "Audio Source File", "ENMF Fingerprint Hash Output by the Echo Nest Fingerprinting Codegen Binary"};
        DublinCoreInterpreter.addToAlternateMappings("dc.Identifier", alt_fields, alternate_mappings);
        alt_fields = new String[]{"Music Brainz Album ID", "Album Disc Number", "Total Number of Discs", "Album Track Number", "Total Number of Album Tracks", "Compilation Album"};
        DublinCoreInterpreter.addToAlternateMappings("dc.Source", alt_fields, alternate_mappings);
        alt_fields = new String[]{"Album Title", "Lyrics", "Lyrics URL"};
        DublinCoreInterpreter.addToAlternateMappings("dc.Relation", alt_fields, alternate_mappings);
        alt_fields = new String[]{"Release Year"};
        DublinCoreInterpreter.addToAlternateMappings("dc.Coverage", alt_fields, alternate_mappings);
        return DublinCoreInterpreter.parseOut(identifier_mappings, alternate_mappings, song_metadata, false);
    }

    public static Vector<MusicMetaData> getArtistUnqualifiedDublinCore(Vector<MusicMetaData> artist_metadata) {
        String[][] identifier_mappings = new String[][]{{"dc.Title", "Artist Name"}, {"dc.Subject", "Artist-Related Tag"}, {"dc.Description", "Last.FM Artist Wiki Text"}, {"dc.Type", "Artist-Related Tag"}, {"dc.Identifier", "Music Brainz Artist ID"}, {"dc.Relation", "Top Tracks"}, {"dc.Coverage", "Artist Location"}};
        HashMap<String, Vector<String[]>> alternate_mappings = new HashMap<String, Vector<String[]>>();
        String[] alt_fields = new String[]{"Artist-Related Term"};
        DublinCoreInterpreter.addToAlternateMappings("dc.Subject", alt_fields, alternate_mappings);
        alt_fields = new String[]{"Last.FM Artist Wiki Summary", "Artist Biography", "Artist-Related URL", "Artist Review", "Artist-Related News", "Artist-Related Blog", "Last.FM Artist Play Count", "Echo Nest Artist Familiarity (0 to 1)", "Echo Nest Artist Hotness (0 to 1)"};
        DublinCoreInterpreter.addToAlternateMappings("dc.Description", alt_fields, alternate_mappings);
        alt_fields = new String[]{"Artist-Related Term"};
        DublinCoreInterpreter.addToAlternateMappings("dc.Type", alt_fields, alternate_mappings);
        alt_fields = new String[]{"Echo Nest Artist ID", "Last.FM Artist URL", "7digital Artist ID", "Play.me Artist ID"};
        DublinCoreInterpreter.addToAlternateMappings("dc.Identifier", alt_fields, alternate_mappings);
        alt_fields = new String[]{"Top Albums", "Artist-Related Audio", "Artist-Related Video", "Artist-Related Image", "Similar Artist"};
        DublinCoreInterpreter.addToAlternateMappings("dc.Relation", alt_fields, alternate_mappings);
        alt_fields = new String[]{"Artist Event", "Artist-Related News", "Artist-Related Blog"};
        DublinCoreInterpreter.addToAlternateMappings("dc.Coverage", alt_fields, alternate_mappings);
        return DublinCoreInterpreter.parseOut(identifier_mappings, alternate_mappings, artist_metadata, false);
    }

    public static Vector<MusicMetaData> getAlbumUnqualifiedDublinCore(Vector<MusicMetaData> album_metadata) {
        String[][] identifier_mappings = new String[][]{{"dc.Title", "Album Title"}, {"dc.Creator", "Artist Name"}, {"dc.Subject", "Album-Related Tag"}, {"dc.Description", "Last.FM Album Wiki Text"}, {"dc.Date", "Release Date"}, {"dc.Type", "Album-Related Tag"}, {"dc.Identifier", "Music Brainz Album ID"}, {"dc.Coverage", "Release Date"}};
        HashMap<String, Vector<String[]>> alternate_mappings = new HashMap<String, Vector<String[]>>();
        String[] alt_fields = new String[]{"Music Brainz Artist ID"};
        DublinCoreInterpreter.addToAlternateMappings("dc.Creator", alt_fields, alternate_mappings);
        alt_fields = new String[]{"Last.FM Album Wiki Summary", "Last.FM Album Play Count"};
        DublinCoreInterpreter.addToAlternateMappings("dc.Description", alt_fields, alternate_mappings);
        alt_fields = new String[]{"Last.FM Album URL"};
        DublinCoreInterpreter.addToAlternateMappings("dc.Identifier", alt_fields, alternate_mappings);
        return DublinCoreInterpreter.parseOut(identifier_mappings, alternate_mappings, album_metadata, false);
    }

    public static Vector<MusicMetaData> getSongQualifiedDublinCore(Vector<MusicMetaData> song_metadata) {
        String[][] identifier_mappings = new String[][]{{"dc.Title^songtitle", "Song Title"}, {"dc.Creator^artistname", "Artist Name"}, {"dc.Creator^musicbrainzartistid", "Music Brainz Artist ID"}, {"dc.Creator^echonestartistid", "Echo Nest Artist ID"}, {"dc.Creator^discogsartistsite", "Discogs Artist Site"}, {"dc.Creator^artistofficialurl", "Artist Official URL"}, {"dc.Creator^artistwikipediaurl", "Artist Wikipedia URL"}, {"dc.Subject^songrelatedtag", "Song-Related Tag"}, {"dc.Description^lastfmtrackwikitext", "Last.FM Track Wiki Text"}, {"dc.Description^lastfmtrackwikisummary", "Last.FM Track Wiki Summary"}, {"dc.Description^comment", "Comment"}, {"dc.Description^duration", "Duration (seconds)"}, {"dc.Description^tempo", "Tempo (BPM)"}, {"dc.Description^timesignature", "Time Signature"}, {"dc.Description^key", "Key"}, {"dc.Description^mode", "Mode"}, {"dc.Description^loudness", "Loudness (-100 to 100 dB)"}, {"dc.Description^lastfmtrackplaycount", "Last.FM Track Play Count"}, {"dc.Description^echonestsonghotness", "Echo Nest Song Hottness (0 to 1)"}, {"dc.Publisher^recordlabel", "Record Label"}, {"dc.Contributor^composername", "Composer Name"}, {"dc.Contributor^lyricistname", "Lyricist Name"}, {"dc.Contributor^remixername", "Remixer Name"}, {"dc.Date^releaseyear", "Release Year"}, {"dc.Type^genre", "Genre"}, {"dc.Type^grouping", "Grouping"}, {"dc.Type^songrelatedtag", "Song-Related Tag"}, {"dc.Type^mood", "Mood"}, {"dc.Format^encodingformat", "Encoding Format"}, {"dc.Format^encodingtype", "Encoding Type"}, {"dc.Format^encoder", "Encoder"}, {"dc.Format^bitrate", "Bit Rate (kilobits per second)"}, {"dc.Format^samplerate", "Sample Rate (Hz)"}, {"dc.Format^variablebitrate", "Variable Bit Rate"}, {"dc.Format^numberofchannels", "Number of Channels"}, {"dc.Format^filepath", "Audio Source File"}, {"dc.Identifier^musicbrainzsongid", "Music Brainz Song ID"}, {"dc.Identifier^echonestsongid", "Echo Nest Song ID"}, {"dc.Identifier^lastfmtrackurl", "Last.FM Track URL"}, {"dc.Identifier^musicipsongid", "MusicIP Song ID"}, {"dc.Identifier^amazonsongid", "Amazon Song ID"}, {"dc.Identifier^songbarcode", "Song Barcode"}, {"dc.Identifier^filepath", "Audio Source File"}, {"dc.Identifier^echonestfingerprintinghash", "ENMF Fingerprint Hash Output by the Echo Nest Fingerprinting Codegen Binary"}, {"dc.Source^albumtitle", "Album Title"}, {"dc.Source^musicbrainzalbumid", "Music Brainz Album ID"}, {"dc.Source^albumdiscnumber", "Album Disc Number"}, {"dc.Source^totalnumberofdiscs", "Total Number of Discs"}, {"dc.Source^albumtracknumber", "Album Track Number"}, {"dc.Source^totalnumberofalbumtracks", "Total Number of Album Tracks"}, {"dc.Source^compilationalbum", "Compilation Album"}, {"dc.Language^tracklanguage", "Language"}, {"dc.Relation^similartrack", "Similar Track"}, {"dc.Relation^albumtitle", "Album Title"}, {"dc.Relation^lyrics", "Lyrics"}, {"dc.Relation^lyricsurl", "Lyrics URL"}, {"dc.Coverage^releasecountry", "Release Country"}, {"dc.Coverage^releaseyear", "Release Year"}};
        return DublinCoreInterpreter.parseOut(identifier_mappings, null, song_metadata, true);
    }

    public static Vector<MusicMetaData> getArtistQualifiedDublinCore(Vector<MusicMetaData> artist_metadata) {
        String[][] identifier_mappings = new String[][]{{"dc.Title^artistname", "Artist Name"}, {"dc.Subject^artistrelatedtag", "Artist-Related Tag"}, {"dc.Subject^artistrelatedterm", "Artist-Related Term"}, {"dc.Description^lastfmartistwikitext", "Last.FM Artist Wiki Text"}, {"dc.Description^lastfmartistwikisummary", "Last.FM Artist Wiki Summary"}, {"dc.Description^artistbiography", "Artist Biography"}, {"dc.Description^artistrelatedurl", "Artist-Related URL"}, {"dc.Description^artistreview", "Artist Review"}, {"dc.Description^artistrelatednews", "Artist-Related News"}, {"dc.Description^artistrelatedblog", "Artist-Related Blog"}, {"dc.Description^lastfmartistplaycount", "Last.FM Artist Play Count"}, {"dc.Description^echonestartistfamiliarity", "Echo Nest Artist Familiarity (0 to 1)"}, {"dc.Description^echonestartisthotness", "Echo Nest Artist Hotness (0 to 1)"}, {"dc.Type^artistrelatedtag", "Artist-Related Tag"}, {"dc.Type^artistrelatedterm", "Artist-Related Term"}, {"dc.Identifier^musicbrainzartistid", "Music Brainz Artist ID"}, {"dc.Identifier^echonestartistid", "Echo Nest Artist ID"}, {"dc.Identifier^lastfmartisturl", "Last.FM Artist URL"}, {"dc.Identifier^7digitalartistid", "7digital Artist ID"}, {"dc.Identifier^playmeartistid", "Play.me Artist ID"}, {"dc.Relation^toptracks", "Top Tracks"}, {"dc.Relation^topalbums", "Top Albums"}, {"dc.Relation^artistrelatedaudio", "Artist-Related Audio"}, {"dc.Relation^artistrelatedvideo", "Artist-Related Video"}, {"dc.Relation^artistrelatedimage", "Artist-Related Image"}, {"dc.Relation^similarartist", "Similar Artist"}, {"dc.Coverage^artistlocation", "Artist Location"}, {"dc.Coverage^artistevent", "Artist Event"}, {"dc.Coverage^artistrelatednews", "Artist-Related News"}, {"dc.Coverage^artistrelatedblog", "Artist-Related Blog"}};
        return DublinCoreInterpreter.parseOut(identifier_mappings, null, artist_metadata, true);
    }

    public static Vector<MusicMetaData> getAlbumQualifiedDublinCore(Vector<MusicMetaData> album_metadata) {
        String[][] identifier_mappings = new String[][]{{"dc.Title^albumtitle", "Album Title"}, {"dc.Creator^artistname", "Artist Name"}, {"dc.Creator^musicbrainzartistid", "Music Brainz Artist ID"}, {"dc.Subject^albumrelatedtag", "Album-Related Tag"}, {"dc.Description^lastfmalbumwikitext", "Last.FM Album Wiki Text"}, {"dc.Description^lastfmalbumwikisummary", "Last.FM Album Wiki Summary"}, {"dc.Description^lastfmalbumplaycount", "Last.FM Album Play Count"}, {"dc.Date^releasedate", "Release Date"}, {"dc.Type^albumrelatedtag", "Album-Related Tag"}, {"dc.Identifier^musicbrainzalbumid", "Music Brainz Album ID"}, {"dc.Identifier^lastfmalbumurl", "Last.FM Album URL"}, {"dc.Coverage^releasedate", "Release Date"}};
        return DublinCoreInterpreter.parseOut(identifier_mappings, null, album_metadata, true);
    }

    private static Vector<MusicMetaData> parseOut(String[][] identifier_mappings, HashMap<String, Vector<String[]>> alternate_mappings, Vector<MusicMetaData> original_metadata, boolean allow_multiple_values) {
        Vector<MusicMetaData> results = new Vector<MusicMetaData>();
        if (original_metadata == null) {
            return results;
        }
        if (original_metadata.size() == 0) {
            return results;
        }
        for (int key = 0; key < identifier_mappings.length; ++key) {
            Vector<MusicMetaData> temp_results = new Vector<MusicMetaData>();
            boolean found_one = false;
            for (int data = 0; data < original_metadata.size(); ++data) {
                String this_field_identifier = original_metadata.get(data).getFieldIdentifier();
                if (this_field_identifier.indexOf(identifier_mappings[key][1]) != -1) {
                    String this_value = original_metadata.get(data).getValue();
                    MusicMetaData dcentry = new MusicMetaData("", identifier_mappings[key][0], this_value);
                    temp_results.add(dcentry);
                    found_one = true;
                    if (!allow_multiple_values) {
                        data = original_metadata.size();
                    }
                }
                if (alternate_mappings == null || data != original_metadata.size() - 1 || found_one || !alternate_mappings.containsKey(identifier_mappings[key][0]) || alternate_mappings.get(identifier_mappings[key][0]) == null || alternate_mappings.get(identifier_mappings[key][0]).size() == 0) continue;
                String[] new_mapping_pair = alternate_mappings.get(identifier_mappings[key][0]).remove(0);
                identifier_mappings[key] = new_mapping_pair;
                data = -1;
            }
            for (int first = 0; first < temp_results.size(); ++first) {
                for (int second = first + 1; second < temp_results.size(); ++second) {
                    String first_value = ((MusicMetaData)temp_results.get(first)).getValue();
                    String second_value = ((MusicMetaData)temp_results.get(second)).getValue();
                    if (first == second || !first_value.equals(second_value)) continue;
                    temp_results.remove(second);
                    --second;
                }
            }
            results.addAll(temp_results);
        }
        return results;
    }

    private static void addToAlternateMappings(String dublin_core_field_name, String[] alternate_jsongminer_field_names, HashMap<String, Vector<String[]>> alternate_mappings) {
        Vector<String[]> alt_vector = new Vector<String[]>(alternate_jsongminer_field_names.length);
        for (int i = 0; i < alternate_jsongminer_field_names.length; ++i) {
            String[] alt_array = new String[]{dublin_core_field_name, alternate_jsongminer_field_names[i]};
            alt_vector.add(alt_array);
        }
        alternate_mappings.put(dublin_core_field_name, alt_vector);
    }
}

