/*
 * Decompiled with CFR 0.152.
 */
package jsongminer;

import com.echonest.api.v4.Artist;
import com.echonest.api.v4.Audio;
import com.echonest.api.v4.Biography;
import com.echonest.api.v4.Blog;
import com.echonest.api.v4.EchoNestAPI;
import com.echonest.api.v4.Image;
import com.echonest.api.v4.News;
import com.echonest.api.v4.Params;
import com.echonest.api.v4.Review;
import com.echonest.api.v4.Song;
import com.echonest.api.v4.Term;
import com.echonest.api.v4.Track;
import com.echonest.api.v4.Video;
import java.io.File;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import jsongminer.MusicMetaData;
import mckay.utilities.staticlibraries.MiscellaneousMethods;
import mckay.utilities.staticlibraries.NetworkMethods;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EchoNestMiner {
    private Vector<MusicMetaData> music_meta_data;
    private String echo_nest_source_identifier_code = "Echo Nest API";
    private static int max_to_report;
    private String api_key;
    private EchoNestAPI echo_nest_api;

    public EchoNestMiner(String api_key) throws Exception {
        max_to_report = 10;
        this.api_key = api_key;
        this.music_meta_data = new Vector();
        this.echo_nest_api = new EchoNestAPI(api_key);
        this.echo_nest_api.setTraceSends(false);
        this.echo_nest_api.setTraceRecvs(false);
    }

    public MusicMetaData[] getExtractedMetadata() {
        if (this.music_meta_data.isEmpty()) {
            return null;
        }
        return this.music_meta_data.toArray(new MusicMetaData[this.music_meta_data.size()]);
    }

    public String getAndStoreFullFingerpintingCodegenOutput(String music_file_path, boolean store_result, String run_script_path, String en_codegen_directory) throws Exception {
        String offset_from_beginning = "10";
        String duration_of_audio = "30";
        return this.getAndStoreFullFingerpintingCodegenOutput(music_file_path, offset_from_beginning, duration_of_audio, store_result, run_script_path, en_codegen_directory);
    }

    public String getAndStoreFullFingerpintingCodegenOutput(String music_file_path, String offset_from_beginning, String duration_of_audio, boolean store_result, String run_script_path, String en_codegen_directory) throws Exception {
        Runtime run_time;
        if (run_script_path == null) {
            throw new Exception("The path to the script for running the Echo Nest fingerprinting codegen is not specified.");
        }
        if (en_codegen_directory == null) {
            throw new Exception("The path to the directory holding the Echo Nest fingerprinting codegen is not specified.");
        }
        String execution_string = run_script_path.endsWith("codegen.windows.exe") || run_script_path.endsWith("codegen.Linux-i686") || run_script_path.endsWith("codegen.Linux-x86_64") ? run_script_path + " " + music_file_path + " " + offset_from_beginning + " " + duration_of_audio : run_script_path + " " + en_codegen_directory + " " + music_file_path + " " + offset_from_beginning + " " + duration_of_audio;
        String[] script_output = MiscellaneousMethods.runCommand((String)execution_string, (Runtime)(run_time = Runtime.getRuntime()), null, null);
        if (script_output != null) {
            for (int i = 0; i < script_output.length; ++i) {
                if (!script_output[i].startsWith("{")) continue;
                if (store_result) {
                    MusicMetaData result = new MusicMetaData(this.echo_nest_source_identifier_code + " (Local Fingerprinter)", "Full JSON Dictionary Output by the Echo Nest Fingerprinting Codegen Binary", script_output[i]);
                    this.music_meta_data.add(result);
                }
                return script_output[i];
            }
        }
        return null;
    }

    public String getAndStoreENMFHash(String codegen_json_output, boolean store_result) {
        MusicMetaData enmf_md = this.extractFieldValueFromEchoNestJSON(codegen_json_output, new String[]{"code"}, "ENMF Fingerprint Hash Output by the Echo Nest Fingerprinting Codegen Binary", store_result);
        if (enmf_md == null) {
            return null;
        }
        return enmf_md.getValue();
    }

    public String getAndStoreFullSongIdentifyResponse(String enmf_hash, boolean store_result) {
        String api_url = "http://developer.echonest.com/api/v4/";
        String api_command = "song/identify";
        String url_to_access = api_url + api_command;
        String api_prefix = "api_key=";
        String enfp_prefix = "&code=";
        String data_to_send = api_prefix + this.api_key + enfp_prefix + enmf_hash;
        try {
            String response = NetworkMethods.sendGetRequest((String)url_to_access, (String)data_to_send);
            if (store_result) {
                MusicMetaData result = new MusicMetaData(this.echo_nest_source_identifier_code + " (Local Fingerprinter)", "Full Echo Nest Song Identify JSON Dictionary Response", response);
                this.music_meta_data.add(result);
            }
            return response;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getAndStoreEchoNestSongIDFromFingerPrint(String song_identify_json_output, boolean store_result) {
        MusicMetaData result = this.extractFieldValueFromEchoNestJSON(song_identify_json_output, new String[]{"response", "songs", "0", "id"}, "Echo Nest Song ID", store_result);
        if (result == null) {
            return null;
        }
        return result.getValue();
    }

    public String getAndStoreEchoNestSongIDFromLocalFingerPrint(String music_file_path, boolean store_results, String run_script_path, String en_codegen_directory) {
        try {
            String codegen_json_output = this.getAndStoreFullFingerpintingCodegenOutput(music_file_path, false, run_script_path, en_codegen_directory);
            String enmf_hash = this.getAndStoreENMFHash(codegen_json_output, store_results);
            String song_identify_json_response = this.getAndStoreFullSongIdentifyResponse(enmf_hash, false);
            String en_song_id = this.getAndStoreEchoNestSongIDFromFingerPrint(song_identify_json_response, store_results);
            return en_song_id;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getAndStoreEchoNestSongIDFromRemoteFingerPrint(String music_file_path, boolean store_result) {
        try {
            Track track = this.echo_nest_api.uploadTrack(new File(music_file_path), true);
            String song_title = track.getTitle();
            String artist_name = track.getArtistName();
            String song_id = this.getAndStoreEchoNestSongIDFromMetadata(song_title, artist_name, false);
            if (store_result) {
                MusicMetaData result = new MusicMetaData(this.echo_nest_source_identifier_code + " (Remote Fingerprinter)", "Echo Nest Song ID", song_id);
                this.music_meta_data.add(result);
            }
            return song_id;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getAndStoreEchoNestSongIDFromMetadata(String song_title, String artist_name, boolean store_result) {
        try {
            if (song_title == null) {
                throw new Exception("A song title must be specified in order to attempt to identify it by embedded metadata.");
            }
            if (song_title.equals("")) {
                throw new Exception("A song title must be specified in order to attempt to identify it by embedded metadata.");
            }
            Params search_parameters = new Params();
            search_parameters.add("title", song_title);
            if (artist_name != null) {
                search_parameters.add("artist", artist_name);
            }
            search_parameters.add("results", 1);
            Song response = (Song)this.echo_nest_api.searchSongs(search_parameters).get(0);
            if (store_result) {
                MusicMetaData result = new MusicMetaData(this.echo_nest_source_identifier_code + " (Embedded Metadata Query)", "Echo Nest Song ID", response.getID());
                this.music_meta_data.add(result);
            }
            return response.getID();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getAndStoreEchoNestSongIDUsingBestAvailableMethod(String music_file_path, String song_title, String artist_name, boolean store_results, PrintStream report_failures_stream, String run_script_path, String en_codegen_directory) {
        String song_id = null;
        if (music_file_path != null && run_script_path != null && en_codegen_directory != null && (song_id = this.getAndStoreEchoNestSongIDFromLocalFingerPrint(music_file_path, store_results, run_script_path, en_codegen_directory)) == null && report_failures_stream != null) {
            report_failures_stream.println("Local fingerprinting of " + music_file_path + " was unsuccessful. Attempting another methodology...\n");
        }
        if (song_id == null && music_file_path != null && (song_id = this.getAndStoreEchoNestSongIDFromRemoteFingerPrint(music_file_path, store_results)) == null && report_failures_stream != null) {
            report_failures_stream.println("Remote fingerprinting of " + music_file_path + " was unsuccessful. Attempting another methodology...\n");
        }
        if (song_id == null && song_title != null && (song_id = this.getAndStoreEchoNestSongIDFromMetadata(song_title, artist_name, store_results)) == null && report_failures_stream != null) {
            report_failures_stream.println("Metadata-based identification of " + music_file_path + " was unsuccessful.\n");
        }
        return song_id;
    }

    public MusicMetaData[] getAndStoreSongMetaData(String song_id, boolean store_result, boolean store_fails) throws Exception {
        Vector<MusicMetaData> results;
        block75: {
            Song song;
            block74: {
                block73: {
                    block72: {
                        block71: {
                            block70: {
                                block69: {
                                    block68: {
                                        block67: {
                                            block66: {
                                                if (song_id == null) {
                                                    throw new Exception("A song ID must be specified in order to attempt to extract song metadata.");
                                                }
                                                if (song_id.equals("")) {
                                                    throw new Exception("A song ID must be specified in order to attempt to extract song metadata.");
                                                }
                                                song = new Song(this.echo_nest_api, song_id);
                                                results = new Vector<MusicMetaData>();
                                                try {
                                                    results.add(this.createAndStoreMusicMetaDataObject("Song Title", song.getTitle(), store_result));
                                                }
                                                catch (Exception e) {
                                                    if (!store_fails) break block66;
                                                    results.add(this.createAndStoreMusicMetaDataObject("Song Title", "Could not extract this information: " + e.getMessage(), store_result));
                                                }
                                            }
                                            try {
                                                results.add(this.createAndStoreMusicMetaDataObject("Artist Name", song.getArtistName(), store_result));
                                            }
                                            catch (Exception e) {
                                                if (!store_fails) break block67;
                                                results.add(this.createAndStoreMusicMetaDataObject("Artist Name", "Could not extract this information: " + e.getMessage(), store_result));
                                            }
                                        }
                                        try {
                                            results.add(this.createAndStoreMusicMetaDataObject("Echo Nest Artist ID", song.getArtistID(), store_result));
                                        }
                                        catch (Exception e) {
                                            if (!store_fails) break block68;
                                            results.add(this.createAndStoreMusicMetaDataObject("Echo Nest Artist ID", "Could not extract this information: " + e.getMessage(), store_result));
                                        }
                                    }
                                    try {
                                        results.add(this.createAndStoreMusicMetaDataObject("Duration (seconds)", new Double(song.getDuration()).toString(), store_result));
                                    }
                                    catch (Exception e) {
                                        if (!store_fails) break block69;
                                        results.add(this.createAndStoreMusicMetaDataObject("Duration (seconds)", "Could not extract this information: " + e.getMessage(), store_result));
                                    }
                                }
                                try {
                                    results.add(this.createAndStoreMusicMetaDataObject("Tempo (BPM)", new Double(song.getTempo()).toString(), store_result));
                                }
                                catch (Exception e) {
                                    if (!store_fails) break block70;
                                    results.add(this.createAndStoreMusicMetaDataObject("Tempo (BPM)", "Could not extract this information: " + e.getMessage(), store_result));
                                }
                            }
                            try {
                                int meter = song.getTimeSignature();
                                String meter_id = null;
                                if (meter == -1) {
                                    meter_id = "No time signature";
                                } else if (meter == 0) {
                                    meter_id = "Complex or changing meter";
                                } else if (meter == 1) {
                                    meter_id = "Unknown";
                                } else if (meter == 3) {
                                    meter_id = "3/4";
                                } else if (meter == 4) {
                                    meter_id = "4/4";
                                } else if (meter == 5) {
                                    meter_id = "5/4";
                                } else if (meter == 6) {
                                    meter_id = "6/4";
                                } else if (meter == 7) {
                                    meter_id = "7/4";
                                }
                                results.add(this.createAndStoreMusicMetaDataObject("Time Signature", meter_id, store_result));
                            }
                            catch (Exception e) {
                                if (!store_fails) break block71;
                                results.add(this.createAndStoreMusicMetaDataObject("Time Signature", "Could not extract this information: " + e.getMessage(), store_result));
                            }
                        }
                        try {
                            int key = song.getKey();
                            String key_id = null;
                            if (key == -1) {
                                key_id = "Unidentified";
                            } else if (key == 0) {
                                key_id = "C";
                            } else if (key == 1) {
                                key_id = "C#/Db";
                            } else if (key == 2) {
                                key_id = "D";
                            } else if (key == 3) {
                                key_id = "D#/Eb";
                            } else if (key == 4) {
                                key_id = "E";
                            } else if (key == 5) {
                                key_id = "F";
                            } else if (key == 6) {
                                key_id = "F#/Gb";
                            } else if (key == 7) {
                                key_id = "G";
                            } else if (key == 8) {
                                key_id = "G#/Ab";
                            } else if (key == 9) {
                                key_id = "A";
                            } else if (key == 10) {
                                key_id = "A#/Bb";
                            } else if (key == 11) {
                                key_id = "B";
                            }
                            results.add(this.createAndStoreMusicMetaDataObject("Key", key_id, store_result));
                        }
                        catch (Exception e) {
                            if (!store_fails) break block72;
                            results.add(this.createAndStoreMusicMetaDataObject("Key", "Could not extract this information: " + e.getMessage(), store_result));
                        }
                    }
                    try {
                        int mode = song.getMode();
                        String mode_id = null;
                        if (mode == 0) {
                            mode_id = "Major";
                        } else if (mode == 1) {
                            mode_id = "Minor";
                        }
                        results.add(this.createAndStoreMusicMetaDataObject("Mode", mode_id, store_result));
                    }
                    catch (Exception e) {
                        if (!store_fails) break block73;
                        results.add(this.createAndStoreMusicMetaDataObject("Mode", "Could not extract this information: " + e.getMessage(), store_result));
                    }
                }
                try {
                    results.add(this.createAndStoreMusicMetaDataObject("Loudness (-100 to 100 dB)", new Double(song.getLoudness()).toString(), store_result));
                }
                catch (Exception e) {
                    if (!store_fails) break block74;
                    results.add(this.createAndStoreMusicMetaDataObject("Loudness (-100 to 100 dB)", "Could not extract this information: " + e.getMessage(), store_result));
                }
            }
            try {
                results.add(this.createAndStoreMusicMetaDataObject("Echo Nest Song Hottness (0 to 1)", new Double(song.getSongHotttnesss()).toString(), store_result));
            }
            catch (Exception e) {
                if (!store_fails) break block75;
                results.add(this.createAndStoreMusicMetaDataObject("Echo Nest Song Hottness (0 to 1)", "Could not extract this information: " + e.getMessage(), store_result));
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results.toArray(new MusicMetaData[results.size()]);
    }

    public MusicMetaData[] getAndStoreArtistMetaData(String song_id, boolean store_result, boolean store_fails) throws Exception {
        Vector<MusicMetaData> results;
        block76: {
            Artist artist;
            block75: {
                block74: {
                    block73: {
                        block72: {
                            block71: {
                                int i;
                                block70: {
                                    block69: {
                                        block68: {
                                            block67: {
                                                block66: {
                                                    block65: {
                                                        block64: {
                                                            block63: {
                                                                String stripped_id;
                                                                String full_id;
                                                                block62: {
                                                                    block61: {
                                                                        block60: {
                                                                            block59: {
                                                                                if (song_id == null) {
                                                                                    throw new Exception("A song ID must be specified in order to attempt to extract artist metadata.");
                                                                                }
                                                                                if (song_id.equals("")) {
                                                                                    throw new Exception("A song ID must be specified in order to attempt to extract artist metadata.");
                                                                                }
                                                                                results = new Vector<MusicMetaData>();
                                                                                artist = this.echo_nest_api.newArtistByID(new Song(this.echo_nest_api, song_id).getArtistID());
                                                                                try {
                                                                                    results.add(this.createAndStoreMusicMetaDataObject("Artist Name", artist.getName(), store_result));
                                                                                }
                                                                                catch (Exception e) {
                                                                                    if (!store_fails) break block59;
                                                                                    results.add(this.createAndStoreMusicMetaDataObject("Artist Name", "Could not extract this information: " + e.getMessage(), store_result));
                                                                                }
                                                                            }
                                                                            try {
                                                                                results.add(this.createAndStoreMusicMetaDataObject("Echo Nest Artist ID", artist.getID(), store_result));
                                                                            }
                                                                            catch (Exception e) {
                                                                                if (!store_fails) break block60;
                                                                                results.add(this.createAndStoreMusicMetaDataObject("Echo Nest Artist ID", "Could not extract this information: " + e.getMessage(), store_result));
                                                                            }
                                                                        }
                                                                        try {
                                                                            full_id = artist.getForeignID("musicbrainz");
                                                                            stripped_id = EchoNestMiner.cleanForeignID(full_id, "musicbrainz:artist:");
                                                                            results.add(this.createAndStoreMusicMetaDataObject("Music Brainz Artist ID", stripped_id, store_result));
                                                                        }
                                                                        catch (Exception e) {
                                                                            if (!store_fails) break block61;
                                                                            results.add(this.createAndStoreMusicMetaDataObject("MusicBrainz Artist ID", "Could not extract this information: " + e.getMessage(), store_result));
                                                                        }
                                                                    }
                                                                    try {
                                                                        full_id = artist.getForeignID("7digital");
                                                                        stripped_id = EchoNestMiner.cleanForeignID(full_id, "7digital:artist:");
                                                                        results.add(this.createAndStoreMusicMetaDataObject("7digital Artist ID", stripped_id, store_result));
                                                                    }
                                                                    catch (Exception e) {
                                                                        if (!store_fails) break block62;
                                                                        results.add(this.createAndStoreMusicMetaDataObject("7digital Artist ID", "Could not extract this information: " + e.getMessage(), store_result));
                                                                    }
                                                                }
                                                                try {
                                                                    full_id = artist.getForeignID("playme");
                                                                    stripped_id = EchoNestMiner.cleanForeignID(full_id, "playme:artist:");
                                                                    results.add(this.createAndStoreMusicMetaDataObject("Play.me Artist ID", stripped_id, store_result));
                                                                }
                                                                catch (Exception e) {
                                                                    if (!store_fails) break block63;
                                                                    results.add(this.createAndStoreMusicMetaDataObject("Play.me Artist ID", "Could not extract this information: " + e.getMessage(), store_result));
                                                                }
                                                            }
                                                            try {
                                                                results.add(this.createAndStoreMusicMetaDataObject("Artist Location", new Song(this.echo_nest_api, song_id).getArtistLocation().getPlaceName(), store_result));
                                                            }
                                                            catch (Exception e) {
                                                                if (!store_fails) break block64;
                                                                results.add(this.createAndStoreMusicMetaDataObject("Artist Location", "Could not extract this information: " + e.getMessage(), store_result));
                                                            }
                                                        }
                                                        try {
                                                            results.add(this.createAndStoreMusicMetaDataObject("Echo Nest Artist Familiarity (0 to 1)", new Double(artist.getFamiliarity()).toString(), store_result));
                                                        }
                                                        catch (Exception e) {
                                                            if (!store_fails) break block65;
                                                            results.add(this.createAndStoreMusicMetaDataObject("Echo Nest Artist Familiarity (0 to 1)", "Could not extract this information: " + e.getMessage(), store_result));
                                                        }
                                                    }
                                                    try {
                                                        results.add(this.createAndStoreMusicMetaDataObject("Echo Nest Artist Hotness (0 to 1)", new Double(artist.getHotttnesss()).toString(), store_result));
                                                    }
                                                    catch (Exception e) {
                                                        if (!store_fails) break block66;
                                                        results.add(this.createAndStoreMusicMetaDataObject("Echo Nest Artist Hotness (0 to 1)", "Could not extract this information: " + e.getMessage(), store_result));
                                                    }
                                                }
                                                try {
                                                    List terms = artist.getTerms();
                                                    int this_max = terms.size();
                                                    if (max_to_report < this_max) {
                                                        this_max = max_to_report;
                                                    }
                                                    for (i = 0; i < this_max; ++i) {
                                                        Term term = (Term)terms.get(i);
                                                        results.add(this.createAndStoreMusicMetaDataObject("Artist-Related Term (Term " + (i + 1) + ")", term.getName() + " (Weight: " + term.getWeight() + " Frequency: " + term.getFrequency() + ")", store_result));
                                                    }
                                                }
                                                catch (Exception e) {
                                                    if (!store_fails) break block67;
                                                    results.add(this.createAndStoreMusicMetaDataObject("Artist-Related Terms", "Could not extract this information: " + e.getMessage(), store_result));
                                                }
                                            }
                                            try {
                                                List similar_artists = artist.getSimilar(max_to_report);
                                                int this_max = similar_artists.size();
                                                if (max_to_report < this_max) {
                                                    this_max = max_to_report;
                                                }
                                                for (i = 0; i < this_max; ++i) {
                                                    Artist similar_artist = (Artist)similar_artists.get(i);
                                                    results.add(this.createAndStoreMusicMetaDataObject("Similar Artist (Artist " + (i + 1) + ")", similar_artist.getName() + " (Echo Nest Artist ID: " + similar_artist.getID() + ")", store_result));
                                                }
                                            }
                                            catch (Exception e) {
                                                if (!store_fails) break block68;
                                                results.add(this.createAndStoreMusicMetaDataObject("Similar Artists", "Could not extract this information: " + e.getMessage(), store_result));
                                            }
                                        }
                                        try {
                                            List audio_list = artist.getAudio();
                                            int this_max = audio_list.size();
                                            if (max_to_report < this_max) {
                                                this_max = max_to_report;
                                            }
                                            for (i = 0; i < this_max; ++i) {
                                                Audio audio = (Audio)audio_list.get(i);
                                                results.add(this.createAndStoreMusicMetaDataObject("Artist-Related Audio (" + audio.getTitle() + ")", audio.getURL(), store_result));
                                            }
                                        }
                                        catch (Exception e) {
                                            if (!store_fails) break block69;
                                            results.add(this.createAndStoreMusicMetaDataObject("Artist-Related Audio", "Could not extract this information: " + e.getMessage(), store_result));
                                        }
                                    }
                                    try {
                                        List images = artist.getImages();
                                        int this_max = images.size();
                                        if (max_to_report < this_max) {
                                            this_max = max_to_report;
                                        }
                                        for (i = 0; i < this_max; ++i) {
                                            Image image = (Image)images.get(i);
                                            results.add(this.createAndStoreMusicMetaDataObject("Artist-Related Image (Image " + (i + 1) + ")", image.getURL(), store_result));
                                        }
                                    }
                                    catch (Exception e) {
                                        if (!store_fails) break block70;
                                        results.add(this.createAndStoreMusicMetaDataObject("Artist-Related Images", "Could not extract this information: " + e.getMessage(), store_result));
                                    }
                                }
                                try {
                                    List videos = artist.getVideos();
                                    int this_max = videos.size();
                                    if (max_to_report < this_max) {
                                        this_max = max_to_report;
                                    }
                                    for (i = 0; i < this_max; ++i) {
                                        Video video = (Video)videos.get(i);
                                        results.add(this.createAndStoreMusicMetaDataObject("Artist-Related Video (" + video.getTitle() + ")", video.getURL(), store_result));
                                    }
                                }
                                catch (Exception e) {
                                    if (!store_fails) break block71;
                                    results.add(this.createAndStoreMusicMetaDataObject("Artist-Related Videos", "Could not extract this information: " + e.getMessage(), store_result));
                                }
                            }
                            try {
                                Map url_map = artist.getUrls();
                                Set key_set = url_map.keySet();
                                String[] keys = key_set.toArray(new String[key_set.size()]);
                                int this_max = keys.length;
                                if (max_to_report < this_max) {
                                    this_max = max_to_report;
                                }
                                for (int i = 0; i < this_max; ++i) {
                                    results.add(this.createAndStoreMusicMetaDataObject("Artist-Related URL (" + keys[i] + ")", (String)url_map.get(keys[i]), store_result));
                                }
                            }
                            catch (Exception e) {
                                if (!store_fails) break block72;
                                results.add(this.createAndStoreMusicMetaDataObject("Artist-Related URLs", "Could not extract this information: " + e.getMessage(), store_result));
                            }
                        }
                        try {
                            List bios = artist.getBiographies();
                            int this_max = bios.size();
                            if (max_to_report < this_max) {
                                this_max = max_to_report;
                            }
                            for (int i = 0; i < this_max; ++i) {
                                Biography bio = (Biography)bios.get(i);
                                results.add(this.createAndStoreMusicMetaDataObject("Artist Biography (" + bio.getSite() + ")", bio.getURL(), store_result));
                            }
                        }
                        catch (Exception e) {
                            if (!store_fails) break block73;
                            results.add(this.createAndStoreMusicMetaDataObject("Artist Biographies", "Could not extract this information: " + e.getMessage(), store_result));
                        }
                    }
                    try {
                        List news_list = artist.getNews();
                        int this_max = news_list.size();
                        if (max_to_report < this_max) {
                            this_max = max_to_report;
                        }
                        for (int i = 0; i < this_max; ++i) {
                            News news = (News)news_list.get(i);
                            results.add(this.createAndStoreMusicMetaDataObject("Artist-Related News (" + news.getName() + ")", news.getURL(), store_result));
                        }
                    }
                    catch (Exception e) {
                        if (!store_fails) break block74;
                        results.add(this.createAndStoreMusicMetaDataObject("Artist-Related News", "Could not extract this information: " + e.getMessage(), store_result));
                    }
                }
                try {
                    List reviews = artist.getReviews();
                    int this_max = reviews.size();
                    if (max_to_report < this_max) {
                        this_max = max_to_report;
                    }
                    for (int i = 0; i < this_max; ++i) {
                        Review review = (Review)reviews.get(i);
                        results.add(this.createAndStoreMusicMetaDataObject("Artist Review (" + review.getName() + ")", review.getURL(), store_result));
                    }
                }
                catch (Exception e) {
                    if (!store_fails) break block75;
                    results.add(this.createAndStoreMusicMetaDataObject("Artist Reviews", "Could not extract this information: " + e.getMessage(), store_result));
                }
            }
            try {
                List blogs = artist.getBlogs();
                int this_max = blogs.size();
                if (max_to_report < this_max) {
                    this_max = max_to_report;
                }
                for (int i = 0; i < this_max; ++i) {
                    Blog blog = (Blog)blogs.get(i);
                    results.add(this.createAndStoreMusicMetaDataObject("Artist-Related Blog (" + blog.getName() + ")", blog.getURL(), store_result));
                }
            }
            catch (Exception e) {
                if (!store_fails) break block76;
                results.add(this.createAndStoreMusicMetaDataObject("Artist-Related Blogs", "Could not extract this information: " + e.getMessage(), store_result));
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results.toArray(new MusicMetaData[results.size()]);
    }

    public boolean getAllAvailableNewMetaData(String song_id, Vector<MusicMetaData> song_metadata, Vector<MusicMetaData> artist_metadata, HashMap<String, Vector<MusicMetaData>> artists_already_extracted, boolean store_identification_metadata, boolean store_fails) throws Exception {
        MusicMetaData[] new_artist_data;
        MusicMetaData[] new_song_metadata;
        if (song_id == null) {
            throw new Exception("A song ID must be specified in order to attempt to extract metadata");
        }
        if (song_id.equals("")) {
            throw new Exception("A song ID must be specified in order to attempt to extract metadata");
        }
        if (song_metadata == null || artist_metadata == null) {
            throw new Exception("A song Vector and an artist Vector must be provided (although they may be empty).");
        }
        boolean some_data_successfully_extracted = false;
        if (store_identification_metadata && !this.music_meta_data.isEmpty()) {
            song_metadata.addAll(this.music_meta_data);
            some_data_successfully_extracted = true;
        }
        if ((new_song_metadata = this.getAndStoreSongMetaData(song_id, false, store_fails)) != null) {
            for (int i = 0; i < new_song_metadata.length; ++i) {
                song_metadata.add(new_song_metadata[i]);
            }
            some_data_successfully_extracted = true;
        }
        boolean extract_artist_data = true;
        if (artists_already_extracted != null) {
            String artist_name = new Song(this.echo_nest_api, song_id).getArtistName();
            if (artist_name == null) {
                extract_artist_data = false;
            } else if (artists_already_extracted.containsKey(artist_name = artist_name.toLowerCase())) {
                extract_artist_data = false;
            }
        }
        if (extract_artist_data && (new_artist_data = this.getAndStoreArtistMetaData(song_id, false, store_fails)) != null) {
            for (int i = 0; i < new_artist_data.length; ++i) {
                artist_metadata.add(new_artist_data[i]);
            }
            some_data_successfully_extracted = true;
        }
        return some_data_successfully_extracted;
    }

    public String[] getIdentifyingMetadataForSong(String song_id) {
        try {
            Song song = new Song(this.echo_nest_api, song_id);
            String[] results = new String[]{song.getTitle(), song.getArtistName()};
            return results;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getEchoNestArtistID(String artist_name) {
        try {
            Artist artist = this.echo_nest_api.newArtistByName(artist_name);
            return artist.getID();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getArtistNameLowerCase(String song_id) {
        try {
            String result = new Song(this.echo_nest_api, song_id).getArtistName();
            result = result.toLowerCase();
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getMusicBrainzArtistID(String song_id) {
        try {
            Artist artist = this.echo_nest_api.newArtistByID(new Song(this.echo_nest_api, song_id).getArtistID());
            String mb_artist_id = artist.getForeignID("musicbrainz");
            mb_artist_id = EchoNestMiner.cleanForeignID(mb_artist_id, "musicbrainz:artist:");
            return mb_artist_id;
        }
        catch (Exception e) {
            return null;
        }
    }

    private MusicMetaData extractFieldValueFromEchoNestJSON(String json_dict, String[] dict_fields, String field_id_to_store, boolean store_result) {
        try {
            String field_value = null;
            Object current_json = JSONValue.parse((String)json_dict);
            for (int i = 0; i < dict_fields.length; ++i) {
                int index;
                if (i == dict_fields.length - 1) {
                    if (current_json instanceof JSONObject) {
                        field_value = (String)((JSONObject)current_json).get((Object)dict_fields[i]);
                        continue;
                    }
                    if (current_json instanceof JSONArray) {
                        index = new Integer(dict_fields[i]);
                        field_value = (String)((JSONArray)current_json).get(index);
                        continue;
                    }
                    return null;
                }
                if (current_json instanceof JSONObject) {
                    current_json = ((JSONObject)current_json).get((Object)dict_fields[i]);
                    continue;
                }
                if (current_json instanceof JSONArray) {
                    index = new Integer(dict_fields[i]);
                    current_json = ((JSONArray)current_json).get(index);
                    continue;
                }
                return null;
            }
            MusicMetaData result = new MusicMetaData(this.echo_nest_source_identifier_code + " (Local Fingerprinter)", field_id_to_store, field_value);
            if (store_result) {
                this.music_meta_data.add(result);
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    private MusicMetaData createAndStoreMusicMetaDataObject(String field_identifier, String field_value, boolean store_result) {
        MusicMetaData result = new MusicMetaData(this.echo_nest_source_identifier_code, field_identifier, field_value);
        if (store_result) {
            this.music_meta_data.add(result);
        }
        return result;
    }

    private static String cleanForeignID(String full_foreign_id, String prefix_to_strip) {
        return full_foreign_id.replaceFirst(prefix_to_strip, "");
    }
}

