/*
 * Decompiled with CFR 0.152.
 */
package jsongminer;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import jsongminer.MusicMetaData;
import net.roarsoftware.lastfm.Album;
import net.roarsoftware.lastfm.Artist;
import net.roarsoftware.lastfm.Event;
import net.roarsoftware.lastfm.Image;
import net.roarsoftware.lastfm.ImageSize;
import net.roarsoftware.lastfm.Tag;
import net.roarsoftware.lastfm.Track;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LastFMMiner {
    private String last_fm_source_identifier_code = "Last.FM API";
    private static int max_to_report;
    private String api_key;
    private Track track;

    public LastFMMiner(String song_title, String artist_name, String api_key) throws Exception {
        max_to_report = 10;
        this.api_key = api_key;
        this.setTrack(song_title, artist_name, false);
    }

    public MusicMetaData[] getSongMetaData(boolean store_fails) {
        Vector<MusicMetaData> results;
        block47: {
            int i;
            int this_max;
            block46: {
                block45: {
                    block44: {
                        block43: {
                            block42: {
                                block41: {
                                    block40: {
                                        block39: {
                                            block38: {
                                                block37: {
                                                    block36: {
                                                        block35: {
                                                            block34: {
                                                                results = new Vector<MusicMetaData>();
                                                                try {
                                                                    results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Song Title", this.track.getName()));
                                                                }
                                                                catch (Exception e) {
                                                                    if (!store_fails) break block34;
                                                                    results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Song Title", "Could not extract this information: " + e.getMessage()));
                                                                }
                                                            }
                                                            try {
                                                                results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Last.FM Track URL", this.track.getUrl()));
                                                            }
                                                            catch (Exception e) {
                                                                if (!store_fails) break block35;
                                                                results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Last.FM Track URL", "Could not extract this information: " + e.getMessage()));
                                                            }
                                                        }
                                                        try {
                                                            results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Music Brainz Song ID", this.track.getMbid()));
                                                        }
                                                        catch (Exception e) {
                                                            if (!store_fails) break block36;
                                                            results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Song Music Brainz ID", "Could not extract this information: " + e.getMessage()));
                                                        }
                                                    }
                                                    try {
                                                        results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Artist Name", this.track.getArtist()));
                                                    }
                                                    catch (Exception e) {
                                                        if (!store_fails) break block37;
                                                        results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Artist Name", "Could not extract this information: " + e.getMessage()));
                                                    }
                                                }
                                                try {
                                                    results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Music Brainz Artist ID", this.track.getArtistMbid()));
                                                }
                                                catch (Exception e) {
                                                    if (!store_fails) break block38;
                                                    results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Music Brainz Artist ID", "Could not extract this information: " + e.getMessage()));
                                                }
                                            }
                                            try {
                                                results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Album Title", this.track.getAlbum()));
                                            }
                                            catch (Exception e) {
                                                if (!store_fails) break block39;
                                                results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Album Title", "Could not extract this information: " + e.getMessage()));
                                            }
                                        }
                                        try {
                                            results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Music Brainz Album ID", this.track.getAlbumMbid()));
                                        }
                                        catch (Exception e) {
                                            if (!store_fails) break block40;
                                            results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Music Brainz Album ID", "Could not extract this information: " + e.getMessage()));
                                        }
                                    }
                                    try {
                                        int track_number_int = this.track.getPosition();
                                        String track_number = "Unknown";
                                        if (track_number_int != -1) {
                                            track_number = new Integer(track_number_int).toString();
                                        }
                                        results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Album Track Number", track_number));
                                    }
                                    catch (Exception e) {
                                        if (!store_fails) break block41;
                                        results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Album Track Number", "Could not extract this information: " + e.getMessage()));
                                    }
                                }
                                try {
                                    results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Duration (seconds)", new Integer(this.track.getDuration()).toString()));
                                }
                                catch (Exception e) {
                                    if (!store_fails) break block42;
                                    results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Duration (seconds)", "Could not extract this information: " + e.getMessage()));
                                }
                            }
                            try {
                                results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Last.FM Track Wiki Summary", this.track.getWikiSummary()));
                            }
                            catch (Exception e) {
                                if (!store_fails) break block43;
                                results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Last.FM Track Wiki Summary", "Could not extract this information: " + e.getMessage()));
                            }
                        }
                        try {
                            results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Last.FM Track Wiki Text", this.track.getWikiText()));
                        }
                        catch (Exception e) {
                            if (!store_fails) break block44;
                            results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Last.FM Track Wiki Text", "Could not extract this information: " + e.getMessage()));
                        }
                    }
                    try {
                        results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Last.FM Track Play Count", new Integer(this.track.getPlaycount()).toString()));
                    }
                    catch (Exception e) {
                        if (!store_fails) break block45;
                        results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Last.FM Play Count", "Could not extract this information: " + e.getMessage()));
                    }
                }
                try {
                    List tag_collection = Track.getTopTags((String)this.track.getArtist(), (String)this.track.getName(), (String)this.api_key);
                    Tag[] tags = tag_collection.toArray(new Tag[tag_collection.size()]);
                    this_max = tags.length;
                    if (max_to_report < this_max) {
                        this_max = max_to_report;
                    }
                    for (i = 0; i < this_max; ++i) {
                        results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Song-Related Tag (Tag " + (i + 1) + ")", tags[i].getName() + " (Count: " + tags[i].getCount() + ") (Last.FM Tag URL: " + tags[i].getUrl() + ")"));
                    }
                }
                catch (Exception e) {
                    if (!store_fails) break block46;
                    results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Song-Related Tags", "Could not extract this information: " + e.getMessage()));
                }
            }
            try {
                Collection track_collection = Track.getSimilar((String)this.track.getArtist(), (String)this.track.getName(), null, (String)this.api_key);
                Track[] tracks = track_collection.toArray(new Track[track_collection.size()]);
                this_max = tracks.length;
                if (max_to_report < this_max) {
                    this_max = max_to_report;
                }
                for (i = 0; i < this_max; ++i) {
                    results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Similar Track (Track " + (i + 1) + ")", tracks[i].getName() + " (Last.FM TracK URL: " + tracks[i].getUrl() + ")"));
                }
            }
            catch (Exception e) {
                if (!store_fails) break block47;
                results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Similar Tracks", "Could not extract this information: " + e.getMessage()));
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results.toArray(new MusicMetaData[results.size()]);
    }

    public MusicMetaData[] getArtistMetaData(boolean store_fails) {
        Vector<MusicMetaData> results;
        block47: {
            int i;
            int this_max;
            Artist artist;
            block46: {
                block45: {
                    block44: {
                        block43: {
                            block42: {
                                block41: {
                                    block40: {
                                        block39: {
                                            block38: {
                                                block37: {
                                                    block36: {
                                                        results = new Vector<MusicMetaData>();
                                                        artist = Artist.getInfo((String)this.track.getArtist(), (String)this.api_key);
                                                        try {
                                                            results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Artist Name", artist.getName()));
                                                        }
                                                        catch (Exception e) {
                                                            if (!store_fails) break block36;
                                                            results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Artist Name", "Could not extract this information: " + e.getMessage()));
                                                        }
                                                    }
                                                    try {
                                                        results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Last.FM Artist URL", artist.getUrl()));
                                                    }
                                                    catch (Exception e) {
                                                        if (!store_fails) break block37;
                                                        results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Last.FM Artist URL", "Could not extract this information: " + e.getMessage()));
                                                    }
                                                }
                                                try {
                                                    results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Music Brainz Artist ID", artist.getMbid()));
                                                }
                                                catch (Exception e) {
                                                    if (!store_fails) break block38;
                                                    results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Music Brainz Artist ID", "Could not extract this information: " + e.getMessage()));
                                                }
                                            }
                                            try {
                                                results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Last.FM Artist Wiki Summary", artist.getWikiSummary()));
                                            }
                                            catch (Exception e) {
                                                if (!store_fails) break block39;
                                                results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Last.FM Artist Wiki Summary", "Could not extract this information: " + e.getMessage()));
                                            }
                                        }
                                        try {
                                            results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Last.FM Artist Wiki Text", artist.getWikiText()));
                                        }
                                        catch (Exception e) {
                                            if (!store_fails) break block40;
                                            results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Last.FM Artist Wiki Text", "Could not extract this information: " + e.getMessage()));
                                        }
                                    }
                                    try {
                                        Collection image_collection = Artist.getImages((String)artist.getName(), (String)this.api_key).getPageResults();
                                        Image[] images = image_collection.toArray(new Image[image_collection.size()]);
                                        this_max = images.length;
                                        if (max_to_report < this_max) {
                                            this_max = max_to_report;
                                        }
                                        for (i = 0; i < this_max; ++i) {
                                            results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Artist-Related Image (" + images[i].getUrl() + ")", images[i].getImageURL(ImageSize.valueOf((String)"LARGE"))));
                                        }
                                    }
                                    catch (Exception e) {
                                        if (!store_fails) break block41;
                                        results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Artist-Related Images", "Could not extract this information: " + e.getMessage()));
                                    }
                                }
                                try {
                                    results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Last.FM Artist Play Count", new Integer(artist.getPlaycount()).toString()));
                                }
                                catch (Exception e) {
                                    if (!store_fails) break block42;
                                    results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Last.FM Aritst Play Count", "Could not extract this information: " + e.getMessage()));
                                }
                            }
                            try {
                                Collection track_collection = Artist.getTopTracks((String)artist.getName(), (String)this.api_key);
                                Track[] tracks = track_collection.toArray(new Track[track_collection.size()]);
                                this_max = tracks.length;
                                if (max_to_report < this_max) {
                                    this_max = max_to_report;
                                }
                                for (i = 0; i < this_max; ++i) {
                                    results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Top Tracks (Track " + (i + 1) + ")", tracks[i].getName() + " (Last.FM TracK URL: " + tracks[i].getUrl() + ")"));
                                }
                            }
                            catch (Exception e) {
                                if (!store_fails) break block43;
                                results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Top Tracks", "Could not extract this information: " + e.getMessage()));
                            }
                        }
                        try {
                            Collection album_collection = Artist.getTopAlbums((String)artist.getName(), (String)this.api_key);
                            Album[] albums = album_collection.toArray(new Album[album_collection.size()]);
                            this_max = albums.length;
                            if (max_to_report < this_max) {
                                this_max = max_to_report;
                            }
                            for (i = 0; i < this_max; ++i) {
                                results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Top Albums (Album " + (i + 1) + ")", albums[i].getName() + " (Last.FM Album URL: " + albums[i].getUrl() + ")"));
                            }
                        }
                        catch (Exception e) {
                            if (!store_fails) break block44;
                            results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Top Albums", "Could not extract this information: " + e.getMessage()));
                        }
                    }
                    try {
                        Collection tag_collection = Artist.getTopTags((String)artist.getName(), (String)this.api_key);
                        String[] tags = tag_collection.toArray(new String[tag_collection.size()]);
                        this_max = tags.length;
                        if (max_to_report < this_max) {
                            this_max = max_to_report;
                        }
                        for (i = 0; i < this_max; ++i) {
                            results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Artist-Related Tag (Tag " + (i + 1) + ")", tags[i]));
                        }
                    }
                    catch (Exception e) {
                        if (!store_fails) break block45;
                        results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Artist-Related Tags", "Could not extract this information: " + e.getMessage()));
                    }
                }
                try {
                    Collection artist_collection = Artist.getSimilar((String)artist.getName(), (int)max_to_report, (String)this.api_key);
                    Artist[] artists = artist_collection.toArray(new Artist[artist_collection.size()]);
                    for (int i2 = 0; i2 < artists.length; ++i2) {
                        results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Similar Artist (Artist " + (i2 + 1) + ")", artists[i2].getName() + " (Last.FM Artist URL: " + artists[i2].getUrl() + ")"));
                    }
                }
                catch (Exception e) {
                    if (!store_fails) break block46;
                    results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Similar Artists", "Could not extract this information: " + e.getMessage()));
                }
            }
            try {
                Collection event_collection = Artist.getEvents((String)artist.getName(), (String)this.api_key);
                Event[] events = event_collection.toArray(new Event[event_collection.size()]);
                this_max = events.length;
                if (max_to_report < this_max) {
                    this_max = max_to_report;
                }
                for (i = 0; i < this_max; ++i) {
                    results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Artist Event (" + events[i].getUrl() + ")", events[i].getTitle() + " (Date: " + events[i].getStartDate() + ")" + " (Venue: " + events[i].getVenue().getName() + ", " + events[i].getVenue().getCity() + ", " + events[i].getVenue().getCountry() + ")"));
                }
            }
            catch (Exception e) {
                if (!store_fails) break block47;
                results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Artist Events", "Could not extract this information: " + e.getMessage()));
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results.toArray(new MusicMetaData[results.size()]);
    }

    public MusicMetaData[] getAlbumMetaData(boolean store_fails) {
        Vector<MusicMetaData> results;
        block32: {
            Album album;
            block31: {
                block30: {
                    block29: {
                        block28: {
                            block27: {
                                block26: {
                                    block25: {
                                        block24: {
                                            block23: {
                                                results = new Vector<MusicMetaData>();
                                                album = Album.getInfo((String)this.track.getArtist(), (String)this.track.getAlbum(), (String)this.api_key);
                                                try {
                                                    results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Album Title", album.getName()));
                                                }
                                                catch (Exception e) {
                                                    if (!store_fails) break block23;
                                                    results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Album Title", "Could not extract this information: " + e.getMessage()));
                                                }
                                            }
                                            try {
                                                results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Last.FM Album URL", album.getUrl()));
                                            }
                                            catch (Exception e) {
                                                if (!store_fails) break block24;
                                                results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Last.FM Album URL", "Could not extract this information: " + e.getMessage()));
                                            }
                                        }
                                        try {
                                            results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Music Brainz Album ID", album.getMbid()));
                                        }
                                        catch (Exception e) {
                                            if (!store_fails) break block25;
                                            results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Album Album Brainz ID", "Could not extract this information: " + e.getMessage()));
                                        }
                                    }
                                    try {
                                        results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Artist Name", album.getArtist()));
                                    }
                                    catch (Exception e) {
                                        if (!store_fails) break block26;
                                        results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Artist Name", "Could not extract this information: " + e.getMessage()));
                                    }
                                }
                                try {
                                    results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Music Brainz Artist ID", this.track.getArtistMbid()));
                                }
                                catch (Exception e) {
                                    if (!store_fails) break block27;
                                    results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Music Brainz Artist ID", "Could not extract this information: " + e.getMessage()));
                                }
                            }
                            try {
                                results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Release Date", album.getReleaseDate().toString()));
                            }
                            catch (Exception e) {
                                if (!store_fails) break block28;
                                results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Release Date", "Could not extract this information: " + e.getMessage()));
                            }
                        }
                        try {
                            results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Last.FM Album Wiki Summary", album.getWikiSummary()));
                        }
                        catch (Exception e) {
                            if (!store_fails) break block29;
                            results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Last.FM Album Wiki Summary", "Could not extract this information: " + e.getMessage()));
                        }
                    }
                    try {
                        results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Last.FM Album Wiki Text", album.getWikiText()));
                    }
                    catch (Exception e) {
                        if (!store_fails) break block30;
                        results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Last.FM Album Wiki Text", "Could not extract this information: " + e.getMessage()));
                    }
                }
                try {
                    results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Last.FM Album Play Count", new Integer(album.getPlaycount()).toString()));
                }
                catch (Exception e) {
                    if (!store_fails) break block31;
                    results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Last.FM Album Play Count", "Could not extract this information: " + e.getMessage()));
                }
            }
            try {
                Collection tag_collection = album.getTags();
                String[] tags = tag_collection.toArray(new String[tag_collection.size()]);
                int this_max = tags.length;
                if (max_to_report < this_max) {
                    this_max = max_to_report;
                }
                for (int i = 0; i < this_max; ++i) {
                    results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Album-Related Tag (Tag " + (i + 1) + ")", tags[i]));
                }
            }
            catch (Exception e) {
                if (!store_fails) break block32;
                results.add(new MusicMetaData(this.last_fm_source_identifier_code, "Album-Related Tags", "Could not extract this information: " + e.getMessage()));
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results.toArray(new MusicMetaData[results.size()]);
    }

    public boolean getAllAvailableNewMetaData(Vector<MusicMetaData> song_metadata, Vector<MusicMetaData> artist_metadata, Vector<MusicMetaData> album_metadata, HashMap<String, Vector<MusicMetaData>> artists_already_extracted, HashMap<String, Vector<MusicMetaData>> albums_already_extracted, boolean store_fails) throws Exception {
        MusicMetaData[] new_album_data;
        MusicMetaData[] new_artist_data;
        if (song_metadata == null || artist_metadata == null || album_metadata == null) {
            throw new Exception("Song, artist and album vectors must be provided (although they may be empty).");
        }
        boolean some_data_successfully_extracted = false;
        MusicMetaData[] new_song_metadata = this.getSongMetaData(store_fails);
        if (new_song_metadata != null) {
            for (int i = 0; i < new_song_metadata.length; ++i) {
                song_metadata.add(new_song_metadata[i]);
            }
            some_data_successfully_extracted = true;
        }
        boolean extract_artist_data = true;
        if (artists_already_extracted != null) {
            String artist_name = this.track.getArtist();
            if (artist_name == null) {
                extract_artist_data = false;
            } else if (artists_already_extracted.containsKey(artist_name = artist_name.toLowerCase())) {
                extract_artist_data = false;
            }
        }
        if (extract_artist_data && (new_artist_data = this.getArtistMetaData(store_fails)) != null) {
            for (int i = 0; i < new_artist_data.length; ++i) {
                artist_metadata.add(new_artist_data[i]);
            }
            some_data_successfully_extracted = true;
        }
        boolean extract_album_data = true;
        if (albums_already_extracted != null) {
            String album_name = this.track.getAlbum();
            if (album_name == null) {
                extract_album_data = false;
            } else if (albums_already_extracted.containsKey(album_name = album_name.toLowerCase())) {
                extract_album_data = false;
            }
        }
        if (extract_album_data && (new_album_data = this.getAlbumMetaData(store_fails)) != null) {
            for (int i = 0; i < new_album_data.length; ++i) {
                album_metadata.add(new_album_data[i]);
            }
            some_data_successfully_extracted = true;
        }
        return some_data_successfully_extracted;
    }

    public String getLastFMTrackURL() {
        try {
            return this.track.getUrl();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String[] getIdentifyingMetadataForSong() {
        try {
            String[] results = new String[]{this.track.getName(), this.track.getArtist(), this.track.getAlbum()};
            return results;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getAlbumNameLowerCase() {
        try {
            String result = this.track.getAlbum();
            result = result.toLowerCase();
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void setTrack(String song_title, String artist_name, boolean called_already) throws Exception {
        if (song_title == null) {
            throw new Exception("A song title must be specified in order to attempt to identify it.");
        }
        if (song_title.equals("")) {
            throw new Exception("A song title must be specified in order to attempt to identify it.");
        }
        if (artist_name != null) {
            this.track = Track.getInfo((String)artist_name, (String)song_title, (String)this.api_key);
            if (this.track == null) {
                throw new Exception("Could not find a Last.FM track matching " + song_title + " by " + artist_name);
            }
        } else {
            Collection tracks = Track.search((String)song_title, (String)this.api_key);
            if (tracks.isEmpty()) {
                throw new Exception("Could not find a Last.FM track matching " + song_title);
            }
            Iterator tracks_iterator = tracks.iterator();
            Track temp_track = (Track)tracks_iterator.next();
            if (!called_already) {
                this.setTrack(temp_track.getName(), temp_track.getArtist(), true);
            } else {
                this.track = temp_track;
            }
        }
    }
}

