/*
 * Decompiled with CFR 0.152.
 */
package jsongminer;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Vector;
import jsongminer.ConfigDataAndParser;
import jsongminer.EchoNestMiner;
import jsongminer.EmbeddedTagMiner;
import jsongminer.LastFMMiner;
import jsongminer.MainMethods;
import jsongminer.MusicMetaData;
import mckay.utilities.webservices.ProxyServerAccessor;

public class Main {
    public static void main(String[] args) {
        try {
            String[] temp_identifiers;
            HashMap<String, String> command_line_args = null;
            ConfigDataAndParser configs = null;
            PrintStream status_stream = null;
            PrintStream error_stream = null;
            HashMap<String, Vector<MusicMetaData>> artist_metadata_so_far = null;
            HashMap<String, Vector<MusicMetaData>> album_metadata_so_far = null;
            EmbeddedTagMiner emb_miner = null;
            EchoNestMiner en_miner = null;
            LastFMMiner lfm_miner = null;
            String en_song_id = null;
            String to_extract_audio_path = null;
            String identifying_title = null;
            String identifying_artist = null;
            String identifying_album = null;
            Vector<MusicMetaData> song_metadata = new Vector<MusicMetaData>();
            Vector<MusicMetaData> artist_metadata = new Vector<MusicMetaData>();
            Vector<MusicMetaData> album_metadata = new Vector<MusicMetaData>();
            String ace_xml_save_file_path = null;
            String text_save_file_path = null;
            command_line_args = MainMethods.parseAndTestCommandLineArgs(args, song_metadata);
            configs = MainMethods.parseConfigurationFile();
            if (configs.print_current_status_to_terminal) {
                status_stream = System.out;
            }
            if (configs.print_errors_to_terminal) {
                error_stream = System.err;
            }
            String[] temp_save_array = MainMethods.updateConfigsBasedOnCommandLineArgs(command_line_args, configs, error_stream);
            ace_xml_save_file_path = temp_save_array[0];
            text_save_file_path = temp_save_array[1];
            if (configs.enable_echo_nest_fingerprinting || configs.enable_last_fm_fingerprinting || configs.save_echo_nest_metadata || configs.save_last_fm_metadata) {
                if (status_stream != null) {
                    status_stream.println("Testing if proxy server is needed and configuring it if so...\n");
                }
                new ProxyServerAccessor("./proxysettings.cfg", null);
            }
            artist_metadata_so_far = MainMethods.parseAlreadyExtractedMetadata(configs.artists_already_accessed_file_path, configs.reextract_known_artist_metadata, "artist", status_stream, error_stream);
            album_metadata_so_far = MainMethods.parseAlreadyExtractedMetadata(configs.albums_already_accessed_file_path, configs.reextract_known_album_metadata, "album", status_stream, error_stream);
            to_extract_audio_path = command_line_args.get("-audio");
            if (configs.enable_embedded_metadata_track_identification || configs.save_embedded_metadata) {
                emb_miner = MainMethods.extractEmbeddedMetadata(to_extract_audio_path, status_stream, error_stream);
            }
            identifying_title = MainMethods.getCandidateMetadataValue(emb_miner, to_extract_audio_path, configs.enable_embedded_metadata_track_identification, "title", command_line_args.get("-title"), error_stream);
            identifying_artist = MainMethods.getCandidateMetadataValue(emb_miner, to_extract_audio_path, configs.enable_embedded_metadata_track_identification, "artist", command_line_args.get("-artist"), error_stream);
            identifying_album = MainMethods.getCandidateMetadataValue(emb_miner, to_extract_audio_path, configs.enable_embedded_metadata_track_identification, "album", command_line_args.get("-album"), error_stream);
            if (configs.enable_echo_nest_fingerprinting || configs.save_echo_nest_metadata) {
                if (status_stream != null) {
                    status_stream.println("Initializing the Echo Nest API...\n");
                }
                en_miner = new EchoNestMiner(configs.echo_nest_api_key);
                if (configs.enable_echo_nest_fingerprinting && (en_song_id = MainMethods.extractEchoNestSongID(to_extract_audio_path, identifying_title, identifying_artist, en_miner, configs.echo_nest_fingerprinting_codegen_run_path, configs.echo_nest_codegen_directory, status_stream, error_stream)) != null && (temp_identifiers = en_miner.getIdentifyingMetadataForSong(en_song_id)) != null) {
                    if (temp_identifiers[0] != null) {
                        identifying_title = temp_identifiers[0];
                    }
                    if (temp_identifiers[1] != null) {
                        identifying_artist = temp_identifiers[1];
                    }
                    identifying_album = null;
                }
            }
            if (configs.save_last_fm_metadata || configs.enable_last_fm_fingerprinting && en_song_id == null) {
                lfm_miner = MainMethods.matchToLastFMTrack(identifying_title, identifying_artist, configs.last_fm_api_key, status_stream, error_stream);
                if (lfm_miner != null && configs.enable_last_fm_fingerprinting && en_song_id == null) {
                    temp_identifiers = lfm_miner.getIdentifyingMetadataForSong();
                    if (temp_identifiers != null) {
                        if (temp_identifiers[0] != null) {
                            identifying_title = temp_identifiers[0];
                        }
                        if (temp_identifiers[1] != null) {
                            identifying_artist = temp_identifiers[1];
                        }
                        if (temp_identifiers[2] != null) {
                            identifying_album = temp_identifiers[2];
                        }
                    }
                } else if (lfm_miner != null && configs.enable_last_fm_fingerprinting && (temp_identifiers = lfm_miner.getIdentifyingMetadataForSong()) != null && temp_identifiers[2] != null) {
                    identifying_album = temp_identifiers[2];
                }
            }
            if (en_song_id == null && identifying_title != null && configs.save_echo_nest_metadata && !configs.enable_echo_nest_fingerprinting) {
                en_song_id = MainMethods.extractEchoNestSongID(null, identifying_title, identifying_artist, en_miner, null, null, status_stream, error_stream);
            }
            if (identifying_title != null) {
                if (configs.identify_only) {
                    MainMethods.storeIdentifyingMetadataOnly(song_metadata, to_extract_audio_path, identifying_title, identifying_artist, identifying_album, en_song_id, lfm_miner, configs.store_fails);
                } else {
                    if (configs.save_echo_nest_metadata) {
                        MainMethods.extractEchoNestMetadata(en_song_id, song_metadata, artist_metadata, artist_metadata_so_far, configs.store_fails, en_miner, status_stream, error_stream);
                    }
                    if (configs.save_last_fm_metadata) {
                        MainMethods.extractLastFMMetadata(lfm_miner, song_metadata, artist_metadata, album_metadata, artist_metadata_so_far, album_metadata_so_far, configs.store_fails, status_stream, error_stream);
                    }
                    if (configs.save_embedded_metadata) {
                        MainMethods.storeEmbeddedMetadata(emb_miner, song_metadata, configs.store_fails, status_stream, error_stream);
                    }
                }
                if (!configs.store_fails) {
                    if (status_stream != null) {
                        status_stream.println("Removing empty metadata...\n");
                    }
                    MusicMetaData.cleanMusicMetaData(song_metadata);
                    MusicMetaData.cleanMusicMetaData(artist_metadata);
                    MusicMetaData.cleanMusicMetaData(album_metadata);
                }
                MainMethods.prepareDublinCore(configs.include_unqualified_dublin_core, configs.include_qualified_dublin_core, configs.include_other_metadata_with_dublin_core, configs.package_song_artist_album, song_metadata, artist_metadata, album_metadata, status_stream);
                if (configs.save_output_as_ace_xml) {
                    MainMethods.saveData(true, song_metadata, artist_metadata, album_metadata, configs.package_song_artist_album, configs.songs_save_directory, configs.artists_save_directory, configs.albums_save_directory, configs.url_encode_output, ace_xml_save_file_path, status_stream, error_stream);
                }
                if (configs.save_output_as_txt) {
                    MainMethods.saveData(false, song_metadata, artist_metadata, album_metadata, configs.package_song_artist_album, configs.songs_save_directory, configs.artists_save_directory, configs.albums_save_directory, configs.url_encode_output, text_save_file_path, status_stream, error_stream);
                }
                MainMethods.updateAlreadyAccessedLog(configs.artists_already_accessed_file_path, artist_metadata_so_far, identifying_artist, null, status_stream, error_stream);
                MainMethods.updateAlreadyAccessedLog(configs.albums_already_accessed_file_path, album_metadata_so_far, null, identifying_album, status_stream, error_stream);
                if (configs.print_extracted_metadata_to_terminal) {
                    MainMethods.printMetadata(song_metadata, artist_metadata, album_metadata, configs.package_song_artist_album);
                }
            }
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e.getMessage() + "\n");
        }
    }
}

