/*
 * Decompiled with CFR 0.152.
 */
package jsongminer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Vector;
import jsongminer.ConfigDataAndParser;
import jsongminer.DublinCoreInterpreter;
import jsongminer.EchoNestMiner;
import jsongminer.EmbeddedTagMiner;
import jsongminer.LastFMMiner;
import jsongminer.MusicMetaData;
import mckay.utilities.staticlibraries.MiscellaneousMethods;
import mckay.utilities.staticlibraries.StringMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainMethods {
    public static HashMap<String, String> parseAndTestCommandLineArgs(String[] args, Vector<MusicMetaData> song_metadata) {
        String this_value;
        String extension;
        HashMap<String, Boolean> permitted_flags = new HashMap<String, Boolean>();
        permitted_flags.put("-audio", new Boolean(false));
        permitted_flags.put("-title", new Boolean(false));
        permitted_flags.put("-artist", new Boolean(false));
        permitted_flags.put("-album", new Boolean(false));
        permitted_flags.put("-savedir", new Boolean(false));
        permitted_flags.put("-savefile", new Boolean(false));
        permitted_flags.put("-saveacexmlfile", new Boolean(false));
        permitted_flags.put("-savetxtfile", new Boolean(false));
        permitted_flags.put("-eraselogs", new Boolean(false));
        permitted_flags.put("-urldecode", new Boolean(false));
        permitted_flags.put("-acexmltotxt", new Boolean(false));
        permitted_flags.put("-acexmltotxtud", new Boolean(false));
        Vector<String> explanations = new Vector<String>();
        explanations.add("The path of an audio file to identify and extract metadata for, if available.");
        explanations.add("The suspected title of the song to extract metadata for, if known.");
        explanations.add("The suspected name of the artist associated with the song to extract metadata for, if known.");
        explanations.add("The suspected title of the album most associated with the song to extract metadata for, if known.");
        explanations.add("The directory to save extracted metadata in. This overrides any and all output directories specified in the configuration file, and applies to both text and ACE XML output. Only a directory should be specified, as file names will be auto-generated based on content. May not be used in conjunction with any of the -savefile, -saveacexmlfile or -savetxtfile flags.");
        explanations.add("The file path to save extracted metadata to. This overrides configuration settings relating to output directories, and sets the package_song_artist_album setting to true so that song, artist and album metadata are combined into one file. If the value specified here has a .xml extension, then the output will be saved as ACE XML. If it has a .txt extension, then the output will be saved as text. May not be used in conjunction with any of the -savedir, -saveacexmlfile or -savetxtfile flags.");
        explanations.add("The file path of the ACE XML file to save extracted metadata to. This overrides configuration settings relating to output directories, sets the save_output_as_ace_xml configuration setting to true, and sets the package_song_artist_album setting to true so that song, artist and album metadata are combined into one file. This flag may be used either alone or in conjunction with the -savetxtfile flag.");
        explanations.add("The file path of the text file to save extracted metadata to. This overrides configuration settings relating to output directories, sets the save_output_as_txt configuration setting to true, and sets the package_song_artist_album setting to true so that song, artist and album metadata are combined into one file. This flag may be used either alone or in conjunction with the -saveacexmlfile flag.");
        explanations.add("Erases the logs of previously extracted artists and/or albums, if any. This does not alter the reextract_known_artist_metadata or reextract_known_album_metadata configuration settings, but it does erase any existing logs before the new processing begins. The value following this flag must be \"artist\", \"album\" or \"all\", and specifies which log(s) are erased.");
        explanations.add("URL decodes the text following this flag and prints the results to standard out. Uses UTF-8 decoding. This is a terminal utility function, so no other processing is performed other than this, and this flag cannot be used in combination with any other flags.");
        explanations.add("Converts the ACE XML Classifications 1.1 file whose path is specified after this flag into the type of text produced by jSongMiner, which is to say field names are printed to odd lines and field values are printed to the following even lines. This is output to standard out. URL decoding is not performed. This is a terminal utility function, so no other processing is performed other than this, and this flag cannot be used in combination with any other flags.");
        explanations.add("Converts the ACE XML Classifications 1.1 file whose path is specified after this flag into the type of text produced by jSongMiner, which is to say field names are printed to odd lines and field values are printed to the following even lines. This is output to standard out. URL decoding is performed (UTF-8). This is a terminal utility function, so no other processing is performed other than this, and this flag cannot be used in combination with any other flags.");
        Vector<String> explanation_keys = new Vector<String>();
        explanation_keys.add("-audio");
        explanation_keys.add("-title");
        explanation_keys.add("-artist");
        explanation_keys.add("-album");
        explanation_keys.add("-savedir");
        explanation_keys.add("-savefile");
        explanation_keys.add("-saveacexmlfile");
        explanation_keys.add("-savetxtfile");
        explanation_keys.add("-eraselogs");
        explanation_keys.add("-urldecode");
        explanation_keys.add("-acexmltotxt");
        explanation_keys.add("-acexmltotxtud");
        HashMap parsed_args = MiscellaneousMethods.parseCommandLineParameters((String[])args, permitted_flags, (String[])explanation_keys.toArray(new String[explanation_keys.size()]), (String[])explanations.toArray(new String[explanations.size()]), (PrintStream)System.err);
        boolean print_valid_and_quit = false;
        if (parsed_args.containsKey("-urldecode")) {
            if (parsed_args.size() > 1) {
                System.err.println("The \"-urldecode\" flag may not be used in combination with any other flags.");
                print_valid_and_quit = true;
            } else {
                MainMethods.urlDecodAndQuit((String)parsed_args.get("-urldecode"));
            }
        }
        if (parsed_args.containsKey("-acexmltotxt")) {
            if (parsed_args.size() > 1) {
                System.err.println("The \"-acexmltotxt\" flag may not be used in combination with any other flags.");
                print_valid_and_quit = true;
            } else {
                MainMethods.aceXMLToTextAndQuit((String)parsed_args.get("-acexmltotxt"), false);
            }
        }
        if (parsed_args.containsKey("-acexmltotxtud")) {
            if (parsed_args.size() > 1) {
                System.err.println("The \"-acexmltotxtud\" flag may not be used in combination with any other flags.");
                print_valid_and_quit = true;
            } else {
                MainMethods.aceXMLToTextAndQuit((String)parsed_args.get("-acexmltotxtud"), true);
            }
        }
        if (!parsed_args.containsKey("-audio") && !parsed_args.containsKey("-title")) {
            System.err.println("The command line arguments contain neither the \"-audio\" nor the \"-title\" flags. At least one of these two flags must be used (unless terminal utility flags are being used).");
            print_valid_and_quit = true;
        }
        if (parsed_args.containsKey("-savedir") && (parsed_args.containsKey("-savefile") || parsed_args.containsKey("-saveacexmlfile") || parsed_args.containsKey("-savetxtfile"))) {
            System.err.println("If the \"-savedir\" flag is used in the command line arguments, then none of the \"-savefile\", \"-saveacexmlfile\" or \"-savetxtfile\" flags flags may be used.");
            print_valid_and_quit = true;
        } else if (parsed_args.containsKey("-savefile") && (parsed_args.containsKey("-savedir") || parsed_args.containsKey("-saveacexmlfile") || parsed_args.containsKey("-savetxtfile"))) {
            System.err.println("If the \"-savefile\" flag is used in the command line arguments, then none of the \"-savedir\", \"-saveacexmlfile\" or \"-savetxtfile\" flags flags may be used.");
            print_valid_and_quit = true;
        }
        if (parsed_args.containsKey("-savefile") && ((extension = StringMethods.getExtension((String)((String)parsed_args.get("-savefile")))) == null || !extension.equals(".txt") && !extension.equals(".xml"))) {
            System.err.println("The file path following the -savefile command line switch must have an extension of either \".txt\" or \".xml\".");
            print_valid_and_quit = true;
        }
        if (parsed_args.containsKey("-eraselogs") && !(this_value = (String)parsed_args.get("-eraselogs")).equals("artist") && !this_value.equals("album") && !this_value.equals("all")) {
            System.err.println("The value following the -eraselogs command line switch must have a value of \"artist\", \"album\" or \"all\".");
            print_valid_and_quit = true;
        }
        if (print_valid_and_quit) {
            System.err.println("\nEXECUTION TERMINATED DUE TO INVALID COMMAND LINE ARGUMENTS");
            MiscellaneousMethods.parseCommandLineParameters((String[])new String[]{"-help"}, permitted_flags, (String[])explanation_keys.toArray(new String[explanation_keys.size()]), (String[])explanations.toArray(new String[explanations.size()]), (PrintStream)System.err);
        }
        String source_identifier_code = "Command Line Argument";
        if (parsed_args.containsKey("-audio")) {
            song_metadata.add(new MusicMetaData(source_identifier_code, "Audio Source File", (String)parsed_args.get("-audio")));
        }
        if (parsed_args.containsKey("-title")) {
            song_metadata.add(new MusicMetaData(source_identifier_code, "Song Title", (String)parsed_args.get("-title")));
        }
        if (parsed_args.containsKey("-artist")) {
            song_metadata.add(new MusicMetaData(source_identifier_code, "Artist Name", (String)parsed_args.get("-artist")));
        }
        if (parsed_args.containsKey("-album")) {
            song_metadata.add(new MusicMetaData(source_identifier_code, "Album Title", (String)parsed_args.get("-album")));
        }
        return parsed_args;
    }

    public static ConfigDataAndParser parseConfigurationFile() {
        ConfigDataAndParser configs = new ConfigDataAndParser("./jSongMinerConfigs.xml", System.err);
        if (configs.print_current_status_to_terminal) {
            System.out.println("\nLoading of configuration settings complete.\n");
        }
        return configs;
    }

    public static String[] updateConfigsBasedOnCommandLineArgs(HashMap<String, String> command_line_args, ConfigDataAndParser configs, PrintStream error_stream) {
        String[] save_file_path = new String[]{null, null};
        if (command_line_args.containsKey("-eraselogs")) {
            boolean deleted;
            File to_erase;
            if ((command_line_args.get("-eraselogs").equals("artist") || command_line_args.get("-eraselogs").equals("all")) && (to_erase = new File(configs.artists_already_accessed_file_path)).exists() && !(deleted = to_erase.delete()) && error_stream != null) {
                error_stream.println("Could not delete the artist log at " + configs.artists_already_accessed_file_path + ".\n");
            }
            if ((command_line_args.get("-eraselogs").equals("album") || command_line_args.get("-eraselogs").equals("all")) && (to_erase = new File(configs.albums_already_accessed_file_path)).exists() && !(deleted = to_erase.delete()) && error_stream != null) {
                error_stream.println("Could not delete the album log at " + configs.albums_already_accessed_file_path + ".\n");
            }
        }
        if (command_line_args.containsKey("-savedir")) {
            configs.songs_save_directory = command_line_args.get("-savedir");
            configs.artists_save_directory = command_line_args.get("-savedir");
            configs.albums_save_directory = command_line_args.get("-savedir");
        }
        if (command_line_args.containsKey("-savefile")) {
            String path = command_line_args.get("-savefile");
            String extension = StringMethods.getExtension((String)path);
            configs.package_song_artist_album = true;
            if (extension.equals(".txt")) {
                configs.save_output_as_ace_xml = false;
                configs.save_output_as_txt = true;
                save_file_path[1] = path;
            } else if (extension.equals(".xml")) {
                configs.save_output_as_ace_xml = true;
                configs.save_output_as_txt = false;
                save_file_path[0] = path;
            }
        }
        if (command_line_args.containsKey("-saveacexmlfile")) {
            save_file_path[0] = command_line_args.get("-saveacexmlfile");
            configs.package_song_artist_album = true;
            configs.save_output_as_ace_xml = true;
        }
        if (command_line_args.containsKey("-savetxtfile")) {
            save_file_path[1] = command_line_args.get("-savetxtfile");
            configs.package_song_artist_album = true;
            configs.save_output_as_txt = true;
        }
        return save_file_path;
    }

    public static HashMap<String, Vector<MusicMetaData>> parseAlreadyExtractedMetadata(String already_accessed_file_path, boolean should_reextract, String type_extracting, PrintStream status_stream, PrintStream error_stream) {
        HashMap<String, Vector<MusicMetaData>> metadata_so_far = null;
        if (!should_reextract) {
            if (status_stream != null) {
                status_stream.println("Parsing " + type_extracting + "s for which metadata has already been extracted...\n");
            }
            if ((metadata_so_far = MainMethods.readArtistsOrAlbumsExtracted(already_accessed_file_path)) == null && error_stream != null) {
                error_stream.println("Unable to load previously extracted " + type_extracting + "s.\n");
            }
        }
        if (metadata_so_far == null) {
            if (error_stream != null) {
                error_stream.println("Creating new data structures for logging " + type_extracting + "s that have already had their metadata extracted...\n");
            }
            metadata_so_far = new HashMap();
        }
        return metadata_so_far;
    }

    public static EmbeddedTagMiner extractEmbeddedMetadata(String to_extract_audio_path, PrintStream status_stream, PrintStream error_stream) {
        block3: {
            if (to_extract_audio_path != null) {
                try {
                    status_stream.println("Parsing metadata embedded in the specified audio file...\n");
                    return new EmbeddedTagMiner(to_extract_audio_path);
                }
                catch (Exception e) {
                    if (error_stream == null) break block3;
                    error_stream.println("Could not extract metadata embedded in " + to_extract_audio_path + ".\n");
                }
            }
        }
        return null;
    }

    public static String getCandidateMetadataValue(EmbeddedTagMiner emb_miner, String audio_path, boolean may_extract_embedded, String metadata_type_identifier, String model_value, PrintStream error_stream) {
        try {
            if (model_value != null) {
                return model_value;
            }
            if (emb_miner == null) {
                if (may_extract_embedded && audio_path != null) {
                    throw new Exception();
                }
                return null;
            }
            if (metadata_type_identifier.equals("title")) {
                return emb_miner.getTitle();
            }
            if (metadata_type_identifier.equals("artist")) {
                return emb_miner.getArtist();
            }
            if (metadata_type_identifier.equals("album")) {
                return emb_miner.getAlbum();
            }
            return null;
        }
        catch (Exception e) {
            if (error_stream != null) {
                error_stream.println("Could not extract embedded " + metadata_type_identifier + " metadata from the audio file.\n");
            }
            return null;
        }
    }

    public static String extractEchoNestSongID(String music_file_path, String model_song_title_metadata, String model_artist_metadata, EchoNestMiner en_miner, String en_codegen_run_path, String en_codegen_directory, PrintStream status_stream, PrintStream error_stream) {
        String en_song_id = null;
        if (status_stream != null) {
            status_stream.println("Attempting to identify the song using the best available Echo Nest method...\n");
        }
        try {
            en_song_id = en_miner.getAndStoreEchoNestSongIDUsingBestAvailableMethod(music_file_path, model_song_title_metadata, model_artist_metadata, true, error_stream, en_codegen_run_path, en_codegen_directory);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (en_song_id != null) {
            if (status_stream != null) {
                status_stream.println("Song identification successfully completed: Echo Nest ID " + en_song_id + "\n");
            }
        } else if (error_stream != null) {
            error_stream.println("\nEcho Nest song identification FAILED!\n");
        }
        return en_song_id;
    }

    public static LastFMMiner matchToLastFMTrack(String model_song_title_metadata, String model_artist_metadata, String last_fm_api_key, PrintStream status_stream, PrintStream error_stream) {
        LastFMMiner lfm_miner;
        block5: {
            lfm_miner = null;
            if (status_stream != null) {
                status_stream.println("Attempting to match the song to a Last.FM track...\n");
            }
            try {
                if (model_song_title_metadata == null) {
                    throw new Exception("No model song title to base identification upon available.");
                }
                lfm_miner = new LastFMMiner(model_song_title_metadata, model_artist_metadata, last_fm_api_key);
                if (status_stream != null) {
                    status_stream.println("Last.FM successfully matched song: " + model_song_title_metadata + ", by " + model_artist_metadata + "\n");
                }
            }
            catch (Exception e) {
                if (error_stream == null) break block5;
                error_stream.println("Last.FM song identification FAILED!: " + e.getMessage() + "\n");
            }
        }
        return lfm_miner;
    }

    public static void storeIdentifyingMetadataOnly(Vector<MusicMetaData> song_metadata, String to_extract_audio_path, String identifying_title, String identifying_artist, String identifying_album, String en_song_id, LastFMMiner lfm_miner, boolean store_fails) {
        song_metadata.clear();
        if (to_extract_audio_path != null) {
            song_metadata.add(new MusicMetaData("jSongMiner", "Audio Source File", to_extract_audio_path));
        } else if (store_fails) {
            song_metadata.add(new MusicMetaData("jSongMiner", "Audio Source File", "Could not extract this information."));
        }
        if (identifying_title != null) {
            song_metadata.add(new MusicMetaData("jSongMiner", "Song Title", identifying_title));
        } else if (store_fails) {
            song_metadata.add(new MusicMetaData("jSongMiner", "Song Title", "Could not extract this information."));
        }
        if (identifying_artist != null) {
            song_metadata.add(new MusicMetaData("jSongMiner", "Artist Name", identifying_artist));
        } else if (store_fails) {
            song_metadata.add(new MusicMetaData("jSongMiner", "Artist Name", "Could not extract this information."));
        }
        if (identifying_album != null) {
            song_metadata.add(new MusicMetaData("jSongMiner", "Album Title", identifying_album));
        } else if (store_fails) {
            song_metadata.add(new MusicMetaData("jSongMiner", "Album Title", "Could not extract this information."));
        }
        if (en_song_id != null) {
            song_metadata.add(new MusicMetaData("jSongMiner", "Echo Nest Song ID", en_song_id));
        } else if (store_fails) {
            song_metadata.add(new MusicMetaData("jSongMiner", "Echo Nest Song ID", "Could not extract this information."));
        }
        String track_url = null;
        if (lfm_miner != null && (track_url = lfm_miner.getLastFMTrackURL()) != null) {
            song_metadata.add(new MusicMetaData("jSongMiner", "Last.FM Track URL", track_url));
        }
        if (track_url == null && store_fails) {
            song_metadata.add(new MusicMetaData("jSongMiner", "Last.FM Track URL", "Could not extract this information."));
        }
    }

    public static void extractEchoNestMetadata(String en_song_id, Vector<MusicMetaData> song_metadata, Vector<MusicMetaData> artist_metadata, HashMap<String, Vector<MusicMetaData>> artist_metadata_so_far, boolean store_fails, EchoNestMiner en_miner, PrintStream status_stream, PrintStream error_stream) {
        if (en_song_id != null) {
            if (status_stream != null) {
                status_stream.println("Attempting to extract Echo Nest metadata...\n");
            }
            boolean echo_nest_found_metadata = false;
            try {
                echo_nest_found_metadata = en_miner.getAllAvailableNewMetaData(en_song_id, song_metadata, artist_metadata, artist_metadata_so_far, true, store_fails);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (echo_nest_found_metadata) {
                if (status_stream != null) {
                    status_stream.println("Echo Nest metadata successfully extracted.\n");
                }
            } else if (error_stream != null) {
                error_stream.println("Echo Nest metadata extraction FAILED!\n");
            }
        }
    }

    public static void extractLastFMMetadata(LastFMMiner lfm_miner, Vector<MusicMetaData> song_metadata, Vector<MusicMetaData> artist_metadata, Vector<MusicMetaData> album_metadata, HashMap<String, Vector<MusicMetaData>> artist_metadata_so_far, HashMap<String, Vector<MusicMetaData>> album_metadata_so_far, boolean store_fails, PrintStream status_stream, PrintStream error_stream) throws Exception {
        if (lfm_miner != null) {
            if (status_stream != null) {
                status_stream.println("Attempting to extract Last.FM metadata...\n");
            }
            boolean last_fm_found_metadata = false;
            last_fm_found_metadata = lfm_miner.getAllAvailableNewMetaData(song_metadata, artist_metadata, album_metadata, artist_metadata_so_far, album_metadata_so_far, store_fails);
            if (last_fm_found_metadata) {
                if (status_stream != null) {
                    status_stream.println("Last.FM metadata successfully extracted.\n");
                }
            } else if (error_stream != null) {
                error_stream.println("Last.FM metadata extraction FAILED!\n");
            }
        }
    }

    public static void storeEmbeddedMetadata(EmbeddedTagMiner emb_miner, Vector<MusicMetaData> song_metadata, boolean store_fails, PrintStream status_stream, PrintStream error_stream) throws Exception {
        if (emb_miner != null) {
            if (status_stream != null) {
                status_stream.println("Storing embedded metadata parsed from the audio file...\n");
            }
            boolean embedded_metadata_found_metadata = false;
            embedded_metadata_found_metadata = emb_miner.getAllAvailableNewMetaData(song_metadata, store_fails);
            if (embedded_metadata_found_metadata) {
                if (status_stream != null) {
                    status_stream.println("Embedded metadata parsed from the audio file successfully stored.\n");
                }
            } else if (error_stream != null) {
                error_stream.println("Could not store any embedded metadata parsed from the audio file.\n");
            }
        }
    }

    public static void prepareDublinCore(boolean include_unqualified_dublin_core, boolean include_qualified_dublin_core, boolean include_other_metadata_with_dublin_core, boolean repress_unqualified_artist_and_album, Vector<MusicMetaData> song_metadata, Vector<MusicMetaData> artist_metadata, Vector<MusicMetaData> album_metadata, PrintStream status_stream) {
        if (include_unqualified_dublin_core || include_qualified_dublin_core) {
            Vector<MusicMetaData> dc_song_metadata = new Vector<MusicMetaData>();
            Vector<MusicMetaData> dc_artist_metadata = new Vector<MusicMetaData>();
            Vector<MusicMetaData> dc_album_metadata = new Vector<MusicMetaData>();
            if (include_unqualified_dublin_core) {
                if (status_stream != null) {
                    status_stream.println("Formatting extracted metadata into unqualified Dublin Core...\n");
                }
                dc_song_metadata.addAll(DublinCoreInterpreter.getSongUnqualifiedDublinCore(song_metadata));
                if (!repress_unqualified_artist_and_album) {
                    dc_artist_metadata.addAll(DublinCoreInterpreter.getArtistUnqualifiedDublinCore(artist_metadata));
                    dc_album_metadata.addAll(DublinCoreInterpreter.getAlbumUnqualifiedDublinCore(album_metadata));
                }
            }
            if (include_qualified_dublin_core) {
                if (status_stream != null) {
                    status_stream.println("Formatting extracted metadata into qualified Dublin Core...\n");
                }
                dc_song_metadata.addAll(DublinCoreInterpreter.getSongQualifiedDublinCore(song_metadata));
                dc_artist_metadata.addAll(DublinCoreInterpreter.getArtistQualifiedDublinCore(artist_metadata));
                dc_album_metadata.addAll(DublinCoreInterpreter.getAlbumQualifiedDublinCore(album_metadata));
            }
            if (!include_other_metadata_with_dublin_core) {
                if (status_stream != null) {
                    status_stream.println("Removing non-Dublin Core formatted metadata...\n");
                }
                song_metadata.clear();
                artist_metadata.clear();
                album_metadata.clear();
            }
            song_metadata.addAll(dc_song_metadata);
            artist_metadata.addAll(dc_artist_metadata);
            album_metadata.addAll(dc_album_metadata);
        }
    }

    public static void saveData(boolean as_ace_xml, Vector<MusicMetaData> song_metadata, Vector<MusicMetaData> artist_metadata, Vector<MusicMetaData> album_metadata, boolean package_song_artist_album, String songs_save_directory, String artists_save_directory, String albums_save_directory, boolean url_encode_output, String save_file_path, PrintStream status_stream, PrintStream error_stream) {
        block32: {
            String[] identifier_keys;
            block31: {
                block30: {
                    block29: {
                        if (package_song_artist_album) {
                            Vector<MusicMetaData> merged_metadata = new Vector<MusicMetaData>(song_metadata.size() + artist_metadata.size() + album_metadata.size());
                            merged_metadata.addAll(song_metadata);
                            merged_metadata.addAll(artist_metadata);
                            merged_metadata.addAll(album_metadata);
                            if (merged_metadata.size() != 0) {
                                try {
                                    MusicMetaData.removeDuplicateEntries(merged_metadata);
                                    if (status_stream != null) {
                                        if (!as_ace_xml) {
                                            status_stream.println("Saving extracted metadata as text...\n");
                                        } else {
                                            status_stream.println("Saving extracted metadata as ACE XML...\n");
                                        }
                                    }
                                    String[] identifier_keys2 = new String[]{"Echo Nest Song ID", "Music Brainz Song ID", "Last.FM Track URL", "Song Title", "Audio Source File", "dc.Identifier^echonestsongid", "dc.Identifier^musicbrainzsongid", "dc.Identifier^lastfmtrackurl", "dc.Title^songtitle", "dc.Identifier^filepath", "dc.Identifier", "dc.Title"};
                                    if (as_ace_xml) {
                                        MusicMetaData.saveInACEXMLClassificationsFile(identifier_keys2, merged_metadata, url_encode_output, songs_save_directory, save_file_path);
                                    } else {
                                        MusicMetaData.saveInTextFile(identifier_keys2, merged_metadata, url_encode_output, songs_save_directory, save_file_path);
                                    }
                                }
                                catch (Exception e) {
                                    if (error_stream == null) break block29;
                                    error_stream.println("Saving of metadata FAILED!: " + e.getMessage());
                                }
                            }
                        }
                    }
                    if (song_metadata.size() != 0 && !package_song_artist_album) {
                        try {
                            if (status_stream != null) {
                                if (!as_ace_xml) {
                                    status_stream.println("Saving extracted song data as text...\n");
                                } else {
                                    status_stream.println("Saving extracted song data as ACE XML...\n");
                                }
                            }
                            identifier_keys = new String[]{"Echo Nest Song ID", "Music Brainz Song ID", "Last.FM Track URL", "Song Title", "Audio Source File", "dc.Identifier^echonestsongid", "dc.Identifier^musicbrainzsongid", "dc.Identifier^lastfmtrackurl", "dc.Title^songtitle", "dc.Identifier^filepath", "dc.Identifier", "dc.Title"};
                            if (as_ace_xml) {
                                MusicMetaData.saveInACEXMLClassificationsFile(identifier_keys, song_metadata, url_encode_output, songs_save_directory, save_file_path);
                            } else {
                                MusicMetaData.saveInTextFile(identifier_keys, song_metadata, url_encode_output, songs_save_directory, save_file_path);
                            }
                        }
                        catch (Exception e) {
                            if (error_stream == null) break block30;
                            error_stream.println("Saving of song data FAILED!: " + e.getMessage());
                        }
                    }
                }
                if (artist_metadata.size() != 0 && !package_song_artist_album) {
                    try {
                        if (status_stream != null) {
                            status_stream.println("Saving extracted artist data in ACE XML...\n");
                        }
                        identifier_keys = new String[]{"Echo Nest Artist ID", "Music Brainz Artist ID", "Last.FM Artist URL", "Artist Name", "dc.Identifier^echonestartistid", "dc.Identifier^musicbrainzartistid", "dc.Identifier^lastfmartisturl", "dc.Title^artistname", "dc.Identifier", "dc.Title"};
                        if (as_ace_xml) {
                            MusicMetaData.saveInACEXMLClassificationsFile(identifier_keys, artist_metadata, url_encode_output, artists_save_directory, save_file_path);
                        } else {
                            MusicMetaData.saveInTextFile(identifier_keys, artist_metadata, url_encode_output, artists_save_directory, save_file_path);
                        }
                    }
                    catch (Exception e) {
                        if (error_stream == null) break block31;
                        error_stream.println("Saving of artist data FAILED!: " + e.getMessage());
                    }
                }
            }
            if (album_metadata.size() != 0 && !package_song_artist_album) {
                try {
                    if (status_stream != null) {
                        status_stream.println("Saving extracted album data in ACE XML...\n");
                    }
                    identifier_keys = new String[]{"Music Brainz Album ID", "Last.FM Album URL", "Album Title", "dc.Identifier^musicbrainzalbumid", "dc.Identifier^lastfmalbumurl", "dc.Title^albumtitle", "dc.Identifier", "dc.Title"};
                    if (as_ace_xml) {
                        MusicMetaData.saveInACEXMLClassificationsFile(identifier_keys, album_metadata, url_encode_output, albums_save_directory, save_file_path);
                    } else {
                        MusicMetaData.saveInTextFile(identifier_keys, album_metadata, url_encode_output, albums_save_directory, save_file_path);
                    }
                }
                catch (Exception e) {
                    if (error_stream == null) break block32;
                    error_stream.println("Saving of album data FAILED!: " + e.getMessage());
                }
            }
        }
    }

    public static void updateAlreadyAccessedLog(String already_accessed_file_path, HashMap<String, Vector<MusicMetaData>> metadata_so_far, String identifying_artist, String identifying_album, PrintStream status_stream, PrintStream error_stream) {
        block8: {
            if (status_stream != null && identifying_artist != null) {
                status_stream.println("Saving update to log of artists already accessed...\n");
            } else if (status_stream != null && identifying_album != null) {
                status_stream.println("Saving update to log of albums already accessed...\n");
            }
            try {
                String key = null;
                if (identifying_artist != null) {
                    key = identifying_artist.toLowerCase();
                } else if (identifying_album != null) {
                    key = identifying_album.toLowerCase();
                }
                MainMethods.writeArtistsOrAlbumsExtracted(already_accessed_file_path, metadata_so_far, key, null);
            }
            catch (Exception e) {
                if (error_stream == null) break block8;
                error_stream.println("Updating of already accessed log file FAILED!\n");
            }
        }
    }

    public static void printMetadata(Vector<MusicMetaData> song_metadata, Vector<MusicMetaData> artist_metadata, Vector<MusicMetaData> album_metadata, boolean package_song_artist_album) {
        int i;
        if (package_song_artist_album) {
            System.out.println("\nEXTRACTED COMBINED METADATA:\n");
        }
        if (!package_song_artist_album) {
            System.out.println("\nEXTRACTED SONG METADATA:\n");
        }
        if (!song_metadata.isEmpty()) {
            for (i = 0; i < song_metadata.size(); ++i) {
                song_metadata.get(i).printValues();
            }
        }
        if (!package_song_artist_album) {
            System.out.println("\nEXTRACTED ARTIST METADATA:\n");
        }
        if (!artist_metadata.isEmpty()) {
            for (i = 0; i < artist_metadata.size(); ++i) {
                artist_metadata.get(i).printValues();
            }
        }
        if (!package_song_artist_album) {
            System.out.println("\nEXTRACTED ALBUM METADATA:\n");
        }
        if (!album_metadata.isEmpty()) {
            for (i = 0; i < album_metadata.size(); ++i) {
                album_metadata.get(i).printValues();
            }
        }
        System.out.println();
    }

    public static HashMap<String, Vector<MusicMetaData>> readArtistsOrAlbumsExtracted(String file_path) {
        try {
            FileInputStream fis = new FileInputStream(file_path);
            ObjectInputStream ois = new ObjectInputStream(fis);
            HashMap metadata_so_far = (HashMap)ois.readObject();
            ois.close();
            return metadata_so_far;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void writeArtistsOrAlbumsExtracted(String file_path, HashMap<String, Vector<MusicMetaData>> metadata_so_far, String new_key_id, Vector<MusicMetaData> new_metadata) throws Exception {
        if (new_key_id != null) {
            metadata_so_far.put(new_key_id, new_metadata);
        }
        try {
            FileOutputStream fos = new FileOutputStream(file_path);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(metadata_so_far);
            oos.close();
        }
        catch (Exception e) {
            throw new Exception("Could not save the updated file.");
        }
    }

    public static void urlDecodAndQuit(String to_decode) {
        try {
            System.out.print(StringMethods.URLDecodeNullCompatible((String)to_decode));
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e.getMessage() + "\n");
        }
        System.exit(0);
    }

    public static void aceXMLToTextAndQuit(String file_path, boolean url_decode) {
        try {
            String parsed_results = MusicMetaData.convertACEXMLToText(file_path);
            if (url_decode) {
                parsed_results = StringMethods.URLDecodeNullCompatible((String)parsed_results);
            }
            System.out.print(parsed_results);
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e.getMessage() + "\n");
        }
        System.exit(0);
    }
}

