/*
 * Decompiled with CFR 0.152.
 */
package jsongminer;

import ace.datatypes.SegmentedClassification;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.Vector;
import mckay.utilities.staticlibraries.StringMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MusicMetaData
implements Serializable {
    private String source;
    private String field_identifier;
    private String value;
    private static final long serialVersionUID = 5454673585687677L;

    public MusicMetaData(String source, String field_identifier, String value) {
        this.source = source;
        this.field_identifier = field_identifier;
        this.value = value;
    }

    public String getSource() {
        return this.source;
    }

    public String getFieldIdentifier() {
        return this.field_identifier;
    }

    public String getValue() {
        return this.value;
    }

    public void printValues() {
        System.out.println("SOURCE: " + this.source);
        System.out.println("FIELD IDENTIFIER: " + this.field_identifier);
        System.out.println("VALUE: " + this.value);
        System.out.println();
    }

    public static String findFirstValidValueForFieldID(String field_id_to_search_for, Vector<MusicMetaData> to_search) {
        for (int i = 0; i < to_search.size(); ++i) {
            String value;
            String field_identifier = to_search.get(i).getFieldIdentifier();
            if (!field_identifier.equals(field_id_to_search_for) || (value = to_search.get(i).getValue()) == null || value.equals("")) continue;
            return value;
        }
        return null;
    }

    public static void cleanMusicMetaData(Vector<MusicMetaData> to_clean) {
        Vector<MusicMetaData> to_erase = new Vector<MusicMetaData>();
        for (int i = 0; i < to_clean.size(); ++i) {
            MusicMetaData this_one = to_clean.get(i);
            if (this_one.getValue() == null) {
                to_erase.add(this_one);
                continue;
            }
            if (!this_one.getValue().equals("")) continue;
            to_erase.add(this_one);
        }
        to_clean.removeAll(to_erase);
    }

    public static void removeDuplicateEntries(Vector<MusicMetaData> to_clean) {
        Vector<MusicMetaData> to_erase = new Vector<MusicMetaData>();
        for (int i = 0; i < to_clean.size(); ++i) {
            MusicMetaData first_one = to_clean.get(i);
            for (int j = i + 1; j < to_clean.size(); ++j) {
                MusicMetaData second_one = to_clean.get(j);
                if (!first_one.field_identifier.equals(second_one.field_identifier) || !first_one.value.equals(second_one.value) || !first_one.source.equals(second_one.source)) continue;
                to_erase.add(second_one);
            }
        }
        to_clean.removeAll(to_erase);
    }

    public static SegmentedClassification convertToJMIRData(String identifier, Vector<MusicMetaData> to_convert, boolean url_encode) throws Exception {
        String[] misc_info;
        String[] misc_info_key;
        if (identifier == null) {
            return null;
        }
        if (identifier.equals("")) {
            return null;
        }
        if (to_convert.isEmpty()) {
            misc_info_key = null;
            misc_info = null;
        } else {
            misc_info_key = new String[to_convert.size()];
            misc_info = new String[to_convert.size()];
            for (int i = 0; i < to_convert.size(); ++i) {
                misc_info_key[i] = MusicMetaData.generateSingleKey(to_convert.get(i));
                misc_info[i] = to_convert.get(i).getValue();
                if (!url_encode) continue;
                misc_info_key[i] = StringMethods.URLEncodeWithNulls((String)misc_info_key[i]);
                misc_info[i] = StringMethods.URLEncodeWithNulls((String)misc_info[i]);
            }
        }
        return new SegmentedClassification(identifier, Double.NaN, Double.NaN, null, misc_info, misc_info_key, null);
    }

    public static void saveInACEXMLClassificationsFile(String[] identifier_keys, Vector<MusicMetaData> data_to_save, boolean url_encode, String save_directory, String save_file_path) throws Exception {
        File save_file = save_file_path == null ? MusicMetaData.getSaveFile(identifier_keys, data_to_save, true, url_encode, save_directory) : new File(save_file_path);
        String identifier = null;
        for (int i = 0; i < identifier_keys.length; ++i) {
            identifier = MusicMetaData.findFirstValidValueForFieldID(identifier_keys[i], data_to_save);
            if (identifier == null) continue;
            i = identifier_keys.length;
        }
        if (identifier == null) {
            throw new Exception("No valid identifier could be found.");
        }
        SegmentedClassification[] to_save = new SegmentedClassification[]{MusicMetaData.convertToJMIRData(identifier, data_to_save, url_encode)};
        SegmentedClassification.saveClassifications((SegmentedClassification[])to_save, (File)save_file, (String)"Generated by jMIR jSongMiner");
    }

    public static void saveInTextFile(String[] identifier_keys, Vector<MusicMetaData> data_to_save, boolean url_encode, String save_directory, String save_file_path) throws Exception {
        File save_file = save_file_path == null ? MusicMetaData.getSaveFile(identifier_keys, data_to_save, false, url_encode, save_directory) : new File(save_file_path);
        FileOutputStream to = new FileOutputStream(save_file);
        DataOutputStream writer = new DataOutputStream(to);
        for (int i = 0; i < data_to_save.size(); ++i) {
            String key = MusicMetaData.generateSingleKey(data_to_save.get(i));
            String data = data_to_save.get(i).getValue();
            if (url_encode) {
                key = StringMethods.URLEncodeWithNulls((String)key);
                data = StringMethods.URLEncodeWithNulls((String)data);
            }
            writer.writeBytes(key);
            writer.writeBytes("\n");
            writer.writeBytes(data);
            writer.writeBytes("\n");
        }
        writer.close();
    }

    public static String convertACEXMLToText(String ace_xml_path) throws Exception {
        SegmentedClassification[] ace_instances = SegmentedClassification.parseClassificationsFile((String)ace_xml_path);
        if (ace_instances == null) {
            throw new Exception("Could not read valid metadata from the " + ace_xml_path + " file.");
        }
        if (ace_instances.length != 1) {
            throw new Exception("The given " + ace_xml_path + " file contains " + ace_instances.length + " instances. It should only contain one.");
        }
        String[] field_keys = ace_instances[0].misc_info_key;
        String[] field_values = ace_instances[0].misc_info_info;
        if (field_keys == null || field_values == null) {
            throw new Exception("The given " + ace_xml_path + " file does not contain any metadata for its instance.");
        }
        if (field_keys.length == 0 || field_values.length == 0) {
            throw new Exception("The given " + ace_xml_path + " file does not contain any metadata for its instance.");
        }
        StringBuffer results = new StringBuffer();
        for (int i = 0; i < field_keys.length; ++i) {
            results.append(field_keys[i]);
            results.append("\n");
            results.append(field_values[i]);
            results.append("\n");
        }
        return results.toString();
    }

    private static File getSaveFile(String[] identifier_keys, Vector<MusicMetaData> data_to_save, boolean is_xml, boolean url_encode, String save_directory) throws Exception {
        if (identifier_keys == null) {
            throw new Exception("Valid identifier keys must be provided (it is null).");
        }
        if (data_to_save == null) {
            throw new Exception("Data to save must be provided (it is null).");
        }
        if (data_to_save.size() == 0) {
            throw new Exception("Data to save must be provided (it is of size 0).");
        }
        String identifier = null;
        for (int i = 0; i < identifier_keys.length; ++i) {
            identifier = MusicMetaData.findFirstValidValueForFieldID(identifier_keys[i], data_to_save);
            if (identifier == null) continue;
            i = identifier_keys.length;
        }
        if (identifier == null) {
            throw new Exception("No valid identifier could be found.");
        }
        File save_file = null;
        int suffix = 0;
        boolean found = false;
        while (!found) {
            String save_path;
            String file_suffix = "";
            if (suffix != 0) {
                file_suffix = "_" + new Integer(suffix).toString();
            }
            String file_name = identifier + file_suffix;
            file_name = is_xml ? file_name + ".xml" : file_name + ".txt";
            if (url_encode) {
                file_name = StringMethods.URLEncodeWithNulls((String)file_name);
            }
            if ((save_file = new File(save_path = save_directory + System.getProperty("file.separator") + file_name)).exists()) {
                ++suffix;
                continue;
            }
            found = true;
        }
        return save_file;
    }

    private static String generateSingleKey(MusicMetaData source_data) {
        String single_key;
        if (source_data.getSource() != null && source_data.getFieldIdentifier() != null) {
            single_key = !source_data.getSource().equals("") ? source_data.getSource() + ": " + source_data.getFieldIdentifier() : source_data.getFieldIdentifier();
        } else {
            if (source_data.getSource() == null && source_data.getFieldIdentifier() == null) {
                return null;
            }
            single_key = source_data.getFieldIdentifier() == null ? source_data.getSource() : source_data.getFieldIdentifier();
        }
        return single_key;
    }
}

