/*
 * Decompiled with CFR 0.152.
 */
package ace;

import ace.CrossValidator;
import ace.DimensionalityReducer;
import ace.Experimenter;
import ace.InstanceClassifier;
import ace.Trainer;
import ace.datatypes.CrossValidationResults;
import ace.datatypes.DataBoard;
import ace.datatypes.SegmentedClassification;
import ace.datatypes.TrainedModel;
import java.io.File;
import java.io.OutputStream;
import java.util.LinkedList;
import mckay.utilities.staticlibraries.MathAndStatsMethods;
import mckay.utilities.staticlibraries.StringMethods;
import weka.classifiers.Classifier;
import weka.classifiers.bayes.NaiveBayes;
import weka.classifiers.functions.MultilayerPerceptron;
import weka.classifiers.functions.SMO;
import weka.classifiers.lazy.IBk;
import weka.classifiers.meta.AdaBoostM1;
import weka.classifiers.meta.Bagging;
import weka.classifiers.trees.J48;
import weka.core.Instances;
import weka.core.SelectedTag;
import weka.core.converters.ArffLoader;
import weka.filters.Filter;
import weka.filters.supervised.instance.SpreadSubsample;
import weka.filters.unsupervised.instance.Randomize;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Coordinator {
    public DataBoard data_board;
    public String arff_path;
    public Instances instances;
    public boolean save_intermediate_arffs;

    public Coordinator(DataBoard data_board, String arff_path, boolean save_intermediate_arffs) {
        this.data_board = data_board;
        this.arff_path = arff_path;
        this.save_intermediate_arffs = save_intermediate_arffs;
    }

    public TrainedModel train(double max_class_membership_spread, double max_class_membership_count, boolean order_randomly, String feature_selector, String classifier_type, OutputStream out, int max_attribute, boolean verbose) throws Exception {
        this.loadInstances("Training");
        this.prepareTrainingInstances(max_class_membership_spread, max_class_membership_count, order_randomly);
        TrainedModel trained = new TrainedModel();
        String[] description = new String[1];
        trained.classifier = Coordinator.getOneUntrainedClassifier(classifier_type, description);
        if (feature_selector != null) {
            this.performDimensionalityReduction(trained, feature_selector, max_attribute, out, verbose);
        }
        try {
            Trainer.train(this.instances, trained);
        }
        catch (Exception e) {
            throw new Exception("ACE was unable to train the Classifier.\nERROR: " + e.getMessage());
        }
        return trained;
    }

    public SegmentedClassification[] classify(String results_file, TrainedModel trained) throws Exception {
        SegmentedClassification[] resulting_classifications;
        this.loadInstances("Testing");
        if (results_file != null) {
            String extension = StringMethods.getExtension((String)results_file);
            if (extension == null) {
                throw new Exception("Results file must have extension \".arff\" or \".xml\".");
            }
            if (this.arff_path != null) {
                if (!StringMethods.getExtension((String)results_file).equals(".arff")) {
                    throw new Exception("sres option must have .arff extention when using arff files.");
                }
            } else if (!StringMethods.getExtension((String)results_file).equals(".xml")) {
                throw new Exception("sres option must have .xml extention when using ACE XML files.");
            }
        }
        try {
            resulting_classifications = InstanceClassifier.classify(trained, this.data_board, this.instances, results_file, this.save_intermediate_arffs);
        }
        catch (Exception e) {
            if (this.arff_path != null) {
                throw new Exception("Could not classify " + this.arff_path + "\nERROR: " + e.getMessage());
            }
            throw new Exception("Could not classify " + this.data_board.feature_vectors[0].identifier + "\nERROR: " + e.getMessage());
        }
        return resulting_classifications;
    }

    public String crossValidate(double max_class_membership_spread, double max_class_membership_count, boolean order_randomly, String file_name, String classifier_type, String feature_selector, int folds, int max_attribute, OutputStream out, boolean verbose) throws Exception {
        this.loadInstances("Training");
        int num_overall = this.data_board.getNumOverall();
        int num_total = this.data_board.getNumTotal();
        String[] identifiers = new String[num_total];
        String[] hierarchy = new String[num_total];
        this.data_board.getInstanceIdentifiersAndHierarchy(num_overall, identifiers, hierarchy);
        boolean subsections = this.data_board.hasSections();
        if (max_class_membership_spread != 0.0 || max_class_membership_count != 0.0 || order_randomly || subsections) {
            if (verbose || subsections) {
                Instances reserve = new Instances(this.instances);
                this.prepareTrainingInstances(max_class_membership_spread, max_class_membership_count, order_randomly);
                identifiers = this.getIdentifiers(reserve, identifiers, hierarchy);
            } else {
                this.prepareTrainingInstances(max_class_membership_spread, max_class_membership_count, order_randomly);
            }
        }
        if (this.instances.numInstances() < folds) {
            throw new Exception(folds + " fold cross validation cannot be performed " + "on this data set because it contains only " + this.instances.numInstances() + " instances.");
        }
        TrainedModel trained = new TrainedModel();
        String[] description = new String[1];
        trained.classifier = Coordinator.getOneUntrainedClassifier(classifier_type, description);
        if (feature_selector != null) {
            feature_selector = this.performDimensionalityReduction(trained, feature_selector, max_attribute, out, verbose);
        }
        CrossValidator cver = new CrossValidator(this.instances, folds, identifiers, num_overall, hierarchy);
        String results = "";
        try {
            LinkedList<String> descriptions = new LinkedList<String>();
            descriptions.add(description[0]);
            CrossValidationResults[] cvres = CrossValidationResults.generateArray(descriptions);
            StringBuffer cv_results = new StringBuffer();
            results = cver.crossValidate(trained, cvres, this.instances, out, cv_results, file_name, feature_selector, this.save_intermediate_arffs, verbose, 0);
        }
        catch (Exception e) {
            if (this.arff_path != null) {
                throw new Exception("Could not cross validate " + this.arff_path + "\nERROR: " + e.getMessage());
            }
            throw new Exception("Could not cross validate " + this.data_board.feature_vectors[0].identifier + "\nERROR: " + e.getMessage());
        }
        return results;
    }

    public String experiment(double max_class_membership_spread, double max_class_membership_count, boolean order_randomly, String results_base_file_name, int folds, OutputStream out, boolean verbose, int max_attribute) throws Exception {
        this.loadInstances("Training");
        int num_overall = this.data_board.getNumOverall();
        int num_total = this.data_board.getNumTotal();
        String[] identifiers = new String[num_total];
        String[] hierarchy = new String[num_total];
        this.data_board.getInstanceIdentifiersAndHierarchy(num_overall, identifiers, hierarchy);
        boolean subsections = this.data_board.hasSections();
        if (max_class_membership_spread != 0.0 || max_class_membership_count != 0.0 || order_randomly) {
            if (verbose || subsections) {
                Instances reserve = new Instances(this.instances);
                this.prepareTrainingInstances(max_class_membership_spread, max_class_membership_count, order_randomly);
                identifiers = this.getIdentifiers(reserve, identifiers, hierarchy);
            } else {
                this.prepareTrainingInstances(max_class_membership_spread, max_class_membership_count, order_randomly);
            }
        }
        if (num_overall < folds) {
            throw new Exception(folds + " fold cross validation cannot be performed " + "on this data set because it contains only " + this.instances.numInstances() + " instances.");
        }
        String best = "";
        try {
            Experimenter exp = new Experimenter(out);
            best = exp.crossValidateMultiApproaches(folds, this.instances, results_base_file_name, this.save_intermediate_arffs, verbose, max_attribute, identifiers, num_overall, hierarchy);
        }
        catch (Exception e) {
            if (this.arff_path != null) {
                throw new Exception("Could not experiment on " + this.arff_path + "\nERROR: " + e.getMessage());
            }
            throw new Exception("Could not experiment on " + this.data_board.feature_vectors[0].identifier + "\nERROR: " + e.getMessage());
        }
        return best;
    }

    public void loadInstances(String relation) throws Exception {
        if (this.arff_path == null) {
            String relation_name = relation + "Relation";
            int initial_capacity = 100;
            this.instances = this.data_board.getInstanceAttributes(relation_name, initial_capacity);
            boolean use_top_level_features = true;
            boolean use_sub_section_features = true;
            this.data_board.storeInstances(this.instances, use_top_level_features, use_sub_section_features);
        } else {
            ArffLoader arffloader = new ArffLoader();
            arffloader.setFile(new File(this.arff_path));
            this.instances = arffloader.getDataSet();
            this.instances.setClassIndex(this.instances.numAttributes() - 1);
        }
    }

    public void prepareTrainingInstances(double max_class_membership_spread, double max_class_membership_count, boolean order_randomly) throws Exception {
        if (this.save_intermediate_arffs) {
            Trainer.saveInstancesAsARFF(this.instances, "training_data_after_parsing.arff");
        }
        int random_seed = MathAndStatsMethods.generateRandomNumber((int)Integer.MAX_VALUE);
        if (order_randomly) {
            Randomize order_randomizer = new Randomize();
            order_randomizer.setRandomSeed(random_seed);
            order_randomizer.setInputFormat(this.instances);
            this.instances = SpreadSubsample.useFilter((Instances)this.instances, (Filter)order_randomizer);
        }
        if (max_class_membership_spread != 0.0 || max_class_membership_count != 0.0) {
            SpreadSubsample class_balance_filter = new SpreadSubsample();
            class_balance_filter.setDistributionSpread(max_class_membership_spread);
            class_balance_filter.setMaxCount(max_class_membership_count);
            class_balance_filter.setRandomSeed(random_seed);
            class_balance_filter.setInputFormat(this.instances);
            this.instances = SpreadSubsample.useFilter((Instances)this.instances, (Filter)class_balance_filter);
            if (this.save_intermediate_arffs) {
                Trainer.saveInstancesAsARFF(this.instances, "training_data_after_thinning.arff");
            }
        }
    }

    public String performDimensionalityReduction(TrainedModel trained, String feature_selector, int max_attribute, OutputStream out, boolean verbose) throws Exception {
        out.write("\nPerforming dimensionality reduction...\n".getBytes());
        int original_number_features = this.instances.numAttributes() - 1;
        LinkedList<String> selectors = new LinkedList<String>();
        selectors.add(feature_selector);
        LinkedList<String> selector_descriptions = new LinkedList<String>();
        double[][] preparation_times = new double[1][];
        trained.attribute_selector = DimensionalityReducer.getFeatureSelectors(this.instances, selectors, selector_descriptions, preparation_times, max_attribute, out)[0];
        trained.attribute_selector.SelectAttributes(this.instances);
        this.instances = trained.attribute_selector.reduceDimensionality(this.instances);
        if (this.save_intermediate_arffs) {
            Trainer.saveInstancesAsARFF(this.instances, "training_data_after_dimensionality_reduction.arff");
        }
        out.write(("Dimensionality Reduction Performed: " + selector_descriptions.getFirst() + "\n").getBytes());
        String feature_selection_report = DimensionalityReducer.getSelectedFeatureNames(trained.attribute_selector, original_number_features, this.instances);
        if (verbose) {
            out.write(trained.attribute_selector.toResultsString().getBytes());
        } else {
            out.write(feature_selection_report.getBytes());
        }
        out.write("\n".getBytes());
        return selector_descriptions.getFirst();
    }

    public static Classifier[] getAllUntrainedClassifiers(LinkedList<String> classifier_descriptions) {
        LinkedList<IBk> classifier_list = new LinkedList<IBk>();
        IBk this_classifier = null;
        J48 component_classifier = null;
        classifier_descriptions.clear();
        int max_k = 10;
        for (int k = 1; k <= max_k; ++k) {
            this_classifier = new IBk();
            this_classifier.setKNN(k);
            classifier_list.add(this_classifier);
            classifier_descriptions.add("k-NN  (k = " + k + ", unweighted)");
            this_classifier = new IBk();
            this_classifier.setKNN(k);
            this_classifier.setDistanceWeighting(new SelectedTag(2, IBk.TAGS_WEIGHTING));
            classifier_list.add(this_classifier);
            classifier_descriptions.add("k-NN  (k = " + k + ", distance weighted)");
            this_classifier = new IBk();
            this_classifier.setKNN(k);
            this_classifier.setDistanceWeighting(new SelectedTag(4, IBk.TAGS_WEIGHTING));
            classifier_list.add(this_classifier);
            classifier_descriptions.add("k-NN  (k = " + k + ", similarity weighted)");
        }
        this_classifier = new NaiveBayes();
        classifier_list.add(this_classifier);
        classifier_descriptions.add("Naive Bayes  (Gaussian)");
        this_classifier = new NaiveBayes();
        ((NaiveBayes)this_classifier).setUseKernelEstimator(true);
        classifier_list.add(this_classifier);
        classifier_descriptions.add("Naive Bayes  (kernel estimation)");
        this_classifier = new SMO();
        classifier_list.add(this_classifier);
        classifier_descriptions.add("Support Vector Machine");
        this_classifier = new J48();
        classifier_list.add(this_classifier);
        classifier_descriptions.add("C4.5 Decision Tree");
        this_classifier = new MultilayerPerceptron();
        classifier_list.add(this_classifier);
        classifier_descriptions.add("Backprop Neural Network");
        this_classifier = new AdaBoostM1();
        component_classifier = new J48();
        ((AdaBoostM1)this_classifier).setClassifier((Classifier)component_classifier);
        classifier_list.add(this_classifier);
        classifier_descriptions.add("AdaBoost seeded with C4.5 Decision Trees");
        this_classifier = new Bagging();
        component_classifier = new J48();
        ((Bagging)this_classifier).setClassifier((Classifier)component_classifier);
        classifier_list.add(this_classifier);
        classifier_descriptions.add("Bagging seeded with C4.5 Decision Trees");
        return classifier_list.toArray(new Classifier[1]);
    }

    public static Classifier getOneUntrainedClassifier(String classifier_type, String[] description) throws Exception {
        IBk classifier;
        if (classifier_type.equalsIgnoreCase("IBk")) {
            classifier = new IBk();
            classifier.setKNN(1);
            description[0] = "k-NN  (k = 1, unweighted)";
        } else if (classifier_type.equalsIgnoreCase("NaiveBayes")) {
            classifier = new NaiveBayes();
            description[0] = "Naive Bayes  (Gaussian)";
        } else if (classifier_type.equalsIgnoreCase("SMO")) {
            classifier = new SMO();
            description[0] = "Support Vector Machine";
        } else if (classifier_type.equalsIgnoreCase("J48")) {
            classifier = new J48();
            description[0] = "C4.5 Decision Tree";
        } else if (classifier_type.equalsIgnoreCase("MultilayerPerceptron")) {
            classifier = new MultilayerPerceptron();
            description[0] = "Backprop Neural Network";
        } else if (classifier_type.equalsIgnoreCase("AdaBoostM1")) {
            classifier = new AdaBoostM1();
            ((AdaBoostM1)classifier).setClassifier((Classifier)new J48());
            description[0] = "AdaBoost seeded with C4.5 Decision Trees";
        } else if (classifier_type.equalsIgnoreCase("Bagging")) {
            classifier = new Bagging();
            ((Bagging)classifier).setClassifier((Classifier)new J48());
            description[0] = "Bagging seeded with C4.5 Decision Trees";
        } else {
            throw new Exception("ERROR: " + classifier_type + " is an invalid classifier type. See help message for codes.");
        }
        return classifier;
    }

    private String[] getIdentifiers(Instances reserve, String[] identifiers, String[] hierarchy) {
        String[] new_identifiers = new String[this.instances.numInstances()];
        String[] old_hierarchy = (String[])hierarchy.clone();
        for (int new_inst = 0; new_inst < this.instances.numInstances(); ++new_inst) {
            for (int res = 0; res < reserve.numInstances(); ++res) {
                String old_features;
                String new_features = this.instances.instance(new_inst).toString();
                if (!new_features.equals(old_features = reserve.instance(res).toString())) continue;
                if (new_identifiers[new_inst] != null) {
                    new_identifiers[new_inst].concat("/" + identifiers[res]);
                    continue;
                }
                new_identifiers[new_inst] = identifiers[res];
                hierarchy[new_inst] = old_hierarchy[res];
            }
        }
        return new_identifiers;
    }
}

