/*
 * Decompiled with CFR 0.152.
 */
package ace.datatypes;

import ace.datatypes.DataSet;
import ace.datatypes.FeatureDefinition;
import ace.datatypes.SegmentedClassification;
import ace.datatypes.Taxonomy;
import ace.datatypes.TrainedModel;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.LinkedList;
import mckay.utilities.staticlibraries.StringMethods;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.ArffLoader;

public class DataBoard
implements Serializable {
    public Taxonomy taxonomy;
    public FeatureDefinition[] feature_definitions;
    public DataSet[] feature_vectors;
    public SegmentedClassification[] model_classifications;
    private static final long serialVersionUID = 5L;

    public DataBoard() {
        this.taxonomy = null;
        this.feature_definitions = null;
        this.feature_vectors = null;
        this.model_classifications = null;
    }

    public DataBoard(Taxonomy taxonomy, FeatureDefinition[] feature_definitions, DataSet[] feature_vectors, SegmentedClassification[] model_classifications) throws Exception {
        this.taxonomy = taxonomy;
        this.feature_definitions = feature_definitions;
        this.feature_vectors = feature_vectors;
        this.model_classifications = model_classifications;
        this.validateFieldCompatibility();
    }

    public DataBoard(String taxonomy_file, String feature_key_file, String[] feature_vector_files, String classifications_file) throws Exception {
        this.taxonomy = null;
        if (taxonomy_file != null && !taxonomy_file.equals("")) {
            this.taxonomy = Taxonomy.parseTaxonomyFile(taxonomy_file);
        }
        this.feature_definitions = null;
        if (feature_key_file != null && !feature_key_file.equals("")) {
            this.feature_definitions = FeatureDefinition.parseFeatureDefinitionsFile(feature_key_file);
        }
        this.feature_vectors = null;
        if (feature_vector_files != null && !feature_vector_files[0].equals("")) {
            this.feature_vectors = DataSet.parseDataSetFiles(feature_vector_files, this.feature_definitions);
        }
        this.model_classifications = null;
        if (classifications_file != null && !classifications_file.equals("")) {
            this.model_classifications = SegmentedClassification.parseClassificationsFile(classifications_file);
        }
        this.validateFieldCompatibility();
    }

    public DataBoard(String arff_file) throws Exception {
        int i;
        ArffLoader reader = new ArffLoader();
        reader.setFile(new File(arff_file));
        Instances instances = reader.getDataSet();
        instances.setClassIndex(instances.numAttributes() - 1);
        this.taxonomy = new Taxonomy(instances);
        this.feature_definitions = new FeatureDefinition[instances.numAttributes() - 1];
        for (i = 0; i < instances.numAttributes() - 1; ++i) {
            this.feature_definitions[i] = new FeatureDefinition(instances, i);
        }
        this.feature_vectors = new DataSet[instances.numInstances()];
        this.model_classifications = new SegmentedClassification[instances.numInstances()];
        for (i = 0; i < instances.numInstances(); ++i) {
            this.model_classifications[i] = new SegmentedClassification(instances.instance(i), i);
            this.feature_vectors[i] = new DataSet(instances.instance(i), i);
        }
    }

    public Taxonomy getTaxonomy() {
        return this.taxonomy;
    }

    public FeatureDefinition[] getFeatureDefinitions() {
        return this.feature_definitions;
    }

    public DataSet[] getFeatureVectors() {
        return this.feature_vectors;
    }

    public SegmentedClassification[] getModelClassifications() {
        return this.model_classifications;
    }

    public String[] getFeatureNames() {
        if (this.feature_definitions == null) {
            return null;
        }
        String[] feature_names = new String[this.feature_definitions.length];
        for (int i = 0; i < feature_names.length; ++i) {
            feature_names[i] = this.feature_definitions[i].name;
        }
        return feature_names;
    }

    public int[] getFeatureDimensionalities() {
        if (this.feature_definitions == null) {
            return null;
        }
        int[] dimensionalities = new int[this.feature_definitions.length];
        for (int i = 0; i < dimensionalities.length; ++i) {
            dimensionalities[i] = this.feature_definitions[i].dimensions;
        }
        return dimensionalities;
    }

    public String[] getInstanceMetaDataFields() {
        if (this.model_classifications == null) {
            return null;
        }
        String[] unique_field_names = null;
        for (int i = 0; i < this.model_classifications.length; ++i) {
            if (this.model_classifications[i].misc_info_key == null) continue;
            String[] new_fields = this.model_classifications[i].misc_info_key;
            if (unique_field_names == null) {
                unique_field_names = new_fields;
                continue;
            }
            for (int j = 0; j < new_fields.length; ++j) {
                if (StringMethods.isStringInArray((String)new_fields[j], (String[])unique_field_names)) continue;
                String[] temp = new String[unique_field_names.length + 1];
                for (int k = 0; k < unique_field_names.length; ++k) {
                    temp[k] = unique_field_names[k];
                }
                temp[temp.length - 1] = new_fields[j];
                unique_field_names = temp;
            }
        }
        return unique_field_names;
    }

    public SegmentedClassification getMatchingModelClassification(DataSet data_set) {
        if (this.model_classifications == null) {
            return null;
        }
        for (int i = 0; i < this.model_classifications.length; ++i) {
            if (!this.model_classifications[i].identifier.equals(data_set.identifier)) continue;
            return this.model_classifications[i];
        }
        return null;
    }

    public Instances getInstanceAttributes(String data_set_name, int initial_capacity) throws Exception {
        if (this.feature_definitions == null) {
            throw new Exception("Cannot set up instances because no feature\ndefinitions are available.");
        }
        if (this.feature_vectors == null) {
            throw new Exception("Cannot set up instances because no feature\nvectors are available.");
        }
        String[] class_names = this.getClassNames();
        if (class_names == null) {
            throw new Exception("Cannot set up instances because no class\nnames available.");
        }
        LinkedList<String> feature_name_list = new LinkedList<String>();
        for (int i = 0; i < this.feature_definitions.length; ++i) {
            if (this.feature_definitions[i].dimensions == 1) {
                feature_name_list.add(this.feature_definitions[i].name);
                continue;
            }
            for (int j = 0; j < this.feature_definitions[i].dimensions; ++j) {
                feature_name_list.add(this.feature_definitions[i].name + " DIM " + j);
            }
        }
        String[] feature_names = feature_name_list.toArray(new String[1]);
        FastVector attributes_vector = new FastVector(feature_names.length + 1);
        for (int feat = 0; feat < feature_names.length; ++feat) {
            attributes_vector.addElement((Object)new Attribute(feature_names[feat]));
        }
        FastVector class_names_vector = new FastVector(class_names.length);
        for (int cat = 0; cat < class_names.length; ++cat) {
            class_names_vector.addElement((Object)class_names[cat]);
        }
        attributes_vector.addElement((Object)new Attribute("Class", class_names_vector));
        Instances instances = new Instances(data_set_name, attributes_vector, initial_capacity);
        instances.setClassIndex(instances.numAttributes() - 1);
        return instances;
    }

    public void storeInstances(Instances set_of_instances, boolean use_top_level_features, boolean use_sub_section_features) throws Exception {
        if (this.feature_definitions == null) {
            throw new Exception("Cannot set up instances because no feature\ndefinitions are available.");
        }
        if (this.feature_vectors == null) {
            throw new Exception("Cannot set up instances because no feature\nvectors are available.");
        }
        if (!use_top_level_features && !use_sub_section_features) {
            throw new Exception("Cannot set up instances because it has been\nspecified to store neither top-level nor\nsub-section features.");
        }
        String[][] model_classifications_overall = null;
        String[][][] model_classifications_sections = null;
        if (this.model_classifications != null) {
            if (use_top_level_features) {
                model_classifications_overall = SegmentedClassification.getOverallLabelsOfDataSets(this.feature_vectors, this.model_classifications);
            }
            if (use_sub_section_features) {
                model_classifications_sections = SegmentedClassification.getSubSectionLabelsOfDataSets(this.feature_vectors, this.model_classifications);
            }
        }
        for (int i = 0; i < this.feature_vectors.length; ++i) {
            String[][][] sec_feat_vals;
            String[][] top_feat_vals;
            if (use_top_level_features && (top_feat_vals = this.feature_vectors[i].getFeatureValuesOfTopLevel(this.feature_definitions)) != null) {
                int classes = 1;
                if (model_classifications_overall != null && model_classifications_overall[i] != null) {
                    classes = model_classifications_overall[i].length;
                }
                for (int cla = 0; cla < classes; ++cla) {
                    Instance this_instance = new Instance(set_of_instances.numAttributes());
                    this_instance.setDataset(set_of_instances);
                    int current_attribute = 0;
                    for (int j = 0; j < top_feat_vals.length; ++j) {
                        for (int k = 0; k < top_feat_vals[j].length; ++k) {
                            if (!top_feat_vals[j][k].equals("?")) {
                                this_instance.setValue(current_attribute, new Double(top_feat_vals[j][k]).doubleValue());
                            }
                            ++current_attribute;
                            if (j != top_feat_vals.length - 1 || k != top_feat_vals[j].length - 1 || model_classifications_overall == null || model_classifications_overall[i] == null) continue;
                            this_instance.setClassValue(model_classifications_overall[i][cla]);
                        }
                    }
                    set_of_instances.add(this_instance);
                }
            }
            if (!use_sub_section_features || (sec_feat_vals = this.feature_vectors[i].getFeatureValuesOfSubSections(this.feature_definitions)) == null) continue;
            for (int sec = 0; sec < sec_feat_vals.length; ++sec) {
                if (sec_feat_vals[sec] == null) continue;
                int classes = 1;
                if (model_classifications_sections != null && model_classifications_sections[i] != null && model_classifications_sections[i][sec] != null) {
                    classes = model_classifications_sections[i][sec].length;
                }
                for (int cla = 0; cla < classes; ++cla) {
                    Instance this_instance = new Instance(set_of_instances.numAttributes());
                    this_instance.setDataset(set_of_instances);
                    int current_attribute = 0;
                    for (int j = 0; j < sec_feat_vals[sec].length; ++j) {
                        for (int k = 0; k < sec_feat_vals[sec][j].length; ++k) {
                            if (!sec_feat_vals[sec][j][k].equals("?")) {
                                this_instance.setValue(current_attribute, new Double(sec_feat_vals[sec][j][k]).doubleValue());
                            }
                            ++current_attribute;
                            if (j != sec_feat_vals[sec].length - 1 || k != sec_feat_vals[sec][j].length - 1 || model_classifications_sections == null || model_classifications_sections[i] == null || model_classifications_sections[i][sec] == null) continue;
                            this_instance.setClassValue(model_classifications_sections[i][sec][cla]);
                        }
                    }
                    set_of_instances.add(this_instance);
                }
            }
        }
    }

    public SegmentedClassification[] getClassifiedResults(Instances instances, boolean save_intermediate_arffs, TrainedModel trained, boolean use_top_level_features, boolean use_sub_section_features) throws Exception {
        LinkedList<SegmentedClassification> overall_classifications = new LinkedList<SegmentedClassification>();
        if (trained.attribute_selector != null) {
            instances = trained.attribute_selector.reduceDimensionality(instances);
        }
        if (save_intermediate_arffs) {
            DataBoard.saveInstancesAsARFF(instances, "testing_data_after_dimensionality_reduction.arff");
        }
        int current_instance = 0;
        for (int set = 0; set < this.feature_vectors.length; ++set) {
            SegmentedClassification this_classification = new SegmentedClassification();
            this_classification.identifier = this.feature_vectors[set].identifier;
            if (use_top_level_features && this.feature_vectors[set].feature_values != null) {
                double predicted = trained.classifier.classifyInstance(instances.instance(current_instance));
                ++current_instance;
                String classification = trained.class_attribute.value((int)predicted);
                this_classification.classifications = new String[1];
                this_classification.classifications[0] = classification;
                if (!use_sub_section_features) {
                    overall_classifications.add(this_classification);
                } else if (this.feature_vectors[set].sub_sets == null) {
                    overall_classifications.add(this_classification);
                }
            }
            if (!use_sub_section_features || this.feature_vectors[set].sub_sets == null) continue;
            LinkedList<SegmentedClassification> sub_section_classifications = new LinkedList<SegmentedClassification>();
            for (int sec = 0; sec < this.feature_vectors[set].sub_sets.length; ++sec) {
                DataSet this_sub_section = this.feature_vectors[set].sub_sets[sec];
                if (this_sub_section.feature_values == null) continue;
                double predicted = trained.classifier.classifyInstance(instances.instance(current_instance));
                ++current_instance;
                String classification = trained.class_attribute.value((int)predicted);
                SegmentedClassification sub_section_result = new SegmentedClassification();
                sub_section_result.classifications = new String[1];
                sub_section_result.classifications[0] = classification;
                sub_section_result.start = this_sub_section.start;
                sub_section_result.stop = this_sub_section.stop;
                sub_section_classifications.add(sub_section_result);
            }
            this_classification.sub_classifications = sub_section_classifications.toArray(new SegmentedClassification[1]);
            overall_classifications.add(this_classification);
        }
        return overall_classifications.toArray(new SegmentedClassification[1]);
    }

    public String[] saveToARFF(String relation_name, File databoard_file, boolean use_top_level_features, boolean use_sub_section_features) throws Exception {
        if (this.feature_definitions == null) {
            throw new Exception("Cannot save ARFF file because no feature\ndefinitions are available.");
        }
        if (this.feature_vectors == null) {
            throw new Exception("Cannot save ARFF file because no feature\nvectors are available.");
        }
        if (!use_top_level_features && !use_sub_section_features) {
            throw new Exception("Cannot save ARFF file because it has been\nspecified to store neither top-level nor\nsub-section features.");
        }
        FileOutputStream to = new FileOutputStream(databoard_file);
        DataOutputStream writer = new DataOutputStream(to);
        writer.writeBytes("@relation " + relation_name + "\n\n");
        for (int i = 0; i < this.feature_definitions.length; ++i) {
            if (this.feature_definitions[i].dimensions == 1) {
                writer.writeBytes("@attribute " + this.feature_definitions[i].name.replace(' ', '_') + " numeric\n");
                continue;
            }
            for (int j = 0; j < this.feature_definitions[i].dimensions; ++j) {
                writer.writeBytes("@attribute " + this.feature_definitions[i].name.replace(' ', '_') + "_" + j + " numeric\n");
            }
        }
        String[] class_names = this.getClassNames();
        if (class_names != null) {
            writer.writeBytes("@attribute class? { ");
            for (int i = 0; i < class_names.length; ++i) {
                writer.writeBytes(class_names[i].replace(' ', '_'));
                if (i != class_names.length - 1) {
                    writer.writeBytes(", ");
                    continue;
                }
                writer.writeBytes(" }\n");
            }
        }
        String[][] model_classifications_overall = null;
        String[][][] model_classifications_sections = null;
        if (this.model_classifications != null) {
            if (use_top_level_features) {
                model_classifications_overall = SegmentedClassification.getOverallLabelsOfDataSets(this.feature_vectors, this.model_classifications);
            }
            if (use_sub_section_features) {
                model_classifications_sections = SegmentedClassification.getSubSectionLabelsOfDataSets(this.feature_vectors, this.model_classifications);
            }
        }
        writer.writeBytes("\n@data\n");
        LinkedList<String> identifiers = new LinkedList<String>();
        for (int i = 0; i < this.feature_vectors.length; ++i) {
            String[][][] sec_feat_vals;
            String[][] top_feat_vals;
            if (use_top_level_features && (top_feat_vals = this.feature_vectors[i].getFeatureValuesOfTopLevel(this.feature_definitions)) != null) {
                int classes = 1;
                if (model_classifications_overall != null && model_classifications_overall[i] != null) {
                    classes = model_classifications_overall[i].length;
                }
                for (int cla = 0; cla < classes; ++cla) {
                    for (int j = 0; j < top_feat_vals.length; ++j) {
                        for (int k = 0; k < top_feat_vals[j].length; ++k) {
                            writer.writeBytes(top_feat_vals[j][k]);
                            if (j == top_feat_vals.length - 1 && k == top_feat_vals[j].length - 1) {
                                if (model_classifications_overall != null) {
                                    if (model_classifications_overall[i] != null) {
                                        writer.writeBytes(", " + model_classifications_overall[i][cla].replace(' ', '_'));
                                    } else {
                                        writer.writeBytes(", ?");
                                    }
                                }
                                writer.writeBytes("\n");
                                identifiers.add(this.feature_vectors[i].identifier);
                                continue;
                            }
                            writer.writeBytes(", ");
                        }
                    }
                }
            }
            if (!use_sub_section_features || (sec_feat_vals = this.feature_vectors[i].getFeatureValuesOfSubSections(this.feature_definitions)) == null) continue;
            for (int sec = 0; sec < sec_feat_vals.length; ++sec) {
                if (sec_feat_vals[sec] == null) continue;
                int classes = 1;
                if (model_classifications_sections != null && model_classifications_sections[i] != null && model_classifications_sections[i][sec] != null) {
                    classes = model_classifications_sections[i][sec].length;
                }
                for (int cla = 0; cla < classes; ++cla) {
                    for (int j = 0; j < sec_feat_vals[sec].length; ++j) {
                        for (int k = 0; k < sec_feat_vals[sec][j].length; ++k) {
                            writer.writeBytes(sec_feat_vals[sec][j][k]);
                            if (j == sec_feat_vals[sec].length - 1 && k == sec_feat_vals[sec][j].length - 1) {
                                if (model_classifications_sections != null && model_classifications_sections[i] != null) {
                                    if (model_classifications_sections[i][sec] != null) {
                                        writer.writeBytes(", " + model_classifications_sections[i][sec][cla].replace(' ', '_'));
                                    } else {
                                        writer.writeBytes(", ?");
                                    }
                                }
                                writer.writeBytes("\n");
                                identifiers.add(this.feature_vectors[i].identifier + ":  Start=" + this.feature_vectors[i].sub_sets[sec].start + "Stop=" + this.feature_vectors[i].sub_sets[sec].stop);
                                continue;
                            }
                            writer.writeBytes(", ");
                        }
                    }
                }
            }
        }
        writer.close();
        to.close();
        return identifiers.toArray(new String[1]);
    }

    public void saveXMLFiles(File taxonomy_file, File feature_key_file, File feature_vector_file, File classifications_file) throws Exception {
        if (taxonomy_file != null && this.taxonomy == null) {
            throw new Exception("No taxonomy is stored to be saved.");
        }
        if (feature_key_file != null && this.feature_definitions == null) {
            throw new Exception("No feature definitinos are stored to be saved.");
        }
        if (feature_vector_file != null && this.feature_vectors == null) {
            throw new Exception("No feature vectors are stored to be saved.");
        }
        if (classifications_file != null && this.model_classifications == null) {
            throw new Exception("No model classifications are stored to be saved.");
        }
        if (taxonomy_file != null) {
            Taxonomy.saveTaxonomy(this.taxonomy, taxonomy_file, new String(""));
        }
        if (feature_key_file != null) {
            FeatureDefinition.saveFeatureDefinitions(this.feature_definitions, feature_key_file, new String(""));
        }
        if (feature_vector_file != null) {
            DataSet.saveDataSets(this.feature_vectors, this.feature_definitions, feature_vector_file, new String(""));
        }
        if (classifications_file != null) {
            SegmentedClassification.saveClassifications(this.model_classifications, classifications_file, new String(""));
        }
    }

    public static void saveDataBoard(DataBoard to_save, File databoard_file) throws Exception {
        FileOutputStream save_stream = new FileOutputStream(databoard_file);
        ObjectOutputStream object_stream = new ObjectOutputStream(save_stream);
        object_stream.writeObject(to_save);
        object_stream.flush();
        save_stream.close();
    }

    public static DataBoard loadDataBoard(File databoard_file) throws Exception {
        FileInputStream load_stream = new FileInputStream(databoard_file);
        ObjectInputStream object_stream = new ObjectInputStream(load_stream);
        DataBoard board = (DataBoard)object_stream.readObject();
        load_stream.close();
        return board;
    }

    public static void saveInstancesAsARFF(Instances instances, String file_path) throws Exception {
        String file_contents = instances.toString();
        try {
            File save_file = new File(file_path);
            FileOutputStream to = new FileOutputStream(save_file);
            DataOutputStream writer = new DataOutputStream(to);
            writer.writeBytes(file_contents);
        }
        catch (Exception e) {
            throw new Exception("Could not save to file " + file_path + ". " + e.getMessage());
        }
    }

    public void getInstanceIdentifiersAndHierarchy(int num_overall, String[] identifiers, String[] hierarchy) {
        int k = 0;
        for (int i = 0; i < num_overall; ++i) {
            identifiers[k] = this.feature_vectors[i].identifier;
            hierarchy[k] = String.valueOf(i);
            if (this.feature_vectors[i].sub_sets != null) {
                for (int j = 0; j < this.feature_vectors[i].sub_sets.length; ++j) {
                    identifiers[++k] = j + "_" + this.feature_vectors[i].identifier;
                    hierarchy[k] = String.valueOf(i) + "_" + String.valueOf(j);
                }
            }
            ++k;
        }
    }

    private void validateFieldCompatibility() throws Exception {
        String[] classes;
        if (this.model_classifications != null && !SegmentedClassification.verifyUniquenessOfIdentifiers(this.model_classifications)) {
            throw new Exception("The provided model classifications are invalid\nbecause two instances have the same identifier.");
        }
        if (this.model_classifications != null && this.taxonomy != null && (classes = this.taxonomy.getClassesInClassificationsButNotTaxonomy(this.model_classifications)) != null) {
            String formatted = "";
            for (int i = 0; i < classes.length; ++i) {
                formatted = formatted + (i + 1) + ": " + classes[i] + "\n";
            }
            throw new Exception("The provided model classifications contain classes\nthat are not in the taxonomy. The following classes were not found in the taxonomy file:\n" + formatted);
        }
    }

    private String[] getClassNames() {
        if (this.taxonomy != null) {
            return this.taxonomy.getLeafLabels();
        }
        if (this.model_classifications != null) {
            return SegmentedClassification.getLeafClasses(this.model_classifications);
        }
        return null;
    }

    public boolean hasSections() {
        int i;
        if (this.feature_vectors != null) {
            for (i = 0; i < this.feature_vectors.length; ++i) {
                if (this.feature_vectors[i].sub_sets == null) continue;
                return true;
            }
        }
        if (this.model_classifications != null) {
            for (i = 0; i < this.model_classifications.length; ++i) {
                if (this.model_classifications[i].sub_classifications == null) continue;
                return true;
            }
        }
        return false;
    }

    public int getNumOverall() {
        int num_overall = this.feature_vectors.length;
        return num_overall;
    }

    public int getNumTotal() {
        int num_overall;
        int num_total = num_overall = this.getNumOverall();
        for (int i = 0; i < num_overall; ++i) {
            if (this.feature_vectors[i].sub_sets == null) continue;
            num_total += this.feature_vectors[i].sub_sets.length;
        }
        return num_total;
    }
}

