/*
 * Decompiled with CFR 0.152.
 */
package ace.datatypes;

import ace.datatypes.FeatureDefinition;
import ace.xmlparsers.XMLDocumentParser;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.LinkedList;
import weka.core.Instance;

public class DataSet
implements Serializable {
    public String identifier;
    public DataSet[] sub_sets;
    public double start;
    public double stop;
    public double[][] feature_values;
    public String[] feature_names;
    public DataSet parent;
    private static final long serialVersionUID = 3L;

    public DataSet() {
        this.identifier = null;
        this.sub_sets = null;
        this.start = Double.NaN;
        this.stop = Double.NaN;
        this.feature_values = null;
        this.feature_names = null;
        this.parent = null;
    }

    public DataSet(String identifier, DataSet[] sub_sets, Double start, Double stop, double[][] feature_values, String[] feature_names, DataSet parent) {
        this.identifier = identifier;
        this.sub_sets = null;
        this.start = start;
        this.stop = stop;
        this.feature_values = feature_values;
        this.feature_names = feature_names;
        this.parent = parent;
    }

    public DataSet(Instance instance, int inst) {
        String fvals = instance.toString();
        if (!instance.classIsMissing()) {
            fvals = fvals.substring(0, instance.toString().lastIndexOf(","));
        }
        this.identifier = inst + "_" + fvals;
        this.sub_sets = null;
        this.start = Double.NaN;
        this.stop = Double.NaN;
        this.feature_values = new double[instance.numAttributes() - 1][1];
        this.feature_names = new String[instance.numAttributes()];
        for (int i = 0; i < instance.numAttributes() - 1; ++i) {
            this.feature_values[i][0] = instance.value(i);
            this.feature_names[i] = instance.attribute(i).name();
        }
        this.parent = null;
    }

    public void orderAndCompactFeatures(FeatureDefinition[] definitions, boolean is_top_level) throws Exception {
        double[][] new_feature_values = new double[definitions.length][];
        if (this.feature_names == null || this.feature_values == null) {
            for (int feat = 0; feat < new_feature_values.length; ++feat) {
                new_feature_values[feat] = null;
            }
        } else {
            for (int def = 0; def < new_feature_values.length; ++def) {
                new_feature_values[def] = null;
                for (int feat = 0; feat < this.feature_names.length; ++feat) {
                    if (!definitions[def].name.equals(this.feature_names[feat])) continue;
                    if (!is_top_level && !definitions[def].is_sequential) {
                        throw new Exception("Feature " + this.feature_names[feat] + " is present in a sub-set of\n" + "a DataSet, but is marked as non-sequential in its definition.");
                    }
                    if (this.feature_values[feat].length != definitions[def].dimensions) {
                        throw new Exception("Feature " + this.feature_names[feat] + " has " + this.feature_values[feat].length + " values, but should have " + definitions[def].dimensions + "\n" + "according to its definition.");
                    }
                    new_feature_values[def] = this.feature_values[feat];
                    feat = this.feature_values.length;
                }
            }
        }
        this.feature_names = null;
        this.feature_values = new_feature_values;
    }

    public String[][] getFeatureValuesOfTopLevel(FeatureDefinition[] definitions) {
        if (this.feature_values == null) {
            return null;
        }
        String[][] feature_values_str = new String[this.feature_values.length][];
        for (int i = 0; i < this.feature_values.length; ++i) {
            int j;
            if (this.feature_values[i] == null) {
                feature_values_str[i] = new String[definitions[i].dimensions];
                for (j = 0; j < feature_values_str[i].length; ++j) {
                    feature_values_str[i][j] = "?";
                }
                continue;
            }
            feature_values_str[i] = new String[this.feature_values[i].length];
            for (j = 0; j < this.feature_values[i].length; ++j) {
                feature_values_str[i][j] = String.valueOf(this.feature_values[i][j]);
            }
        }
        return feature_values_str;
    }

    public String[][][] getFeatureValuesOfSubSections(FeatureDefinition[] definitions) {
        if (this.sub_sets == null) {
            return null;
        }
        String[][][] feature_values_str = new String[this.sub_sets.length][][];
        for (int i = 0; i < this.sub_sets.length; ++i) {
            feature_values_str[i] = this.sub_sets[i].getFeatureValuesOfTopLevel(definitions);
        }
        return feature_values_str;
    }

    public String getDataSetDescription(int depth) {
        String indent = new String("");
        for (int i = 0; i < depth; ++i) {
            indent = indent + "   ";
        }
        String id_string = new String("");
        if (this.identifier != null) {
            id_string = indent + "DATASET " + this.identifier + ": ";
            id_string = this.sub_sets != null ? id_string + this.sub_sets.length + " sub-sets " : id_string + "0 sub-sets ";
            id_string = this.feature_values != null ? id_string + this.feature_values.length + " features\n\n" : id_string + "0 features\n\n";
        } else {
            id_string = indent + "SUB-SET -> Start: " + this.start + "   Stop: " + this.stop + "\n";
        }
        String feature_string = new String("");
        if (this.feature_values != null) {
            for (int feat = 0; feat < this.feature_values.length; ++feat) {
                String this_feature = indent + indent;
                if (this.feature_names != null) {
                    this_feature = this_feature + this.feature_names[feat] + ": ";
                }
                if (this.feature_values[feat] == null) {
                    this_feature = this_feature + "?";
                } else {
                    for (int val = 0; val < this.feature_values[feat].length; ++val) {
                        this_feature = this_feature + this.feature_values[feat][val] + " ";
                    }
                }
                this_feature = this_feature + "\n";
                feature_string = feature_string + this_feature;
            }
            feature_string = feature_string + "\n";
        }
        String sub_set_string = new String("");
        if (this.sub_sets != null) {
            for (int set = 0; set < this.sub_sets.length; ++set) {
                sub_set_string = sub_set_string + this.sub_sets[set].getDataSetDescription(depth + 1);
            }
        }
        return id_string + feature_string + sub_set_string;
    }

    public static String getDataSetDescriptions(DataSet[] dataset) {
        String combined_descriptions = new String();
        for (int i = 0; i < dataset.length; ++i) {
            combined_descriptions = combined_descriptions + dataset[i].getDataSetDescription(0);
        }
        return combined_descriptions;
    }

    public static String[] getFeatureNames(DataSet[] feature_vectors) throws Exception {
        LinkedList<String> names = new LinkedList<String>();
        for (int i = 0; i < feature_vectors.length; ++i) {
            if (feature_vectors[i].feature_names != null) {
                for (int j = 0; j < feature_vectors[i].feature_names.length; ++j) {
                    names.add(feature_vectors[i].feature_names[j]);
                }
                if (feature_vectors[i].sub_sets == null) continue;
                for (int k = 0; k < feature_vectors[i].sub_sets.length; ++k) {
                    for (int l = 0; l < feature_vectors[i].sub_sets[k].feature_names.length; ++l) {
                        names.add(feature_vectors[i].sub_sets[k].feature_names[l]);
                    }
                }
                continue;
            }
            throw new Exception(" Unable to access feature_names field of DataSet object. ");
        }
        return names.toArray(new String[1]);
    }

    public static DataSet[] parseDataSetFile(String data_set_file_path) throws Exception {
        Object[] results = (Object[])XMLDocumentParser.parseXMLDocument(data_set_file_path, "feature_vector_file");
        DataSet[] parse_results = new DataSet[results.length];
        for (int i = 0; i < parse_results.length; ++i) {
            parse_results[i] = (DataSet)results[i];
        }
        return parse_results;
    }

    public static DataSet[] parseDataSetFile(String data_set_file_path, FeatureDefinition[] definitions) throws Exception {
        Object[] results = (Object[])XMLDocumentParser.parseXMLDocument(data_set_file_path, "feature_vector_file");
        DataSet[] parse_results = new DataSet[results.length];
        for (int i = 0; i < parse_results.length; ++i) {
            parse_results[i] = (DataSet)results[i];
        }
        return parse_results;
    }

    public static DataSet[] parseDataSetFiles(String[] data_set_file_paths, FeatureDefinition[] definitions) throws Exception {
        DataSet[][] segmented_data_sets = new DataSet[data_set_file_paths.length][];
        int number_data_sets = 0;
        for (int file = 0; file < segmented_data_sets.length; ++file) {
            Object[] results = (Object[])XMLDocumentParser.parseXMLDocument(data_set_file_paths[file], "feature_vector_file");
            DataSet[] parse_results = new DataSet[results.length];
            for (int i = 0; i < parse_results.length; ++i) {
                parse_results[i] = (DataSet)results[i];
            }
            segmented_data_sets[file] = parse_results;
            number_data_sets += parse_results.length;
        }
        DataSet[] combined_data_sets = new DataSet[number_data_sets];
        int current_set = 0;
        for (int file = 0; file < segmented_data_sets.length; ++file) {
            for (int set = 0; set < segmented_data_sets[file].length; ++set) {
                combined_data_sets[current_set] = segmented_data_sets[file][set];
                ++current_set;
            }
        }
        return combined_data_sets;
    }

    public static DataSet[] getMergedFeatureTypes(DataSet[][] datasets_to_combine, FeatureDefinition[] combined_feature_definitions, String[][] matching_identifier_keys) throws Exception {
        int set;
        int key_inst;
        int i;
        if (datasets_to_combine == null) {
            throw new Exception("No feature vectors provided.");
        }
        if (combined_feature_definitions == null) {
            throw new Exception("No feature definitions provided.");
        }
        if (matching_identifier_keys == null) {
            throw new Exception("No matching keys provided.");
        }
        if (datasets_to_combine.length == 1) {
            throw new Exception("More than one set of feature vectors must be provided.");
        }
        for (i = 1; i < datasets_to_combine.length; ++i) {
            if (datasets_to_combine[i].length == datasets_to_combine[0].length) continue;
            throw new Exception("All sets of feature vectors must have the same number of instances.");
        }
        if (matching_identifier_keys[0].length != datasets_to_combine.length + 1) {
            throw new Exception("There must be exactly one more key provided than the number of sets of feature vectors.\nA total of " + matching_identifier_keys[0].length + " keys were provided" + " for " + datasets_to_combine.length + " sets of feature" + "vectors.");
        }
        for (i = 1; i < matching_identifier_keys.length; ++i) {
            if (matching_identifier_keys[i].length == matching_identifier_keys[0].length) continue;
            throw new Exception("There must be an equal number of keys  for all instances.");
        }
        if (matching_identifier_keys.length != datasets_to_combine[0].length) {
            throw new Exception("There must be an equal number of instances and of matching identifier keys.\n" + datasets_to_combine[0].length + " instances were provided" + " and " + matching_identifier_keys.length + " of identifier" + " keys.");
        }
        int number_sets = datasets_to_combine.length;
        int number_instances = matching_identifier_keys.length;
        DataSet[] output = new DataSet[number_instances];
        boolean[][] used = new boolean[number_sets][number_instances];
        for (int i2 = 0; i2 < used.length; ++i2) {
            for (int j = 0; j < used[i2].length; ++j) {
                used[i2][j] = false;
            }
        }
        int[][] mapping = new int[number_instances][number_sets];
        for (key_inst = 0; key_inst < number_instances; ++key_inst) {
            for (set = 0; set < number_sets; ++set) {
                boolean found_one = false;
                for (int vect_inst = 0; vect_inst < datasets_to_combine[set].length; ++vect_inst) {
                    if (!datasets_to_combine[set][vect_inst].identifier.equals(matching_identifier_keys[key_inst][set])) continue;
                    if (used[set][vect_inst]) {
                        throw new Exception("More than one occurence of the key " + datasets_to_combine[set][vect_inst].identifier + " in the same set of instances.");
                    }
                    mapping[key_inst][set] = vect_inst;
                    used[set][vect_inst] = true;
                    found_one = true;
                    vect_inst = datasets_to_combine[set].length;
                }
                if (found_one) continue;
                throw new Exception("No instance with the identifiers " + matching_identifier_keys[key_inst][set] + " was found in set " + (set + 1) + ".");
            }
        }
        for (key_inst = 0; key_inst < matching_identifier_keys.length; ++key_inst) {
            output[key_inst] = datasets_to_combine[0][mapping[key_inst][0]];
            output[key_inst].identifier = matching_identifier_keys[key_inst][matching_identifier_keys[0].length - 1];
            for (set = 1; set < datasets_to_combine.length; ++set) {
                int feat;
                DataSet to_merge_into = output[key_inst];
                DataSet to_merge_in = datasets_to_combine[set][mapping[key_inst][set]];
                double[][] new_feature_values = new double[to_merge_into.feature_values.length + to_merge_in.feature_values.length][];
                String[] new_feature_names = null;
                if (to_merge_into.feature_names != null && to_merge_in.feature_names != null) {
                    new_feature_names = new String[to_merge_into.feature_names.length + to_merge_in.feature_names.length];
                }
                for (feat = 0; feat < to_merge_into.feature_values.length; ++feat) {
                    new_feature_values[feat] = to_merge_into.feature_values[feat];
                    if (new_feature_names == null) continue;
                    new_feature_names[feat] = to_merge_into.feature_names[feat];
                }
                for (feat = 0; feat < to_merge_in.feature_values.length; ++feat) {
                    new_feature_values[feat + to_merge_into.feature_values.length] = to_merge_in.feature_values[feat];
                    if (new_feature_names == null) continue;
                    new_feature_names[feat + to_merge_into.feature_names.length] = to_merge_in.feature_names[feat];
                }
                output[key_inst].feature_values = new_feature_values;
                output[key_inst].feature_names = new_feature_names;
            }
        }
        return output;
    }

    public static void saveDataSets(DataSet[] data_sets, FeatureDefinition[] definitions, File to_save_to, String comments) throws Exception {
        if (definitions == null) {
            for (int set = 0; set < data_sets.length; ++set) {
                if (data_sets[set].feature_names != null) continue;
                throw new Exception("Could not save because no feature definitions\nwere provided and DataSet " + data_sets[set].identifier + "\n" + "does not hold the names of its features.");
            }
        }
        try {
            FileOutputStream to = new FileOutputStream(to_save_to);
            DataOutputStream writer = new DataOutputStream(to);
            String pre_tree_part = new String("<?xml version=\"1.0\"?>\n<!DOCTYPE feature_vector_file [\n   <!ELEMENT feature_vector_file (comments, data_set+)>\n   <!ELEMENT comments (#PCDATA)>\n   <!ELEMENT data_set (data_set_id, section*, feature*)>\n   <!ELEMENT data_set_id (#PCDATA)>\n   <!ELEMENT section (feature+)>\n   <!ATTLIST section start CDATA \"\"\n                     stop CDATA \"\">\n   <!ELEMENT feature (name, v+)>\n   <!ELEMENT name (#PCDATA)>\n   <!ELEMENT v (#PCDATA)>\n]>\n\n<feature_vector_file>\n\n   <comments>" + comments + "</comments>\n\n");
            writer.writeBytes(pre_tree_part);
            for (int set = 0; set < data_sets.length; ++set) {
                writer.writeBytes("   <data_set>\n");
                writer.writeBytes("      <data_set_id>" + data_sets[set].identifier + "</data_set_id>\n");
                if (data_sets[set].sub_sets != null) {
                    for (int sec = 0; sec < data_sets[set].sub_sets.length; ++sec) {
                        DataSet section_set = data_sets[set].sub_sets[sec];
                        writer.writeBytes("      <section start=\"" + section_set.start + "\" stop=\"" + section_set.stop + "\">\n");
                        for (int feat = 0; feat < section_set.feature_values.length; ++feat) {
                            double[] values = section_set.feature_values[feat];
                            if (values == null) continue;
                            writer.writeBytes("         <feature>\n");
                            if (section_set.feature_names != null) {
                                writer.writeBytes("            <name>" + section_set.feature_names[feat] + "</name>\n");
                            } else {
                                writer.writeBytes("            <name>" + definitions[feat].name + "</name>\n");
                            }
                            for (int val = 0; val < values.length; ++val) {
                                writer.writeBytes("            <v>" + values[val] + "</v>\n");
                            }
                            writer.writeBytes("         </feature>\n");
                        }
                        writer.writeBytes("      </section>\n");
                    }
                }
                if (data_sets[set].feature_values != null) {
                    for (int feat = 0; feat < data_sets[set].feature_values.length; ++feat) {
                        double[] values = data_sets[set].feature_values[feat];
                        if (values == null) continue;
                        writer.writeBytes("      <feature>\n");
                        if (data_sets[set].feature_names != null) {
                            writer.writeBytes("         <name>" + data_sets[set].feature_names[feat] + "</name>\n");
                        } else {
                            writer.writeBytes("         <name>" + definitions[feat].name + "</name>\n");
                        }
                        for (int val = 0; val < values.length; ++val) {
                            writer.writeBytes("         <v>" + values[val] + "</v>\n");
                        }
                        writer.writeBytes("      </feature>\n");
                    }
                }
                writer.writeBytes("   </data_set>\n\n");
            }
            writer.writeBytes("</feature_vector_file>");
            writer.close();
        }
        catch (Exception e) {
            throw new Exception("Unable to write file " + to_save_to.getName() + ".");
        }
    }
}

