/*
 * Decompiled with CFR 0.152.
 */
package ace.datatypes;

import ace.xmlparsers.XMLDocumentParser;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import mckay.utilities.staticlibraries.FileMethods;

public class Project {
    public String filename;
    public String comments;
    public String taxonomy_path;
    public String[] feature_settings_paths;
    public String[] feature_vectors_paths;
    public String[] classification_paths;
    public String gui_preferences_path;
    public String classifier_settings_path;
    public String trained_classifiers_path;
    public String weka_arff_path;

    public Project(String filename, String comments, String taxonomy_path, String[] feature_settings_paths, String[] feature_vectors_paths, String[] classification_paths, String gui_preferences_path, String classifier_settings_path, String trained_classifiers_path, String weka_arff_path) {
        this.filename = filename;
        this.comments = comments;
        this.taxonomy_path = taxonomy_path;
        this.feature_settings_paths = feature_settings_paths;
        this.feature_vectors_paths = feature_vectors_paths;
        this.classification_paths = classification_paths;
        this.gui_preferences_path = gui_preferences_path;
        this.classification_paths = classification_paths;
        this.gui_preferences_path = gui_preferences_path;
        this.classifier_settings_path = classifier_settings_path;
        this.trained_classifiers_path = trained_classifiers_path;
        this.weka_arff_path = weka_arff_path;
    }

    public Project() {
        this.comments = null;
        this.taxonomy_path = null;
        this.feature_settings_paths = null;
        this.feature_vectors_paths = null;
        this.classification_paths = null;
        this.gui_preferences_path = null;
        this.classification_paths = null;
        this.gui_preferences_path = null;
        this.classifier_settings_path = null;
        this.trained_classifiers_path = null;
        this.weka_arff_path = null;
    }

    public void parseProjectFile(String selected_project_file) throws Exception {
        LinkedList[] parsed_file = (LinkedList[])XMLDocumentParser.parseXMLDocument(selected_project_file, "ace_project_file");
        if (parsed_file[0].size() != 0) {
            this.comments = (String)parsed_file[0].getFirst();
        }
        if (parsed_file[1].size() != 0) {
            this.taxonomy_path = (String)parsed_file[1].getFirst();
        }
        if (parsed_file[2].size() != 0) {
            this.feature_settings_paths = parsed_file[2].toArray(new String[0]);
        }
        if (parsed_file[3].size() != 0) {
            this.feature_vectors_paths = parsed_file[3].toArray(new String[0]);
        }
        if (parsed_file[4].size() != 0) {
            this.classification_paths = parsed_file[4].toArray(new String[0]);
        }
        if (parsed_file[5].size() != 0) {
            this.gui_preferences_path = (String)parsed_file[5].getFirst();
        }
        if (parsed_file[6].size() != 0) {
            this.classifier_settings_path = (String)parsed_file[6].getFirst();
        }
        if (parsed_file[7].size() != 0) {
            this.trained_classifiers_path = (String)parsed_file[7].getFirst();
        }
        if (parsed_file[8].size() != 0) {
            this.weka_arff_path = (String)parsed_file[8].getFirst();
        }
    }

    public static String saveProjectFile(String path, boolean can_erase, String comments, String taxonomy_path, String[] feature_settings_paths, String[] feature_vectors_paths, String[] classification_paths, String gui_preferences_path, String classifier_settings_path, String trained_classifiers_path, String weka_arff_path) throws Exception {
        int i;
        File to_file = new File(path);
        FileMethods.getNewFileForWriting((String)path, (boolean)can_erase);
        to_file.delete();
        to_file.createNewFile();
        String contents = new String("<?xml version=\"1.0\"?>\n<!DOCTYPE ace_project_file [\n   <!ELEMENT ace_project_file (comments, taxonomy_path, feature_definitions_path, feature_vectors_path, model_classifications_path, gui_preferences_path, classifier_settings_path, trained_classifiers_path, weka_arff_path)>\n   <!ELEMENT comments (#PCDATA)>\n   <!ELEMENT taxonomy_path (#PCDATA)>\n   <!ELEMENT feature_definitions_path (path*)>\n   <!ELEMENT feature_vectors_path (path*)>\n   <!ELEMENT model_classifications_path (path*)>\n   <!ELEMENT gui_preferences_path (#PCDATA)>\n   <!ELEMENT classifier_settings_path (#PCDATA)>\n   <!ELEMENT trained_classifiers_path (#PCDATA)>\n   <!ELEMENT weka_arff_path (#PCDATA)>\n   <!ELEMENT path (#PCDATA)>\n]>\n\n<ace_project_file>\n   <comments>");
        if (comments != null) {
            contents = contents + comments;
        }
        contents = contents + "</comments>\n   <taxonomy_path>";
        if (taxonomy_path != null) {
            contents = contents + taxonomy_path;
        }
        contents = contents + "</taxonomy_path>\n   <feature_definitions_path>\n";
        if (feature_settings_paths != null) {
            for (i = 0; i <= feature_settings_paths.length - 1 && feature_settings_paths[i] != null; ++i) {
                contents = contents + "      <path>" + feature_settings_paths[i] + "</path>\n";
            }
        }
        contents = contents + "   </feature_definitions_path>\n   <feature_vectors_path>\n";
        if (feature_vectors_paths != null) {
            for (i = 0; i <= feature_vectors_paths.length - 1 && feature_vectors_paths[i] != null; ++i) {
                contents = contents + "      <path>" + feature_vectors_paths[i] + "</path>\n";
            }
        }
        contents = contents + "   </feature_vectors_path>\n   <model_classifications_path>\n";
        if (classification_paths != null) {
            for (i = 0; i <= classification_paths.length - 1 && classification_paths[i] != null; ++i) {
                contents = contents + "      <path>" + classification_paths[i] + "</path>\n";
            }
        }
        contents = contents + "   </model_classifications_path>\n   <gui_preferences_path>";
        if (gui_preferences_path != null) {
            contents = contents + gui_preferences_path;
        }
        contents = contents + "</gui_preferences_path>\n   <classifier_settings_path>";
        if (classifier_settings_path != null) {
            contents = contents + classifier_settings_path;
        }
        contents = contents + "</classifier_settings_path>\n   <trained_classifiers_path>";
        if (trained_classifiers_path != null) {
            contents = contents + trained_classifiers_path;
        }
        contents = contents + "</trained_classifiers_path>\n   <weka_arff_path>";
        if (weka_arff_path != null) {
            contents = contents + weka_arff_path;
        }
        contents = contents + "</weka_arff_path>\n</ace_project_file>";
        try {
            FileOutputStream to = new FileOutputStream(to_file);
            DataOutputStream writer = new DataOutputStream(to);
            writer.writeBytes(contents);
            writer.close();
        }
        catch (IOException ioe) {
            throw new Exception("Problem saving file " + path + ".\nERROR: " + ioe.getMessage());
        }
        return to_file.getAbsolutePath();
    }

    public String saveProjectFile(String project_name, boolean can_erase) throws Exception {
        String proj = Project.saveProjectFile(project_name, can_erase, this.comments, this.taxonomy_path, this.feature_settings_paths, this.feature_vectors_paths, this.classification_paths, this.gui_preferences_path, this.classifier_settings_path, this.trained_classifiers_path, this.weka_arff_path);
        return proj;
    }

    public void saveUnzippedProjectFile(String directory_path, String project_name) throws Exception {
        int i;
        String sep = File.separator;
        if (project_name != null) {
            if (project_name.contains(sep)) {
                project_name = project_name.substring(project_name.lastIndexOf(sep));
            }
            this.filename = directory_path + sep + project_name;
        }
        if (this.taxonomy_path != null) {
            if (this.taxonomy_path.contains(sep)) {
                this.taxonomy_path = this.taxonomy_path.substring(this.taxonomy_path.lastIndexOf(sep));
            }
            this.taxonomy_path = directory_path + sep + this.taxonomy_path;
        }
        if (this.feature_settings_paths != null) {
            for (i = 0; i < this.feature_settings_paths.length && this.feature_settings_paths[i] != null; ++i) {
                if (this.feature_settings_paths[i].contains(sep)) {
                    this.feature_settings_paths[i] = this.feature_settings_paths[i].substring(this.feature_settings_paths[i].lastIndexOf(sep));
                }
                this.feature_settings_paths[i] = directory_path + sep + this.feature_settings_paths[i];
            }
        }
        if (this.feature_vectors_paths != null) {
            for (i = 0; i < this.feature_vectors_paths.length && this.feature_vectors_paths[i] != null; ++i) {
                if (this.feature_vectors_paths[i].contains(sep)) {
                    this.feature_vectors_paths[i] = this.feature_vectors_paths[i].substring(this.feature_vectors_paths[i].lastIndexOf(sep));
                }
                this.feature_vectors_paths[i] = directory_path + sep + this.feature_vectors_paths[i];
            }
        }
        if (this.classification_paths != null) {
            for (i = 0; i < this.classification_paths.length && this.classification_paths[i] != null; ++i) {
                if (this.classification_paths[i].contains(sep)) {
                    this.classification_paths[i] = this.classification_paths[i].substring(this.classification_paths[i].lastIndexOf(sep));
                }
                this.classification_paths[i] = directory_path + sep + this.classification_paths[i];
            }
        }
        if (this.gui_preferences_path != null) {
            if (this.gui_preferences_path.contains(sep)) {
                this.gui_preferences_path = this.gui_preferences_path.substring(this.gui_preferences_path.lastIndexOf(sep));
            }
            this.gui_preferences_path = directory_path + sep + this.gui_preferences_path;
        }
        if (this.classifier_settings_path != null) {
            if (this.classifier_settings_path.contains(sep)) {
                this.classifier_settings_path = this.classifier_settings_path.substring(this.classifier_settings_path.lastIndexOf(sep));
            }
            this.classifier_settings_path = directory_path + sep + this.classifier_settings_path;
        }
        if (this.trained_classifiers_path != null) {
            if (this.trained_classifiers_path.contains(sep)) {
                this.trained_classifiers_path = this.trained_classifiers_path.substring(this.trained_classifiers_path.lastIndexOf(sep));
            }
            this.trained_classifiers_path = directory_path + sep + this.trained_classifiers_path;
        }
        if (this.weka_arff_path != null) {
            if (this.weka_arff_path.contains(sep)) {
                this.weka_arff_path = this.weka_arff_path.substring(this.weka_arff_path.lastIndexOf(sep));
            }
            this.weka_arff_path = directory_path + sep + this.weka_arff_path;
        }
        this.saveProjectFile(this.filename, true);
    }

    public void addTaxonomy(String new_taxonomy) {
        this.taxonomy_path = new_taxonomy;
    }

    public void addDataSet(String new_dataset) {
        if (this.feature_vectors_paths == null) {
            this.feature_vectors_paths = new String[1];
            this.feature_vectors_paths[0] = new_dataset;
        } else {
            String[] temp = new String[this.feature_vectors_paths.length + 1];
            System.arraycopy(this.feature_vectors_paths, 0, temp, 0, this.feature_vectors_paths.length);
            temp[temp.length - 1] = new_dataset;
            this.feature_vectors_paths = temp;
        }
    }

    public void addFeatureDefinition(String new_feature_definition) {
        if (this.feature_settings_paths == null) {
            this.feature_settings_paths = new String[1];
            this.feature_settings_paths[0] = new_feature_definition;
        } else {
            String[] temp = new String[this.feature_settings_paths.length + 1];
            System.arraycopy(this.feature_settings_paths, 0, temp, 0, this.feature_settings_paths.length);
            temp[temp.length - 1] = new_feature_definition;
            this.feature_settings_paths = temp;
        }
    }

    public void addClassification(String new_classification) {
        if (this.classification_paths == null) {
            this.classification_paths = new String[1];
            this.classification_paths[0] = new_classification;
        } else {
            String[] temp = new String[this.classification_paths.length + 1];
            System.arraycopy(this.classification_paths, 0, temp, 0, this.classification_paths.length);
            temp[temp.length - 1] = new_classification;
            this.classification_paths = temp;
        }
    }

    public void delete() {
        if (this.filename != null && !this.filename.equals("")) {
            File file = new File(this.filename);
            file.delete();
        }
    }
}

