/*
 * Decompiled with CFR 0.152.
 */
package ace.datatypes;

import ace.datatypes.DataSet;
import ace.xmlparsers.XMLDocumentParser;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.LinkedList;
import mckay.utilities.staticlibraries.MathAndStatsMethods;
import mckay.utilities.staticlibraries.StringMethods;
import weka.core.Instance;

public class SegmentedClassification
implements Serializable {
    public String identifier;
    public String[] classifications;
    public String[] misc_info_info;
    public String[] misc_info_key;
    public String role;
    public SegmentedClassification[] sub_classifications;
    public double start;
    public double stop;
    private static final long serialVersionUID = 4L;

    public SegmentedClassification() {
        this.identifier = null;
        this.classifications = null;
        this.misc_info_info = null;
        this.misc_info_key = null;
        this.role = null;
        this.sub_classifications = null;
        this.start = Double.NaN;
        this.stop = Double.NaN;
    }

    public SegmentedClassification(String identifier, double start, double stop, String[] classifications, String[] misc_info, String[] misc_info_key, SegmentedClassification[] sub_classifications) {
        this.identifier = identifier;
        this.classifications = classifications;
        this.misc_info_info = misc_info;
        this.misc_info_key = misc_info_key;
        this.role = null;
        this.sub_classifications = sub_classifications;
        this.start = start;
        this.stop = stop;
    }

    public SegmentedClassification(Instance instance, int i) {
        if (!instance.classIsMissing()) {
            this.identifier = i + "_" + instance.toString().substring(0, instance.toString().lastIndexOf(","));
            this.classifications = new String[1];
            this.classifications[0] = instance.classAttribute().value((int)instance.classValue());
            this.misc_info_info = null;
            this.misc_info_key = null;
            this.role = null;
            this.sub_classifications = null;
            this.start = Double.NaN;
            this.stop = Double.NaN;
        } else {
            this.identifier = null;
            this.classifications = null;
            this.misc_info_info = null;
            this.misc_info_key = null;
            this.role = null;
            this.sub_classifications = null;
            this.start = Double.NaN;
            this.stop = Double.NaN;
        }
    }

    public String getClassificationDescription(int depth) {
        String indent = new String("");
        for (int i = 0; i < depth; ++i) {
            indent = indent + "   ";
        }
        String id_string = new String("");
        if (this.identifier != null) {
            id_string = "DATASET " + this.identifier + ": ";
            id_string = this.sub_classifications != null ? id_string + this.sub_classifications.length + " sub-sections " : id_string + "0 sub-sections ";
            id_string = this.classifications != null ? id_string + this.classifications.length + " overall classes\n" : id_string + "0 overall classes\n";
            if (this.misc_info_info != null) {
                for (int i = 0; i < this.misc_info_info.length; ++i) {
                    id_string = id_string + this.misc_info_key[i] + ": " + this.misc_info_info[i] + "\n";
                }
            }
            if (this.role != null) {
                id_string = id_string + "Role: " + this.role + "\n";
            }
            id_string = id_string + "\n";
        } else {
            id_string = id_string + indent + "START: " + this.start + "     STOP: " + this.stop + "\n\n";
        }
        String classifications_string = new String("");
        if (this.classifications != null) {
            for (int i = 0; i < this.classifications.length; ++i) {
                classifications_string = classifications_string + indent + indent + "Class: " + this.classifications[i] + "\n";
            }
            classifications_string = classifications_string + "\n";
        }
        String sub_section_string = new String("");
        if (this.sub_classifications != null) {
            for (int set = 0; set < this.sub_classifications.length; ++set) {
                sub_section_string = sub_section_string + this.sub_classifications[set].getClassificationDescription(depth + 1);
            }
        }
        return id_string + classifications_string + sub_section_string;
    }

    public static String getClassificationDescriptions(SegmentedClassification[] seg_classes) {
        String combined_classificationss = new String();
        for (int i = 0; i < seg_classes.length; ++i) {
            combined_classificationss = combined_classificationss + seg_classes[i].getClassificationDescription(0);
        }
        return combined_classificationss;
    }

    public static int getNumberOverallInstancesBelongingToClass(SegmentedClassification[] model_classifications, String class_of_interest) {
        int count = 0;
        for (int inst = 0; inst < model_classifications.length; ++inst) {
            String[] classes = model_classifications[inst].classifications;
            if (classes == null) continue;
            for (int clas = 0; clas < classes.length; ++clas) {
                if (!classes[clas].equals(class_of_interest)) continue;
                clas = classes.length;
                ++count;
            }
        }
        return count;
    }

    public static int getNumberSectionsInInstancesBelongingToClass(SegmentedClassification[] model_classifications, String class_of_interest) {
        int count = 0;
        for (int inst = 0; inst < model_classifications.length; ++inst) {
            SegmentedClassification[] sub_sections = model_classifications[inst].sub_classifications;
            if (sub_sections == null) continue;
            count += SegmentedClassification.getNumberOverallInstancesBelongingToClass(sub_sections, class_of_interest);
        }
        return count;
    }

    public static String[] getLeafClasses(SegmentedClassification[] seg_classes) {
        LinkedList<String> classes_including_doubles = new LinkedList<String>();
        for (int set = 0; set < seg_classes.length; ++set) {
            if (seg_classes[set].classifications != null) {
                for (int cla = 0; cla < seg_classes[set].classifications.length; ++cla) {
                    classes_including_doubles.add(seg_classes[set].classifications[cla]);
                }
            }
            if (seg_classes[set].sub_classifications == null) continue;
            for (int sub = 0; sub < seg_classes[set].sub_classifications.length; ++sub) {
                for (int cla = 0; cla < seg_classes[set].sub_classifications[sub].classifications.length; ++cla) {
                    classes_including_doubles.add(seg_classes[set].sub_classifications[sub].classifications[cla]);
                }
            }
        }
        Object[] obj = classes_including_doubles.toArray();
        String[] unshortened = new String[obj.length];
        for (int i = 0; i < unshortened.length; ++i) {
            unshortened[i] = (String)obj[i];
        }
        String[] shortened = StringMethods.removeDoubles((String[])unshortened);
        return shortened;
    }

    public static boolean verifyUniquenessOfIdentifiers(SegmentedClassification[] seg_classes) {
        boolean unique = true;
        for (int i = 0; i < seg_classes.length - 1; ++i) {
            for (int j = i + 1; j < seg_classes.length; ++j) {
                if (!seg_classes[i].identifier.equals(seg_classes[j].identifier)) continue;
                unique = false;
                i = seg_classes.length;
                j = seg_classes.length;
            }
        }
        return unique;
    }

    public static String[][] getOverallLabelsOfDataSets(DataSet[] data_sets, SegmentedClassification[] set_classifications) throws Exception {
        if (!SegmentedClassification.verifyUniquenessOfIdentifiers(set_classifications)) {
            throw new Exception("Given classifications contain multiple references\nto instances with the same identifier.");
        }
        String[][] data_set_overall_labels = new String[data_sets.length][];
        for (int set = 0; set < data_sets.length; ++set) {
            data_set_overall_labels[set] = null;
            for (int clas = 0; clas < set_classifications.length; ++clas) {
                if (!data_sets[set].identifier.equals(set_classifications[clas].identifier)) continue;
                data_set_overall_labels[set] = set_classifications[clas].classifications;
                clas = set_classifications.length;
            }
        }
        return data_set_overall_labels;
    }

    public static String[][][] getSubSectionLabelsOfDataSets(DataSet[] data_sets, SegmentedClassification[] set_classifications) throws Exception {
        if (!SegmentedClassification.verifyUniquenessOfIdentifiers(set_classifications)) {
            throw new Exception("Given classifications contain multiple references\nto instances with the same identifier.");
        }
        String[][][] labels = new String[data_sets.length][][];
        for (int set = 0; set < data_sets.length; ++set) {
            labels[set] = null;
            for (int clas = 0; clas < set_classifications.length; ++clas) {
                if (!data_sets[set].identifier.equals(set_classifications[clas].identifier)) continue;
                DataSet[] data_sub_set = data_sets[set].sub_sets;
                SegmentedClassification[] classification_sections = set_classifications[clas].sub_classifications;
                if (data_sub_set == null || classification_sections == null) continue;
                labels[set] = new String[data_sub_set.length][];
                double[] data_low_bound = new double[data_sub_set.length];
                double[] data_high_bound = new double[data_sub_set.length];
                for (int sub = 0; sub < data_sub_set.length; ++sub) {
                    data_low_bound[sub] = data_sub_set[sub].start;
                    data_high_bound[sub] = data_sub_set[sub].stop;
                }
                double[] classifications_low_bound = new double[classification_sections.length];
                double[] classifications_high_bound = new double[classification_sections.length];
                for (int cl_sub = 0; cl_sub < classification_sections.length; ++cl_sub) {
                    classifications_low_bound[cl_sub] = classification_sections[cl_sub].start;
                    classifications_high_bound[cl_sub] = classification_sections[cl_sub].stop;
                }
                for (int sub = 0; sub < data_sub_set.length; ++sub) {
                    labels[set][sub] = null;
                    double[] fraction_in = new double[classification_sections.length];
                    double data_set_length = data_high_bound[sub] - data_low_bound[sub];
                    for (int cl_sub = 0; cl_sub < classification_sections.length; ++cl_sub) {
                        fraction_in[cl_sub] = data_high_bound[sub] < classifications_low_bound[cl_sub] || data_low_bound[sub] > classifications_high_bound[cl_sub] ? 0.0 : (data_low_bound[sub] >= classifications_low_bound[cl_sub] && data_high_bound[sub] <= classifications_high_bound[cl_sub] ? 1.0 : (data_low_bound[sub] <= classifications_low_bound[cl_sub] && data_high_bound[sub] >= classifications_high_bound[cl_sub] ? (classifications_high_bound[cl_sub] - classifications_low_bound[cl_sub]) / data_set_length : (data_low_bound[sub] <= classifications_low_bound[cl_sub] && data_high_bound[sub] >= classifications_low_bound[cl_sub] && data_high_bound[sub] <= classifications_high_bound[cl_sub] ? (data_high_bound[sub] - classifications_low_bound[cl_sub]) / data_set_length : (data_low_bound[sub] >= classifications_low_bound[cl_sub] && data_high_bound[sub] >= classifications_high_bound[cl_sub] && data_low_bound[sub] <= classifications_high_bound[cl_sub] ? (classifications_high_bound[cl_sub] - data_low_bound[sub]) / data_set_length : 0.0))));
                    }
                    int best_cl_sub = MathAndStatsMethods.getIndexOfLargest((double[])fraction_in);
                    labels[set][sub] = classification_sections[best_cl_sub].classifications;
                }
            }
        }
        return labels;
    }

    public static SegmentedClassification[] parseClassificationsFile(String model_classification_file_path) throws Exception {
        Object[] results = (Object[])XMLDocumentParser.parseXMLDocument(model_classification_file_path, "classifications_file");
        SegmentedClassification[] parse_results = new SegmentedClassification[results.length];
        for (int i = 0; i < parse_results.length; ++i) {
            parse_results[i] = (SegmentedClassification)results[i];
        }
        return parse_results;
    }

    public static void saveClassifications(SegmentedClassification[] seg_classifications, File to_save_to, String comments) throws Exception {
        try {
            FileOutputStream to = new FileOutputStream(to_save_to);
            DataOutputStream writer = new DataOutputStream(to);
            String pre_tree_part = new String("<?xml version=\"1.0\"?>\n<!DOCTYPE classifications_file [\n   <!ELEMENT classifications_file (comments, data_set+)>\n   <!ELEMENT comments (#PCDATA)>\n   <!ELEMENT data_set (data_set_id, misc_info*, role?, classification)>\n   <!ELEMENT data_set_id (#PCDATA)>\n   <!ELEMENT misc_info (#PCDATA)>\n   <!ATTLIST misc_info info_type CDATA \"\">\n   <!ELEMENT role (#PCDATA)>\n   <!ELEMENT classification (section*, class*)>\n   <!ELEMENT section (start, stop, class+)>\n   <!ELEMENT class (#PCDATA)>\n   <!ELEMENT start (#PCDATA)>\n   <!ELEMENT stop (#PCDATA)>\n]>\n\n<classifications_file>\n\n   <comments>" + comments + "</comments>\n\n");
            writer.writeBytes(pre_tree_part);
            for (int set = 0; set < seg_classifications.length; ++set) {
                writer.writeBytes("   <data_set>\n");
                writer.writeBytes("      <data_set_id>" + seg_classifications[set].identifier + "</data_set_id>\n");
                if (seg_classifications[set].misc_info_key != null) {
                    for (int met = 0; met < seg_classifications[set].misc_info_key.length; ++met) {
                        writer.writeBytes("      <misc_info info_type=\"" + seg_classifications[set].misc_info_key[met] + "\">" + seg_classifications[set].misc_info_info[met] + "</misc_info>\n");
                    }
                }
                if (seg_classifications[set].role != null) {
                    writer.writeBytes("      <role>" + seg_classifications[set].role + "</role>\n");
                }
                writer.writeBytes("      <classification>\n");
                if (seg_classifications[set].sub_classifications != null) {
                    SegmentedClassification[] sub_secs = seg_classifications[set].sub_classifications;
                    for (int sub = 0; sub < sub_secs.length; ++sub) {
                        writer.writeBytes("         <section>\n");
                        writer.writeBytes("            <start>" + sub_secs[sub].start + "</start>\n");
                        writer.writeBytes("            <stop>" + sub_secs[sub].stop + "</stop>\n");
                        for (int cla = 0; cla < sub_secs[sub].classifications.length; ++cla) {
                            writer.writeBytes("            <class>" + sub_secs[sub].classifications[cla] + "</class>\n");
                        }
                        writer.writeBytes("         </section>\n");
                    }
                }
                if (seg_classifications[set].classifications != null) {
                    for (int cla = 0; cla < seg_classifications[set].classifications.length; ++cla) {
                        writer.writeBytes("         <class>" + seg_classifications[set].classifications[cla] + "</class>\n");
                    }
                }
                writer.writeBytes("      </classification>\n");
                writer.writeBytes("   </data_set>\n\n");
            }
            writer.writeBytes("</classifications_file>");
            writer.close();
        }
        catch (Exception e) {
            throw new Exception("Unable to write file " + to_save_to.getName() + ".");
        }
    }

    public static void mergeAdjacentSections(SegmentedClassification verbose_classifications) {
        if (verbose_classifications.sub_classifications == null) {
            return;
        }
        if (verbose_classifications.sub_classifications.length == 1) {
            return;
        }
        LinkedList<SegmentedClassification> new_sections = new LinkedList<SegmentedClassification>();
        SegmentedClassification[] old_sections = verbose_classifications.sub_classifications;
        SegmentedClassification this_section = old_sections[0];
        for (int sec = 0; sec < old_sections.length - 1; ++sec) {
            if (StringMethods.doStringArraysMatch((String[])this_section.classifications, (String[])old_sections[sec + 1].classifications) && this_section.stop >= old_sections[sec + 1].start) {
                this_section.stop = old_sections[sec + 1].stop;
                if (sec != old_sections.length - 2) continue;
                new_sections.add(this_section);
                continue;
            }
            new_sections.add(this_section);
            this_section = old_sections[sec + 1];
            if (sec != old_sections.length - 2) continue;
            new_sections.add(this_section);
        }
        verbose_classifications.sub_classifications = new_sections.toArray(new SegmentedClassification[1]);
    }

    public static String[][][] getMergedSectionalClassifications(SegmentedClassification[] sub_classes, DataSet[] sub_set, double[][][] times) {
        String[][][] classes = new String[sub_set.length][sub_classes.length][];
        for (int j = 0; j < sub_set.length; ++j) {
            int class_index = 0;
            for (int i = 0; i < sub_classes.length; ++i) {
                if (sub_classes[i].start == Double.NaN || sub_classes[i].stop == Double.NaN || !(sub_classes[i].start <= sub_set[j].start && sub_classes[i].stop >= sub_set[j].start) && (!(sub_classes[i].start >= sub_set[j].start) || !(sub_classes[i].start <= sub_set[j].stop))) continue;
                classes[j][class_index] = sub_classes[i].classifications;
                if (sub_classes[i].start >= sub_set[j].start) {
                    times[j][class_index][0] = sub_classes[i].start;
                    if (sub_classes[i].stop <= sub_set[j].stop) {
                        times[j][class_index][1] = sub_classes[i].stop;
                    } else if (sub_classes[i].stop > sub_set[j].stop) {
                        times[j][class_index][1] = sub_set[j].stop;
                    }
                } else {
                    times[j][class_index][0] = sub_set[j].start;
                    if (sub_classes[i].stop <= sub_set[j].stop) {
                        times[j][class_index][1] = sub_classes[i].stop;
                    } else if (sub_classes[i].stop > sub_set[j].stop) {
                        times[j][class_index][1] = sub_set[j].stop;
                    }
                }
                ++class_index;
            }
        }
        return classes;
    }

    public static SegmentedClassification findMatchingClassification(DataSet instance, SegmentedClassification[] classes) {
        for (int i = 0; i < classes.length; ++i) {
            if (!instance.identifier.equals(classes[i].identifier)) continue;
            return classes[i];
        }
        return null;
    }
}

