/*
 * Decompiled with CFR 0.152.
 */
package ace.gui;

import ace.datatypes.FeatureDefinition;
import ace.gui.FeatureDefinitionsTableModel;
import ace.gui.MainGUIFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import mckay.utilities.gui.tables.StripedTableCellRenderer;
import mckay.utilities.gui.tables.TableSortModel;
import mckay.utilities.staticlibraries.FileMethods;

public class FeatureDefinitionsPanel
extends JPanel
implements ActionListener,
TableModelListener {
    private MainGUIFrame parent;
    private JTable features_table;
    private JPanel features_display_panel;
    private JPanel button_panel;
    private JScrollPane features_display_scroll_pane;
    private JTextField status_bar;
    private JButton view_feature_descriptions_button;
    private JButton add_feature_definition_button;
    private JButton delete_feature_definitions_button;
    private JButton load_features_definitions_button;
    private JButton save_features_definitions_button;
    private JButton save_features_definitions_as_button;

    public FeatureDefinitionsPanel(MainGUIFrame parent_frame) {
        this.parent = parent_frame;
        this.setLayout(new BorderLayout());
        int horizontal_gap = 4;
        int vertical_gap = 4;
        this.status_bar = new JTextField("");
        this.status_bar.setEditable(false);
        this.add((Component)this.status_bar, "South");
        this.view_feature_descriptions_button = new JButton("View Descriptions");
        this.view_feature_descriptions_button.addActionListener(this);
        this.add_feature_definition_button = new JButton("Add Feature");
        this.add_feature_definition_button.addActionListener(this);
        this.delete_feature_definitions_button = new JButton("Delete Features");
        this.delete_feature_definitions_button.addActionListener(this);
        this.load_features_definitions_button = new JButton("Load Features");
        this.load_features_definitions_button.addActionListener(this);
        this.save_features_definitions_button = new JButton("Save Features");
        this.save_features_definitions_button.addActionListener(this);
        this.save_features_definitions_as_button = new JButton("Save Features As");
        this.save_features_definitions_as_button.addActionListener(this);
        this.button_panel = new JPanel(new GridLayout(18, 1, horizontal_gap, vertical_gap));
        this.button_panel.add(this.load_features_definitions_button);
        this.button_panel.add(this.save_features_definitions_button);
        this.button_panel.add(this.save_features_definitions_as_button);
        this.button_panel.add(new JLabel(""));
        this.button_panel.add(this.add_feature_definition_button);
        this.button_panel.add(this.delete_feature_definitions_button);
        this.button_panel.add(new JLabel(""));
        this.button_panel.add(this.view_feature_descriptions_button);
        this.add((Component)this.button_panel, "East");
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.view_feature_descriptions_button)) {
            this.viewFeatureDefinitions();
        } else if (event.getSource().equals(this.add_feature_definition_button)) {
            this.addNewFeatureDefinition();
        } else if (event.getSource().equals(this.delete_feature_definitions_button)) {
            this.deleteFeatureDefinitions();
        } else if (event.getSource().equals(this.load_features_definitions_button)) {
            this.browseNewFeatureDefinitions();
        } else if (event.getSource().equals(this.save_features_definitions_button)) {
            this.saveAsFile(this.parent.project.feature_settings_paths[0]);
        } else if (event.getSource().equals(this.save_features_definitions_as_button)) {
            this.saveAsFileWithBrowse();
        }
    }

    public void loadNewPanelContents() {
        if (this.features_display_panel != null) {
            this.remove(this.features_display_panel);
        }
        Object[] column_headings = new Object[]{new String("Name"), new String("Dimensions"), new String("Sequential"), new String("Description")};
        int number_rows = 0;
        if (this.parent.data_board.getFeatureDefinitions() != null) {
            number_rows = this.parent.data_board.getFeatureDefinitions().length;
        }
        FeatureDefinitionsTableModel features_table_model = new FeatureDefinitionsTableModel(column_headings, number_rows);
        features_table_model.fillTable(this.parent.data_board.getFeatureDefinitions());
        this.features_table = new JTable(features_table_model);
        TableSortModel sort_model = new TableSortModel(this.features_table);
        StripedTableCellRenderer.installInTable((JTable)this.features_table, (Color)Color.lightGray, (Color)Color.white, null, null);
        this.setColumnWidths();
        this.features_table.getModel().addTableModelListener(this);
        this.features_display_scroll_pane = new JScrollPane(this.features_table);
        this.features_display_panel = new JPanel(new GridLayout(1, 1));
        this.features_display_panel.add(this.features_display_scroll_pane);
        this.add((Component)this.features_display_panel, "Center");
        this.updateStatusBar();
        features_table_model.fireTableDataChanged();
        this.repaint();
        this.parent.repaint();
    }

    public void saveAsFile(String save_path) {
        if (this.parent.data_board.getFeatureDefinitions().length == 0) {
            JOptionPane.showMessageDialog(null, "There are not currently any feature definitions to save.", "WARNING", 2);
        } else if (!save_path.equals("")) {
            File save_file = FileMethods.getNewFileForWriting((String)save_path, (boolean)true);
            try {
                FeatureDefinition.saveFeatureDefinitions(this.parent.data_board.getFeatureDefinitions(), save_file, "");
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
            }
        } else {
            this.saveAsFileWithBrowse();
        }
    }

    public void tableChanged(TableModelEvent event) {
        boolean accept_change = true;
        String error_message = "";
        if (event.getType() == 0) {
            int column = event.getColumn();
            int first_row = event.getFirstRow();
            if (column == 0) {
                FeatureDefinition[] old_features = this.parent.data_board.feature_definitions;
                this.updateFeaturesSettings();
                String duplicates = FeatureDefinition.verifyFeatureNameUniqueness(this.parent.data_board.feature_definitions);
                if (duplicates != null) {
                    error_message = "You have entered a feature name of " + this.features_table.getModel().getValueAt(first_row, column) + ".\n" + "A feature with this name already exists.";
                    this.parent.data_board.feature_definitions = old_features;
                    accept_change = false;
                }
            } else if (column == 1 && (Integer)this.features_table.getModel().getValueAt(first_row, column) < 1) {
                error_message = "You have entered a dimension value of " + this.features_table.getModel().getValueAt(first_row, column) + ".\n" + "Each feature must have at least 1 dimension.";
                accept_change = false;
            }
        }
        if (accept_change) {
            this.updateFeaturesSettings();
            this.updateStatusBar();
            this.setColumnWidths();
        } else {
            JOptionPane.showMessageDialog(null, error_message, "ERROR", 0);
            this.loadNewPanelContents();
        }
    }

    private void viewFeatureDefinitions() {
        int i;
        int[] rows = this.features_table.getSelectedRows();
        String[] names = new String[rows.length];
        String[] descriptions = new String[rows.length];
        for (i = 0; i < descriptions.length; ++i) {
            names[i] = (String)this.features_table.getModel().getValueAt(rows[i], 0);
            descriptions[i] = (String)this.features_table.getModel().getValueAt(rows[i], 3);
        }
        for (i = 0; i < descriptions.length; ++i) {
            JOptionPane.showMessageDialog(null, descriptions[i], names[i] + " Description", 1);
        }
    }

    private void addNewFeatureDefinition() {
        String new_name = "New Feature";
        int label_number = 1;
        String[] names = new String[this.features_table.getRowCount()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = (String)this.features_table.getModel().getValueAt(i, 0);
        }
        boolean found = true;
        while (found) {
            found = false;
            for (int i = 0; i < names.length; ++i) {
                if (!new_name.equals(names[i])) continue;
                found = true;
            }
            if (!found) continue;
            new_name = "New Feature " + label_number;
            ++label_number;
        }
        Object[] new_feature = new Object[]{new_name, new Integer(1), new Boolean(false), "This is a newly added feature."};
        ((TableSortModel)this.features_table.getModel()).addRow(new_feature);
    }

    private void deleteFeatureDefinitions() {
        int[] rows = this.features_table.getSelectedRows();
        if (rows.length == 0) {
            JOptionPane.showMessageDialog(null, "No features are selected to delete.", "WARNING", 2);
        }
        ((TableSortModel)this.features_table.getModel()).removeRows(rows);
    }

    private void browseNewFeatureDefinitions() {
        boolean ok_pressed = this.parent.project_files_dialog_box.browsePath("feature_definitions", true);
        if (ok_pressed) {
            String definitions_path = this.parent.project.feature_settings_paths[0];
            try {
                this.parent.data_board.feature_definitions = FeatureDefinition.parseFeatureDefinitionsFile(definitions_path);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
            }
            this.loadNewPanelContents();
        }
    }

    private void saveAsFileWithBrowse() {
        if (this.parent.data_board.getFeatureDefinitions().length == 0) {
            JOptionPane.showMessageDialog(null, "There are not currently any feature definitions to save.", "WARNING", 2);
        } else {
            File save_file = this.parent.project_files_dialog_box.saveFileExternally("feature_definitions", false);
            if (save_file != null) {
                try {
                    FeatureDefinition.saveFeatureDefinitions(this.parent.data_board.getFeatureDefinitions(), save_file, "");
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
                }
            }
        }
    }

    private void updateFeaturesSettings() {
        TableSortModel table_model = (TableSortModel)this.features_table.getModel();
        this.parent.data_board.feature_definitions = new FeatureDefinition[table_model.getRowCount()];
        for (int i = 0; i < table_model.getRowCount(); ++i) {
            this.parent.data_board.feature_definitions[i] = new FeatureDefinition((String)table_model.getValueAt(i, 0), (String)table_model.getValueAt(i, 3), (Boolean)table_model.getValueAt(i, 2), (Integer)table_model.getValueAt(i, 1));
        }
    }

    private void updateStatusBar() {
        int number_features = 0;
        int number_multi_dimensional_features = 0;
        int number_sequential_features = 0;
        if (this.parent.data_board.getFeatureDefinitions() != null) {
            for (int i = 0; i < this.parent.data_board.getFeatureDefinitions().length; ++i) {
                ++number_features;
                if (this.parent.data_board.getFeatureDefinitions()[i].dimensions > 1) {
                    ++number_multi_dimensional_features;
                }
                if (!this.parent.data_board.getFeatureDefinitions()[i].is_sequential) continue;
                ++number_sequential_features;
            }
        }
        String status_text = new String(number_features + " features available, including  " + number_multi_dimensional_features + " multi-dimensional features and " + number_sequential_features + " sequential features");
        this.status_bar.setText(status_text);
    }

    private void setColumnWidths() {
        int max_width = 25;
        TableColumn[] columns_to_set_sizes = new TableColumn[]{this.features_table.getColumn("Name"), this.features_table.getColumn("Dimensions"), this.features_table.getColumn("Sequential")};
        TableSortModel.setColumnWidths((JTable)this.features_table, (TableColumn[])columns_to_set_sizes, (int)max_width);
    }
}

