/*
 * Decompiled with CFR 0.152.
 */
package ace.gui;

import ace.datatypes.DataBoard;
import ace.datatypes.DataSet;
import ace.datatypes.FeatureDefinition;
import ace.datatypes.SegmentedClassification;
import ace.datatypes.Taxonomy;
import ace.gui.InstancesTableModel;
import ace.gui.MainGUIFrame;
import ace.gui.ShowSectionsColumnRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import mckay.utilities.gui.tables.MultiLineCellRenderer;
import mckay.utilities.gui.tables.StripedTableCellRenderer;
import mckay.utilities.gui.tables.TableSortModel;
import mckay.utilities.staticlibraries.FileMethods;

public class InstancesPanel
extends JPanel
implements ActionListener,
TableModelListener {
    private MainGUIFrame parent;
    private JTable instances_table;
    private JPanel instances_display_panel;
    private JPanel button_panel;
    private JScrollPane instances_display_scroll_pane;
    private JTextField status_bar;
    private JButton load_classification_button;
    private JButton load_feature_vectors_button;
    private JButton save_classification_button;
    private JButton save_feature_vectors_button;
    private JButton save_as_classification_button;
    private JButton save_as_feature_vectors_button;
    private JButton add_instance_button;
    private JButton delete_instance_button;
    private JCheckBox display_feature_values_checkbox;
    private JCheckBox show_misc_info_checkbox;
    private boolean display_meta_data;
    private boolean display_feature_values;

    public InstancesPanel(MainGUIFrame parent_frame) {
        this.parent = parent_frame;
        this.setLayout(new BorderLayout());
        int horizontal_gap = 4;
        int vertical_gap = 4;
        this.status_bar = new JTextField("");
        this.status_bar.setEditable(false);
        this.add((Component)this.status_bar, "South");
        this.load_classification_button = new JButton("Load Classifications");
        this.load_classification_button.addActionListener(this);
        this.load_feature_vectors_button = new JButton("Load Feature Vectors");
        this.load_feature_vectors_button.addActionListener(this);
        this.save_classification_button = new JButton("Save Classifications");
        this.save_classification_button.addActionListener(this);
        this.save_feature_vectors_button = new JButton("Save Feature Vectors");
        this.save_feature_vectors_button.addActionListener(this);
        this.save_as_classification_button = new JButton("Save Classifications As");
        this.save_as_classification_button.addActionListener(this);
        this.save_as_feature_vectors_button = new JButton("Save Feature Vectors As");
        this.save_as_feature_vectors_button.addActionListener(this);
        this.add_instance_button = new JButton("Add Instance");
        this.add_instance_button.addActionListener(this);
        this.delete_instance_button = new JButton("Delete Instance");
        this.delete_instance_button.addActionListener(this);
        this.display_feature_values_checkbox = new JCheckBox("Display Feature Values");
        this.display_feature_values_checkbox.addActionListener(this);
        this.show_misc_info_checkbox = new JCheckBox("Display Misc Info");
        this.show_misc_info_checkbox.addActionListener(this);
        this.button_panel = new JPanel(new GridLayout(18, 1, horizontal_gap, vertical_gap));
        this.button_panel.add(this.load_classification_button);
        this.button_panel.add(this.load_feature_vectors_button);
        this.button_panel.add(new JLabel(""));
        this.button_panel.add(this.save_classification_button);
        this.button_panel.add(this.save_feature_vectors_button);
        this.button_panel.add(this.save_as_classification_button);
        this.button_panel.add(this.save_as_feature_vectors_button);
        this.button_panel.add(new JLabel(""));
        this.button_panel.add(this.add_instance_button);
        this.button_panel.add(this.delete_instance_button);
        this.button_panel.add(new JLabel(""));
        this.button_panel.add(this.display_feature_values_checkbox);
        this.button_panel.add(this.show_misc_info_checkbox);
        this.add((Component)this.button_panel, "East");
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.load_classification_button)) {
            this.browseNewClassifications();
        } else if (event.getSource().equals(this.load_feature_vectors_button)) {
            this.browseNewFeatureVectors();
        } else if (event.getSource().equals(this.save_classification_button)) {
            this.saveAsClassificationsFile(this.parent.project.classification_paths[0]);
        } else if (event.getSource().equals(this.save_feature_vectors_button)) {
            this.saveAsFeatureVectorsFile(this.parent.project.feature_vectors_paths[0]);
        } else if (event.getSource().equals(this.save_as_classification_button)) {
            this.saveAsClassificationsFileWithBrowse();
        } else if (event.getSource().equals(this.save_as_feature_vectors_button)) {
            this.saveAsFeatureVectorsFileWithBrowse();
        } else if (event.getSource().equals(this.add_instance_button)) {
            this.addNewInstance();
        } else if (event.getSource().equals(this.delete_instance_button)) {
            this.deleteInstances();
        } else if (event.getSource().equals(this.display_feature_values_checkbox)) {
            this.display_feature_values = this.display_feature_values_checkbox.isSelected();
            this.loadNewPanelContents();
        } else if (event.getSource().equals(this.show_misc_info_checkbox)) {
            this.display_meta_data = this.show_misc_info_checkbox.isSelected();
            this.loadNewPanelContents();
        }
    }

    public void loadNewPanelContents() {
        String[] identifiers_to_be_expanded = this.getIdentifiersToBeExpanded(this.instances_table);
        if (this.parent.data_board.model_classifications != null && (this.parent.data_board.taxonomy == null || this.parent.data_board.taxonomy.isTreeEmpty())) {
            this.parent.data_board.taxonomy = Taxonomy.generateTaxonomy(this.parent.data_board.model_classifications);
            this.parent.taxonomy_panel.loadNewPanelContents();
        }
        if (this.parent.data_board.feature_vectors != null && (this.parent.data_board.feature_definitions == null || this.parent.data_board.feature_definitions.length <= 0)) {
            try {
                this.parent.data_board.feature_definitions = FeatureDefinition.generateFeatureDefinitions(this.parent.data_board.feature_vectors);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Unable to automatically generate feature definitions from feature vectors.  " + e.getMessage(), "ERROR", 0);
            }
            this.parent.feature_definitions_panel.loadNewPanelContents();
        }
        if (this.instances_display_panel != null) {
            this.remove(this.instances_display_panel);
        }
        InstancesTableModel instances_table_model = new InstancesTableModel();
        instances_table_model.addTableModelListener(this);
        try {
            instances_table_model.fillTable(this.parent.data_board, identifiers_to_be_expanded, this.display_meta_data, this.display_feature_values);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Unable to Fill Table.  " + e.getMessage(), "ERROR", 0);
        }
        this.instances_table = new JTable(instances_table_model);
        int class_column_indice = -1;
        int show_sections_column_indice = -1;
        for (int i = 0; i < instances_table_model.getColumnCount(); ++i) {
            if (instances_table_model.getColumnName(i).equals("Classes")) {
                class_column_indice = i;
            }
            if (!instances_table_model.getColumnName(i).equals("Show Sections")) continue;
            show_sections_column_indice = i;
        }
        TableColumnModel column_model = this.instances_table.getColumnModel();
        if (class_column_indice != -1) {
            MultiLineCellRenderer multi_line_renderer = new MultiLineCellRenderer(2, 0);
            column_model.getColumn(class_column_indice).setCellRenderer((TableCellRenderer)multi_line_renderer);
        }
        if (show_sections_column_indice != -1) {
            String[] expandable = this.getExpandable(this.parent.data_board);
            ShowSectionsColumnRenderer show_sections_renderer = new ShowSectionsColumnRenderer(expandable);
            column_model.getColumn(show_sections_column_indice).setCellRenderer(show_sections_renderer);
        }
        StripedTableCellRenderer.installInTable((JTable)this.instances_table, (Color)Color.lightGray, (Color)Color.white, null, null);
        this.instances_table.getModel().addTableModelListener(this);
        this.instances_display_scroll_pane = new JScrollPane(this.instances_table);
        this.instances_display_panel = new JPanel(new GridLayout(1, 1));
        this.instances_display_panel.add(this.instances_display_scroll_pane);
        this.add((Component)this.instances_display_panel, "Center");
        this.updateStatusBar();
        instances_table_model.fireTableDataChanged();
        this.repaint();
        this.parent.repaint();
    }

    public void saveAsClassificationsFile(String save_path) {
        if (this.parent.data_board.getModelClassifications().length == 0) {
            JOptionPane.showMessageDialog(null, "There are not currently any model classifications to save.", "WARNING", 2);
        } else if (!save_path.equals("")) {
            File save_file = FileMethods.getNewFileForWriting((String)save_path, (boolean)true);
            try {
                SegmentedClassification.saveClassifications(this.parent.data_board.getModelClassifications(), save_file, "");
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
            }
        } else {
            this.saveAsClassificationsFileWithBrowse();
        }
    }

    public void saveAsFeatureVectorsFile(String save_path) {
        if (this.parent.data_board.getFeatureVectors().length == 0) {
            JOptionPane.showMessageDialog(null, "There are not currently any feature values to save.", "WARNING", 2);
        } else if (!save_path.equals("")) {
            File save_file = FileMethods.getNewFileForWriting((String)save_path, (boolean)true);
            try {
                DataSet.saveDataSets(this.parent.data_board.getFeatureVectors(), this.parent.data_board.getFeatureDefinitions(), save_file, "");
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
            }
        } else {
            this.saveAsFeatureVectorsFileWithBrowse();
        }
    }

    public void tableChanged(TableModelEvent event) {
        if (event.getColumn() == 0) {
            this.loadNewPanelContents();
        }
    }

    private void browseNewClassifications() {
        boolean ok_pressed = this.parent.project_files_dialog_box.browsePath("model_classifications", true);
        if (ok_pressed) {
            String classifications_path = this.parent.project.classification_paths[0];
            try {
                this.parent.data_board.model_classifications = SegmentedClassification.parseClassificationsFile(classifications_path);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
            }
            this.loadNewPanelContents();
        }
    }

    private void browseNewFeatureVectors() {
        boolean ok_pressed = this.parent.project_files_dialog_box.browsePath("feature_vectors", true);
        if (ok_pressed) {
            String feature_vectors_path = this.parent.project.feature_vectors_paths[0];
            try {
                this.parent.data_board.feature_vectors = DataSet.parseDataSetFile(feature_vectors_path, this.parent.data_board.feature_definitions);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
            }
            this.loadNewPanelContents();
        }
    }

    private void saveAsClassificationsFileWithBrowse() {
        if (this.parent.data_board.getModelClassifications().length == 0) {
            JOptionPane.showMessageDialog(null, "There are not currently any classifications to save.", "WARNING", 2);
        } else {
            File save_file = this.parent.project_files_dialog_box.saveFileExternally("model_classifications", false);
            if (save_file != null) {
                try {
                    SegmentedClassification.saveClassifications(this.parent.data_board.getModelClassifications(), save_file, "");
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
                }
            }
        }
    }

    private void saveAsFeatureVectorsFileWithBrowse() {
        if (this.parent.data_board.getFeatureVectors().length == 0) {
            JOptionPane.showMessageDialog(null, "There are not currently any feature vectors to save.", "WARNING", 2);
        } else {
            File save_file = this.parent.project_files_dialog_box.saveFileExternally("feature_vectors", false);
            if (save_file != null) {
                try {
                    DataSet.saveDataSets(this.parent.data_board.getFeatureVectors(), this.parent.data_board.getFeatureDefinitions(), save_file, "");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
                }
            }
        }
    }

    private void addNewInstance() {
        String new_name = "New Instance";
        int label_number = 1;
        String[] names = new String[this.instances_table.getRowCount()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = (String)this.instances_table.getModel().getValueAt(i, 0);
        }
        boolean found = true;
        while (found) {
            found = false;
            for (int i = 0; i < names.length; ++i) {
                if (!new_name.equals(names[i])) continue;
                found = true;
            }
            if (!found) continue;
            new_name = "New Feature " + label_number;
            ++label_number;
        }
        Object[] new_feature = new Object[]{new JCheckBox(), new_name, new String("-"), new String("-"), new String("")};
        ((TableSortModel)this.instances_table.getModel()).addRow(new_feature);
    }

    private void deleteInstances() {
        int[] rows = this.instances_table.getSelectedRows();
        if (rows.length == 0) {
            JOptionPane.showMessageDialog(null, "No instances are selected to delete.", "WARNING", 2);
        }
        ((TableSortModel)this.instances_table.getModel()).removeRows(rows);
    }

    private void updateModelClassifications() {
    }

    private void updateFeatureVectors() {
    }

    private void updateStatusBar() {
        int number_classifications = 0;
        if (this.parent.data_board.getModelClassifications() != null) {
            for (int i = 0; i < this.parent.data_board.getModelClassifications().length; ++i) {
                ++number_classifications;
            }
        }
        int number_feature_vectors = 0;
        if (this.parent.data_board.getFeatureVectors() != null) {
            for (int i = 0; i < this.parent.data_board.getFeatureVectors().length; ++i) {
                ++number_feature_vectors;
            }
        }
        String status_text = new String(number_classifications + " classifications available, " + number_feature_vectors + " feature values available");
        this.status_bar.setText(status_text);
    }

    private void setColumnWidths() {
        int max_width = 25;
        TableColumn[] columns_to_set_sizes = new TableColumn[]{this.instances_table.getColumn("Show Sections"), this.instances_table.getColumn("Identifier"), this.instances_table.getColumn("Start"), this.instances_table.getColumn("Stop")};
        TableSortModel.setColumnWidths((JTable)this.instances_table, (TableColumn[])columns_to_set_sizes, (int)max_width);
    }

    private String[] getExpandable(DataBoard data_board) {
        LinkedList<String> expandable = new LinkedList<String>();
        if (data_board.feature_vectors != null && data_board.feature_vectors.length != 0) {
            for (int i = 0; i < data_board.feature_vectors.length; ++i) {
                if (data_board.feature_vectors[i].sub_sets == null) continue;
                expandable.add(data_board.feature_vectors[i].identifier);
            }
        } else if (data_board.model_classifications != null && data_board.model_classifications.length != 0) {
            for (int i = 0; i < data_board.model_classifications.length; ++i) {
                if (data_board.model_classifications[i].sub_classifications == null) continue;
                expandable.add(data_board.model_classifications[i].identifier);
            }
        } else {
            return null;
        }
        return expandable.toArray(new String[expandable.size()]);
    }

    private String[] getIdentifiersToBeExpanded(JTable instances_table) {
        LinkedList<String> identifiers_to_be_expanded = new LinkedList<String>();
        if (instances_table == null || instances_table.getRowCount() == 0) {
            return null;
        }
        if (instances_table.getColumnName(0).equals("Show Sections") && instances_table.getRowCount() > 0) {
            for (int i = 0; i < instances_table.getRowCount(); ++i) {
                if (instances_table.getValueAt(i, 0) instanceof Boolean) {
                    if (!((Boolean)instances_table.getValueAt(i, 0)).booleanValue()) continue;
                    identifiers_to_be_expanded.add(instances_table.getValueAt(i, 1).toString());
                    continue;
                }
                if (!(instances_table.getValueAt(i, 0) instanceof String)) continue;
                return null;
            }
            return identifiers_to_be_expanded.toArray(new String[1]);
        }
        return null;
    }
}

