/*
 * Decompiled with CFR 0.152.
 */
package ace.gui;

import ace.datatypes.DataBoard;
import ace.datatypes.Project;
import ace.gui.ClassificationSettingsPanel;
import ace.gui.ExperimentationPanel;
import ace.gui.FeatureDefinitionsPanel;
import ace.gui.GUIPreferencesPanel;
import ace.gui.InstancesPanel;
import ace.gui.ProjectFilesDialogBox;
import ace.gui.TaxonomyPanel;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.LinkedList;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import mckay.utilities.gui.templates.AboutDialog;
import mckay.utilities.gui.templates.HelpDialog;
import mckay.utilities.staticlibraries.FileMethods;

public class MainGUIFrame
extends JFrame
implements ActionListener {
    public DataBoard data_board;
    public Project project;
    public LinkedList<String> temp_files;
    public boolean project_previously_loaded;
    public boolean zipfile_loaded;
    public ProjectFilesDialogBox project_files_dialog_box;
    public TaxonomyPanel taxonomy_panel;
    private InstancesPanel instances_panel;
    public FeatureDefinitionsPanel feature_definitions_panel;
    private GUIPreferencesPanel gui_preferences_panel;
    private ClassificationSettingsPanel classification_settings_panel;
    private ExperimentationPanel experimentation_panel;
    private HelpDialog help_dialog;
    private JTabbedPane tabbed_pane;
    private Container content_pane;
    private JMenuBar menu_bar;
    private JMenu file_menu;
    private JMenu help_menu;
    private JMenuItem load_configuration_files_menu_item;
    private JMenuItem save_project_menu_item;
    private JMenuItem save_project_paths_menu_item;
    private JMenuItem about_menu_item;
    private JMenuItem view_manual_menu_item;
    private JMenuItem quit_menu_item;
    private JMenuItem load_zip_item;

    public MainGUIFrame() {
        this.prepareGUI();
        this.project = new Project();
        this.data_board = new DataBoard();
        this.project_files_dialog_box = new ProjectFilesDialogBox(this);
        this.temp_files = new LinkedList();
        this.setVisible(true);
    }

    public MainGUIFrame(String project_file_name) throws Exception {
        try {
            this.prepareGUI();
            this.project = new Project();
            this.project.parseProjectFile(project_file_name);
            this.temp_files = new LinkedList();
            this.temp_files.add("TEMPZIP");
            this.project_files_dialog_box = new ProjectFilesDialogBox(this, project_file_name);
            this.project_files_dialog_box.setTextFields(this.project, project_file_name);
            this.project_files_dialog_box.parseAllFiles();
            this.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.getMessage() + " Unable to Initialize GUI with selected project file.", "ERROR", 0);
        }
    }

    public MainGUIFrame(String taxonomy_file, String[] feature_key_files, String[] feature_vector_files, String[] model_classifications_files, String weka_arff_file, String trained_classifiers_file) {
        try {
            this.prepareGUI();
            this.temp_files = new LinkedList();
            this.project = new Project(null, null, taxonomy_file, feature_key_files, feature_vector_files, model_classifications_files, null, null, trained_classifiers_file, weka_arff_file);
            this.project_files_dialog_box = new ProjectFilesDialogBox(this);
            this.project_files_dialog_box.parseAllFiles();
            this.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.getMessage() + " Unable to Initialize GUI with selected ACE XML files.", "ERROR", 0);
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.load_configuration_files_menu_item)) {
            this.project_files_dialog_box.setVisible(true);
        }
        if (event.getSource().equals(this.save_project_menu_item)) {
            this.saveProject();
        }
        if (event.getSource().equals(this.save_project_paths_menu_item)) {
            this.project_files_dialog_box.saveCurrentProject();
        }
        if (event.getSource().equals(this.about_menu_item)) {
            new AboutDialog((JFrame)this, "ACE 2.2.1", "Cory McKay (ACE 1.x) and Jessica Thompson (ACE 2.x)", "2010 (GNU GPL)", "McGill University");
        }
        if (event.getSource().equals(this.view_manual_menu_item)) {
            this.help_dialog.setVisible(true);
        }
        if (event.getSource().equals(this.quit_menu_item)) {
            if (this.zipfile_loaded) {
                this.project_files_dialog_box.saveZipPrompt();
            }
            this.deleteTempFiles();
            System.exit(0);
        }
        if (event.getSource().equals(this.load_zip_item)) {
            this.project_files_dialog_box.browsePath("ace_project", false);
            this.loadNewConfigurationFiles();
            this.zipfile_loaded = true;
        }
    }

    public void loadNewConfigurationFiles() {
        DataBoard temp_data_board = this.data_board;
        try {
            if (this.project_files_dialog_box.use_arff_rather_than_ace_xml) {
                this.data_board = new DataBoard(this.project.weka_arff_path);
            } else if (this.project.feature_settings_paths != null || this.project.feature_settings_paths != null || this.project.classification_paths != null || this.project.taxonomy_path != null) {
                String feature_definitions_path = null;
                String classifications_path = null;
                String[] feature_vectors_paths = null;
                String taxonomy_path = null;
                if (this.project.feature_settings_paths != null && this.project.feature_settings_paths.length > 0 && this.project.feature_settings_paths[0] != null) {
                    feature_definitions_path = this.project.feature_settings_paths[0];
                }
                if (this.project.classification_paths != null && this.project.classification_paths.length > 0 && this.project.classification_paths[0] != null) {
                    classifications_path = this.project.classification_paths[0];
                }
                if (this.project.feature_vectors_paths != null && this.project.feature_vectors_paths.length > 0 && this.project.feature_vectors_paths[0] != null) {
                    feature_vectors_paths = new String[]{this.project.feature_vectors_paths[0]};
                }
                if (this.project.taxonomy_path != null) {
                    taxonomy_path = this.project.taxonomy_path;
                }
                this.data_board = new DataBoard(taxonomy_path, feature_definitions_path, feature_vectors_paths, classifications_path);
            } else {
                this.data_board = new DataBoard();
            }
            this.taxonomy_panel.loadNewPanelContents();
            this.instances_panel.loadNewPanelContents();
            this.feature_definitions_panel.loadNewPanelContents();
            this.gui_preferences_panel.loadNewPanelContents(this.project.gui_preferences_path);
            this.classification_settings_panel.loadNewPanelContents(this.project.classifier_settings_path);
            this.experimentation_panel.loadNewPanelContents(this.project.trained_classifiers_path);
            this.project_previously_loaded = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Unable to load Configuration Files. " + e.getMessage(), "ERROR ", 0);
            this.data_board = temp_data_board;
        }
    }

    private void prepareGUI() {
        this.setTitle("ACE");
        this.content_pane = this.getContentPane();
        this.tabbed_pane = new JTabbedPane();
        this.load_configuration_files_menu_item = new JMenuItem("Load Configuration Files");
        this.load_configuration_files_menu_item.addActionListener(this);
        this.load_configuration_files_menu_item.setMnemonic('L');
        this.save_project_menu_item = new JMenuItem("Save Project");
        this.save_project_menu_item.addActionListener(this);
        this.save_project_menu_item.setMnemonic('S');
        this.save_project_paths_menu_item = new JMenuItem("Save Project Paths");
        this.save_project_paths_menu_item.addActionListener(this);
        this.save_project_paths_menu_item.setMnemonic('P');
        this.load_zip_item = new JMenuItem("Load ACE Zip File");
        this.load_zip_item.addActionListener(this);
        this.load_zip_item.setMnemonic('Z');
        this.quit_menu_item = new JMenuItem("Quit");
        this.quit_menu_item.addActionListener(this);
        this.quit_menu_item.setMnemonic('Q');
        this.file_menu = new JMenu("File");
        this.file_menu.setMnemonic('F');
        this.file_menu.add(this.load_configuration_files_menu_item);
        this.file_menu.add(this.save_project_menu_item);
        this.file_menu.add(this.save_project_paths_menu_item);
        this.file_menu.add(this.load_zip_item);
        this.file_menu.add(this.quit_menu_item);
        this.about_menu_item = new JMenuItem("About");
        this.about_menu_item.addActionListener(this);
        this.about_menu_item.setMnemonic('A');
        this.view_manual_menu_item = new JMenuItem("View Manual");
        this.view_manual_menu_item.addActionListener(this);
        this.view_manual_menu_item.setMnemonic('M');
        this.help_menu = new JMenu("Help");
        this.help_menu.setMnemonic('H');
        this.help_menu.add(this.about_menu_item);
        this.help_menu.add(this.view_manual_menu_item);
        this.menu_bar = new JMenuBar();
        this.menu_bar.add(this.file_menu);
        this.menu_bar.add(this.help_menu);
        this.setJMenuBar(this.menu_bar);
        this.taxonomy_panel = new TaxonomyPanel(this);
        this.tabbed_pane.addTab("Taxonomy", this.taxonomy_panel);
        this.feature_definitions_panel = new FeatureDefinitionsPanel(this);
        this.tabbed_pane.addTab("Features", this.feature_definitions_panel);
        this.instances_panel = new InstancesPanel(this);
        this.tabbed_pane.addTab("Instances", this.instances_panel);
        this.gui_preferences_panel = new GUIPreferencesPanel(this);
        this.tabbed_pane.addTab("Preferences", this.gui_preferences_panel);
        this.classification_settings_panel = new ClassificationSettingsPanel(this);
        this.tabbed_pane.addTab("Classification Settings", this.classification_settings_panel);
        this.experimentation_panel = new ExperimentationPanel(this);
        this.tabbed_pane.addTab("Experimenter", this.experimentation_panel);
        this.content_pane.add(this.tabbed_pane);
        this.tabbed_pane.setSelectedIndex(2);
        String help_path = "ProgramFiles" + File.separator + "Help" + File.separator;
        HelpDialog help_dialog = new HelpDialog(help_path + "contents.html", help_path + "title_page.html");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (MainGUIFrame.this.zipfile_loaded) {
                    MainGUIFrame.this.project_files_dialog_box.saveZipPrompt();
                }
                MainGUIFrame.this.deleteTempFiles();
                System.exit(0);
            }
        });
        this.setBounds(0, 0, 800, 600);
        this.project_previously_loaded = false;
    }

    private void saveProject() {
        this.project_files_dialog_box.saveCurrentProject();
        this.taxonomy_panel.saveAsFile(this.project.taxonomy_path);
        this.instances_panel.saveAsFeatureVectorsFile(this.project.feature_vectors_paths[0]);
        this.instances_panel.saveAsClassificationsFile(this.project.classification_paths[0]);
        this.feature_definitions_panel.saveAsFile(this.project.feature_settings_paths[0]);
        this.gui_preferences_panel.saveAsFile(this.project.gui_preferences_path);
        this.classification_settings_panel.saveAsFile(this.project.classifier_settings_path);
        this.experimentation_panel.saveAsFile(this.project.trained_classifiers_path);
    }

    private void deleteTempFiles() {
        if (this.temp_files != null) {
            for (int i = 0; i < this.temp_files.size(); ++i) {
                File to_del = new File(this.temp_files.get(i));
                if (to_del.isDirectory()) {
                    FileMethods.deleteDirectoryRecursively((File)to_del);
                    continue;
                }
                to_del.delete();
            }
        }
    }

    private void testStoredPaths() {
        System.out.println("project_path: " + this.project_files_dialog_box.project_path);
        System.out.println("use_arff_rather_than_ace_xml: " + this.project_files_dialog_box.use_arff_rather_than_ace_xml);
        System.out.println("taxonomy_path: " + this.project.taxonomy_path);
        System.out.println("feature_definitions_path: " + this.project.feature_settings_paths[0]);
        for (int i = 0; i < this.project.feature_vectors_paths.length; ++i) {
            System.out.println("feature_vectors_paths " + i + ": " + this.project.feature_vectors_paths[i]);
        }
        System.out.println("model_classifications_path: " + this.project.classification_paths[0]);
        System.out.println("gui_preferences_path: " + this.project.gui_preferences_path);
        System.out.println("classifier_settings_path: " + this.project.classifier_settings_path);
        System.out.println("trained_classifiers_path: " + this.project.trained_classifiers_path);
        System.out.println("arff_path: " + this.project.weka_arff_path);
    }
}

