/*
 * Decompiled with CFR 0.152.
 */
package ace.gui;

import ace.datatypes.Project;
import ace.gui.MainGUIFrame;
import ace.xmlparsers.ParseACEZipFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.filechooser.FileFilter;
import mckay.utilities.general.FileFilterImplementation;
import mckay.utilities.staticlibraries.FileMethods;
import mckay.utilities.staticlibraries.StringMethods;

public class ProjectFilesDialogBox
extends JFrame
implements ActionListener {
    public String project_path;
    public String zip_path;
    public boolean use_arff_rather_than_ace_xml;
    private MainGUIFrame parent;
    private String current_directory = ".";
    private JTextField project_field;
    private JTextField arff_field;
    private JTextField taxonomy_field;
    private JTextField feature_settings_field;
    private JList feature_vectors_field;
    private JTextField model_classifications_field;
    private JTextField gui_preferences_field;
    private JTextField classifier_settings_field;
    private JTextField trained_classifiers_field;
    private JCheckBox ace_xml_or_arff_checkbox;
    private JButton browse_project_button;
    private JButton browse_arff_button;
    private JButton browse_taxonomy_button;
    private JButton browse_feature_settings_file_button;
    private JButton add_feature_vectors_file_button;
    private JButton remove_feature_vectors_file_button;
    private JButton browse_model_classifications_file_button;
    private JButton browse_gui_preferences_button;
    private JButton browse_classifier_settings_button;
    private JButton browse_trained_classifiers_button;
    private JButton clear_button;
    private JButton new_project_button;
    private JButton save_this_project_button;
    private JButton save_as_defaults_button;
    private JButton cancel_button;
    private JButton ok_button;

    public ProjectFilesDialogBox(MainGUIFrame parent, String project_file_name) {
        this.prepareGUI(parent);
        try {
            parent.project.parseProjectFile(project_file_name);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR1", 0);
        }
    }

    public ProjectFilesDialogBox(MainGUIFrame parent) {
        this.prepareGUI(parent);
        if (new File("." + File.separator + "default_ace_project.xml").exists()) {
            try {
                parent.project.parseProjectFile("." + File.separator + "default_ace_project.xml");
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
            }
        } else {
            this.setTextFields(parent.project, null);
        }
        if (parent.project.feature_vectors_paths != null && parent.project.feature_vectors_paths.length != 0) {
            ProjectFilesDialogBox.clearJList(this.feature_vectors_field);
            for (int i = 0; i < parent.project.feature_vectors_paths.length; ++i) {
                ((DefaultListModel)this.feature_vectors_field.getModel()).addElement(parent.project.feature_vectors_paths[i]);
            }
        }
        this.updateCheckBox();
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.ace_xml_or_arff_checkbox)) {
            this.deactivateAppropriateGUIElements(this.ace_xml_or_arff_checkbox.isSelected());
        } else if (event.getSource().equals(this.browse_project_button)) {
            this.browsePath("ace_project", false);
        } else if (event.getSource().equals(this.browse_arff_button)) {
            this.browsePath("arff", false);
        } else if (event.getSource().equals(this.browse_taxonomy_button)) {
            this.browsePath("taxonomy", false);
        } else if (event.getSource().equals(this.browse_feature_settings_file_button)) {
            this.browsePath("feature_definitions", false);
        } else if (event.getSource().equals(this.add_feature_vectors_file_button)) {
            this.browsePath("feature_vectors", false);
        } else if (event.getSource().equals(this.remove_feature_vectors_file_button)) {
            ProjectFilesDialogBox.removeItemsFromPathList(this.feature_vectors_field);
        } else if (event.getSource().equals(this.browse_model_classifications_file_button)) {
            this.browsePath("model_classifications", false);
        } else if (event.getSource().equals(this.browse_gui_preferences_button)) {
            this.browsePath("gui_preferences", false);
        } else if (event.getSource().equals(this.browse_classifier_settings_button)) {
            this.browsePath("classifier_settings", false);
        } else if (event.getSource().equals(this.browse_trained_classifiers_button)) {
            this.browsePath("trained_classifiers", false);
        } else if (event.getSource().equals(this.clear_button)) {
            this.clearAllGUIFields();
        } else if (event.getSource().equals(this.new_project_button)) {
            this.startNewProject();
        } else if (event.getSource().equals(this.save_this_project_button)) {
            this.saveCurrentProject();
        } else if (event.getSource().equals(this.save_as_defaults_button)) {
            this.readFields();
            try {
                this.parent.project.saveProjectFile("." + File.separator + "default_ace_project.xml", true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Unable to save default project file. " + e.getMessage(), "ERROR", 0);
            }
        } else if (event.getSource().equals(this.cancel_button)) {
            this.cancel();
        } else if (event.getSource().equals(this.ok_button)) {
            this.parseAllFiles();
        }
    }

    public void parseAllFiles() {
        if (this.parent.project_previously_loaded) {
            int response = JOptionPane.showConfirmDialog(this, "This will erase any unsaved changes you have made to your project.\nDo you wish to proceed?", "Warning", 2, 2);
            if (response == 0) {
                this.readFields();
                this.parent.loadNewConfigurationFiles();
                this.setVisible(false);
            }
        } else {
            this.readFields();
            this.parent.loadNewConfigurationFiles();
            this.setVisible(false);
        }
    }

    public boolean browsePath(String what_to_browse, boolean called_externally) {
        String[] extension;
        JFileChooser browse_dialog = new JFileChooser(new File(this.current_directory));
        if (what_to_browse.equals("ace_project")) {
            extension = new String[]{"xml", "zip"};
            browse_dialog.setFileFilter((FileFilter)new FileFilterImplementation(extension));
        } else if (what_to_browse.equals("taxonomy") || what_to_browse.equals("feature_definitions") || what_to_browse.equals("feature_vectors") || what_to_browse.equals("model_classifications") || what_to_browse.equals("gui_preferences") || what_to_browse.equals("classifier_settings") || what_to_browse.equals("trained_classifiers")) {
            extension = new String[]{"xml"};
            browse_dialog.setFileFilter((FileFilter)new FileFilterImplementation(extension));
        } else if (what_to_browse.equals("arff")) {
            extension = new String[]{"arff"};
            browse_dialog.setFileFilter((FileFilter)new FileFilterImplementation(extension));
        } else {
            return false;
        }
        int browse_return = browse_dialog.showOpenDialog(this);
        if (browse_return == 0) {
            File selection = browse_dialog.getSelectedFile();
            this.current_directory = selection.getParentFile().getAbsolutePath();
            if (what_to_browse.equals("ace_project")) {
                String selected_project_file = selection.getPath();
                String ext = StringMethods.getExtension((String)selected_project_file);
                try {
                    if (ext.equals(".zip")) {
                        selected_project_file = ParseACEZipFile.parseZip(selected_project_file, "TEMP");
                        this.parent.temp_files.add("TEMP");
                        this.parent.zipfile_loaded = true;
                    }
                    this.parent.project = new Project();
                    this.parent.project.parseProjectFile(selected_project_file);
                    this.setTextFields(this.parent.project, selected_project_file);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "A problem occured while trying to load your ACE project. " + e.getMessage(), "zip/project ERROR", 0);
                }
            } else if (what_to_browse.equals("arff")) {
                this.arff_field.setText(selection.getPath());
            } else if (what_to_browse.equals("taxonomy")) {
                this.taxonomy_field.setText(selection.getPath());
            } else if (what_to_browse.equals("feature_definitions")) {
                this.feature_settings_field.setText(selection.getPath());
            } else if (what_to_browse.equals("feature_vectors")) {
                ((DefaultListModel)this.feature_vectors_field.getModel()).addElement(selection.getPath());
            } else if (what_to_browse.equals("model_classifications")) {
                this.model_classifications_field.setText(selection.getPath());
            } else if (what_to_browse.equals("gui_preferences")) {
                this.gui_preferences_field.setText(selection.getPath());
            } else if (what_to_browse.equals("classifier_settings")) {
                this.classifier_settings_field.setText(selection.getPath());
            } else if (what_to_browse.equals("trained_classifiers")) {
                this.trained_classifiers_field.setText(selection.getPath());
            }
            if (called_externally) {
                this.readFields();
            }
            return true;
        }
        return false;
    }

    public File saveFileExternally(String file_type, boolean can_erase) {
        JFileChooser save_dialog = new JFileChooser(new File(this.current_directory));
        int save_return = save_dialog.showSaveDialog(this);
        File selection = null;
        if (save_return == 0) {
            File temp_file = save_dialog.getSelectedFile();
            String path = temp_file.getPath();
            String ext = StringMethods.getExtension((String)path);
            if (ext == null) {
                path = path + ".xml";
                temp_file = new File(path);
            } else if (!ext.equals(".xml")) {
                path = StringMethods.removeExtension((String)path) + ".xml";
                temp_file = new File(path);
            }
            selection = FileMethods.getNewFileForWriting((String)path, (boolean)can_erase);
            if (selection != null) {
                if (file_type.equals("arff")) {
                    this.parent.project.weka_arff_path = path;
                    this.arff_field.setText(path);
                } else if (file_type.equals("taxonomy")) {
                    this.parent.project.taxonomy_path = path;
                    this.taxonomy_field.setText(path);
                } else if (file_type.equals("feature_definitions")) {
                    this.parent.project.feature_settings_paths = new String[1];
                    this.parent.project.feature_settings_paths[0] = path;
                    this.feature_settings_field.setText(path);
                } else if (file_type.equals("feature_vectors")) {
                    ((DefaultListModel)this.feature_vectors_field.getModel()).addElement(path);
                    ListModel feature_vector_model = this.feature_vectors_field.getModel();
                    this.parent.project.feature_vectors_paths = new String[feature_vector_model.getSize()];
                    for (int i = 0; i < this.parent.project.feature_vectors_paths.length; ++i) {
                        this.parent.project.feature_vectors_paths[i] = (String)feature_vector_model.getElementAt(i);
                    }
                } else if (file_type.equals("model_classifications")) {
                    this.parent.project.classification_paths = new String[1];
                    this.parent.project.classification_paths[0] = path;
                    this.model_classifications_field.setText(path);
                } else if (file_type.equals("gui_preferences")) {
                    this.parent.project.gui_preferences_path = path;
                    this.gui_preferences_field.setText(path);
                } else if (file_type.equals("classifier_settings")) {
                    this.parent.project.classifier_settings_path = path;
                    this.classifier_settings_field.setText(path);
                } else if (file_type.equals("trained_classifiers")) {
                    this.parent.project.trained_classifiers_path = path;
                    this.trained_classifiers_field.setText(path);
                }
            }
        }
        return selection;
    }

    public void saveCurrentProject() {
        if (this.project_field.getText().equals("")) {
            this.startNewProject();
        } else {
            try {
                this.readFields();
                this.parent.project.saveProjectFile(this.project_field.getText(), true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Unable to save project file for current project. " + e.getMessage(), "ERROR", 0);
            }
        }
    }

    public void startNewProject() {
        JFileChooser save_dialog = new JFileChooser(new File("."));
        save_dialog.setDialogTitle("Save New Project File");
        int save_return = save_dialog.showSaveDialog(this);
        if (save_return == 0) {
            File selection = save_dialog.getSelectedFile();
            String new_project_path = selection.getPath();
            String ext = StringMethods.getExtension((String)new_project_path);
            if (ext == null) {
                new_project_path = new_project_path + ".xml";
                selection = new File(new_project_path);
            } else if (!ext.equals(".xml")) {
                new_project_path = StringMethods.removeExtension((String)new_project_path) + ".xml";
                selection = new File(new_project_path);
            }
            try {
                if (selection.exists()) {
                    throw new Exception("Project file by same name already exists.");
                }
                int copy = JOptionPane.showConfirmDialog(null, "Do you wish to copy project files to new location?", "New Project", 0);
                if (copy == 0) {
                    int i;
                    String new_directory = StringMethods.removeExtension((String)new_project_path) + File.separator;
                    File new_directory_file = new File(new_directory);
                    if (new_directory_file.exists()) {
                        throw new Exception("Directory called " + new_directory + " already exists.");
                    }
                    new_directory_file.mkdir();
                    ListModel feature_vector_model = this.feature_vectors_field.getModel();
                    String[] current_feature_vector_paths = new String[feature_vector_model.getSize()];
                    for (int i2 = 0; i2 < current_feature_vector_paths.length; ++i2) {
                        current_feature_vector_paths[i2] = (String)feature_vector_model.getElementAt(i2);
                    }
                    String new_arff_path = new_directory + StringMethods.convertFilePathToFileName((String)this.arff_field.getText());
                    String new_taxonomy_path = new_directory + StringMethods.convertFilePathToFileName((String)this.taxonomy_field.getText());
                    String new_feature_definitions_path = new_directory + StringMethods.convertFilePathToFileName((String)this.feature_settings_field.getText());
                    String new_model_classifications_path = new_directory + StringMethods.convertFilePathToFileName((String)this.model_classifications_field.getText());
                    String new_gui_preferences_path = new_directory + StringMethods.convertFilePathToFileName((String)this.gui_preferences_field.getText());
                    String new_classifier_settings_path = new_directory + StringMethods.convertFilePathToFileName((String)this.classifier_settings_field.getText());
                    String new_trained_classifiers_path = new_directory + StringMethods.convertFilePathToFileName((String)this.trained_classifiers_field.getText());
                    String[] new_feature_vectors_paths = new String[current_feature_vector_paths.length];
                    if (current_feature_vector_paths != null) {
                        for (i = 0; i < current_feature_vector_paths.length; ++i) {
                            new_feature_vectors_paths[i] = new_directory + StringMethods.convertFilePathToFileName((String)current_feature_vector_paths[i]);
                        }
                    }
                    if (!this.arff_field.getText().equals("")) {
                        FileMethods.copyFile((String)this.arff_field.getText(), (String)new_arff_path);
                        this.arff_field.setText(new_arff_path);
                    }
                    if (!this.taxonomy_field.getText().equals("")) {
                        FileMethods.copyFile((String)this.taxonomy_field.getText(), (String)new_taxonomy_path);
                        this.taxonomy_field.setText(new_taxonomy_path);
                    }
                    if (!this.feature_settings_field.getText().equals("")) {
                        FileMethods.copyFile((String)this.feature_settings_field.getText(), (String)new_feature_definitions_path);
                        this.feature_settings_field.setText(new_feature_definitions_path);
                    }
                    if (!this.model_classifications_field.getText().equals("")) {
                        FileMethods.copyFile((String)this.model_classifications_field.getText(), (String)new_model_classifications_path);
                        this.model_classifications_field.setText(new_model_classifications_path);
                    }
                    if (!this.gui_preferences_field.getText().equals("")) {
                        FileMethods.copyFile((String)this.gui_preferences_field.getText(), (String)new_gui_preferences_path);
                        this.gui_preferences_field.setText(new_gui_preferences_path);
                    }
                    if (!this.classifier_settings_field.getText().equals("")) {
                        FileMethods.copyFile((String)this.classifier_settings_field.getText(), (String)new_classifier_settings_path);
                        this.classifier_settings_field.setText(new_classifier_settings_path);
                    }
                    if (!this.trained_classifiers_field.getText().equals("")) {
                        FileMethods.copyFile((String)this.trained_classifiers_field.getText(), (String)new_trained_classifiers_path);
                        this.trained_classifiers_field.setText(new_trained_classifiers_path);
                    }
                    if (current_feature_vector_paths != null) {
                        ProjectFilesDialogBox.clearJList(this.feature_vectors_field);
                        for (i = 0; i < current_feature_vector_paths.length; ++i) {
                            FileMethods.copyFile((String)current_feature_vector_paths[i], (String)new_feature_vectors_paths[i]);
                            ((DefaultListModel)this.feature_vectors_field.getModel()).addElement(new_feature_vectors_paths[i]);
                        }
                    }
                }
                this.parent.project.saveProjectFile(new_project_path, true);
                this.project_field.setText(new_project_path);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
            }
        }
    }

    public void saveZipPrompt() {
        File selection = null;
        try {
            int choice = JOptionPane.showConfirmDialog(this, "Do you wish to save zip project file before closing?", "Warning", 0, 2);
            if (choice == 0) {
                JFileChooser browse_dialog = new JFileChooser(this.current_directory);
                String[] extension = new String[]{"zip"};
                browse_dialog.setFileFilter((FileFilter)new FileFilterImplementation(extension));
                int save_return = browse_dialog.showSaveDialog(this);
                if (save_return == 0) {
                    selection = browse_dialog.getSelectedFile();
                    ParseACEZipFile.saveZip(this.parent.project.taxonomy_path, this.parent.project.feature_settings_paths, this.parent.project.feature_vectors_paths, this.parent.project.classification_paths, null, selection.getName(), null);
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Unable to save file " + selection.getName() + ".", "ERROR", 0);
        }
    }

    public void setTextFields(Project project, String project_path) {
        if (project_path != null) {
            this.project_field.setText(project_path);
        } else {
            this.project_field.setText("");
        }
        if (project.weka_arff_path != null) {
            this.arff_field.setText(project.weka_arff_path);
        } else {
            this.arff_field.setText("");
        }
        if (project.taxonomy_path != null) {
            this.taxonomy_field.setText(project.taxonomy_path);
        } else {
            this.taxonomy_field.setText("");
        }
        if (project.feature_settings_paths != null && project.feature_settings_paths[0] != null) {
            this.feature_settings_field.setText(project.feature_settings_paths[0]);
        } else {
            this.feature_settings_field.setText("");
        }
        if (project.feature_vectors_paths != null && project.feature_vectors_paths[0] != null) {
            ((DefaultListModel)this.feature_vectors_field.getModel()).addElement(project.feature_vectors_paths[0]);
        } else {
            ProjectFilesDialogBox.removeItemsFromPathList(this.feature_vectors_field);
        }
        if (project.classification_paths != null && project.classification_paths[0] != null) {
            this.model_classifications_field.setText(project.classification_paths[0]);
        } else {
            this.model_classifications_field.setText("");
        }
        if (project.gui_preferences_path != null) {
            this.gui_preferences_field.setText(project.gui_preferences_path);
        } else {
            this.gui_preferences_field.setText("");
        }
        if (project.classifier_settings_path != null) {
            this.classifier_settings_field.setText(project.classifier_settings_path);
        } else {
            this.classifier_settings_field.setText("");
        }
        if (project.trained_classifiers_path != null) {
            this.trained_classifiers_field.setText(project.trained_classifiers_path);
        } else {
            this.trained_classifiers_field.setText("");
        }
    }

    private void prepareGUI(MainGUIFrame parent) {
        this.parent = parent;
        this.setTitle("File Path Settings");
        int preferred_width = 350;
        int preferred_height = 20;
        int horizontal_gap = 6;
        int vertical_gap = 11;
        this.project_field = new JTextField();
        this.project_field.setEditable(false);
        this.project_field.setPreferredSize(new Dimension(preferred_width, preferred_height));
        this.arff_field = new JTextField();
        this.arff_field.setPreferredSize(new Dimension(preferred_width, preferred_height));
        this.taxonomy_field = new JTextField();
        this.taxonomy_field.setPreferredSize(new Dimension(preferred_width, preferred_height));
        this.feature_settings_field = new JTextField();
        this.feature_settings_field.setPreferredSize(new Dimension(preferred_width, preferred_height));
        this.feature_vectors_field = new JList(new DefaultListModel());
        this.model_classifications_field = new JTextField();
        this.model_classifications_field.setPreferredSize(new Dimension(preferred_width, preferred_height));
        this.gui_preferences_field = new JTextField();
        this.gui_preferences_field.setPreferredSize(new Dimension(preferred_width, preferred_height));
        this.classifier_settings_field = new JTextField();
        this.classifier_settings_field.setPreferredSize(new Dimension(preferred_width, preferred_height));
        this.trained_classifiers_field = new JTextField();
        this.trained_classifiers_field.setPreferredSize(new Dimension(preferred_width, preferred_height));
        this.browse_project_button = new JButton("Browse");
        this.browse_project_button.addActionListener(this);
        this.browse_arff_button = new JButton("Browse");
        this.browse_arff_button.addActionListener(this);
        this.browse_taxonomy_button = new JButton("Browse");
        this.browse_taxonomy_button.addActionListener(this);
        this.browse_feature_settings_file_button = new JButton("Browse");
        this.browse_feature_settings_file_button.addActionListener(this);
        this.add_feature_vectors_file_button = new JButton("Add");
        this.add_feature_vectors_file_button.addActionListener(this);
        this.remove_feature_vectors_file_button = new JButton("Remove");
        this.remove_feature_vectors_file_button.addActionListener(this);
        this.browse_model_classifications_file_button = new JButton("Browse");
        this.browse_model_classifications_file_button.addActionListener(this);
        this.browse_gui_preferences_button = new JButton("Browse");
        this.browse_gui_preferences_button.addActionListener(this);
        this.browse_classifier_settings_button = new JButton("Browse");
        this.browse_classifier_settings_button.addActionListener(this);
        this.browse_trained_classifiers_button = new JButton("Browse");
        this.browse_trained_classifiers_button.addActionListener(this);
        this.clear_button = new JButton("Clear Paths");
        this.clear_button.addActionListener(this);
        this.save_this_project_button = new JButton("Save Project Paths");
        this.save_this_project_button.addActionListener(this);
        this.save_as_defaults_button = new JButton("Save As Startup Defaults");
        this.save_as_defaults_button.addActionListener(this);
        this.new_project_button = new JButton("Start New Project");
        this.new_project_button.addActionListener(this);
        this.cancel_button = new JButton("Cancel");
        this.cancel_button.addActionListener(this);
        this.ok_button = new JButton("OK");
        this.ok_button.addActionListener(this);
        this.ace_xml_or_arff_checkbox = new JCheckBox("Use ARFF file rather than ACE XML files");
        this.ace_xml_or_arff_checkbox.addActionListener(this);
        Container content_pane = this.getContentPane();
        content_pane.setLayout(new BorderLayout(horizontal_gap, vertical_gap));
        JPanel sub_panel = new JPanel(new BorderLayout(horizontal_gap, vertical_gap));
        JPanel sub_panel_top = new JPanel(new GridLayout(4, 1, horizontal_gap, vertical_gap));
        JPanel sub_panel_bottom = new JPanel(new GridLayout(5, 1, horizontal_gap, vertical_gap));
        JPanel project_panel = new JPanel(new BorderLayout(horizontal_gap, vertical_gap));
        JPanel checkbox_panel = new JPanel(new BorderLayout(horizontal_gap, vertical_gap));
        JPanel arff_panel = new JPanel(new BorderLayout(horizontal_gap, vertical_gap));
        JPanel taxonomy_panel = new JPanel(new BorderLayout(horizontal_gap, vertical_gap));
        JPanel feature_settings_panel = new JPanel(new BorderLayout(horizontal_gap, vertical_gap));
        JPanel feature_vectors_panel = new JPanel(new BorderLayout(horizontal_gap, vertical_gap));
        JScrollPane scroll_pane = new JScrollPane(this.feature_vectors_field);
        scroll_pane.setPreferredSize(new Dimension(preferred_width, preferred_height));
        JPanel feature_vectors_panel_right = new JPanel(new GridLayout(2, 1));
        JPanel model_classifications_panel = new JPanel(new BorderLayout(horizontal_gap, vertical_gap));
        JPanel gui_preferences_panel = new JPanel(new BorderLayout(horizontal_gap, vertical_gap));
        JPanel classifier_settings_panel = new JPanel(new BorderLayout(horizontal_gap, vertical_gap));
        JPanel trained_classifiers_path_panel = new JPanel(new BorderLayout(horizontal_gap, vertical_gap));
        JPanel button_panel = new JPanel(new GridLayout(2, 3, horizontal_gap, vertical_gap));
        project_panel.add((Component)new JLabel("Project file:"), "North");
        project_panel.add((Component)this.project_field, "West");
        project_panel.add((Component)this.browse_project_button, "Center");
        sub_panel_top.add(project_panel);
        checkbox_panel.add((Component)this.ace_xml_or_arff_checkbox, "Center");
        sub_panel_top.add(checkbox_panel);
        taxonomy_panel.add((Component)new JLabel("Taxonomy file:"), "North");
        taxonomy_panel.add((Component)this.taxonomy_field, "West");
        taxonomy_panel.add((Component)this.browse_taxonomy_button, "Center");
        sub_panel_top.add(taxonomy_panel);
        feature_settings_panel.add((Component)new JLabel("Feature definitions file:"), "North");
        feature_settings_panel.add((Component)this.feature_settings_field, "West");
        feature_settings_panel.add((Component)this.browse_feature_settings_file_button, "Center");
        sub_panel_top.add(feature_settings_panel);
        sub_panel.add((Component)sub_panel_top, "North");
        feature_vectors_panel.add((Component)new JLabel("Feature vector files:"), "North");
        feature_vectors_panel_right.add(this.add_feature_vectors_file_button);
        feature_vectors_panel_right.add(this.remove_feature_vectors_file_button);
        feature_vectors_panel.add((Component)scroll_pane, "West");
        feature_vectors_panel.add((Component)feature_vectors_panel_right, "Center");
        sub_panel.add((Component)feature_vectors_panel, "Center");
        model_classifications_panel.add((Component)new JLabel("Model classifications file:"), "North");
        model_classifications_panel.add((Component)this.model_classifications_field, "West");
        model_classifications_panel.add((Component)this.browse_model_classifications_file_button, "Center");
        sub_panel_bottom.add(model_classifications_panel);
        gui_preferences_panel.add((Component)new JLabel("GUI preferences file:"), "North");
        gui_preferences_panel.add((Component)this.gui_preferences_field, "West");
        gui_preferences_panel.add((Component)this.browse_gui_preferences_button, "Center");
        sub_panel_bottom.add(gui_preferences_panel);
        classifier_settings_panel.add((Component)new JLabel("Classifier settings file:"), "North");
        classifier_settings_panel.add((Component)this.classifier_settings_field, "West");
        classifier_settings_panel.add((Component)this.browse_classifier_settings_button, "Center");
        sub_panel_bottom.add(classifier_settings_panel);
        trained_classifiers_path_panel.add((Component)new JLabel("Trained classifiers file:"), "North");
        trained_classifiers_path_panel.add((Component)this.trained_classifiers_field, "West");
        trained_classifiers_path_panel.add((Component)this.browse_trained_classifiers_button, "Center");
        sub_panel_bottom.add(trained_classifiers_path_panel);
        arff_panel.add((Component)new JLabel("Weka ARFF file:"), "North");
        arff_panel.add((Component)this.arff_field, "West");
        arff_panel.add((Component)this.browse_arff_button, "Center");
        sub_panel_bottom.add(arff_panel);
        sub_panel.add((Component)sub_panel_bottom, "South");
        content_pane.add((Component)sub_panel, "Center");
        button_panel.add(this.new_project_button);
        button_panel.add(this.save_this_project_button);
        button_panel.add(this.save_as_defaults_button);
        button_panel.add(this.cancel_button);
        button_panel.add(this.clear_button);
        button_panel.add(this.ok_button);
        content_pane.add((Component)button_panel, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ProjectFilesDialogBox.this.cancel();
            }
        });
        this.pack();
        this.setTextFields(parent.project, this.project_path);
        this.project_path = new String("");
        this.use_arff_rather_than_ace_xml = false;
    }

    private void readFields() {
        if (this.project_field.getText().length() > 0) {
            this.project_path = this.project_field.getText();
        }
        if (this.arff_field.getText().length() > 0) {
            this.parent.project.weka_arff_path = this.arff_field.getText();
        }
        if (this.taxonomy_field.getText().length() > 0) {
            this.parent.project.taxonomy_path = this.taxonomy_field.getText();
        }
        if (this.feature_settings_field.getText().length() > 0) {
            this.parent.project.feature_settings_paths = new String[1];
            this.parent.project.feature_settings_paths[0] = this.feature_settings_field.getText();
        }
        if (this.model_classifications_field.getText().length() > 0) {
            this.parent.project.classification_paths = new String[1];
            this.parent.project.classification_paths[0] = this.model_classifications_field.getText();
        }
        if (this.gui_preferences_field.getText().length() > 0) {
            this.parent.project.gui_preferences_path = this.gui_preferences_field.getText();
        }
        if (this.classifier_settings_field.getText().length() > 0) {
            this.parent.project.classifier_settings_path = this.classifier_settings_field.getText();
        }
        if (this.trained_classifiers_field.getText().length() > 0) {
            this.parent.project.trained_classifiers_path = this.trained_classifiers_field.getText();
        }
        ListModel feature_vector_model = this.feature_vectors_field.getModel();
        this.parent.project.feature_vectors_paths = new String[feature_vector_model.getSize()];
        for (int i = 0; i < this.parent.project.feature_vectors_paths.length; ++i) {
            String current = (String)feature_vector_model.getElementAt(i);
            if (current.length() <= 0) continue;
            this.parent.project.feature_vectors_paths[i] = current;
        }
        this.use_arff_rather_than_ace_xml = this.ace_xml_or_arff_checkbox.isSelected();
        this.parent.loadNewConfigurationFiles();
    }

    private void resetFields() {
        if (this.project_path != null) {
            this.project_field.setText(this.project_path);
        } else {
            this.project_field.setText("");
        }
        if (this.parent.project.weka_arff_path != null) {
            this.arff_field.setText(this.parent.project.weka_arff_path);
        } else {
            this.arff_field.setText("");
        }
        if (this.parent.project.taxonomy_path != null) {
            this.taxonomy_field.setText(this.parent.project.taxonomy_path);
        } else {
            this.taxonomy_field.setText("");
        }
        if (this.parent.project.feature_settings_paths != null && this.parent.project.feature_settings_paths[0] != null) {
            this.feature_settings_field.setText(this.parent.project.feature_settings_paths[0]);
        } else {
            this.feature_settings_field.setText("");
        }
        if (this.parent.project.classification_paths != null && this.parent.project.classification_paths[0] != null) {
            this.model_classifications_field.setText(this.parent.project.classification_paths[0]);
        } else {
            this.model_classifications_field.setText("");
        }
        if (this.parent.project.gui_preferences_path != null) {
            this.gui_preferences_field.setText(this.parent.project.gui_preferences_path);
        } else {
            this.gui_preferences_field.setText("");
        }
        if (this.parent.project.classifier_settings_path != null) {
            this.classifier_settings_field.setText(this.parent.project.classifier_settings_path);
        } else {
            this.classifier_settings_field.setText("");
        }
        if (this.parent.project.trained_classifiers_path != null) {
            this.trained_classifiers_field.setText(this.parent.project.trained_classifiers_path);
        } else {
            this.trained_classifiers_field.setText("");
        }
        DefaultListModel<String> feature_vectors_model = new DefaultListModel<String>();
        if (this.parent.project.feature_vectors_paths != null) {
            for (int i = 0; i < this.parent.project.feature_vectors_paths.length; ++i) {
                feature_vectors_model.addElement(this.parent.project.feature_vectors_paths[i]);
            }
        }
        this.feature_vectors_field.setModel(feature_vectors_model);
        this.ace_xml_or_arff_checkbox.setSelected(this.use_arff_rather_than_ace_xml);
        this.deactivateAppropriateGUIElements(this.use_arff_rather_than_ace_xml);
    }

    private void updateCheckBox() {
        boolean parsed_using_arff = true;
        if (this.arff_field.getText().equals("")) {
            parsed_using_arff = false;
        }
        this.ace_xml_or_arff_checkbox.setSelected(parsed_using_arff);
        this.deactivateAppropriateGUIElements(parsed_using_arff);
    }

    private void deactivateAppropriateGUIElements(boolean using_arff) {
        this.arff_field.setEnabled(using_arff);
        this.taxonomy_field.setEnabled(!using_arff);
        this.feature_settings_field.setEnabled(!using_arff);
        this.feature_vectors_field.setEnabled(!using_arff);
        this.model_classifications_field.setEnabled(!using_arff);
        this.browse_arff_button.setEnabled(using_arff);
        this.browse_taxonomy_button.setEnabled(!using_arff);
        this.browse_feature_settings_file_button.setEnabled(!using_arff);
        this.add_feature_vectors_file_button.setEnabled(!using_arff);
        this.remove_feature_vectors_file_button.setEnabled(!using_arff);
        this.browse_model_classifications_file_button.setEnabled(!using_arff);
    }

    private void clearAllGUIFields() {
        this.project_field.setText("");
        this.arff_field.setText("");
        this.taxonomy_field.setText("");
        this.feature_settings_field.setText("");
        this.model_classifications_field.setText("");
        this.gui_preferences_field.setText("");
        this.classifier_settings_field.setText("");
        this.trained_classifiers_field.setText("");
        ProjectFilesDialogBox.clearJList(this.feature_vectors_field);
    }

    private static void clearJList(JList list_to_clear) {
        int[] all_indices = new int[list_to_clear.getModel().getSize()];
        for (int i = 0; i < all_indices.length; ++i) {
            all_indices[i] = i;
        }
        list_to_clear.setSelectedIndices(all_indices);
        ProjectFilesDialogBox.removeItemsFromPathList(list_to_clear);
    }

    private static void removeItemsFromPathList(JList list) {
        Object[] selected_objects = list.getSelectedValues();
        DefaultListModel model = (DefaultListModel)list.getModel();
        for (int i = 0; i < selected_objects.length; ++i) {
            model.removeElement(selected_objects[i]);
        }
    }

    private void cancel() {
        this.resetFields();
        this.setVisible(false);
    }
}

