/*
 * Decompiled with CFR 0.152.
 */
package ace.gui;

import ace.datatypes.Taxonomy;
import ace.gui.MainGUIFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import mckay.utilities.staticlibraries.FileMethods;
import mckay.utilities.staticlibraries.SortingMethods;

public class TaxonomyPanel
extends JPanel
implements ActionListener {
    private MainGUIFrame parent;
    private JTree taxonomy_display;
    private JPanel tree_display_panel;
    private JPanel ancestry_display_panel;
    private JPanel button_panel;
    private JScrollPane taxonomy_display_scroll_pane;
    private JTextField status_bar;
    private JButton display_hierarchy_button;
    private JButton display_ancestry_button;
    private JButton new_taxonomy_button;
    private JButton load_taxonomy_button;
    private JButton save_taxonomy_button;
    private JButton save_taxonomy_as_button;
    private JButton add_new_sibling_category_button;
    private JButton add_new_child_category_button;
    private JButton delete_branch_button;

    public TaxonomyPanel(MainGUIFrame parent_frame) {
        this.parent = parent_frame;
        this.setLayout(new BorderLayout());
        int horizontal_gap = 4;
        int vertical_gap = 4;
        this.status_bar = new JTextField("");
        this.status_bar.setEditable(false);
        this.add((Component)this.status_bar, "South");
        this.button_panel = new JPanel(new GridLayout(18, 1, horizontal_gap, vertical_gap));
        this.display_hierarchy_button = new JButton("Display Hierarchy");
        this.display_hierarchy_button.setEnabled(false);
        this.display_ancestry_button = new JButton("Display Ancestry");
        this.new_taxonomy_button = new JButton("New Taxonomy");
        this.load_taxonomy_button = new JButton("Load Taxonomy");
        this.save_taxonomy_button = new JButton("Save Taxonomy");
        this.save_taxonomy_as_button = new JButton("Save Taxonomy As");
        this.add_new_sibling_category_button = new JButton("Add New Sibling Category");
        this.add_new_child_category_button = new JButton("Add New Child Category");
        this.delete_branch_button = new JButton("Delete Branch");
        this.display_hierarchy_button.addActionListener(this);
        this.display_ancestry_button.addActionListener(this);
        this.new_taxonomy_button.addActionListener(this);
        this.load_taxonomy_button.addActionListener(this);
        this.save_taxonomy_button.addActionListener(this);
        this.save_taxonomy_as_button.addActionListener(this);
        this.add_new_sibling_category_button.addActionListener(this);
        this.add_new_child_category_button.addActionListener(this);
        this.delete_branch_button.addActionListener(this);
        this.button_panel.add(this.display_hierarchy_button);
        this.button_panel.add(this.display_ancestry_button);
        this.button_panel.add(new JLabel(""));
        this.button_panel.add(this.new_taxonomy_button);
        this.button_panel.add(this.load_taxonomy_button);
        this.button_panel.add(this.save_taxonomy_button);
        this.button_panel.add(this.save_taxonomy_as_button);
        this.button_panel.add(new JLabel(""));
        this.button_panel.add(this.add_new_sibling_category_button);
        this.button_panel.add(this.add_new_child_category_button);
        this.button_panel.add(this.delete_branch_button);
        this.add((Component)this.button_panel, "East");
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.display_hierarchy_button)) {
            this.displayTaxonomyHierarchically();
        }
        if (event.getSource().equals(this.display_ancestry_button)) {
            this.displayAncestryTree();
        } else if (event.getSource().equals(this.new_taxonomy_button)) {
            this.newTaxonomy();
        } else if (event.getSource().equals(this.load_taxonomy_button)) {
            this.browseNewTaxonomy();
        } else if (event.getSource().equals(this.save_taxonomy_button)) {
            this.saveAsFile(this.parent.project.taxonomy_path);
        } else if (event.getSource().equals(this.save_taxonomy_as_button)) {
            this.saveAsFileWithBrowse();
        } else if (event.getSource().equals(this.add_new_sibling_category_button)) {
            this.addNewNode(false);
        } else if (event.getSource().equals(this.add_new_child_category_button)) {
            this.addNewNode(true);
        } else if (event.getSource().equals(this.delete_branch_button)) {
            this.deleteBranch();
        }
    }

    public void loadNewPanelContents() {
        if (this.parent.data_board.taxonomy == null) {
            this.newTaxonomy();
        } else {
            this.displayTaxonomyHierarchically();
        }
    }

    public void saveAsFile(String save_path) {
        if (!save_path.equals("")) {
            File save_file = FileMethods.getNewFileForWriting((String)save_path, (boolean)true);
            Taxonomy.setRootName(this.parent.data_board.taxonomy, save_file.getPath());
            try {
                Taxonomy.saveTaxonomy(this.parent.data_board.taxonomy, save_file, "");
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
            }
        } else {
            this.saveAsFileWithBrowse();
        }
    }

    private void newTaxonomy() {
        DefaultMutableTreeNode new_node = new DefaultMutableTreeNode("New Taxonomy");
        DefaultTreeModel taxonomy_tree = new DefaultTreeModel(new_node);
        this.parent.data_board.taxonomy = new Taxonomy(taxonomy_tree);
        this.taxonomy_display = new JTree(taxonomy_tree);
        this.setTreeIcons(this.taxonomy_display, new String("." + File.separator + "ProgramFiles" + File.separator + "bluebull.gif"), new String("." + File.separator + "ProgramFiles" + File.separator + "beigebull.gif"));
        this.taxonomy_display.setEditable(true);
        Object[] nodes = taxonomy_tree.getPathToRoot(new_node);
        TreePath path = new TreePath(nodes);
        this.taxonomy_display.setSelectionPath(path);
        this.displayTaxonomyHierarchically();
    }

    private void browseNewTaxonomy() {
        boolean ok_pressed = this.parent.project_files_dialog_box.browsePath("taxonomy", true);
        if (ok_pressed) {
            String taxonomy_path = this.parent.project.taxonomy_path;
            try {
                this.parent.data_board.taxonomy = Taxonomy.parseTaxonomyFile(taxonomy_path);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
            }
            this.loadNewPanelContents();
        }
    }

    private void saveAsFileWithBrowse() {
        File save_file = this.parent.project_files_dialog_box.saveFileExternally("taxonomy", false);
        if (save_file != null) {
            Taxonomy.setRootName(this.parent.data_board.taxonomy, save_file.getPath());
            try {
                Taxonomy.saveTaxonomy(this.parent.data_board.taxonomy, save_file, "");
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
            }
        }
        this.repaint();
        this.parent.repaint();
    }

    private void displayTaxonomyHierarchically() {
        if (this.tree_display_panel != null) {
            this.remove(this.tree_display_panel);
        }
        if (this.ancestry_display_panel != null) {
            this.remove(this.ancestry_display_panel);
        }
        this.parent.data_board.taxonomy.taxonomy = new DefaultTreeModel(SortingMethods.sortTree((DefaultMutableTreeNode)((DefaultMutableTreeNode)this.parent.data_board.taxonomy.taxonomy.getRoot())));
        this.taxonomy_display = new JTree(this.parent.data_board.taxonomy.taxonomy);
        this.setTreeIcons(this.taxonomy_display, new String("." + File.separator + "ProgramFiles" + File.separator + "bluebull.gif"), new String("." + File.separator + "ProgramFiles" + File.separator + "beigebull.gif"));
        this.taxonomy_display.setEditable(true);
        TaxonomyPanel.expandTree(this.taxonomy_display);
        this.updateStatusBar(null);
        this.taxonomy_display_scroll_pane = new JScrollPane(this.taxonomy_display);
        this.tree_display_panel = new JPanel(new GridLayout(1, 1));
        this.tree_display_panel.add(this.taxonomy_display_scroll_pane);
        this.add((Component)this.tree_display_panel, "Center");
        this.repaint();
        this.parent.repaint();
        this.display_hierarchy_button.setEnabled(false);
        this.display_ancestry_button.setEnabled(true);
        this.new_taxonomy_button.setEnabled(true);
        this.load_taxonomy_button.setEnabled(true);
        this.save_taxonomy_button.setEnabled(true);
        this.save_taxonomy_as_button.setEnabled(true);
        this.add_new_sibling_category_button.setEnabled(true);
        this.add_new_child_category_button.setEnabled(true);
        this.delete_branch_button.setEnabled(true);
    }

    private void displayAncestryTree() {
        if (((DefaultMutableTreeNode)this.parent.data_board.taxonomy.taxonomy.getRoot()).getChildCount() != 0) {
            if (this.tree_display_panel != null) {
                this.remove(this.tree_display_panel);
            }
            if (this.ancestry_display_panel != null) {
                this.remove(this.ancestry_display_panel);
            }
            DefaultTreeModel ancestry = this.getAncestorTree();
            ancestry = new DefaultTreeModel(SortingMethods.sortTree((DefaultMutableTreeNode)((DefaultMutableTreeNode)ancestry.getRoot())));
            JTree anestry_display = new JTree(ancestry);
            this.setTreeIcons(anestry_display, new String("." + File.separator + "ProgramFiles" + File.separator + "bluebull.gif"), new String("." + File.separator + "ProgramFiles" + File.separator + "beigebull.gif"));
            TaxonomyPanel.expandTree(anestry_display);
            this.updateStatusBar((DefaultMutableTreeNode)ancestry.getRoot());
            JScrollPane ancesty_display_scroll_pane = new JScrollPane(anestry_display);
            this.ancestry_display_panel = new JPanel(new GridLayout(1, 1));
            this.ancestry_display_panel.add(ancesty_display_scroll_pane);
            this.add((Component)this.ancestry_display_panel, "Center");
            this.repaint();
            this.parent.repaint();
            this.display_hierarchy_button.setEnabled(true);
            this.display_ancestry_button.setEnabled(false);
            this.new_taxonomy_button.setEnabled(false);
            this.load_taxonomy_button.setEnabled(false);
            this.save_taxonomy_button.setEnabled(false);
            this.save_taxonomy_as_button.setEnabled(false);
            this.add_new_sibling_category_button.setEnabled(false);
            this.add_new_child_category_button.setEnabled(false);
            this.delete_branch_button.setEnabled(false);
        }
    }

    private void updateStatusBar(DefaultMutableTreeNode root) {
        if (root == null) {
            int number_parent_categories = ((DefaultMutableTreeNode)this.parent.data_board.taxonomy.taxonomy.getRoot()).getChildCount();
            this.status_bar.setText(new String(number_parent_categories + " top-level categories"));
        } else {
            int number_parent_categories = root.getChildCount();
            this.status_bar.setText(new String(number_parent_categories + " leaf categories"));
        }
    }

    private DefaultTreeModel getAncestorTree() {
        Object root_label_of_taxonomy = ((DefaultMutableTreeNode)this.parent.data_board.taxonomy.taxonomy.getRoot()).getUserObject();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(root_label_of_taxonomy);
        String[][] ancestry = this.parent.data_board.taxonomy.getLeafsAndTheirParents();
        for (int i = 0; i < ancestry.length; ++i) {
            DefaultMutableTreeNode parent = new DefaultMutableTreeNode(ancestry[i][0]);
            for (int j = 1; j < ancestry[i].length; ++j) {
                parent.add(new DefaultMutableTreeNode(ancestry[i][j]));
            }
            root.add(parent);
        }
        return new DefaultTreeModel(root);
    }

    private void addNewNode(boolean child) {
        DefaultMutableTreeNode selected_node = (DefaultMutableTreeNode)this.taxonomy_display.getLastSelectedPathComponent();
        if (selected_node == null) {
            return;
        }
        DefaultMutableTreeNode new_node = new DefaultMutableTreeNode("New Category");
        if (child) {
            this.parent.data_board.taxonomy.taxonomy.insertNodeInto(new_node, selected_node, selected_node.getChildCount());
        } else {
            DefaultMutableTreeNode tree_parent = (DefaultMutableTreeNode)selected_node.getParent();
            if (tree_parent != null) {
                int selected_index = tree_parent.getIndex(selected_node);
                this.parent.data_board.taxonomy.taxonomy.insertNodeInto(new_node, tree_parent, selected_index + 1);
            }
        }
        Object[] nodes = this.parent.data_board.taxonomy.taxonomy.getPathToRoot(new_node);
        TreePath path = new TreePath(nodes);
        this.taxonomy_display.scrollPathToVisible(path);
        this.updateStatusBar(null);
    }

    private void deleteBranch() {
        DefaultMutableTreeNode selected_node = (DefaultMutableTreeNode)this.taxonomy_display.getLastSelectedPathComponent();
        if (selected_node == null) {
            return;
        }
        if (selected_node.getParent() != null) {
            this.parent.data_board.taxonomy.taxonomy.removeNodeFromParent(selected_node);
        }
        this.updateStatusBar(null);
    }

    private void setTreeIcons(JTree tree, String leaf_icon_path, String non_leaf_icon_path) {
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setLeafIcon(new ImageIcon(leaf_icon_path));
        renderer.setOpenIcon(new ImageIcon(non_leaf_icon_path));
        renderer.setClosedIcon(new ImageIcon(non_leaf_icon_path));
        tree.setCellRenderer(renderer);
    }

    private static void expandTree(JTree tree) {
        for (int row = 0; row < tree.getRowCount(); ++row) {
            tree.expandRow(row);
        }
    }
}

