/*
 * Decompiled with CFR 0.152.
 */
package ace.xmlparsers;

import ace.datatypes.Project;
import ace.xmlparsers.XMLDocumentParser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import mckay.utilities.staticlibraries.FileMethods;
import mckay.utilities.staticlibraries.StringMethods;

public class ParseACEZipFile {
    public static String parseZip(String zipfile, String destination) throws Exception {
        boolean can_erase = false;
        File zip = new File(zipfile);
        String zippath = zip.getAbsolutePath();
        ParseACEZipFile.decompress(zippath, destination, can_erase);
        String project_file_path = ParseACEZipFile.parseSp(destination);
        Project newpaths = new Project();
        newpaths.parseProjectFile(project_file_path);
        newpaths.saveUnzippedProjectFile(destination, project_file_path);
        return project_file_path;
    }

    public static void saveZip(String taxonomy_path, String[] feature_defs_paths, String[] data_set_paths, String[] classification_paths, String[] other_paths, String zipfile, String project_file) throws Exception {
        int i;
        if (project_file == null) {
            project_file = StringMethods.removeExtension((String)zipfile) + ".xml";
        } else {
            int sep = project_file.lastIndexOf(File.separator);
            if (sep > -1 && sep < project_file.length()) {
                project_file = project_file.substring(sep + 1);
            }
        }
        int array_length = 2;
        boolean ace_xml = true;
        if (taxonomy_path != null) {
            ++array_length;
        }
        if (classification_paths != null) {
            array_length += classification_paths.length;
        }
        if (feature_defs_paths != null) {
            array_length += feature_defs_paths.length;
        }
        if (data_set_paths != null) {
            array_length += data_set_paths.length;
        }
        if (other_paths != null) {
            array_length += other_paths.length;
        }
        if (array_length == 2) {
            throw new Exception("No files were specified to be zipped!");
        }
        if (other_paths != null && taxonomy_path == null && classification_paths == null && feature_defs_paths == null && data_set_paths == null) {
            array_length -= 2;
            ace_xml = false;
        }
        String[] filesToZip = new String[array_length];
        int current = 0;
        if (taxonomy_path != null) {
            filesToZip[0] = taxonomy_path;
            ++current;
        }
        if (classification_paths != null) {
            System.arraycopy(classification_paths, 0, filesToZip, current, classification_paths.length);
            current += classification_paths.length;
        }
        if (feature_defs_paths != null) {
            System.arraycopy(feature_defs_paths, 0, filesToZip, current, feature_defs_paths.length);
            current += feature_defs_paths.length;
        }
        if (data_set_paths != null) {
            System.arraycopy(data_set_paths, 0, filesToZip, current, data_set_paths.length);
            current += data_set_paths.length;
        }
        if (other_paths != null) {
            System.arraycopy(other_paths, 0, filesToZip, current, other_paths.length);
        }
        File projfile = null;
        File special = null;
        if (ace_xml) {
            String project_path;
            Project proj = new Project(project_file, null, taxonomy_path, feature_defs_paths, data_set_paths, classification_paths, null, null, null, null);
            filesToZip[filesToZip.length - 2] = project_path = proj.saveProjectFile(project_file, true);
            projfile = new File(project_path);
            filesToZip[filesToZip.length - 1] = ParseACEZipFile.writeSp(project_file);
        }
        boolean[] pwd = new boolean[filesToZip.length];
        String sep = File.separator;
        for (i = 0; i < filesToZip.length && filesToZip[i] != null; ++i) {
            int index;
            pwd[i] = true;
            if (!filesToZip[i].contains(sep) || (index = filesToZip[i].lastIndexOf(sep)) <= 0) continue;
            String outfile = filesToZip[i].substring(index);
            File outFile = new File(outfile);
            if (!outFile.exists()) {
                pwd[i] = false;
                FileMethods.copyFile((String)filesToZip[i], (String)outfile);
            } else {
                pwd[i] = true;
            }
            filesToZip[i] = outfile;
        }
        ParseACEZipFile.compress(filesToZip, zipfile);
        if (ace_xml) {
            special = new File("project.sp");
            projfile.delete();
            special.delete();
        }
        for (i = 0; i < filesToZip.length && filesToZip[i] != null; ++i) {
            if (pwd[i]) continue;
            File temp = new File(filesToZip[i]);
            temp.delete();
        }
    }

    public static void saveZip(String project_path, String zip_path) throws Exception {
        String[] other_paths = null;
        Project save = new Project();
        save.parseProjectFile(project_path);
        ParseACEZipFile.saveZip(save.taxonomy_path, save.feature_settings_paths, save.feature_vectors_paths, save.classification_paths, other_paths, zip_path, project_path);
    }

    public static void saveZip(String[] files2, String name) throws Exception {
        String[] files = ParseACEZipFile.getFiles(files2);
        String project = null;
        String taxonomy_path = null;
        LinkedList<String> feature_definitions_paths = new LinkedList<String>();
        LinkedList<String> feature_vectors_paths = new LinkedList<String>();
        LinkedList<String> classifications_paths = new LinkedList<String>();
        LinkedList<String> other_paths = new LinkedList<String>();
        for (int i = 0; i < files.length; ++i) {
            String type = XMLDocumentParser.getFileType(files[i]);
            if (type.equals("taxonomy_file")) {
                if (taxonomy_path != null) {
                    throw new Exception("Only one ACE XML taxonomy file may be included in an ACE zip file.");
                }
                taxonomy_path = files[i];
                continue;
            }
            if (type.equals("feature_vector_file")) {
                feature_vectors_paths.add(files[i]);
                continue;
            }
            if (type.equals("feature_key_file")) {
                feature_definitions_paths.add(files[i]);
                continue;
            }
            if (type.equals("classifications_file")) {
                classifications_paths.add(files[i]);
                continue;
            }
            if (type.equals("project_file")) {
                project = files[i];
                continue;
            }
            other_paths.add(files[i]);
        }
        if (project != null && files.length == 1) {
            ParseACEZipFile.saveZip(project, name);
        }
        String[] fdefs_paths = feature_definitions_paths.toArray(new String[0]);
        String[] fvec_paths = feature_vectors_paths.toArray(new String[0]);
        String[] class_paths = classifications_paths.toArray(new String[0]);
        String[] oth_paths = other_paths.toArray(new String[0]);
        if (fdefs_paths.length == 0) {
            fdefs_paths = null;
        }
        if (fvec_paths.length == 0) {
            fvec_paths = null;
        }
        if (class_paths.length == 0) {
            class_paths = null;
        }
        if (oth_paths.length == 0) {
            oth_paths = null;
        }
        if (files.length <= 1 && project != null) {
            throw new Exception("Please specify more than one file or an ACE project file to include in the ACE zip file.");
        }
        ParseACEZipFile.saveZip(taxonomy_path, fdefs_paths, fvec_paths, class_paths, oth_paths, name, project);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] extract(String file_name, String zip_file, String file_type, String destpath) throws Exception {
        String[] files_to_extract = null;
        try {
            File zipfile = new File(zip_file);
            File unzipDestinationDirectory = new File(destpath);
            unzipDestinationDirectory.mkdir();
            ZipFile zipFile = new ZipFile(zipfile, 1);
            if (file_type != null) {
                if (file_type.equals("project_file")) {
                    String project_file = ParseACEZipFile.getProjectFile(zipFile);
                    files_to_extract = new String[]{project_file};
                    return ParseACEZipFile.decompress(destpath, files_to_extract, zipFile);
                } else if (file_type.equals("taxonomy_file") || file_type.equals("feature_key_file") || file_type.equals("feature_vector_file") || file_type.equals("classifications_file")) {
                    String[] extracted = ParseACEZipFile.extract(null, zip_file, "project_file", destpath);
                    String proj_path = null;
                    if (extracted == null || extracted.length <= 0 || extracted[0] == null) {
                        throw new Exception("Unable extract ACE Project file.");
                    }
                    proj_path = destpath + File.separator + extracted[0];
                    Project project = new Project();
                    project.parseProjectFile(proj_path);
                    project.saveUnzippedProjectFile(destpath, proj_path);
                    if (file_type.equals("taxonomy_file")) {
                        files_to_extract = new String[]{project.taxonomy_path};
                    } else if (file_type.equals("feature_key_file")) {
                        files_to_extract = project.feature_settings_paths;
                    } else if (file_type.equals("feature_vector_file")) {
                        files_to_extract = project.feature_vectors_paths;
                    } else if (file_type.equals("classifications_file")) {
                        files_to_extract = project.classification_paths;
                    }
                    project.delete();
                    return ParseACEZipFile.decompress(destpath, files_to_extract, zipFile);
                } else {
                    if (!file_type.equals("unknown")) throw new Exception(file_type + " is not a valid file type. ");
                    files_to_extract = new String[1];
                }
                return ParseACEZipFile.decompress(destpath, files_to_extract, zipFile);
            } else {
                files_to_extract = new String[]{file_name};
            }
            return ParseACEZipFile.decompress(destpath, files_to_extract, zipFile);
        }
        catch (IOException ioe) {
            throw new Exception("IO Exception: An error occured while trying to extract from " + zip_file + ". ");
        }
    }

    public static void add(String zip_file, String[] files) throws Exception {
        String dest_path = "tempzip";
        boolean can_erase = false;
        ParseACEZipFile.decompress(zip_file, dest_path, can_erase);
        String[] files_to_zip = new String[files.length + 1];
        System.arraycopy(files, 0, files_to_zip, 0, files.length);
        files_to_zip[files_to_zip.length - 1] = dest_path;
        ParseACEZipFile.saveZip(files_to_zip, zip_file);
        File temp = new File("tempzip");
        FileMethods.deleteDirectoryRecursively((File)temp);
    }

    private static String parseSp(String zipdirectory) throws Exception, IOException {
        String project_path = null;
        String sep = File.separator;
        BufferedReader in = new BufferedReader(new FileReader(zipdirectory + sep + "project.sp"));
        project_path = zipdirectory + sep + in.readLine();
        in.close();
        return project_path;
    }

    private static String writeSp(String projpath) throws Exception {
        Object sp_path = null;
        try {
            File sp = new File("project.sp");
            sp.delete();
            sp.createNewFile();
            FileWriter out = new FileWriter(sp);
            out.write(projpath);
            out.flush();
            out.close();
        }
        catch (IOException ioe) {
            throw new IOException("I/O error " + ioe.getMessage());
        }
        return "project.sp";
    }

    private static void compress(String[] toZip, String nameofZip) throws Exception {
        try {
            File zip = new File(nameofZip);
            zip.delete();
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(nameofZip));
            byte[] buffer = new byte[18024];
            out.setLevel(-1);
            for (int i = 0; i < toZip.length && toZip[i] != null; ++i) {
                int len;
                FileInputStream in = new FileInputStream(toZip[i]);
                out.putNextEntry(new ZipEntry(toZip[i]));
                while ((len = in.read(buffer)) > 0) {
                    out.write(buffer, 0, len);
                }
                out.closeEntry();
                in.close();
            }
            out.close();
        }
        catch (IllegalArgumentException iae) {
            throw new Exception("Illegal Arguments encountered" + iae.getMessage());
        }
        catch (FileNotFoundException fnfe) {
            throw new Exception("file was not found" + fnfe.getMessage());
        }
        catch (IOException ioe) {
            throw new Exception("I/O error" + ioe.getMessage());
        }
    }

    private static void decompress(String zippath, String destpath, boolean can_erase) throws Exception {
        int BUFFER = 2048;
        try {
            File zipfile = new File(zippath);
            File unzipDestinationDirectory = new File(destpath);
            unzipDestinationDirectory.mkdir();
            ZipFile zipFile = new ZipFile(zipfile, 1);
            Enumeration<? extends ZipEntry> zipFileEntries = zipFile.entries();
            while (zipFileEntries.hasMoreElements()) {
                int currentByte;
                ZipEntry entry = zipFileEntries.nextElement();
                String currentEntry = entry.getName();
                File destFile = new File(unzipDestinationDirectory, currentEntry);
                BufferedInputStream is = new BufferedInputStream(zipFile.getInputStream(entry));
                byte[] data = new byte[2048];
                FileOutputStream fos = new FileOutputStream(destFile);
                BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
                while ((currentByte = is.read(data, 0, 2048)) != -1) {
                    dest.write(data, 0, currentByte);
                }
                dest.flush();
                dest.close();
                is.close();
            }
            zipFile.close();
        }
        catch (IOException ioe) {
            throw new IOException("I/O error " + ioe.getMessage());
        }
    }

    private static String[] decompress(String destpath, String[] files_to_extract, ZipFile zipFile) throws Exception {
        int BUFFER = 2048;
        try {
            Enumeration<? extends ZipEntry> zipFileEntries = zipFile.entries();
            boolean found = false;
            for (int i = 0; i < files_to_extract.length; ++i) {
                found = false;
                String file = files_to_extract[i];
                if (file.contains(File.separator)) {
                    file = file.substring(file.lastIndexOf(File.separator) + 1);
                }
                while (zipFileEntries.hasMoreElements() && !found) {
                    int currentByte;
                    ZipEntry current_entry = zipFileEntries.nextElement();
                    String compare = current_entry.getName();
                    if (!compare.endsWith(file)) continue;
                    found = true;
                    boolean can_erase = false;
                    File destFile = FileMethods.getNewFileForWriting((String)(destpath + File.separator + file), (boolean)can_erase);
                    if (destFile == null) {
                        throw new Exception("File " + file + " was not extracted because a file with that name already exists in " + destpath + ".\n");
                    }
                    BufferedInputStream is = new BufferedInputStream(zipFile.getInputStream(current_entry));
                    byte[] data = new byte[2048];
                    FileOutputStream fos = new FileOutputStream(destFile);
                    BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
                    while ((currentByte = is.read(data, 0, 2048)) != -1) {
                        dest.write(data, 0, currentByte);
                    }
                    dest.flush();
                    dest.close();
                    is.close();
                }
                if (found) continue;
                throw new Exception("Unable to find " + file + ".\n");
            }
            zipFile.close();
            return files_to_extract;
        }
        catch (IOException ioe) {
            throw new IOException("I/O error" + ioe.getMessage());
        }
    }

    private static String[] getFiles(String[] paths) {
        LinkedList<String> files = new LinkedList<String>();
        for (int i = 0; i < paths.length; ++i) {
            File current = new File(paths[i]);
            if (current.isDirectory()) {
                String[] x = ParseACEZipFile.getFiles(current.list());
                for (int j = 0; j < x.length; ++j) {
                    files.add(current.getName() + File.separator + x[j]);
                }
                continue;
            }
            if (current.getName().startsWith(".")) continue;
            files.add(paths[i]);
        }
        return files.toArray(new String[1]);
    }

    private static String getProjectFile(ZipFile zipFile) throws Exception {
        try {
            Enumeration<? extends ZipEntry> zipFileEntries = zipFile.entries();
            String project_path = "";
            boolean sp_found = false;
            while (zipFileEntries.hasMoreElements() && !sp_found) {
                ZipEntry entry = zipFileEntries.nextElement();
                String currentEntry = entry.getName();
                int start = currentEntry.lastIndexOf(".");
                String ext = StringMethods.getExtension((String)currentEntry);
                if (start == -1 || ext == null || !ext.equals(".sp")) continue;
                sp_found = true;
                InputStream in = zipFile.getInputStream(entry);
                project_path = "";
                InputStreamReader isr = new InputStreamReader(in);
                BufferedReader br = new BufferedReader(isr);
                project_path = br.readLine();
                in.close();
                isr.close();
                br.close();
                if (project_path != null && !project_path.equals("")) continue;
                throw new Exception("Unable to extract project file. Error in .sp file.");
            }
            return project_path;
        }
        catch (IOException ioe) {
            throw new Exception("Unable to find project file. An errror occured while reading from a file");
        }
    }
}

