/*
 * Decompiled with CFR 0.152.
 */
package mckay.utilities.gui.progressbars;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JProgressBar;

public class SimpleProgressBarDialog
extends JDialog {
    private Component parent;
    private JProgressBar progress_bar;
    private int task_status;
    private int number_tasks;

    public SimpleProgressBarDialog(int number_tasks, Component parent) {
        this.setTitle("Task Progress");
        this.setSize(225, 75);
        this.setLocationRelativeTo(parent);
        if (parent != null) {
            parent.setEnabled(false);
        }
        this.parent = parent;
        this.number_tasks = number_tasks;
        this.task_status = 0;
        this.progress_bar = new JProgressBar(0, number_tasks);
        this.progress_bar.setStringPainted(true);
        this.progress_bar.setValue(this.task_status);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setLayout(new BorderLayout());
        this.add((Component)this.progress_bar, "Center");
        this.setVisible(true);
        this.progress_bar.paintImmediately(this.progress_bar.getBounds());
    }

    public void incrementStatus() {
        this.requestFocus();
        ++this.task_status;
        this.progress_bar.setValue(this.task_status);
        this.progress_bar.paintImmediately(this.progress_bar.getBounds());
        if (this.task_status == this.number_tasks) {
            this.done();
        }
    }

    public void done() {
        this.setCursor(null);
        this.setVisible(false);
        if (this.parent != null) {
            this.parent.setEnabled(true);
        }
        if (this.parent instanceof Window) {
            ((Window)this.parent).toFront();
        }
    }
}

