/*
 * Decompiled with CFR 0.152.
 */
package mckay.utilities.gui.tables;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class MultiLineCellRenderer
extends JPanel
implements TableCellRenderer {
    protected int verticalAlignment;
    protected int horizontalAlignment;
    protected float alignmentX;
    protected Color foreground;
    protected Color background;
    protected Font font;
    protected static Border border = new EmptyBorder(1, 2, 1, 2);

    public MultiLineCellRenderer(int horizontalAlignment, int verticalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        this.verticalAlignment = verticalAlignment;
        switch (horizontalAlignment) {
            case 2: {
                this.alignmentX = 0.0f;
                break;
            }
            case 0: {
                this.alignmentX = 0.5f;
                break;
            }
            case 4: {
                this.alignmentX = 1.0f;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal horizontal alignment value");
            }
        }
        this.setLayout(new BoxLayout(this, 1));
        this.setOpaque(true);
        this.setBorder(border);
        this.background = null;
        this.foreground = null;
    }

    public void setForeground(Color foreground) {
        super.setForeground(foreground);
        for (Component comp : this.getComponents()) {
            if (!(comp instanceof JLabel)) continue;
            comp.setForeground(foreground);
        }
    }

    public void setBackground(Color background) {
        this.background = background;
        super.setBackground(background);
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color cellBackground;
        this.removeAll();
        this.invalidate();
        if (value == null || table == null) {
            return this;
        }
        Color cellForeground = this.foreground == null ? table.getForeground() : this.foreground;
        Color color = cellBackground = this.background == null ? table.getBackground() : this.background;
        if (isSelected) {
            cellForeground = table.getSelectionForeground();
            cellBackground = table.getSelectionBackground();
        }
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (table.isCellEditable(row, column)) {
                cellForeground = UIManager.getColor("Table.focusCellForeground");
                cellBackground = UIManager.getColor("Table.focusCellBackground");
            }
        } else {
            this.setBorder(border);
        }
        super.setForeground(cellForeground);
        super.setBackground(cellBackground);
        if (this.font == null) {
            this.font = table.getFont();
        }
        if (this.verticalAlignment != 1) {
            this.add(Box.createVerticalGlue());
        }
        Object[] values = value instanceof Object[] ? (Object[])value : new Object[]{value};
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            Object thisRow = values[i];
            if (thisRow instanceof JComponent) {
                this.add((JComponent)thisRow);
                continue;
            }
            JLabel l = new JLabel();
            this.setValue(l, thisRow, i, cellForeground);
            this.add(l);
        }
        if (this.verticalAlignment != 3) {
            this.add(Box.createVerticalGlue());
        }
        return this;
    }

    protected void setValue(JLabel l, Object value, int lineNumber, Color cellForeground) {
        if (value != null && value instanceof Icon) {
            l.setIcon((Icon)value);
        } else {
            l.setText(value == null ? "" : value.toString());
        }
        l.setHorizontalAlignment(this.horizontalAlignment);
        l.setAlignmentX(this.alignmentX);
        l.setOpaque(false);
        l.setForeground(cellForeground);
        l.setFont(this.font);
    }
}

