/*
 * Decompiled with CFR 0.152.
 */
package mckay.utilities.gui.templates;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;

public class HTMLFramesPanel
extends JPanel
implements HyperlinkListener {
    private JEditorPane left_pane;
    private JEditorPane right_pane;

    public HTMLFramesPanel(String left_start_path, String right_start_path) {
        this.setLayout(new BorderLayout(2, 0));
        this.left_pane = new JEditorPane();
        this.left_pane.setEditable(false);
        if (left_start_path != null) {
            this.setLeftFrame(left_start_path);
        }
        JScrollPane left_scroll_pane = new JScrollPane(this.left_pane);
        this.left_pane.addHyperlinkListener(this);
        this.left_pane.setBorder(BorderFactory.createMatteBorder(7, 7, 7, 7, Color.BLACK));
        this.add((Component)left_scroll_pane, "West");
        this.right_pane = new JEditorPane();
        this.right_pane.setEditable(false);
        if (this.right_pane != null) {
            this.setRightFrame(right_start_path);
        }
        JScrollPane right_scroll_pane = new JScrollPane(this.right_pane);
        this.right_pane.addHyperlinkListener(this);
        this.right_pane.setBorder(BorderFactory.createMatteBorder(7, 7, 7, 7, new Color(228, 228, 228)));
        this.add((Component)right_scroll_pane, "Center");
    }

    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else if (event.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        } else if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                this.right_pane.setPage(event.getURL());
            }
            catch (Exception f) {
                this.right_pane.setText("Unable to find requested page:\n" + event.getURL());
            }
        }
    }

    public void setLeftFrame(String left_start_path) {
        try {
            Document doc = this.left_pane.getDocument();
            doc.putProperty("stream", null);
            this.left_pane.setPage("file:" + left_start_path);
        }
        catch (Exception e) {
            this.left_pane.setText("Unable to find requested page:\nfile:" + left_start_path);
        }
    }

    public void setRightFrame(String right_start_path) {
        try {
            Document doc = this.right_pane.getDocument();
            doc.putProperty("stream", null);
            this.right_pane.setPage("file:" + right_start_path);
        }
        catch (Exception e) {
            this.right_pane.setText("Unable to find requested page:\nfile:" + right_start_path);
        }
    }
}

